/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.Files;
import gate.util.ant.packager.GappModel;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageGappTask
extends Task {
    private File destFile;
    private File src;
    private File gateHome;
    private boolean copyPlugins = true;
    private boolean copyResourceDirs = false;
    private List<Path> extraResourcesPaths = new ArrayList<Path>();
    private UnresolvedAction onUnresolved = UnresolvedAction.fail;
    private List<MappingHint> hintTasks = new ArrayList<MappingHint>();
    private Map<URL, String> mappingHints = new LinkedHashMap<URL, String>();

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File file) {
        this.src = file;
    }

    public File getGateHome() {
        return this.gateHome;
    }

    public void setGateHome(File file) {
        this.gateHome = file;
    }

    public boolean isCopyPlugins() {
        return this.copyPlugins;
    }

    public void setCopyPlugins(boolean bl) {
        this.copyPlugins = bl;
    }

    public boolean isCopyResourceDirs() {
        return this.copyResourceDirs;
    }

    public void setCopyResourceDirs(boolean bl) {
        this.copyResourceDirs = bl;
    }

    public UnresolvedAction getOnUnresolved() {
        return this.onUnresolved;
    }

    public void setOnUnresolved(UnresolvedAction unresolvedAction) {
        this.onUnresolved = unresolvedAction;
    }

    public MappingHint createHint() {
        MappingHint mappingHint = new MappingHint();
        mappingHint.setProject(this.getProject());
        mappingHint.setTaskName(this.getTaskName());
        mappingHint.setLocation(this.getLocation());
        mappingHint.init();
        this.hintTasks.add(mappingHint);
        return mappingHint;
    }

    public void addExtraResourcesPath(Path path) {
        this.extraResourcesPaths.add(path);
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Iterator iOException;
        Iterator iterator2;
        Serializable malformedURLException;
        for (MappingHint object72 : this.hintTasks) {
            object72.perform();
        }
        HashMap hashMap = new HashMap();
        HashMap<URL, URL> hashMap2 = new HashMap<URL, URL>();
        HashMap<URL, URL> hashMap3 = new HashMap<URL, URL>();
        this.log("Packaging gapp file " + this.src);
        GappModel gappModel = null;
        URL uRL = null;
        try {
            malformedURLException = null;
            if (this.gateHome != null) {
                malformedURLException = this.gateHome.toURI().toURL();
            }
            gappModel = new GappModel(this.src.toURI().toURL(), (URL)malformedURLException);
            uRL = this.destFile.toURI().toURL();
            gappModel.setGappFileURL(uRL);
        }
        catch (MalformedURLException malformedURLException2) {
            throw new BuildException("Couldn't convert src or dest file to URL", (Throwable)malformedURLException2, this.getLocation());
        }
        malformedURLException = new HashSet<URL>(gappModel.getPluginURLs());
        HashSet<URL> hashSet = new HashSet<URL>(gappModel.getResourceURLs());
        this.processExtraResourcesPaths(hashSet);
        if (this.mappingHints != null && !this.mappingHints.isEmpty()) {
            iterator2 = hashSet.iterator();
            block24: while (iterator2.hasNext()) {
                iOException = (URL)iterator2.next();
                for (URL uRL2 : this.mappingHints.keySet()) {
                    String string = uRL2.toExternalForm();
                    if (!((URL)((Object)iOException)).equals(uRL2) && (!string.endsWith("/") || !((URL)((Object)iOException)).toExternalForm().startsWith(string))) continue;
                    this.log("Found resource " + iOException + " under mapping hint URL " + uRL2, 3);
                    iterator = this.mappingHints.get(uRL2);
                    object3 = null;
                    if (iterator == null) {
                        this.log("  Converting to absolute URL", 3);
                        object3 = iOException;
                    } else {
                        try {
                            object2 = new URL(uRL, (String)((Object)iterator));
                            object = PersistenceManager.getRelativePath(uRL2, iOException);
                            object3 = new URL((URL)object2, (String)object);
                            hashMap.put(iOException, object3);
                            if (this.copyResourceDirs) {
                                hashMap3.put(new URL((URL)((Object)iOException), "."), new URL((URL)object3, "."));
                            }
                        }
                        catch (MalformedURLException malformedURLException3) {
                            throw new BuildException("Couldn't construct URL relative to " + (String)((Object)iterator) + " for " + iOException, (Throwable)malformedURLException3, this.getLocation());
                        }
                        this.log("  Relocating to " + object3, 3);
                    }
                    gappModel.updatePathForURL((URL)((Object)iOException), (URL)object3, iterator != null);
                    iterator2.remove();
                    continue block24;
                }
            }
        }
        iterator2 = malformedURLException.iterator();
        while (iterator2.hasNext()) {
            URL uRL3;
            void var10_18;
            iOException = (URL)iterator2.next();
            iterator2.remove();
            String string = ((URL)((Object)iOException)).getFile();
            this.log("Processing plugin " + string, 3);
            if (string.endsWith("/")) {
                String string2 = string.substring(string.lastIndexOf(47, string.length() - 2) + 1);
            } else {
                String string3 = string.substring(string.lastIndexOf(47) + 1);
            }
            this.log("  Plugin name is " + (String)var10_18, 3);
            Object var11_30 = null;
            try {
                uRL3 = new URL(uRL, "plugins/" + (String)var10_18);
            }
            catch (MalformedURLException malformedURLException4) {
                throw new BuildException("Couldn't construct URL relative to plugins/ for " + iOException, (Throwable)malformedURLException4, this.getLocation());
            }
            this.log("  Relocating to " + uRL3, 3);
            gappModel.updatePathForURL((URL)((Object)iOException), uRL3, true);
            hashMap2.put((URL)((Object)iOException), uRL3);
            String string4 = ((URL)((Object)iOException)).toExternalForm();
            if (!string4.endsWith("/")) {
                String string5 = string4 + "/";
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object3 = (URL)iterator.next();
                try {
                    void var12_41;
                    if (!((URL)object3).toExternalForm().startsWith((String)var12_41)) continue;
                    iterator.remove();
                    object2 = PersistenceManager.getRelativePath(iOException, (URL)object3);
                    this.log("    Found resource " + object3, 3);
                    object = null;
                    object = new URL(uRL3, (String)object2);
                    this.log("    Relocating to " + object, 3);
                    gappModel.updatePathForURL((URL)object3, (URL)object, true);
                    hashMap.put(object3, object);
                    if (!this.copyResourceDirs) continue;
                    hashMap3.put(new URL((URL)object3, "."), new URL((URL)object, "."));
                }
                catch (MalformedURLException malformedURLException5) {
                    throw new BuildException("Couldn't construct URL relative to " + uRL3 + " for " + object3, (Throwable)malformedURLException5, this.getLocation());
                }
            }
        }
        if (!hashSet.isEmpty()) {
            switch (this.onUnresolved) {
                case fail: {
                    this.log("There were unresolved resources:", 0);
                    for (URL uRL4 : hashSet) {
                        this.log(uRL4.toExternalForm(), 0);
                    }
                    this.log("Either set onUnresolved=\"absolute|recover\" or add the relevant mapping hints", 0);
                    throw new BuildException("There were unresolved resources", this.getLocation());
                }
                case absolute: {
                    this.log("There were unresolved resources, which have been made absolute", 1);
                    for (URL uRL5 : hashSet) {
                        gappModel.updatePathForURL(uRL5, uRL5, false);
                        this.log(uRL5.toExternalForm(), 3);
                    }
                    break;
                }
                case recover: {
                    iOException = null;
                    try {
                        iOException = new URL(uRL, "application-resources/");
                    }
                    catch (MalformedURLException malformedURLException6) {
                        throw new BuildException("Can't construct URL relative to " + uRL + " for application-resources", (Throwable)malformedURLException6, this.getLocation());
                    }
                    HashMap<URL, URL> hashMap4 = new HashMap<URL, URL>();
                    this.log("There were unresolved resources, which have been gathered into " + iOException, 2);
                    for (URL uRL6 : hashSet) {
                        iterator = null;
                        try {
                            iterator = new URL(uRL6, ".");
                        }
                        catch (MalformedURLException malformedURLException7) {
                            throw new BuildException("Can't construct URL to parent directory of " + uRL6, (Throwable)malformedURLException7, this.getLocation());
                        }
                        object3 = this.getUnresolvedResourcesTarget((Map<URL, URL>)hashMap4, (URL)((Object)iOException), (URL)((Object)iterator));
                        object2 = uRL6.getFile();
                        object2 = ((String)object2).substring(((String)object2).lastIndexOf(47) + 1);
                        object = null;
                        try {
                            object = new URL((URL)object3, (String)object2);
                        }
                        catch (MalformedURLException malformedURLException8) {
                            throw new BuildException("Can't construct URL relative to " + iOException + " for " + (String)object2, (Throwable)malformedURLException8, this.getLocation());
                        }
                        gappModel.updatePathForURL(uRL6, (URL)object, true);
                        hashMap.put(uRL6, object);
                        if (!this.copyResourceDirs) continue;
                        hashMap3.put((URL)((Object)iterator), (URL)object3);
                    }
                    break;
                }
                default: {
                    throw new BuildException("Unrecognised UnresolvedAction", this.getLocation());
                }
            }
        }
        try {
            this.log("Writing modified gapp to " + this.destFile);
            gappModel.write();
        }
        catch (IOException iOException2) {
            throw new BuildException("Error writing out modified GAPP file", (Throwable)iOException2, this.getLocation());
        }
        if (hashMap.size() > 0) {
            this.log("Copying " + hashMap.size() + " resources");
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            File file = Files.fileFromURL((URL)entry.getKey());
            File file2 = Files.fileFromURL((URL)entry.getValue());
            file2.getParentFile().mkdirs();
            try {
                this.log("Copying " + file + " to " + file2, 3);
                FileUtils.getFileUtils().copyFile(file, file2);
            }
            catch (IOException iOException3) {
                throw new BuildException("Error copying file " + file + " to " + file2, (Throwable)iOException3, this.getLocation());
            }
        }
        if (hashMap2.size() > 0) {
            this.log("Copying " + hashMap2.size() + " plugins");
            if (this.copyPlugins) {
                this.log("Also copying complete plugin contents", 3);
            }
        }
        this.copyDirectories(hashMap2, !this.copyPlugins);
        if (hashMap3.size() > 0) {
            this.log("Copying " + hashMap3.size() + " resource directories");
        }
        this.copyDirectories(hashMap3, false);
    }

    private void processExtraResourcesPaths(Set<URL> set) {
        for (Path path : this.extraResourcesPaths) {
            for (String string : path.list()) {
                File file = new File(string);
                try {
                    set.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BuildException("Couldn't construct URL for extra resource " + file, (Throwable)malformedURLException, this.getLocation());
                }
            }
        }
    }

    private void copyDirectories(Map<URL, URL> map, boolean bl) {
        for (Map.Entry<URL, URL> entry : map.entrySet()) {
            File file = Files.fileFromURL(entry.getKey());
            File file2 = Files.fileFromURL(entry.getValue());
            Copy copy = new Copy();
            copy.setProject(this.getProject());
            copy.setLocation(this.getLocation());
            copy.setTaskName(this.getTaskName());
            copy.setTodir(file2);
            file2.mkdirs();
            FileSet fileSet = new FileSet();
            copy.addFileset(fileSet);
            fileSet.setDir(file);
            if (bl) {
                URL uRL;
                PatternSet.NameEntry nameEntry = fileSet.createInclude();
                nameEntry.setName("creole.xml");
                try {
                    uRL = new URL(entry.getKey().toExternalForm() + "/creole.xml");
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BuildException("Error creating URL for creole.xml in plugin " + entry.getKey());
                }
                for (String string : this.getJars(uRL)) {
                    PatternSet.NameEntry nameEntry2 = fileSet.createInclude();
                    nameEntry2.setName(string);
                }
            }
            copy.init();
            copy.perform();
        }
    }

    private Set<String> getJars(URL uRL) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            XPath xPath = XPath.newInstance((String)"//*[translate(local-name(), 'ajr', 'AJR') = 'JAR']");
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(uRL);
            List list = xPath.selectNodes((Object)document);
            for (Element element : list) {
                hashSet.add(element.getTextTrim());
            }
            return hashSet;
        }
        catch (JDOMException jDOMException) {
            throw new BuildException("Error extracting JAR elements from " + uRL, (Throwable)jDOMException, this.getLocation());
        }
        catch (IOException iOException) {
            throw new BuildException("Error loading " + uRL + " to extract JARs", (Throwable)iOException, this.getLocation());
        }
    }

    private URL getUnresolvedResourcesTarget(Map<URL, URL> map, URL uRL, URL uRL2) throws BuildException {
        URL uRL3 = map.get(uRL2);
        if (uRL3 == null) {
            try {
                String string;
                String string2 = uRL2.getFile();
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if ((string = string2.substring(string2.lastIndexOf(47) + 1)).length() == 0) {
                    string = "resources";
                }
                if (map.containsValue(uRL3 = new URL(uRL, string + "/"))) {
                    int n = 1;
                    while (map.containsValue(uRL3 = new URL(uRL, string + "-" + n++ + "/"))) {
                    }
                }
                map.put(uRL2, uRL3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException("Can't construct target URL for directory " + uRL2, (Throwable)malformedURLException, this.getLocation());
            }
        }
        return uRL3;
    }

    public class MappingHint
    extends Property {
        private boolean absolute = false;

        public void setFrom(File file) {
            super.setName(file.getAbsolutePath());
        }

        public void setTo(String string) {
            super.setValue(string);
        }

        public void setAbsolute(boolean bl) {
            if (bl) {
                super.setValue("dummy");
            }
            this.absolute = bl;
        }

        protected void addProperty(String string, String string2) {
            try {
                File file = this.getProject().resolveFile(string);
                if (file.isDirectory() && string2 != null && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                PackageGappTask.this.mappingHints.put(file.toURI().toURL(), this.absolute ? null : string2);
            }
            catch (MalformedURLException malformedURLException) {
                PackageGappTask.this.log("Couldn't interpret \"" + string + "\" as a file path, ignored", 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnresolvedAction {
        fail,
        absolute,
        recover;

    }
}

