/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.util.AnnotationDiffer;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import gate.util.Out;
import gate.util.Strings;
import gate.util.persistence.PersistenceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestApplication
extends TestCase {
    protected Properties properties;
    protected File propertiesFile;
    protected String documentEncoding;
    protected File applicationFile;
    protected File cleanDocumentsDirectory;
    protected File previousRunDirectory;
    protected File goldStandardDirectory;
    protected String applicationAnnotationSet;
    protected String goldAnnotationSet;
    protected Set<String> annotationTypes;
    protected Set<String> annotationFeatures;
    protected double failThreshold;
    protected File resultsFile;
    final String nl = Strings.getNl();
    static final String BEGINHTML = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>";
    static final String ENDHTML = "</body></html>";
    static final String BEGINHEAD = "<head><meta content=\"text/html; charset=utf-8\" http-equiv=\"content-type\"><title>";
    static final String ENDHEAD = "</title></head><body>";

    public static Test suite() {
        return new TestSuite(TestApplication.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setUp() throws Exception {
        this.propertiesFile = new File("test.application.properties");
        this.properties = new Properties();
        this.annotationFeatures = new HashSet<String>();
        this.applicationAnnotationSet = "";
        this.goldAnnotationSet = "";
        this.failThreshold = 0.7;
        Out.prln();
        Out.prln("Load properties file: " + this.propertiesFile.getAbsolutePath());
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this.propertiesFile);
                this.properties.load(fileInputStream);
                String string = this.properties.getProperty("document.encoding");
                if (string != null && !string.equals("")) {
                    this.documentEncoding = string.trim();
                    Out.prln("Document encoding: " + this.documentEncoding);
                }
                if ((string = this.properties.getProperty("application.file")) == null) throw new IllegalArgumentException("application.file");
                if (string.equals("")) throw new IllegalArgumentException("application.file");
                this.applicationFile = new File(string.trim());
                Out.prln("Application path: " + this.applicationFile.getAbsolutePath());
                string = this.properties.getProperty("clean.documents.directory");
                if (string == null) throw new IllegalArgumentException("clean.documents.directory");
                if (string.equals("")) throw new IllegalArgumentException("clean.documents.directory");
                this.cleanDocumentsDirectory = new File(string.trim());
                Out.prln("Clean documents directory: " + this.cleanDocumentsDirectory.getAbsolutePath());
                string = this.properties.getProperty("previous.run.directory");
                if (string != null && !string.equals("")) {
                    this.previousRunDirectory = new File(string.trim());
                    Out.prln("Previous run directory: " + this.previousRunDirectory.getAbsolutePath());
                }
                if ((string = this.properties.getProperty("gold.standard.directory")) != null && !string.equals("")) {
                    this.goldStandardDirectory = new File(string.trim());
                    Out.prln("Gold standard directory: " + this.goldStandardDirectory.getAbsolutePath());
                }
                if ((string = this.properties.getProperty("application.annotation.set")) != null && !string.equals("")) {
                    this.applicationAnnotationSet = string.trim();
                    Out.prln("Application annotation set: " + this.applicationAnnotationSet);
                }
                if ((string = this.properties.getProperty("gold.annotation.set")) != null && !string.equals("")) {
                    this.goldAnnotationSet = string.trim();
                    Out.prln("Gold annotation set: " + this.goldAnnotationSet);
                }
                if ((string = this.properties.getProperty("annotation.types")) == null) throw new IllegalArgumentException("annotation.types");
                if (string.equals("")) throw new IllegalArgumentException("annotation.types");
                this.annotationTypes = new HashSet<String>(Arrays.asList(string.trim().split(", ?")));
                Out.prln("Annotation types: " + Arrays.toString(this.annotationTypes.toArray()));
                string = this.properties.getProperty("annotation.features");
                if (string != null && !string.equals("")) {
                    this.annotationFeatures = new HashSet<String>(Arrays.asList(string.trim().split(", ?")));
                    Out.prln("Annotation features: " + Arrays.toString(this.annotationFeatures.toArray()));
                }
                if ((string = this.properties.getProperty("fail.threshold")) != null && !string.equals("")) {
                    this.failThreshold = Double.parseDouble(string.trim());
                    Out.prln("Fail threshold: " + this.failThreshold);
                }
                if ((string = this.properties.getProperty("results.file")) != null && !string.equals("")) {
                    this.resultsFile = new File(string.trim());
                    Out.prln("Results file: " + this.resultsFile.getAbsolutePath());
                }
                Out.prln();
            }
            catch (IOException iOException) {
                Out.prln("Could not load the properties file:");
                Out.prln("test.application.properties");
                Out.prln("The file must be in the directory from where you run the test.");
                iOException.printStackTrace();
                Object var4_6 = null;
                if (fileInputStream == null) return;
                fileInputStream.close();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Out.prln("Property " + illegalArgumentException.getMessage() + " is empty or not defined!");
                Object var4_7 = null;
                if (fileInputStream == null) return;
                fileInputStream.close();
                return;
            }
            Object var4_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(this.propertiesFile);
                this.properties.store(fileOutputStream, " Property file for the JUnit TestApplication test.\n\n# the encoding for all the documents, optional\n#document.encoding=utf-8\n\n# the application to be run on the clean documents directory\n#application.file=/home/thomas/.tmp/gate/plugins/ANNIE/ANNIE_with_defaults.gapp\n\n# documents with only original markups\n# these are annotated with the current application\n#clean.documents.directory=/home/thomas/.tmp/corpus/gatecorpora/business/clean\n\n# the previous run documents directory that will be filled automatically\n# with the current run of the application on the clean documents\n# it can be empty the first time and then you will get no results\n#previous.run.directory=\n\n# annotated documents from the clean documents, optional\n#gold.standard.directory=/home/thomas/.tmp/corpus/gatecorpora/business/marked\n\n# annotation set, types and features\n# if an annotation set is empty then use the default set\n# only annotation.features is optional\n#application.annotation.set=\n#gold.annotation.set=Key\n#annotation.types=Location, Date, Person\n#annotation.features=\n\n# average F1 score threshold, between 0 and 1 to make the test failed\n# it also determines if the previous and current application must be\n# compared with the goldstandard, default value is 0.7\n# 0 will never fail\n# 1 will fail for any difference between documents\n#fail.threshold=0.9\n\n# file where to save the result in HTML format\n# if not set will use a temporary file\n#results.file=");
            }
            catch (IOException iOException) {
                Out.prln("Could not save the properties file:");
                Out.prln("test.application.properties");
                Out.prln("The file must be in the directory from where you run the test.");
                iOException.printStackTrace();
                Object var4_3 = null;
                if (fileOutputStream == null) return;
                fileOutputStream.close();
                return;
            }
            Object var4_2 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void test() {
        Writer writer;
        block26: {
            writer = null;
            if (!Gate.isInitialised()) {
                Gate.init();
            }
            Out.prln("Load the application");
            CorpusController corpusController = (CorpusController)PersistenceManager.loadObjectFromFile(this.applicationFile);
            corpusController.init();
            Corpus corpus = Factory.newCorpus("New corpus");
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }
            };
            corpus.populate(this.cleanDocumentsDirectory.toURI().toURL(), fileFilter, this.documentEncoding, false);
            Out.prln("Run the application on the clean " + corpus.size() + " documents");
            corpusController.setCorpus(corpus);
            corpusController.execute();
            Out.prln("Save the documents processed in ");
            File file = File.createTempFile("gate-test-application-", null);
            if (!file.delete() || !file.mkdir()) {
                throw new IOException("Unable to create temporary directory.\n" + file.getCanonicalPath());
            }
            for (Object object2 : corpus) {
                Document document = (Document)object2;
                writer = new BufferedWriter(new FileWriter(new File(file, Files.fileFromURL(document.getSourceUrl()).getName())));
                writer.write(document.toXml());
                writer.close();
            }
            Out.prln(file.getPath());
            this.properties.put("previous.run.directory", file.getCanonicalPath());
            if (this.previousRunDirectory != null && this.previousRunDirectory.listFiles().length > 0) {
                Object object;
                Document document;
                String string;
                Document document2;
                Object object2;
                if (this.resultsFile == null) {
                    this.resultsFile = File.createTempFile("gate-test-application-results-", ".html");
                    this.properties.put("results.file", this.resultsFile.getCanonicalPath());
                }
                writer = new BufferedWriter(new FileWriter(this.resultsFile));
                writer.write(BEGINHTML + this.nl);
                writer.write(BEGINHEAD);
                writer.write("GATE Test Application");
                writer.write(ENDHEAD + this.nl);
                writer.write("<h1>GATE Test Application</h1>" + this.nl);
                writer.write("<p>Application: " + this.applicationFile.getPath() + "<br>" + this.nl);
                writer.write("Fail Threshold: " + this.failThreshold + "</p>" + this.nl);
                writer.write("<p>&nbsp;</p>" + this.nl);
                Out.prln("Compare previous and new application");
                writer.write("<h2>Compare previous and new application</h2>" + this.nl);
                object2 = new ArrayList();
                double d = 0.0;
                for (Object e : corpus) {
                    document2 = (Document)e;
                    writer.write("<h3>Document: " + document2.getName() + "</h3>" + this.nl);
                    string = Files.fileFromURL(document2.getSourceUrl()).getName();
                    document = Factory.newDocument(new File(this.previousRunDirectory, string).toURI().toURL(), this.documentEncoding);
                    double d2 = 0.0;
                    for (String string2 : this.annotationTypes) {
                        writer.write("<h4>Annotation type: " + string2 + "</h4>" + this.nl);
                        object = new AnnotationDiffer();
                        ((AnnotationDiffer)object).setSignificantFeaturesSet(this.annotationFeatures);
                        object2.clear();
                        object2.addAll(((AnnotationDiffer)object).calculateDiff(document.getAnnotations(this.applicationAnnotationSet).get(string2), document2.getAnnotations(this.applicationAnnotationSet).get(string2)));
                        if (((AnnotationDiffer)object).getCorrectMatches() != ((AnnotationDiffer)object).getKeysCount()) {
                            writer.write(this.printHTMLForPairings((List<AnnotationDiffer.Pairing>)object2, document2));
                        }
                        d2 += ((AnnotationDiffer)object).getFMeasureStrict(1.0);
                    }
                    d += d2 / (double)this.annotationTypes.size();
                    writer.write("Average F1 measure is " + d2 / (double)this.annotationTypes.size() + "</p>" + this.nl);
                }
                Out.prln("Average F1 measure is " + (d /= (double)corpus.size()));
                if (d < this.failThreshold && this.goldStandardDirectory != null) {
                    Out.prln("Compare previous application and gold standard");
                    writer.write("<h2>Compare previous application and gold standard</h2>" + this.nl);
                    for (Object e : corpus) {
                        document2 = (Document)e;
                        writer.write("<h3>Document: " + document2.getName() + "</h3>" + this.nl);
                        string = Files.fileFromURL(document2.getSourceUrl()).getName();
                        document = Factory.newDocument(new File(this.goldStandardDirectory, string).toURI().toURL(), this.documentEncoding);
                        Document document3 = Factory.newDocument(new File(this.previousRunDirectory, string).toURI().toURL(), this.documentEncoding);
                        for (String string3 : this.annotationTypes) {
                            writer.write("<h4>Annotation type: " + string3 + "</h4>" + this.nl);
                            object = new AnnotationDiffer();
                            ((AnnotationDiffer)object).setSignificantFeaturesSet(this.annotationFeatures);
                            object2.clear();
                            object2.addAll(((AnnotationDiffer)object).calculateDiff(document.getAnnotations(this.goldAnnotationSet).get(string3), document3.getAnnotations(this.applicationAnnotationSet).get(string3)));
                            if (((AnnotationDiffer)object).getCorrectMatches() == ((AnnotationDiffer)object).getKeysCount()) continue;
                            writer.write(this.printHTMLForPairings((List<AnnotationDiffer.Pairing>)object2, document2));
                        }
                    }
                    Out.prln("Compare new application and gold standard");
                    writer.write("<h2>Compare new application and gold standard</h2>" + this.nl);
                    for (Object e : corpus) {
                        document2 = (Document)e;
                        writer.write("<h3>Document: " + document2.getName() + "</h3>" + this.nl);
                        string = Files.fileFromURL(document2.getSourceUrl()).getName();
                        document = Factory.newDocument(new File(this.goldStandardDirectory, string).toURI().toURL(), this.documentEncoding);
                        for (String string4 : this.annotationTypes) {
                            writer.write("<h4>Annotation type: " + string4 + "</h4>" + this.nl);
                            object = new AnnotationDiffer();
                            ((AnnotationDiffer)object).setSignificantFeaturesSet(this.annotationFeatures);
                            object2.clear();
                            object2.addAll(((AnnotationDiffer)object).calculateDiff(document.getAnnotations(this.goldAnnotationSet).get(string4), document2.getAnnotations(this.applicationAnnotationSet).get(string4)));
                            if (((AnnotationDiffer)object).getCorrectMatches() == ((AnnotationDiffer)object).getKeysCount()) continue;
                            writer.write(this.printHTMLForPairings((List<AnnotationDiffer.Pairing>)object2, document2));
                        }
                    }
                }
                writer.write(ENDHTML + this.nl);
                Out.prln("Results have been written to " + this.resultsFile.getPath());
                if (d < this.failThreshold) {
                    TestApplication.fail((String)("The average F1 measure is " + d + " which is inferior to the fail threshold " + this.failThreshold));
                }
                break block26;
            }
            Out.prln();
            Out.prln("Previous run directory is missing or empty.");
            Out.prln("You will need to run again this test with your new application");
            Out.prln("so it can compute the differences.");
        }
        Object var20_29 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (GateException gateException) {
                gateException.printStackTrace();
                Object var20_30 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (GateRuntimeException gateRuntimeException) {
                gateRuntimeException.printStackTrace();
                Object var20_31 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var20_32 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var20_33 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    private String printHTMLForPairings(List<AnnotationDiffer.Pairing> list, Document document) {
        String string = Strings.getNl();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table cellpadding=\"0\" border=\"1\">").append(string);
        stringBuilder.append("<tr><th>Start</th><th>End</th><th>Key</th>");
        if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
            stringBuilder.append("<th>Features</th>");
        }
        stringBuilder.append("<th>=?</th><th>Start</th><th>End</th><th>Response</th>");
        if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
            stringBuilder.append("<th>Features</th>");
        }
        stringBuilder.append("</tr>").append(string);
        for (AnnotationDiffer.Pairing pairing : list) {
            String string2;
            if (pairing.getType() == 0) continue;
            Annotation annotation = pairing.getKey();
            if (annotation == null) {
                stringBuilder.append("<tr><td></td><td></td><td></td>");
                if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
                    stringBuilder.append("<td></td>");
                }
            } else {
                try {
                    string2 = document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new LuckyException(invalidOffsetException);
                }
                stringBuilder.append("<tr>").append("<td>").append(annotation.getStartNode().getOffset().toString()).append("</td><td>").append(annotation.getEndNode().getOffset().toString()).append("</td><td>").append(string2).append("</td>");
                if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
                    stringBuilder.append("<td>").append(annotation.getFeatures().toString()).append("</td>");
                }
            }
            string2 = "";
            switch (pairing.getType()) {
                case 0: {
                    string2 = "=";
                    break;
                }
                case 1: {
                    string2 = "~";
                    break;
                }
                case 2: {
                    string2 = "-?";
                    break;
                }
                case 3: {
                    string2 = "?-";
                    break;
                }
                case 4: {
                    string2 = "<>";
                }
            }
            stringBuilder.append("<td>").append(string2).append("</td>");
            Annotation annotation2 = pairing.getResponse();
            if (annotation2 == null) {
                stringBuilder.append("<td></td><td></td><td></td>");
                if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
                    stringBuilder.append("<td></td>");
                }
            } else {
                String string3;
                try {
                    string3 = document.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new LuckyException(invalidOffsetException);
                }
                stringBuilder.append("<td>").append(annotation2.getStartNode().getOffset().toString()).append("</td><td>").append(annotation2.getEndNode().getOffset().toString()).append("</td><td>").append(string3).append("</td>");
                if (this.annotationFeatures != null && !this.annotationFeatures.isEmpty()) {
                    stringBuilder.append("<td>").append(annotation2.getFeatures().toString()).append("</td>");
                }
            }
            stringBuilder.append("</tr>").append(string);
        }
        stringBuilder.append("</table>").append(string);
        stringBuilder.append("<p>&nbsp;</p>").append(string);
        return stringBuilder.toString();
    }
}

