/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final boolean DEBUG = false;
    private static char padChar = (char)32;
    private static String newline = System.getProperty("line.separator");
    private static String pathSep = System.getProperty("path.separator");
    private static String fileSep = System.getProperty("file.separator");

    public static String getNl() {
        return newline;
    }

    public static String getPathSep() {
        return pathSep;
    }

    public static String getFileSep() {
        return fileSep;
    }

    public static String addPadding(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(padChar);
        }
        return stringBuffer.toString();
    }

    public static String addLineNumbers(String string) {
        return Strings.addLineNumbers(string, 1);
    }

    public static String addLineNumbers(String string, int n) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = n;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = n2 < 10 ? " " : "";
                stringBuffer.append(string3 + n2 + "  " + string2 + Strings.getNl());
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (string == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(4);
        boolean bl = false;
        boolean bl2 = false;
        for (char c : string.toCharArray()) {
            if (bl) {
                stringBuilder2.append(c);
                if (stringBuilder2.length() != 4) continue;
                try {
                    int n = Integer.parseInt(stringBuilder2.toString(), 16);
                    stringBuilder.append((char)n);
                    stringBuilder2.setLength(0);
                    bl = false;
                    bl2 = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("Couldn't parse unicode value: " + stringBuilder2, numberFormatException);
                }
            }
            if (bl2) {
                bl2 = false;
                switch (c) {
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '\'': {
                        stringBuilder.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'u': {
                        bl = true;
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c);
        }
        if (bl2) {
            stringBuilder.append('\\');
        }
        return stringBuilder.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof Collection) {
            return Arrays.deepToString(((Collection)object).toArray());
        }
        return object.toString();
    }

    public static String toString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (String string : list) {
            String string2 = string.replaceAll(",", "\\\\,");
            stringBuilder.append(string2).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey().replaceAll("=", "\\\\=").replaceAll(",", "\\\\,");
            String string2 = entry.getValue().replaceAll("=", "\\\\=").replaceAll(",", "\\\\,");
            stringBuilder.append(string).append("=").append(string2).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static List<String> toList(String string, String string2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() < 3) {
            return arrayList;
        }
        String string3 = string.substring(0, string.length() - 1);
        int n2 = 1;
        int n3 = 1;
        while ((n = string3.indexOf(string2, n2)) != -1) {
            if (string3.charAt(n - 1) != '\\') {
                arrayList.add(string3.substring(n3, n).replaceAll("\\\\" + string2.charAt(0), "" + string2.charAt(0)));
                n3 = n + string2.length();
            }
            n2 = n + string2.length();
        }
        arrayList.add(string3.substring(n3));
        return arrayList;
    }

    public static Map<String, String> toMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || string.length() < 3) {
            return hashMap;
        }
        List<String> list = Strings.toList(string, ", ");
        for (String string2 : list) {
            List<String> list2 = Strings.toList("[" + string2 + "]", "=");
            if (list2.size() == 2) {
                hashMap.put(list2.get(0), list2.get(1));
                continue;
            }
            Err.prln("Ignoring element: [" + string2 + "]");
            Err.prln("Expecting: [key=value]");
        }
        return hashMap;
    }

    public static String crop(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n / 2 - 2) + "..." + string.substring(string.length() - n / 2);
        }
        return string;
    }
}

