/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.util.AnnotationDiffer;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.Out;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyMeasures {
    protected Map<String, Float> bdmByTypeMap = new HashMap<String, Float>();
    protected URL bdmFileUrl;
    protected Map<String, AnnotationDiffer> differByTypeMap = new HashMap<String, AnnotationDiffer>();
    protected Map<String, Float> bdmByConceptsMap;

    public OntologyMeasures() {
    }

    public OntologyMeasures(Collection<OntologyMeasures> collection) {
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        for (OntologyMeasures object : collection) {
            for (Map.Entry<String, Float> entry : object.bdmByTypeMap.entrySet()) {
                float f = 0.0f;
                if (this.bdmByTypeMap.containsKey(entry.getKey())) {
                    f = this.bdmByTypeMap.get(entry.getKey()).floatValue();
                }
                this.bdmByTypeMap.put(entry.getKey(), Float.valueOf(f + entry.getValue().floatValue()));
            }
            for (Map.Entry<String, Object> entry : object.differByTypeMap.entrySet()) {
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(entry.getKey());
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(entry.getValue());
                hashMap.put(entry.getKey(), arrayList);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.differByTypeMap.put((String)entry.getKey(), new AnnotationDiffer((Collection)entry.getValue()));
        }
    }

    public void calculateBdm(Collection<AnnotationDiffer> collection) {
        List<AnnotationDiffer> list;
        if (this.bdmByConceptsMap == null) {
            this.bdmByConceptsMap = this.read(this.bdmFileUrl);
        }
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        for (AnnotationDiffer iterator : collection) {
            hashSet.addAll(iterator.getAnnotationsOfType(3));
        }
        this.bdmByTypeMap.clear();
        for (AnnotationDiffer annotationDiffer : collection) {
            Set<Annotation> set = annotationDiffer.getAnnotationsOfType(2);
            if (!this.bdmByTypeMap.containsKey(annotationDiffer.getAnnotationType())) {
                this.bdmByTypeMap.put(annotationDiffer.getAnnotationType(), Float.valueOf(0.0f));
            }
            for (Annotation annotation : set) {
                list = annotation.getType();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Annotation annotation2 = (Annotation)iterator.next();
                    float f = 0.0f;
                    if (!annotation.coextensive(annotation2)) continue;
                    if (annotationDiffer.getSignificantFeaturesSet() != null) {
                        if (!((String)((Object)list)).equals(annotation2.getType())) continue;
                        for (Object e : annotationDiffer.getSignificantFeaturesSet()) {
                            if (annotation.getFeatures() == null || annotation2.getFeatures() == null) continue;
                            String string = (String)annotation.getFeatures().get(e);
                            String string2 = (String)annotation2.getFeatures().get(e);
                            if (string == null || string2 == null) continue;
                            if (this.bdmByConceptsMap.containsKey(string + ", " + string2)) {
                                f += this.bdmByConceptsMap.get(string + ", " + string2).floatValue();
                                continue;
                            }
                            if (!this.bdmByConceptsMap.containsKey(string2 + ", " + string)) continue;
                            f += this.bdmByConceptsMap.get(string2 + ", " + string).floatValue();
                        }
                        f /= (float)annotationDiffer.getSignificantFeaturesSet().size();
                    } else if (this.bdmByConceptsMap.containsKey(list + ',' + annotation2.getType())) {
                        f = this.bdmByConceptsMap.get(list + ',' + annotation2.getType()).floatValue();
                    } else if (this.bdmByConceptsMap.containsKey(annotation2.getType() + ", " + list)) {
                        f = this.bdmByConceptsMap.get(annotation2.getType() + ", " + list).floatValue();
                    }
                    if (!(f > 0.0f)) continue;
                    this.bdmByTypeMap.put((String)((Object)list), Float.valueOf(this.bdmByTypeMap.get(list).floatValue() + f));
                    iterator.remove();
                }
            }
        }
        this.differByTypeMap.clear();
        HashMap hashMap = new HashMap();
        for (AnnotationDiffer annotationDiffer : collection) {
            String string = annotationDiffer.getAnnotationType();
            list = (List)hashMap.get(string);
            if (list == null) {
                list = new ArrayList<AnnotationDiffer>();
            }
            list.add(annotationDiffer);
            hashMap.put(string, list);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.differByTypeMap.put((String)entry.getKey(), new AnnotationDiffer((Collection)entry.getValue()));
        }
    }

    public double getPrecisionStrictBdm(String string) {
        AnnotationDiffer annotationDiffer = this.differByTypeMap.get(string);
        if (annotationDiffer.getCorrectMatches() + annotationDiffer.getSpurious() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(string).floatValue() + (float)annotationDiffer.getCorrectMatches()) / (float)(annotationDiffer.getCorrectMatches() + annotationDiffer.getSpurious());
    }

    public double getPrecisionStrictBdm() {
        double d = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d += this.getPrecisionStrictBdm(string);
        }
        return d / (double)this.differByTypeMap.size();
    }

    public double getRecallStrictBdm(String string) {
        AnnotationDiffer annotationDiffer = this.differByTypeMap.get(string);
        if (annotationDiffer.getCorrectMatches() + annotationDiffer.getMissing() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(string).floatValue() + (float)annotationDiffer.getCorrectMatches()) / (float)(annotationDiffer.getCorrectMatches() + annotationDiffer.getMissing());
    }

    public double getRecallStrictBdm() {
        double d = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d += this.getRecallStrictBdm(string);
        }
        return d / (double)this.differByTypeMap.size();
    }

    public double getFMeasureStrictBdm(String string, double d) {
        double d2;
        double d3 = d * d;
        double d4 = this.getPrecisionStrictBdm(string);
        double d5 = (d3 + 1.0) * d4 * (d2 = this.getRecallStrictBdm(string)) / (d3 * d4 + d2);
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        return d5;
    }

    public double getFMeasureStrictBdm(double d) {
        double d2 = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d2 += this.getFMeasureStrictBdm(string, d);
        }
        return d2 / (double)this.differByTypeMap.size();
    }

    public double getPrecisionLenientBdm(String string) {
        AnnotationDiffer annotationDiffer = this.differByTypeMap.get(string);
        if (annotationDiffer.getCorrectMatches() + annotationDiffer.getSpurious() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(string).floatValue() + (float)annotationDiffer.getCorrectMatches() + (float)annotationDiffer.getPartiallyCorrectMatches()) / (float)(annotationDiffer.getCorrectMatches() + annotationDiffer.getSpurious());
    }

    public double getPrecisionLenientBdm() {
        double d = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d += this.getPrecisionLenientBdm(string);
        }
        return d / (double)this.differByTypeMap.size();
    }

    public double getRecallLenientBdm(String string) {
        AnnotationDiffer annotationDiffer = this.differByTypeMap.get(string);
        if (annotationDiffer.getCorrectMatches() + annotationDiffer.getMissing() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(string).floatValue() + (float)annotationDiffer.getCorrectMatches() + (float)annotationDiffer.getPartiallyCorrectMatches()) / (float)(annotationDiffer.getCorrectMatches() + annotationDiffer.getMissing());
    }

    public double getRecallLenientBdm() {
        double d = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d += this.getRecallLenientBdm(string);
        }
        return d / (double)this.differByTypeMap.size();
    }

    public double getFMeasureLenientBdm(String string, double d) {
        double d2;
        double d3 = d * d;
        double d4 = this.getPrecisionLenientBdm(string);
        double d5 = (d3 + 1.0) * d4 * (d2 = this.getRecallLenientBdm(string)) / (d3 * d4 + d2);
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        return d5;
    }

    public double getFMeasureLenientBdm(double d) {
        double d2 = 0.0;
        for (String string : this.differByTypeMap.keySet()) {
            d2 += this.getFMeasureLenientBdm(string, d);
        }
        return d2 / (double)this.differByTypeMap.size();
    }

    public double getPrecisionAverageBdm(String string) {
        return (this.getPrecisionLenientBdm(string) + this.getPrecisionStrictBdm(string)) / 2.0;
    }

    public double getPrecisionAverageBdm() {
        return (this.getPrecisionLenientBdm() + this.getPrecisionStrictBdm()) / 2.0;
    }

    public double getRecallAverageBdm(String string) {
        return (this.getRecallLenientBdm(string) + this.getRecallStrictBdm(string)) / 2.0;
    }

    public double getRecallAverageBdm() {
        return (this.getRecallLenientBdm() + this.getRecallStrictBdm()) / 2.0;
    }

    public double getFMeasureAverageBdm(String string, double d) {
        return (this.getFMeasureLenientBdm(string, d) + this.getFMeasureStrictBdm(string, d)) / 2.0;
    }

    public double getFMeasureAverageBdm(double d) {
        return (this.getFMeasureLenientBdm(d) + this.getFMeasureStrictBdm(d)) / 2.0;
    }

    public void setBdmFile(URL uRL) {
        this.bdmFileUrl = uRL;
        this.bdmByConceptsMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Float> read(URL uRL) {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        if (uRL == null) {
            Out.prln("There is no BDM file specified.");
            return hashMap;
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BomStrippingInputStreamReader((InputStream)new FileInputStream(Files.fileFromURL(uRL)), "UTF-8");
        bufferedReader.readLine();
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray = string.split(", ");
            if (stringArray.length > 3) {
                String string2 = stringArray[0].substring(4);
                String string3 = stringArray[1].substring(9);
                String string4 = stringArray[2].substring(4);
                hashMap.put(string2 + ", " + string3, new Float(string4));
            } else {
                Out.prln("File " + uRL.toString() + " has incorrect format" + "for the line [" + string + "].");
            }
            string = bufferedReader.readLine();
        }
        Object var10_10 = null;
        if (bufferedReader == null) return hashMap;
        try {
            bufferedReader.close();
            return hashMap;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
        {
            catch (Exception exception) {
                Out.prln("There is something wrong with the BDM file.");
                exception.printStackTrace();
                Object var10_11 = null;
                if (bufferedReader == null) return hashMap;
                try {
                    bufferedReader.close();
                    return hashMap;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public List<String> getMeasuresRow(Object[] objectArray, String string) {
        ArrayList<AnnotationDiffer> arrayList = new ArrayList<AnnotationDiffer>(this.getDifferByTypeMap().values());
        AnnotationDiffer annotationDiffer = new AnnotationDiffer(arrayList);
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string);
        arrayList2.add(Integer.toString(annotationDiffer.getCorrectMatches()));
        arrayList2.add(Integer.toString(annotationDiffer.getMissing()));
        arrayList2.add(Integer.toString(annotationDiffer.getSpurious()));
        arrayList2.add(Integer.toString(annotationDiffer.getPartiallyCorrectMatches()));
        for (Object object : objectArray) {
            String string2 = (String)object;
            double d = Double.valueOf(string2.substring(1, string2.indexOf(45)));
            if (string2.endsWith("strict")) {
                arrayList2.add(numberFormat.format(annotationDiffer.getRecallStrict()));
                arrayList2.add(numberFormat.format(annotationDiffer.getPrecisionStrict()));
                arrayList2.add(numberFormat.format(annotationDiffer.getFMeasureStrict(d)));
                continue;
            }
            if (string2.endsWith("strict BDM")) {
                arrayList2.add(numberFormat.format(this.getRecallStrictBdm()));
                arrayList2.add(numberFormat.format(this.getPrecisionStrictBdm()));
                arrayList2.add(numberFormat.format(this.getFMeasureStrictBdm(d)));
                continue;
            }
            if (string2.endsWith("lenient")) {
                arrayList2.add(numberFormat.format(annotationDiffer.getRecallLenient()));
                arrayList2.add(numberFormat.format(annotationDiffer.getPrecisionLenient()));
                arrayList2.add(numberFormat.format(annotationDiffer.getFMeasureLenient(d)));
                continue;
            }
            if (string2.endsWith("lenient BDM")) {
                arrayList2.add(numberFormat.format(this.getRecallLenientBdm()));
                arrayList2.add(numberFormat.format(this.getPrecisionLenientBdm()));
                arrayList2.add(numberFormat.format(this.getFMeasureLenientBdm(d)));
                continue;
            }
            if (string2.endsWith("average")) {
                arrayList2.add(numberFormat.format(annotationDiffer.getRecallAverage()));
                arrayList2.add(numberFormat.format(annotationDiffer.getPrecisionAverage()));
                arrayList2.add(numberFormat.format(annotationDiffer.getFMeasureAverage(d)));
                continue;
            }
            if (!string2.endsWith("average BDM")) continue;
            arrayList2.add(numberFormat.format(this.getRecallAverageBdm()));
            arrayList2.add(numberFormat.format(this.getPrecisionAverageBdm()));
            arrayList2.add(numberFormat.format(this.getFMeasureAverageBdm(d)));
        }
        return arrayList2;
    }

    public Map<String, AnnotationDiffer> getDifferByTypeMap() {
        return this.differByTypeMap;
    }
}

