/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

public class HashMapLong {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public HashMapLong(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public HashMapLong(int n) {
        this(n, 0.75f);
    }

    public HashMapLong() {
        this(11, 0.75f);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(long l) {
        Entry[] entryArray = this.table;
        int n = (int)(l ^ l >> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && l == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(long l, Object object) {
        Entry[] entryArray = this.table;
        int n = (int)(l ^ l >> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && l == entry.key) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, l, object, entryArray[n2]);
        ++this.count;
        return null;
    }

    private static class Entry {
        int hash;
        long key;
        Object value;
        Entry next;

        Entry(int n, long l, Object object, Entry entry) {
            this.hash = n;
            this.key = l;
            this.value = object;
            this.next = entry;
        }
    }
}

