/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.util.Out;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationMeasures {
    private float[][] confusionMatrix;
    private float kappaCohen = 0.0f;
    private float kappaPi = 0.0f;
    private boolean isCalculatedKappas = false;
    private TreeSet<String> featureValues;

    public ClassificationMeasures() {
    }

    public float getObservedAgreement() {
        float f = this.getAgreedTrials();
        float f2 = this.getTotalTrials();
        if (f2 > 0.0f) {
            return f / f2;
        }
        return 0.0f;
    }

    public float getKappaCohen() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaCohen;
    }

    public float getKappaPi() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaPi;
    }

    public float[][] getConfusionMatrix() {
        return (float[][])this.confusionMatrix.clone();
    }

    public SortedSet<String> getFeatureValues() {
        return Collections.unmodifiableSortedSet(this.featureValues);
    }

    public void calculateConfusionMatrix(AnnotationSet annotationSet, AnnotationSet annotationSet2, String string, String string2, boolean bl) {
        this.featureValues = new TreeSet();
        HashMap<String, HashMap<String, Float>> hashMap = new HashMap<String, HashMap<String, Float>>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        AnnotationSet annotationSet3 = annotationSet.get(string, hashSet);
        AnnotationSet annotationSet4 = annotationSet2.get(string, hashSet);
        for (Annotation annotation : annotationSet3) {
            Object object;
            Object object22;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object22 : annotationSet3) {
                if (object22.equals(annotation) || !object22.coextensive(annotation)) continue;
                arrayList.add(object22);
                arrayList.add(annotation);
            }
            if (arrayList.size() > 1) {
                if (!bl) continue;
                Out.prln("ClassificationMeasures: Same span annotations in set 1 detected! Ignoring.");
                Out.prln(Arrays.toString(arrayList.toArray()));
                continue;
            }
            ArrayList arrayList2 = new ArrayList();
            object22 = annotationSet4.iterator();
            while (object22.hasNext()) {
                object = (Annotation)object22.next();
                if (!object.coextensive(annotation)) continue;
                arrayList2.add(object);
            }
            if (arrayList2.size() == 0) {
                if (!bl) continue;
                Out.prln("ClassificationMeasures: Annotation in set 1 with no counterpart in set 2 detected! Ignoring.");
                Out.prln(annotation.toString());
                continue;
            }
            if (arrayList2.size() == 1) {
                Serializable serializable;
                object22 = (String)annotation.getFeatures().get(string2);
                object = (String)((Annotation)arrayList2.get(0)).getFeatures().get(string2);
                this.featureValues.add((String)object22);
                this.featureValues.add((String)object);
                HashMap<String, Float> hashMap2 = hashMap.get(object22);
                if (hashMap2 == null) {
                    serializable = new HashMap<Object, Float>();
                    ((HashMap)serializable).put(object, Float.valueOf(1.0f));
                    hashMap.put((String)object22, (HashMap<String, Float>)serializable);
                    continue;
                }
                serializable = hashMap2.get(object);
                if (serializable == null) {
                    hashMap2.put((String)object, Float.valueOf(1.0f));
                    continue;
                }
                hashMap2.put((String)object, Float.valueOf((float)((Float)serializable).intValue() + 1.0f));
                continue;
            }
            if (arrayList2.size() <= 1 || !bl) continue;
            Out.prln("ClassificationMeasures: Same span annotations in set 2 detected! Ignoring.");
            Out.prln(Arrays.toString(arrayList2.toArray()));
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(hashMap, this.featureValues);
    }

    public ClassificationMeasures(Collection<ClassificationMeasures> collection) {
        HashMap<String, HashMap<String, Float>> hashMap = new HashMap<String, HashMap<String, Float>>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ClassificationMeasures classificationMeasures : collection) {
            int n = 0;
            for (String string : classificationMeasures.featureValues) {
                treeSet.add(string);
                int n2 = 0;
                for (String string2 : classificationMeasures.featureValues) {
                    Serializable serializable;
                    Float f = Float.valueOf(classificationMeasures.confusionMatrix[n][n2]);
                    HashMap<String, Float> hashMap2 = hashMap.get(string);
                    if (hashMap2 == null) {
                        serializable = new HashMap<String, Float>();
                        ((HashMap)serializable).put(string2, f);
                        hashMap.put(string, (HashMap<String, Float>)serializable);
                    } else {
                        serializable = hashMap2.get(string2);
                        if (serializable == null) {
                            hashMap2.put(string2, f);
                        } else {
                            hashMap2.put(string2, Float.valueOf((float)((Float)serializable).intValue() + f.floatValue()));
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(hashMap, treeSet);
        this.featureValues = treeSet;
        this.isCalculatedKappas = false;
    }

    protected void computeKappaPairwise() {
        int n;
        float f;
        float f2 = this.getObservedAgreement();
        int n2 = this.featureValues.size();
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float f3 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += this.confusionMatrix[i][n];
            }
            fArray[i] = f;
            f3 += f;
            f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += this.confusionMatrix[n][i];
            }
            fArray2[i] = f;
        }
        float f4 = 0.0f;
        if (f3 > 0.0f) {
            f = f3 * f3;
            for (n = 0; n < n2; ++n) {
                f4 += fArray[n] * fArray2[n] / f;
            }
        }
        this.kappaCohen = f3 > 0.0f ? (f2 - f4) / (1.0f - f4) : 0.0f;
        f4 = 0.0f;
        if (f3 > 0.0f) {
            f = 2.0f * f3;
            for (n = 0; n < n2; ++n) {
                float f5 = (fArray[n] + fArray2[n]) / f;
                f4 += f5 * f5;
            }
        }
        this.kappaPi = f3 > 0.0f ? (f2 - f4) / (1.0f - f4) : 0.0f;
        float[][] fArray3 = new float[n2][2];
        for (n = 0; n < n2; ++n) {
            fArray3[n][0] = fArray[n] + fArray2[n] > 0.0f ? 2.0f * this.confusionMatrix[n][n] / (fArray[n] + fArray2[n]) : 0.0f;
            fArray3[n][1] = 2.0f * f3 - fArray[n] - fArray2[n] > 0.0f ? 2.0f * (f3 - fArray[n] - fArray2[n] + this.confusionMatrix[n][n]) / (2.0f * f3 - fArray[n] - fArray2[n]) : 0.0f;
        }
    }

    public float getAgreedTrials() {
        float f = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            f += this.confusionMatrix[i][i];
        }
        return f;
    }

    public float getTotalTrials() {
        float f = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            for (int j = 0; j < this.featureValues.size(); ++j) {
                f += this.confusionMatrix[i][j];
            }
        }
        return f;
    }

    public List<List<String>> getConfusionMatrix(String string) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(" ");
        arrayList.add(arrayList2);
        arrayList2 = new ArrayList();
        arrayList2.add(string);
        arrayList.add(arrayList2);
        TreeSet<String> treeSet = new TreeSet<String>(this.getFeatureValues());
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.addAll(treeSet);
        arrayList.add(arrayList2);
        for (float[] fArray : this.getConfusionMatrix()) {
            arrayList2 = new ArrayList();
            arrayList2.add((String)treeSet.first());
            treeSet.remove(treeSet.first());
            for (float f : fArray) {
                arrayList2.add(String.valueOf((int)f));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public List<String> getMeasuresRow(Object[] objectArray, String string) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(String.valueOf((int)this.getAgreedTrials()));
        arrayList.add(String.valueOf((int)this.getTotalTrials()));
        for (Object object : objectArray) {
            float f;
            String string2 = (String)object;
            if (string2.equals("Observed agreement")) {
                arrayList.add(numberFormat.format(this.getObservedAgreement()));
            }
            if (string2.equals("Cohen's Kappa")) {
                f = this.getKappaCohen();
                arrayList.add(Float.isNaN(f) ? "" : numberFormat.format(f));
            }
            if (!string2.equals("Pi's Kappa")) continue;
            f = this.getKappaPi();
            arrayList.add(Float.isNaN(f) ? "" : numberFormat.format(f));
        }
        return arrayList;
    }

    private float[][] convert2DHashTo2DFloatArray(HashMap<String, HashMap<String, Float>> hashMap, TreeSet<String> treeSet) {
        int n = treeSet.size();
        float[][] fArray = new float[n][n];
        int n2 = 0;
        int n3 = 0;
        for (String string : treeSet) {
            HashMap<String, Float> hashMap2 = hashMap.get(string);
            n3 = 0;
            for (String string2 : treeSet) {
                Float f = null;
                if (hashMap2 != null) {
                    f = hashMap2.get(string2);
                }
                fArray[n2][n3] = f != null ? f.floatValue() : 0.0f;
                ++n3;
            }
            ++n2;
        }
        return fArray;
    }
}

