/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.gui.MainFrame;
import gate.swing.AbstractTreeTableModel;
import gate.swing.JTreeTable;
import gate.swing.TreeTableModel;
import java.io.File;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TestJTreeTable {
    private JFrame mainFrame;
    private JTreeTable treeTable;
    private TreeTableModel treeTableModel;

    public TestJTreeTable() {
        this.initGui();
    }

    private void initGui() {
        UIManager.put("Tree.collapsedIcon", MainFrame.getIcon("closed"));
        UIManager.put("Tree.expandedIcon", MainFrame.getIcon("expanded"));
        this.mainFrame = new JFrame(JTreeTable.class.getName());
        this.mainFrame.setSize(800, 600);
        this.mainFrame.setDefaultCloseOperation(2);
        this.treeTableModel = new FileTTModel(new File("/"));
        this.treeTable = new JTreeTable(this.treeTableModel);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(MainFrame.getIcon("open-file"));
        defaultTreeCellRenderer.setClosedIcon(MainFrame.getIcon("open-file"));
        defaultTreeCellRenderer.setLeafIcon(MainFrame.getIcon("document"));
        this.treeTable.getTree().setCellRenderer(defaultTreeCellRenderer);
        this.treeTable.getTree().putClientProperty("JTree.lineStyle", "None");
        this.mainFrame.getContentPane().add(new JScrollPane(this.treeTable));
    }

    public static void main(String[] stringArray) {
        TestJTreeTable testJTreeTable = new TestJTreeTable();
        testJTreeTable.mainFrame.setVisible(true);
    }

    private class FileTTModel
    extends AbstractTreeTableModel {
        private File root;
        private String[] columnNames;
        private static final int NAME_COLUMN = 0;
        private static final int SIZE_COLUMN = 1;
        private static final int DATE_COLUMN = 2;

        public FileTTModel(File file) {
            super(file);
            this.columnNames = new String[]{"NAME", "SIZE", "DATE"};
            this.root = file;
        }

        public Object getChild(Object object, int n) {
            if (object instanceof File) {
                File file = (File)object;
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null && fileArray.length > n) {
                        return fileArray[n];
                    }
                    return null;
                }
                throw new RuntimeException("Not a directory!");
            }
            throw new RuntimeException("Not a file!");
        }

        public int getChildCount(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    return fileArray == null ? 0 : fileArray.length;
                }
                return 0;
            }
            throw new RuntimeException("Not a file!");
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof File) {
                File file = (File)object;
                switch (n) {
                    case 0: {
                        return file.getName();
                    }
                    case 1: {
                        return file.length();
                    }
                    case 2: {
                        return new Date(file.lastModified()).toString();
                    }
                }
                return "";
            }
            throw new RuntimeException("Not a file!");
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }
    }
}

