/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JMenuButton
extends JToggleButton {
    protected JPopupMenu popup;
    protected JMenu menu;

    public JMenuButton(JMenu jMenu) {
        this(jMenu.getPopupMenu());
        this.menu = jMenu;
    }

    public JMenuButton(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
        jPopupMenu.setInvoker(this);
        this.initListeners();
    }

    protected void initListeners() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(JMenuButton.this.isSelected());
                }
                if (JMenuButton.this.isSelected()) {
                    Point point = JMenuButton.this.getPopupMenuOrigin();
                    JMenuButton.this.popup.show(JMenuButton.this, point.x, point.y);
                } else {
                    JMenuButton.this.popup.setVisible(false);
                }
            }
        });
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                JMenuButton.this.setSelected(false);
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(false);
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                JMenuButton.this.setSelected(false);
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(false);
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    protected Point getPopupMenuOrigin() {
        int n;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.popup.getSize();
        if (dimension2.width == 0) {
            dimension2 = this.popup.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[n].getType() != 0 || !(graphicsConfiguration2 = graphicsDeviceArray[n].getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(insets.left + insets.right);
            rectangle.height -= Math.abs(insets.top + insets.bottom);
            point.x -= Math.abs(insets.left);
            point.y -= Math.abs(insets.top);
        }
        n = UIManager.getInt("Menu.menuPopupOffsetX");
        int n4 = UIManager.getInt("Menu.menuPopupOffsetY");
        if (this.getComponentOrientation().isLeftToRight()) {
            n2 = n;
            if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                n2 = dimension.width - n - dimension2.width;
            }
        } else {
            n2 = dimension.width - n - dimension2.width;
            if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                n2 = n;
            }
        }
        if (point.y + (n3 = dimension.height + n4) + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
            n3 = 0 - n4 - dimension2.height;
        }
        return new Point(n2, n3);
    }
}

