/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.DocumentContent;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.Node;
import gate.corpora.DatabaseCorpusImpl;
import gate.corpora.DatabaseDocumentImpl;
import gate.persist.DBHelper;
import gate.persist.DatabaseDataStore;
import gate.persist.JDBCDataStore;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.util.MethodNotImplementedException;
import gate.util.OrderByRestriction;
import gate.util.Restriction;
import gate.util.SimpleFeatureMapImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Assert;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleDataStore
extends JDBCDataStore {
    private static final String DS_COMMENT = "GATE Oracle datastore";
    private static final String DS_ICON_NAME = "ora_ds";
    private static final boolean DEBUG = false;
    private static final int ORACLE_TRUE = 1;
    private static final int ORACLE_FALSE = 0;
    private static final int VARRAY_SIZE = 10;
    private static final int ORACLE_VARCHAR_LIMIT_BYTES = 4000;
    private static final int UTF_BYTES_PER_CHAR_MAX = 3;
    private static final int ORACLE_VARCHAR_MAX_SYMBOLS = 1333;
    private static final int INTERNAL_BUFFER_SIZE = 16384;

    public OracleDataStore() {
        this.datastoreComment = DS_COMMENT;
        this.iconName = DS_ICON_NAME;
    }

    public void setStorageUrl(String string) throws PersistenceException {
        super.setStorageUrl(string);
    }

    public String getStorageUrl() {
        return super.getStorageUrl();
    }

    public void create() throws PersistenceException, UnsupportedOperationException {
        super.create();
    }

    public void open() throws PersistenceException {
        super.open();
    }

    public void close() throws PersistenceException {
        super.close();
    }

    protected void deleteDocument(Long l) throws PersistenceException {
        Assert.assertNotNull((Object)l);
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.delete_document(?) }");
                callableStatement.setLong(1, (long)l);
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't delete LR from DB: [" + sQLException.getMessage() + "]");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void deleteCorpus(Long l) throws PersistenceException {
        Long l2 = l;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.delete_corpus(?) }");
                callableStatement.setLong(1, (long)l2);
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't delete LR from DB: [" + sQLException.getMessage() + "]");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    public void setAutoSaving(boolean bl) throws UnsupportedOperationException, PersistenceException {
        super.setAutoSaving(bl);
    }

    public boolean isAutoSaving() {
        throw new MethodNotImplementedException();
    }

    protected Long createLR(String string, String string2, SecurityInfo securityInfo, Long l) throws PersistenceException, SecurityException {
        Long l2;
        Assert.assertNotNull((Object)string2);
        CallableStatement callableStatement = null;
        try {
            Long l3;
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_lr(?,?,?,?,?,?,?) }");
            callableStatement.setLong(1, (long)securityInfo.getUser().getID());
            callableStatement.setLong(2, (long)securityInfo.getGroup().getID());
            callableStatement.setString(3, string);
            callableStatement.setString(4, string2);
            callableStatement.setInt(5, securityInfo.getAccessMode());
            if (null == l) {
                callableStatement.setNull(6, -5);
            } else {
                callableStatement.setLong(6, (long)l);
            }
            callableStatement.registerOutParameter(7, -5);
            callableStatement.execute();
            l2 = l3 = new Long(callableStatement.getLong(7));
            Object var9_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20113: {
                        throw new PersistenceException("can't create LR [step 3] in DB, invalid LR Type");
                    }
                }
                throw new PersistenceException("can't create LR [step 3] in DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(callableStatement);
        return l2;
    }

    protected void updateDocumentContent(Long l, DocumentContent documentContent) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CallableStatement callableStatement = null;
        try {
            try {
                String string = "select dc.dc_id,        dc.dc_content_type,        dc.dc_character_content,        dc.dc_binary_content from gateadmin.t_doc_content dc , gateadmin.t_document doc where  dc.dc_id = doc.doc_content_id        and doc.doc_id = ? for update ";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Long l2 = new Long(resultSet.getLong("dc_id"));
                long l3 = resultSet.getLong("DC_CONTENT_TYPE");
                Clob clob = resultSet.getClob("dc_character_content");
                Blob blob = resultSet.getBlob("dc_binary_content");
                Assert.assertTrue((l3 == 1L || l3 == 2L || l3 == 3L ? 1 : 0) != 0);
                OracleDataStore.writeCLOB(documentContent.toString(), clob);
                long l4 = 1L;
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.change_content_type(?,?) }");
                callableStatement.setLong(1, (long)l2);
                callableStatement.setLong(2, l4);
                callableStatement.execute();
            }
            catch (IOException iOException) {
                throw new PersistenceException("can't update document content in DB : [" + iOException.getMessage() + "]");
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't update document content in DB : [" + sQLException.getMessage() + "]");
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        DBHelper.cleanup(callableStatement);
    }

    protected Long createDoc(Long l, URL uRL, String string, Long l2, Long l3, Boolean bl, Long l4) throws PersistenceException {
        Long l5;
        CallableStatement callableStatement = null;
        Long l6 = null;
        try {
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_document(?,?,?,?,?,?,?,?) }");
            callableStatement.setLong(1, (long)l);
            if (uRL == null) {
                callableStatement.setNull(2, 12);
            } else {
                callableStatement.setString(2, uRL.toString());
            }
            if (null == string) {
                callableStatement.setNull(3, 12);
            } else {
                callableStatement.setString(3, string);
            }
            if (null == l2) {
                callableStatement.setNull(4, 2);
            } else {
                callableStatement.setLong(4, (long)l2);
            }
            if (null == l3) {
                callableStatement.setNull(5, 2);
            } else {
                callableStatement.setLong(5, (long)l3);
            }
            callableStatement.setBoolean(6, (boolean)bl);
            if (null == l4) {
                callableStatement.setNull(7, -5);
            } else {
                callableStatement.setLong(7, (long)l4);
            }
            callableStatement.registerOutParameter(8, -5);
            callableStatement.execute();
            l5 = l6 = new Long(callableStatement.getLong(8));
            Object var12_12 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't create document [step 4] in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(callableStatement);
        return l5;
    }

    protected void createAnnotationSet(Long l, AnnotationSet annotationSet) throws PersistenceException {
        Node node;
        String string = annotationSet.getName();
        Long l2 = null;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_annotation_set(?,?,?) }");
                callableStatement.setLong(1, (long)l);
                if (null == string) {
                    callableStatement.setNull(2, 12);
                } else {
                    callableStatement.setString(2, string);
                }
                callableStatement.registerOutParameter(3, -5);
                callableStatement.execute();
                l2 = new Long(callableStatement.getLong(3));
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't create a-set [step 1] in DB: [" + sQLException.getMessage() + "]");
            }
            node = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_annotation(?,?,?,?,?,?,?,?,?) }");
                for (Annotation annotation : annotationSet) {
                    node = annotation.getStartNode();
                    Node node2 = annotation.getEndNode();
                    String string2 = annotation.getType();
                    Long l3 = null;
                    callableStatement.setLong(1, (long)l);
                    callableStatement.setLong(2, annotation.getId().longValue());
                    callableStatement.setLong(3, (long)l2);
                    callableStatement.setLong(4, node.getId().longValue());
                    callableStatement.setLong(5, (long)node.getOffset());
                    callableStatement.setLong(6, node2.getId().longValue());
                    callableStatement.setLong(7, (long)node2.getOffset());
                    callableStatement.setString(8, string2);
                    callableStatement.registerOutParameter(9, -5);
                    callableStatement.execute();
                    l3 = new Long(callableStatement.getLong(9));
                    FeatureMap featureMap = annotation.getFeatures();
                    Assert.assertNotNull((Object)featureMap);
                    this.createFeaturesBulk(l3, 3, featureMap);
                }
                Object var14_17 = null;
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20114: {
                        throw new PersistenceException("can't create annotation in DB, [invalid annotation type]");
                    }
                }
                throw new PersistenceException("can't create annotation in DB: [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    public Long timestamp() throws PersistenceException {
        Long l;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.get_timestamp(?)} ");
            callableStatement.registerOutParameter(1, -5);
            callableStatement.execute();
            long l2 = callableStatement.getLong(1);
            l = new Long(l2);
            Object var6_5 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get a timestamp from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(callableStatement);
        return l;
    }

    protected boolean canAccessLR(Long l, int n) throws PersistenceException, SecurityException {
        boolean bl;
        Assert.assertTrue((0 == n || 1 == n ? 1 : 0) != 0);
        if (null == this.session) {
            throw new SecurityException("user session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.security.has_access_to_lr(?,?,?,?,?)} ");
            callableStatement.setLong(1, (long)l);
            callableStatement.setLong(2, (long)this.session.getUser().getID());
            callableStatement.setLong(3, (long)this.session.getGroup().getID());
            callableStatement.setLong(4, (long)n);
            callableStatement.registerOutParameter(5, 2);
            callableStatement.execute();
            int n2 = callableStatement.getInt(5);
            bl = 1 == n2;
            Object var7_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't check permissions in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(callableStatement);
        return bl;
    }

    public static void readCLOB(Clob clob, StringBuffer stringBuffer) throws SQLException, IOException {
        int n = 0;
        stringBuffer.delete(0, stringBuffer.length());
        CLOB cLOB = (CLOB)clob;
        int n2 = Math.max(16384, cLOB.getBufferSize());
        char[] cArray = new char[n2];
        Reader reader = cLOB.getCharacterStream();
        BufferedReader bufferedReader = new BufferedReader(reader, 16384);
        while ((n = bufferedReader.read(cArray, 0, 16384)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        reader.close();
    }

    public static void writeCLOB(String string, Clob clob) throws SQLException, IOException {
        Assert.assertNotNull((Object)string);
        CLOB cLOB = (CLOB)clob;
        Writer writer = cLOB.getCharacterOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(writer, 16384);
        bufferedWriter.write(string.toString());
        bufferedWriter.flush();
        writer.flush();
        bufferedWriter.close();
        writer.close();
    }

    public static void writeCLOB(StringBuffer stringBuffer, Clob clob) throws SQLException, IOException {
        OracleDataStore.writeCLOB(stringBuffer.toString(), clob);
    }

    public static Object readBLOB(Blob blob) throws SQLException, IOException, ClassNotFoundException {
        boolean bl = false;
        Object object = null;
        Assert.assertNotNull((Object)blob);
        BLOB bLOB = (BLOB)blob;
        InputStream inputStream = bLOB.getBinaryStream();
        Assert.assertNotNull((Object)inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        object = objectInputStream.readObject();
        objectInputStream.close();
        inputStream.close();
        return object;
    }

    public static void writeBLOB(Object object, Blob blob) throws SQLException, IOException {
        Assert.assertNotNull((Object)object);
        BLOB bLOB = (BLOB)blob;
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        outputStream.flush();
        objectOutputStream.close();
        outputStream.close();
    }

    private Long _createFeature(Long l, int n, String string, Object object, int n2, CallableStatement callableStatement) throws PersistenceException {
        Long l2 = null;
        try {
            try {
                callableStatement.setLong(1, (long)l);
                callableStatement.setLong(2, (long)n);
                callableStatement.setString(3, string);
                callableStatement.setNull(4, 2);
                callableStatement.setNull(5, 12);
                callableStatement.setLong(6, (long)n2);
                callableStatement.registerOutParameter(7, -5);
                switch (n2) {
                    case 100: {
                        break;
                    }
                    case 103: {
                        boolean bl = (Boolean)object;
                        callableStatement.setLong(4, bl ? 1L : 0L);
                        break;
                    }
                    case 101: {
                        callableStatement.setLong(4, (long)((Integer)object).intValue());
                        break;
                    }
                    case 102: {
                        callableStatement.setLong(4, (long)((Long)object));
                        break;
                    }
                    case 106: {
                        Double d = (Double)object;
                        callableStatement.setDouble(4, (double)d);
                        break;
                    }
                    case 105: {
                        break;
                    }
                    case 104: {
                        String string2 = (String)object;
                        if (!this.fitsInVarchar2(string2)) break;
                        callableStatement.setString(5, string2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsuppoeted feature type");
                    }
                }
                callableStatement.execute();
                l2 = new Long(callableStatement.getLong(7));
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20115: {
                        throw new PersistenceException("can't create feature [step 1],[invalid feature type] in DB: [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't create feature [step 1] in DB: [" + sQLException.getMessage() + "]");
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            throw throwable;
        }
        return l2;
    }

    private void _createFeatureBulk(Vector vector, CallableStatement callableStatement, ArrayDescriptor arrayDescriptor, ArrayDescriptor arrayDescriptor2) throws PersistenceException {
        String[] stringArray = new String[10];
        long[] lArray = new long[10];
        double[] dArray = new double[10];
        long[] lArray2 = new long[10];
        long[] lArray3 = new long[10];
        String[] stringArray2 = new String[10];
        long[] lArray4 = new long[10];
        try {
            int n = 0;
            int n2 = 0;
            for (Feature feature : vector) {
                String string;
                lArray2[n2] = feature.entityID;
                lArray3[n2] = feature.entityType;
                stringArray2[n2] = feature.key;
                lArray4[n2] = feature.valueType;
                Assert.assertTrue((feature.valueType == 103 || feature.valueType == 106 || feature.valueType == 101 || feature.valueType == 102 || feature.valueType == 100 || feature.valueType == 104 ? 1 : 0) != 0);
                Object object = feature.value;
                switch (feature.valueType) {
                    case 100: {
                        lArray[n2] = 0L;
                        dArray[n2] = 0.0;
                        stringArray[n2] = "";
                        break;
                    }
                    case 103: {
                        boolean bl = (Boolean)object;
                        lArray[n2] = bl ? 1L : 0L;
                        dArray[n2] = 0.0;
                        stringArray[n2] = "";
                        break;
                    }
                    case 101: {
                        lArray[n2] = ((Integer)object).intValue();
                        dArray[n2] = 0.0;
                        stringArray[n2] = "";
                        break;
                    }
                    case 102: {
                        lArray[n2] = (Long)object;
                        dArray[n2] = 0.0;
                        stringArray[n2] = "";
                        break;
                    }
                    case 106: {
                        dArray[n2] = (Double)object;
                        lArray[n2] = 0L;
                        stringArray[n2] = "";
                        break;
                    }
                    case 105: {
                        Assert.fail();
                        break;
                    }
                    case 104: {
                        string = (String)object;
                        if (this.fitsInVarchar2(string)) {
                            stringArray[n2] = string;
                            dArray[n2] = 0.0;
                            lArray[n2] = 0L;
                            break;
                        }
                        Assert.fail();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsuppoeted feature type");
                    }
                }
                if (++n != vector.size() && ++n2 != 10) continue;
                if (n2 == 10) {
                    n2 = 0;
                }
                ARRAY aRRAY = new ARRAY(arrayDescriptor, this.jdbcConn, (Object)lArray2);
                string = new ARRAY(arrayDescriptor, this.jdbcConn, (Object)lArray3);
                ARRAY aRRAY2 = new ARRAY(arrayDescriptor2, this.jdbcConn, (Object)stringArray2);
                ARRAY aRRAY3 = new ARRAY(arrayDescriptor, this.jdbcConn, (Object)lArray4);
                ARRAY aRRAY4 = new ARRAY(arrayDescriptor, this.jdbcConn, (Object)lArray);
                ARRAY aRRAY5 = new ARRAY(arrayDescriptor, this.jdbcConn, (Object)dArray);
                ARRAY aRRAY6 = new ARRAY(arrayDescriptor2, this.jdbcConn, (Object)stringArray);
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(1, aRRAY);
                oracleCallableStatement.setARRAY(2, (ARRAY)string);
                oracleCallableStatement.setARRAY(3, aRRAY2);
                oracleCallableStatement.setARRAY(4, aRRAY4);
                oracleCallableStatement.setARRAY(5, aRRAY5);
                oracleCallableStatement.setARRAY(6, aRRAY6);
                oracleCallableStatement.setARRAY(7, aRRAY3);
                oracleCallableStatement.setInt(8, n2 == 0 ? 10 : n2);
                oracleCallableStatement.execute();
            }
        }
        catch (SQLException sQLException) {
            switch (sQLException.getErrorCode()) {
                case 20115: {
                    throw new PersistenceException("can't create feature [step 1],[invalid feature type] in DB: [" + sQLException.getMessage() + "]");
                }
            }
            throw new PersistenceException("can't create feature [step 1] in DB: [" + sQLException.getMessage() + "]");
        }
    }

    private void _updateFeatureLOB(Long l, Object object, int n) throws PersistenceException {
        Assert.assertTrue((n == 105 || n == 104 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Clob clob = null;
        Blob blob = null;
        try {
            block8: {
                try {
                    String string = " select ft_long_character_value,         ft_binary_value  from  gateadmin.t_feature  where  ft_id = ? ";
                    preparedStatement = this.jdbcConn.prepareStatement(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    if (!resultSet.next()) {
                        throw new PersistenceException("Incorrect feature ID supplied [" + l + "]");
                    }
                    clob = resultSet.getClob(1);
                    blob = resultSet.getBlob(2);
                    if (n == 105) {
                        OracleDataStore.writeBLOB(object, blob);
                        break block8;
                    }
                    if (n == 104) {
                        String string2 = (String)object;
                        OracleDataStore.writeCLOB(string2, clob);
                        break block8;
                    }
                    Assert.fail();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't create feature [step 2] in DB: [" + sQLException.getMessage() + "]");
                }
                catch (IOException iOException) {
                    throw new PersistenceException("can't create feature [step 2] in DB: [" + iOException.getMessage() + "]");
                }
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
    }

    private void createFeature(Long l, int n, String string, Object object, CallableStatement callableStatement) throws PersistenceException {
        Iterator iterator;
        int n2 = this.findFeatureType(object);
        Vector<Object> vector = new Vector<Object>();
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                vector.add(object);
                break;
            }
            default: {
                List list = (List)object;
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
                if (n2 == 111) {
                    n2 = 105;
                    break;
                }
                if (n2 == 109) {
                    n2 = 103;
                    break;
                }
                if (n2 == 112) {
                    n2 = 106;
                    break;
                }
                if (n2 == 107) {
                    n2 = 101;
                    break;
                }
                if (n2 == 108) {
                    n2 = 102;
                    break;
                }
                if (n2 != 110) break;
                n2 = 104;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            iterator = vector.elementAt(i);
            Long l2 = this._createFeature(l, n, string, iterator, n2, callableStatement);
            if (n2 == 104) {
                String string2 = (String)((Object)iterator);
                if (this.fitsInVarchar2(string2)) continue;
                this._updateFeatureLOB(l2, object, n2);
                continue;
            }
            if (n2 != 105) continue;
            this._updateFeatureLOB(l2, object, n2);
        }
    }

    private Vector normalizeFeature(Long l, int n, String string, Object object) throws PersistenceException {
        Iterator iterator;
        int n2 = this.findFeatureType(object);
        Vector<Object> vector = new Vector<Object>();
        Vector<Feature> vector2 = new Vector<Feature>();
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                vector.add(object);
                break;
            }
            default: {
                List list = (List)object;
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
                if (n2 == 111) {
                    n2 = 105;
                    break;
                }
                if (n2 == 109) {
                    n2 = 103;
                    break;
                }
                if (n2 == 112) {
                    n2 = 106;
                    break;
                }
                if (n2 == 107) {
                    n2 = 101;
                    break;
                }
                if (n2 == 108) {
                    n2 = 102;
                    break;
                }
                if (n2 != 110) break;
                n2 = 104;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            iterator = vector.elementAt(i);
            Feature feature = new Feature(l, n, string, iterator, n2);
            vector2.add(feature);
        }
        return vector2;
    }

    private boolean fitsInVarchar2(String string) {
        return string.getBytes().length < 4000;
    }

    protected void createFeatures(Long l, int n, FeatureMap featureMap) throws PersistenceException {
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        ArrayDescriptor arrayDescriptor = null;
        ArrayDescriptor arrayDescriptor2 = null;
        try {
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_feature(?,?,?,?,?,?,?)} ");
            callableStatement2 = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_feature_bulk(?,?,?,?,?,?,?,?)} ");
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)"GATEADMIN.PERSIST.INTARRAY", (Connection)this.jdbcConn);
            arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"GATEADMIN.PERSIST.CHARARRAY", (Connection)this.jdbcConn);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        Set set = featureMap.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            this.createFeature(l, n, string, v, callableStatement);
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void createFeaturesBulk(Long l, int n, FeatureMap featureMap) throws PersistenceException {
        Serializable serializable;
        Object object;
        Object object2;
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        ArrayDescriptor arrayDescriptor = null;
        ArrayDescriptor arrayDescriptor2 = null;
        try {
            callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_feature(?,?,?,?,?,?,?)} ");
            callableStatement2 = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_feature_bulk(?,?,?,?,?,?,?,?)} ");
            arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)("gateadmin".toUpperCase() + ".STRING_ARRAY"), (Connection)this.jdbcConn);
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)("gateadmin".toUpperCase() + ".INT_ARRAY"), (Connection)this.jdbcConn);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        Vector vector = new Vector();
        Set set = featureMap.entrySet();
        for (Map.Entry object32 : set) {
            object2 = (String)object32.getKey();
            object = object32.getValue();
            serializable = this.normalizeFeature(l, n, (String)object2, object);
            vector.addAll(serializable);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object2 = (Feature)iterator.next();
            if (((Feature)object2).valueType == 104) {
                object = (String)((Feature)object2).value;
                if (this.fitsInVarchar2((String)object)) continue;
                serializable = this._createFeature(((Feature)object2).entityID, ((Feature)object2).entityType, ((Feature)object2).key, ((Feature)object2).value, ((Feature)object2).valueType, callableStatement);
                this._updateFeatureLOB((Long)serializable, ((Feature)object2).value, ((Feature)object2).valueType);
                iterator.remove();
                continue;
            }
            if (((Feature)object2).valueType != 105) continue;
            object = this._createFeature(((Feature)object2).entityID, ((Feature)object2).entityType, ((Feature)object2).key, ((Feature)object2).value, ((Feature)object2).valueType, callableStatement);
            this._updateFeatureLOB((Long)object, ((Feature)object2).value, ((Feature)object2).valueType);
            iterator.remove();
        }
        this._createFeatureBulk(vector, callableStatement2, arrayDescriptor, arrayDescriptor2);
        DBHelper.cleanup(callableStatement);
        DBHelper.cleanup(callableStatement2);
    }

    public void setSecurityInfo(LanguageResource languageResource, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        throw new MethodNotImplementedException();
    }

    protected FeatureMap readFeatures(Long l, int n) throws PersistenceException {
        Assert.assertNotNull((Object)l);
        Assert.assertTrue((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        try {
            block25: {
                try {
                    String string = " select v2.fk_string,         v1.ft_value_type,         v1.ft_number_value,         v1.ft_binary_value,         v1.ft_character_value,         v1.ft_long_character_value  from  gateadmin.t_feature v1,        gateadmin.t_feature_key v2  where  v1.ft_entity_id = ?         and v1.ft_entity_type = ?         and v1.ft_key_id = v2.fk_id  order by v2.fk_string,v1.ft_id";
                    preparedStatement = this.jdbcConn.prepareStatement(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, n);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    Vector<Object> vector = new Vector<Object>();
                    String string2 = null;
                    String string3 = null;
                    Object object = null;
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        Long l2 = new Long(resultSet.getLong(2));
                        Comparable<Boolean> comparable = null;
                        switch (l2.intValue()) {
                            case 103: {
                                comparable = new Boolean(resultSet.getBoolean(3));
                                break;
                            }
                            case 106: {
                                comparable = new Double(resultSet.getDouble(3));
                                break;
                            }
                            case 101: {
                                comparable = new Integer(resultSet.getInt(3));
                                break;
                            }
                            case 102: {
                                comparable = new Long(resultSet.getLong(3));
                            }
                        }
                        Blob blob = resultSet.getBlob(4);
                        String string4 = resultSet.getString(5);
                        Clob clob = resultSet.getClob(6);
                        switch (l2.intValue()) {
                            case 100: {
                                object = null;
                                break;
                            }
                            case 101: 
                            case 102: 
                            case 103: 
                            case 106: {
                                object = comparable;
                                break;
                            }
                            case 105: {
                                object = OracleDataStore.readBLOB(blob);
                                break;
                            }
                            case 104: {
                                if (null == string4) {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    OracleDataStore.readCLOB(clob, stringBuffer);
                                    object = stringBuffer.toString();
                                    break;
                                }
                                object = string4;
                                break;
                            }
                            default: {
                                throw new PersistenceException("Invalid feature type found in DB, type is [" + l2.intValue() + "]");
                            }
                        }
                        if (string3.equals(string2) && string2 != null) {
                            vector.add(object);
                            continue;
                        }
                        if (vector.size() > 1) {
                            simpleFeatureMapImpl.put(string2, new Vector(vector));
                        } else if (vector.size() == 1) {
                            simpleFeatureMapImpl.put(string2, vector.elementAt(0));
                        }
                        vector.clear();
                        string2 = string3;
                        vector.add(object);
                    }
                    if (vector.size() > 1) {
                        simpleFeatureMapImpl.put(string3, vector);
                        break block25;
                    }
                    if (vector.size() != 1) break block25;
                    simpleFeatureMapImpl.put(string3, vector.elementAt(0));
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't read features from DB: [" + sQLException.getMessage() + "]");
                }
                catch (IOException iOException) {
                    throw new PersistenceException("can't read features from DB: [" + iOException.getMessage() + "]");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PersistenceException("can't read features from DB: [" + classNotFoundException.getMessage() + "]");
                }
            }
            Object var18_20 = null;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return simpleFeatureMapImpl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OracleDataStore)) {
            return false;
        }
        OracleDataStore oracleDataStore = (OracleDataStore)object;
        return false != this.getDatabaseID().equals(oracleDataStore.getDatabaseID());
    }

    protected void _syncLR(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.update_lr(?,?,?) }");
                callableStatement.setLong(1, (long)((Long)languageResource.getLRPersistenceId()));
                callableStatement.setString(2, languageResource.getName());
                if (languageResource instanceof Document && null != languageResource.getParent()) {
                    callableStatement.setLong(3, (long)((Long)languageResource.getParent().getLRPersistenceId()));
                } else {
                    callableStatement.setNull(3, -5);
                }
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("can't set LR name in DB: [invalid LR ID]");
                    }
                }
                throw new PersistenceException("can't set LR name in DB: [" + sQLException.getMessage() + "]");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void _syncDocumentHeader(Document document) throws PersistenceException {
        Long l = (Long)document.getLRPersistenceId();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.update_document(?,?,?,?,?) }");
                callableStatement.setLong(1, (long)l);
                if (null == document.getSourceUrl()) {
                    callableStatement.setNull(2, 12);
                } else {
                    callableStatement.setString(2, document.getSourceUrl().toString());
                }
                if (null == document.getSourceUrlStartOffset()) {
                    callableStatement.setNull(3, 2);
                } else {
                    callableStatement.setLong(3, (long)document.getSourceUrlStartOffset());
                }
                if (null == document.getSourceUrlEndOffset()) {
                    callableStatement.setNull(4, 2);
                } else {
                    callableStatement.setLong(4, (long)document.getSourceUrlEndOffset());
                }
                callableStatement.setLong(5, true == document.getMarkupAware() ? 1L : 0L);
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR supplied: no such document: [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't change document data: [" + sQLException.getMessage() + "]");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void _syncDocumentContent(Document document) throws PersistenceException {
        Long l = (Long)document.getLRPersistenceId();
        this.updateDocumentContent(l, document.getContent());
    }

    protected void _syncRemovedDocumentsFromCorpus(List list, Long l) throws PersistenceException {
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)l);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.remove_document_from_corpus(?,?) }");
                for (Long l2 : list) {
                    callableStatement.setLong(1, (long)l2);
                    callableStatement.setLong(2, (long)l);
                    callableStatement.execute();
                }
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR supplied: no such document: [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't change document data: [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void _syncFeatures(LanguageResource languageResource) throws PersistenceException {
        int n;
        Assert.assertNotNull((Object)languageResource);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((String)((DatabaseDataStore)languageResource.getDataStore()).getDatabaseID(), (String)this.getDatabaseID());
        Assert.assertTrue((languageResource instanceof Document || languageResource instanceof Corpus ? 1 : 0) != 0);
        Long l = (Long)languageResource.getLRPersistenceId();
        CallableStatement callableStatement = null;
        try {
            try {
                Assert.assertTrue((false == this.jdbcConn.getAutoCommit() ? 1 : 0) != 0);
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.delete_features(?,?) }");
                callableStatement.setLong(1, (long)l);
                if (languageResource instanceof Document) {
                    n = 2;
                } else if (languageResource instanceof Corpus) {
                    n = 1;
                } else {
                    throw new IllegalArgumentException();
                }
                callableStatement.setInt(2, n);
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't delete features in DB: [" + sQLException.getMessage() + "]");
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
        this.createFeaturesBulk(l, n, languageResource.getFeatures());
    }

    public boolean lockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((Object)languageResource.getDataStore(), (Object)this);
        return this._lockLr((Long)languageResource.getLRPersistenceId());
    }

    private boolean _lockLr(Long l) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)l);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(l)) {
            throw new SecurityException("no write access granted to the user");
        }
        CallableStatement callableStatement = null;
        boolean bl = false;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.lock_lr(?,?,?,?) }");
                callableStatement.setLong(1, (long)l);
                callableStatement.setLong(2, (long)this.session.getUser().getID());
                callableStatement.setLong(3, (long)this.session.getGroup().getID());
                callableStatement.registerOutParameter(4, 2);
                callableStatement.execute();
                bl = callableStatement.getLong(4) == 1L;
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't lock LR in DB : [" + sQLException.getMessage() + "]");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
        return bl;
    }

    public void unlockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((Object)languageResource.getDataStore(), (Object)this);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(languageResource.getLRPersistenceId())) {
            throw new SecurityException("no write access granted to the user");
        }
        CallableStatement callableStatement = null;
        boolean bl = false;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.unlock_lr(?,?) }");
                callableStatement.setLong(1, (long)((Long)languageResource.getLRPersistenceId()));
                callableStatement.setLong(2, (long)this.session.getUser().getID());
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't unlock LR in DB : [" + sQLException.getMessage() + "]");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    protected void addDocumentToCorpus(Long l, Long l2) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)l);
        Assert.assertNotNull((Object)l2);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(l2)) {
            throw new SecurityException("no write access granted to the user");
        }
        if (!this.canWriteLR(l)) {
            throw new SecurityException("no write access granted to the user");
        }
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.add_document_to_corpus(?,?) }");
                callableStatement.setLong(1, (long)l);
                callableStatement.setLong(2, (long)l2);
                callableStatement.execute();
            }
            catch (SQLException sQLException) {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't add document to corpus : [" + sQLException.getMessage() + "]");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
    }

    public List findLrIds(List list) throws PersistenceException {
        return this.findLrIds(list, null);
    }

    public List findLrIds(List list, String string) throws PersistenceException {
        return this.findLrIds(list, string, null, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findLrIds(List list, String string, List list2, int n) throws PersistenceException {
        Vector<Long> vector;
        Vector<Long> vector2 = new Vector<Long>();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            try {
                Vector vector3 = new Vector();
                String string2 = this.getSQLQuery(list, string, false, list2, n, vector3);
                connection = DBHelper.connect(this.getStorageUrl(), true);
                callableStatement = connection.prepareCall(string2);
                for (int i = 0; i < vector3.size(); ++i) {
                    if (vector3.elementAt(i) instanceof String) {
                        callableStatement.setString(i + 1, vector3.elementAt(i).toString());
                        continue;
                    }
                    if (vector3.elementAt(i) instanceof Long) {
                        callableStatement.setLong(i + 1, (long)((Long)vector3.elementAt(i)));
                        continue;
                    }
                    if (!(vector3.elementAt(i) instanceof Integer)) continue;
                    callableStatement.setLong(i + 1, (long)((Integer)vector3.elementAt(i)).intValue());
                }
                callableStatement.execute();
                resultSet = callableStatement.getResultSet();
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    vector2.addElement(new Long(l));
                }
                vector = vector2;
                Object var14_16 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't get LRs from DB: [" + sQLException + "]");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PersistenceException("can't not find driver: [" + classNotFoundException + "]");
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(callableStatement);
            DBHelper.disconnect(connection, true);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(callableStatement);
        DBHelper.disconnect(connection, true);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLrsCount(List list, String string) throws PersistenceException {
        long l;
        Vector vector = new Vector();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            try {
                Vector vector2 = new Vector();
                String string2 = this.getSQLQuery(list, string, true, null, -1, vector2);
                connection = DBHelper.connect(this.getStorageUrl(), true);
                callableStatement = connection.prepareCall(string2);
                for (int i = 0; i < vector2.size(); ++i) {
                    if (vector2.elementAt(i) instanceof String) {
                        callableStatement.setString(i + 1, vector2.elementAt(i).toString());
                        continue;
                    }
                    if (vector2.elementAt(i) instanceof Long) {
                        callableStatement.setLong(i + 1, (long)((Long)vector2.elementAt(i)));
                        continue;
                    }
                    if (!(vector2.elementAt(i) instanceof Integer)) continue;
                    callableStatement.setLong(i + 1, (long)((Integer)vector2.elementAt(i)).intValue());
                }
                callableStatement.execute();
                resultSet = callableStatement.getResultSet();
                resultSet.next();
                l = resultSet.getLong(1);
                Object var12_13 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't get LRs Count from DB: [" + sQLException + "]");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PersistenceException("can't not find driver: [" + classNotFoundException + "]");
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(callableStatement);
            DBHelper.disconnect(connection, true);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(callableStatement);
        DBHelper.disconnect(connection, true);
        return l;
    }

    private String getSQLQuery(List list, String string, boolean bl, List list2, int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.getJoinQuery(list, list2, vector);
        String string3 = "lr_id";
        if (bl) {
            string3 = "count(*)";
        }
        stringBuffer = stringBuffer.append(" SELECT " + string3 + " " + " FROM  " + "gateadmin" + ".t_lang_resource LR " + string2);
        if (list != null && list.size() > 0) {
            stringBuffer = stringBuffer.append("  ( ");
            stringBuffer = stringBuffer.append(this.getIntersectionPart(list, vector));
            stringBuffer = stringBuffer.append(" ) intersected_feat_restr ");
        }
        String string4 = this.getEndPartOfJoin(list, list2, string, vector);
        stringBuffer = stringBuffer.append(string4);
        if (n > 0) {
            stringBuffer = stringBuffer.insert(0, "select lr_id from ( ");
            stringBuffer = stringBuffer.append(") where rownum<" + (n + 1));
        }
        return stringBuffer.toString();
    }

    private String getIntersectionPart(List list, Vector vector) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(" ");
        Collections.sort(list, new RestrictionComepator());
        Vector<Serializable> vector2 = new Vector<Serializable>();
        for (n = 0; n < list.size(); ++n) {
            Serializable serializable;
            if (n > 0) {
                Vector vector3;
                serializable = (Restriction)list.get(n);
                Restriction restriction = (Restriction)list.get(n - 1);
                if (((Restriction)serializable).getKey().equals(restriction.getKey())) {
                    vector3 = (Vector)vector2.get(vector2.size() - 1);
                    vector3.add(serializable);
                    continue;
                }
                vector3 = new Vector();
                vector3.add(serializable);
                vector2.add(vector3);
                continue;
            }
            serializable = new Vector();
            ((Vector)serializable).add(list.get(0));
            vector2.add(serializable);
        }
        if (list != null && list.size() > 0) {
            for (n = 0; n < vector2.size(); ++n) {
                stringBuffer = stringBuffer.append(this.getRestrictionPartOfQuery((List)vector2.get(n), vector));
                if (n >= vector2.size() - 1) continue;
                stringBuffer = stringBuffer.append("  intersect ");
            }
        }
        return stringBuffer.toString();
    }

    private String getRestrictionPartOfQuery(List list, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(" SELECT ft_entity_id  FROM gateadmin.t_feature FEATURE, gateadmin.t_feature_key FTK WHERE FEATURE.ft_entity_type = 2 ");
        Restriction restriction = (Restriction)list.get(0);
        if (restriction.getKey() != null) {
            stringBuffer = stringBuffer.append(" AND FTK.fk_id = FEATURE.ft_key_id ");
            stringBuffer = stringBuffer.append(" AND FTK.fk_string = ? ");
            vector.addElement(restriction.getKey());
        }
        block4: for (int i = 0; i < list.size(); ++i) {
            restriction = (Restriction)list.get(i);
            if (restriction.getValue() == null) continue;
            stringBuffer = stringBuffer.append(" AND ");
            switch (this.findFeatureType(restriction.getValue())) {
                case 101: {
                    stringBuffer = stringBuffer.append(this.getNumberExpresion(restriction, vector));
                    continue block4;
                }
                case 102: {
                    stringBuffer = stringBuffer.append(this.getNumberExpresion(restriction, vector));
                    continue block4;
                }
                default: {
                    if (restriction.getOperator() == 100) {
                        stringBuffer = stringBuffer.append(" FEATURE.ft_character_value = ? ");
                        vector.addElement(restriction.getStringValue());
                    }
                    if (restriction.getOperator() != 105) continue block4;
                    stringBuffer = stringBuffer.append(" upper(FEATURE.ft_character_value) like ? ");
                    vector.addElement("%" + restriction.getStringValue().toUpperCase() + "%");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getNumberExpresion(Restriction restriction, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("FEATURE.ft_number_value ");
        switch (restriction.getOperator()) {
            case 100: {
                stringBuffer = stringBuffer.append(" = ");
                break;
            }
            case 102: {
                stringBuffer = stringBuffer.append("  > ");
                break;
            }
            case 101: {
                stringBuffer = stringBuffer.append(" < ");
                break;
            }
            case 103: {
                stringBuffer = stringBuffer.append(" >= ");
                break;
            }
            case 104: {
                stringBuffer = stringBuffer.append(" <= ");
                break;
            }
            default: {
                return " 0 = 0 ";
            }
        }
        stringBuffer.append(" ? ");
        vector.addElement(restriction.getValue());
        return stringBuffer.toString();
    }

    private String getJoinQuery(List list, List list2, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (list != null && list.size() > 0) {
            stringBuffer = stringBuffer.append(" , ");
        }
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                stringBuffer = stringBuffer.append("gateadmin.t_feature FT" + i);
                stringBuffer = stringBuffer.append(" , gateadmin.t_feature_key FTK" + i + " , ");
            }
        }
        return stringBuffer.toString();
    }

    private String getEndPartOfJoin(List list, List list2, String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer = stringBuffer.append(" WHERE ");
        stringBuffer = stringBuffer.append(" LR.lr_type_id = ? ");
        if (string.equals("gate.corpora.DatabaseCorpusImpl")) {
            vector.addElement(new Long(2L));
        }
        if (string.equals("gate.corpora.DatabaseDocumentImpl")) {
            vector.addElement(new Long(1L));
        }
        if (list != null && list.size() > 0) {
            stringBuffer = stringBuffer.append(" and intersected_feat_restr.ft_entity_id = lr.lr_id ");
        }
        if (list2 != null && list2.size() > 0) {
            OrderByRestriction orderByRestriction;
            int n;
            for (n = 0; n < list2.size(); ++n) {
                stringBuffer = stringBuffer.append(" and lr_id=FT" + n + ".ft_entity_id ");
                stringBuffer = stringBuffer.append(" and  FT" + n + ".ft_key_id = FTK" + n + ".fk_id ");
                stringBuffer = stringBuffer.append(" and  FTK" + n + ".fk_string= ? ");
                orderByRestriction = (OrderByRestriction)list2.get(n);
                vector.addElement(orderByRestriction.getKey());
            }
            stringBuffer = stringBuffer.append(" order by ");
            for (n = 0; n < list2.size(); ++n) {
                orderByRestriction = (OrderByRestriction)list2.get(n);
                stringBuffer = stringBuffer.append("  FT" + n + ".ft_number_value ");
                stringBuffer = orderByRestriction.getOperator() == 100 ? stringBuffer.append(" asc ") : stringBuffer.append(" desc ");
                if (n >= list2.size() - 1) continue;
                stringBuffer = stringBuffer.append(" , ");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findDocIdsByAnn(List list, int n) throws PersistenceException {
        Vector<Long> vector;
        Vector<Long> vector2 = new Vector<Long>();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            try {
                Vector vector3 = new Vector();
                String string = this.getSQLQueryAnn(list, n, vector3);
                connection = DBHelper.connect(this.getStorageUrl(), true);
                callableStatement = connection.prepareCall(string);
                for (int i = 0; i < vector3.size(); ++i) {
                    if (vector3.elementAt(i) instanceof String) {
                        callableStatement.setString(i + 1, vector3.elementAt(i).toString());
                        continue;
                    }
                    if (vector3.elementAt(i) instanceof Long) {
                        callableStatement.setLong(i + 1, (long)((Long)vector3.elementAt(i)));
                        continue;
                    }
                    if (!(vector3.elementAt(i) instanceof Integer)) continue;
                    callableStatement.setLong(i + 1, (long)((Integer)vector3.elementAt(i)).intValue());
                }
                callableStatement.execute();
                resultSet = callableStatement.getResultSet();
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    vector2.addElement(new Long(l));
                }
                vector = vector2;
                Object var12_14 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't get LRs from DB: [" + sQLException + "]");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PersistenceException("can't not find driver: [" + classNotFoundException + "]");
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(callableStatement);
            DBHelper.disconnect(connection, true);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(callableStatement);
        DBHelper.disconnect(connection, true);
        return vector;
    }

    private String getSQLQueryAnn(List list, int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT lr_id ");
        stringBuffer.append(" FROM gateadmin.t_lang_resource LR ");
        stringBuffer.append(" WHERE LR.lr_type_id = 1 ");
        for (int i = 0; i < list.size(); ++i) {
            Restriction restriction = (Restriction)list.get(i);
            stringBuffer.append(" AND EXISTS( ");
            stringBuffer.append(" SELECT F.ft_id ");
            stringBuffer.append(" FROM   gateadmin.t_feature F, ");
            stringBuffer.append(" gateadmin.T_AS_ANNOTATION A, ");
            stringBuffer.append(" gateadmin.T_ANNOT_SET S, ");
            stringBuffer.append(" gateadmin.T_DOCUMENT D, ");
            stringBuffer.append(" gateadmin.t_feature_key FK ");
            stringBuffer.append(" WHERE  F.ft_entity_id = A.asann_ann_id ");
            stringBuffer.append(" AND  A.asann_as_id = S.as_id ");
            stringBuffer.append(" AND  S.as_doc_id = D.doc_id ");
            stringBuffer.append(" AND  D.doc_lr_id = LR.LR_ID ");
            stringBuffer.append(" AND  S.AS_NAME = ? ");
            vector.add("NewsCollector");
            stringBuffer.append(" AND  FK.fk_id = F.ft_key_id ");
            stringBuffer.append(" AND  FK.fk_string= ? ");
            vector.add(restriction.getKey());
            stringBuffer.append(" AND  F.FT_CHARACTER_VALUE = ? ");
            vector.add(restriction.getStringValue());
            stringBuffer.append(" ) ");
        }
        stringBuffer.append(" group by lr_id ");
        if (n > 0) {
            stringBuffer = stringBuffer.insert(0, "select lr_id from ( ");
            stringBuffer = stringBuffer.append(") where rownum<" + (n + 1));
        }
        return stringBuffer.toString();
    }

    private class RestrictionComepator
    implements Comparator {
        private RestrictionComepator() {
        }

        public int compare(Object object, Object object2) {
            Restriction restriction = (Restriction)object;
            Restriction restriction2 = (Restriction)object2;
            return restriction.getKey().compareTo(restriction2.getKey());
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    private class Feature {
        Long entityID;
        int entityType;
        String key;
        Object value;
        int valueType;

        public Feature(Long l, int n, String string, Object object, int n2) {
            this.entityID = l;
            this.entityType = n;
            this.key = string;
            this.value = object;
            this.valueType = n2;
        }
    }
}

