/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.functest;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.jape.functest.BaseJapeTests;
import gate.persist.PersistenceException;
import gate.util.AnnotationDiffer;
import gate.util.Files;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class TestJape
extends BaseJapeTests {
    private static final Logger logger = Logger.getLogger(TestJape.class);

    public TestJape(String string) {
        super(string);
    }

    public void testSimple() throws Exception {
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.add(2, 4, "A");
                this.add(4, 6, "B");
                this.add(6, 8, "C");
                this.add(8, 10, "C");
                return document.getAnnotations();
            }
        };
        Set<Annotation> set = this.doTest("texts/doc0.html", "/jape/TestABC.jape", baseAnnotationCreator);
        Out.println(set);
        TestJape.assertEquals((String)set.toString(), (int)3, (int)set.size());
        TestJape.compareStartOffsets(set, 2, 2, 2);
        TestJape.compareEndOffsets(set, 6, 8, 10);
    }

    public void testApplicationModes() throws PersistenceException, ResourceInstantiationException, IOException, ExecutionException {
        URL uRL = Files.getGateResource("gate.ac.uk/tests/jape/jape-test.xgapp");
        CorpusController corpusController = (CorpusController)PersistenceManager.loadObjectFromUrl(uRL);
        Document document = Factory.newDocument(Files.getGateResource("gate.ac.uk/tests/jape/test-doc.xml"), "UTF-8");
        Corpus corpus = Factory.newCorpus("JAPE Test Corpus");
        corpus.add(document);
        corpusController.setCorpus(corpus);
        corpusController.execute();
        AnnotationDiffer annotationDiffer = new AnnotationDiffer();
        annotationDiffer.setSignificantFeaturesSet(null);
        for (String string : new String[]{"appelt", "brill", "all", "once"}) {
            AnnotationSet annotationSet = document.getAnnotations(string);
            AnnotationSet annotationSet2 = document.getAnnotations(string + "-test");
            annotationDiffer.calculateDiff(annotationSet, annotationSet2);
            double d = annotationDiffer.getFMeasureStrict(1.0);
            TestJape.assertEquals((String)("Incorrect F-measure for test " + string), (Object)1.0, (Object)d);
        }
        corpusController.setCorpus(null);
        Factory.deleteResource(corpusController);
        corpus.remove(0);
        Factory.deleteResource(document);
        Factory.deleteResource(corpus);
    }

    public void disabled_testRhsErrorMessages() {
        block2: {
            try {
                Document document = Factory.newDocument("This is a Small Document.");
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("orth", "upperInitial");
                document.getAnnotations().add(new Long(0L), new Long(8L), "Token", featureMap);
                this.doTest(document, "tests/RhsError.jape", null, null);
                TestJape.fail((String)"Bad JAPE grammar didn't throw an exception");
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block2;
                logger.info((Object)("Exception in Jape rule: " + exception));
            }
        }
    }

    public void testBrill() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/brill_test.jape";
        String[] stringArray = new String[]{"Find_A", "Find_A", "Find_A_B", "Find_A_B", "Find_A_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.add(2, 4, "A");
                this.add(2, 5, "A");
                this.add(3, 5, "A");
                this.add(4, 6, "B");
                this.add(5, 7, "B");
                this.add(6, 8, "C");
                this.add(8, 10, "D");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestJape.compareResults(stringArray, set);
    }

    public void testAppeltMode() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/appelt_test.jape";
        String[] stringArray = new String[]{"Find_A_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.add(2, 4, "A");
                this.add(4, 6, "B");
                this.add(2, 3, "C");
                this.add(3, 8, "D");
                this.add(2, 3, "A");
                this.add(3, 4, "B");
                this.add(4, 9, "C");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestJape.compareResults(stringArray, set);
    }

    public void testAllMode() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/all_mode_test.jape";
        String[] stringArray = new String[]{"Find_A", "Find_A", "Find_A_B", "Find_A_B", "Find_A_B_C", "Find_A", "Find_A_B", "Find_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.add(2, 4, "A");
                this.add(2, 5, "A");
                this.add(3, 5, "A");
                this.add(4, 6, "B");
                this.add(5, 7, "B");
                this.add(6, 8, "C");
                this.add(8, 10, "D");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestJape.compareResults(stringArray, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disabled_testRhsErrorMessages2() {
        PrintStream printStream = System.out;
        System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
        try {
            try {
                Document document = Factory.newDocument("This is a Small Document.");
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("orth", "upperInitial");
                document.getAnnotations().add(new Long(0L), new Long(8L), "Token", featureMap);
                this.doTest(document, "tests/RhsError2.jape", null, null);
                TestJape.fail((String)"Bad JAPE grammar (2) didn't throw an exception");
            }
            catch (Exception exception) {
                Object var5_6 = null;
                System.setOut(printStream);
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            System.setOut(printStream);
            throw throwable;
        }
        System.setOut(printStream);
    }

    public static Test suite() {
        TestSetup testSetup = new TestSetup((Test)new TestSuite(TestJape.class)){

            protected void setUp() {
                BaseJapeTests.setUpGate();
                logger.info((Object)"GATE initialized and fixure set up.");
            }
        };
        return testSetup;
    }

    public static void main(String ... stringArray) {
        TestRunner.run((Test)TestJape.suite());
    }
}

