/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.functest;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.jape.MultiPhaseTransducer;
import gate.jape.Transducer;
import gate.jape.functest.BaseJapeTests;
import gate.jape.parser.ParseCpsl;
import gate.jape.parser.ParseException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class TestConstraints
extends BaseJapeTests {
    private static final Logger logger = Logger.getLogger(TestConstraints.class);
    private final BaseJapeTests.AnnotationCreator annoCreatorEmpty = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            return this.as;
        }
    };
    private final BaseJapeTests.AnnotationCreator annoCreator81LocOrgDateJob = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            this.add(1, 6, "Location");
            this.add(1, 15, "Location");
            this.add(7, 15, "Location");
            this.add(16, 24, "Organization");
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("month", "September");
            this.add(25, 35, "Date", featureMap);
            this.add(36, 53, "JobTitle");
            this.add(54, 59, "Location");
            this.add(54, 68, "Location");
            this.add(60, 68, "Location");
            this.add(69, 77, "Organization");
            featureMap = Factory.newFeatureMap();
            featureMap.put("month", "November");
            this.add(78, 88, "Date", featureMap);
            this.add(89, 100, "JobTitle");
            this.add(101, 107, "Location");
            this.add(101, 110, "Location");
            this.add(108, 110, "Location");
            this.add(111, 115, "Organization");
            featureMap = Factory.newFeatureMap();
            featureMap.put("month", "October");
            this.add(116, 126, "Date", featureMap);
            this.add(127, 137, "JobTitle");
            return this.as;
        }
    };
    private final BaseJapeTests.AnnotationCreator annoCreator813Operators = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("string", "room");
            this.add(1, 5, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("string", "qu\"oted");
            this.add(6, 13, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("int", 101L);
            this.add(14, 17, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("int", -10);
            this.add(18, 21, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("double", Float.valueOf(3.14f));
            this.add(22, 26, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("double", -273.15);
            this.add(27, 34, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("string", "qu\\\"oted");
            this.add(35, 43, "Token", featureMap);
            return this.as;
        }
    };
    private final BaseJapeTests.AnnotationCreator annoCreator814MetaProps = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            this.add(1, 61, "Span");
            return this.as;
        }
    };
    private final BaseJapeTests.AnnotationCreator annoCreator815MultipleActions = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            this.add(1, 5, "TempPerson");
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("majorType", "jobtitle");
            this.add(6, 12, "Lookup", featureMap);
            this.add(13, 21, "TempPerson");
            this.add(36, 50, "Lookup", featureMap);
            this.add(36, 59, "TempPerson");
            return this.as;
        }
    };
    private final BaseJapeTests.AnnotationCreator annoCreator817Contexts = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("type", "elmail");
            this.add(9, 25, "Annotation", featureMap);
            this.add(30, 44, "Annotation", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("string", "<");
            this.add(8, 9, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("string", ">");
            this.add(25, 26, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("string", "de");
            this.add(58, 60, "Token", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("majorType", "name");
            featureMap.put("minorType", "surname");
            this.add(58, 66, "Lookup", featureMap);
            return this.as;
        }
    };
    protected BaseJapeTests.AnnotationCreator basicAnnotCreator = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "atext");
            featureMap.put("f2", "2");
            featureMap.put("f3", 3);
            this.add(2, 4, "A", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "btext");
            featureMap.put("f2", "2");
            featureMap.put("f4", "btext4");
            this.add(2, 3, "B", featureMap);
            this.add(4, 6, "B", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "cctext");
            featureMap.put("f2", "2");
            featureMap.put("f3", 3L);
            featureMap.put("f4", "ctext4");
            this.add(6, 7, "B", featureMap);
            this.add(6, 8, "C", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "cctext");
            featureMap.put("f2", "1");
            featureMap.put("f4", "ctext4");
            this.add(8, 10, "C", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "dtext");
            featureMap.put("f3", 3L);
            this.add(12, 14, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f2", 2L);
            this.add(14, 16, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("ontology", "http://gate.ac.uk/tests/demo.owl");
            featureMap.put("class", "Businessman");
            this.add(16, 18, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("ontology", "http://gate.ac.uk/tests/demo.owl");
            featureMap.put("class", "Country");
            this.add(18, 19, "D", featureMap);
            return this.as;
        }
    };

    public TestConstraints(String string) {
        super(string);
    }

    public void test000TransduceEmptyDoc() throws Exception {
        Set<Annotation> set = this.doTest(Factory.newDocument(""), "/jape/test/japefiles/Req-GATETao-8.1.1.jape", this.annoCreatorEmpty, null);
        TestConstraints.assertEquals((String)"There must be no transduced annotations.", (int)0, (int)set.size());
    }

    public void test811MatchText() throws Exception {
        String[] stringArray = new String[]{"SimpleText", "ComplexText", "ComplexText", "ComplexText", "ComplexText"};
        int[] nArray = new int[]{1, 4, 11, 26, 43};
        int[] nArray2 = new int[]{3, 11, 15, 32, 47};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("string", "of");
                this.add(1, 3, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "http");
                this.add(4, 8, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", ":");
                this.add(8, 9, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "/");
                this.add(9, 10, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "/");
                this.add(10, 11, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "www");
                this.add(11, 14, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", ".");
                this.add(14, 15, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "ftp");
                this.add(26, 29, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", ":");
                this.add(29, 30, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "/");
                this.add(30, 31, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "/");
                this.add(31, 32, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "www");
                this.add(37, 42, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", ".");
                this.add(42, 43, "Token", featureMap);
                return this.as;
            }
        };
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.1.jape", "/jape/test/docfiles/Req-GATETao-8.1.1.txt", stringArray, nArray, nArray2, baseAnnotationCreator);
    }

    public void test811MatchStringInEmptyAnnotSet() throws Exception {
        Set<Annotation> set = this.doTest("/jape/test/docfiles/Req-GATETao-8.1.1.txt", "/jape/test/japefiles/Req-GATETao-8.1.1.jape", this.annoCreatorEmpty);
        TestConstraints.assertEquals((String)"There must be no transduced annotations.", (int)0, (int)set.size());
    }

    public void test812MatchAnnot() throws Exception {
        String[] stringArray = new String[]{"SimpleAnnotation", "SimpleAnnotation"};
        int[] nArray = new int[]{1, 101};
        int[] nArray2 = new int[]{53, 137};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.2.jape", "/jape/test/docfiles/Req-GATETao-8.1.2.txt", stringArray, nArray, nArray2, this.annoCreator81LocOrgDateJob);
    }

    public void test812MatchNegativeAnnotationsInEmptyAnnotSet() throws Exception {
        Set<Annotation> set = this.doTest("/jape/test/docfiles/Req-GATETao-8.1.2.txt", "/jape/test/japefiles/Req-GATETao-8.1.2-Negative.jape", this.annoCreatorEmpty);
        TestConstraints.assertEquals((String)"There must be no transduced annotations.", (int)0, (int)set.size());
    }

    public void test812MatchNegativeAnnotations() throws Exception {
        String[] stringArray = new String[]{"NegativeAnnotation", "NegativeAnnotation", "NegativeAnnotation"};
        int[] nArray = new int[]{16, 69, 111};
        int[] nArray2 = new int[]{53, 100, 137};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.2.jape", "/jape/test/docfiles/Req-GATETao-8.1.2.txt", stringArray, nArray, nArray2, this.annoCreator81LocOrgDateJob);
    }

    public void test813OpContains() throws Exception {
        String[] stringArray = new String[]{"OpContains", "OpContains", "OpContains"};
        int[] nArray = new int[]{1, 54, 101};
        int[] nArray2 = new int[]{15, 68, 110};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-LHSOP_contains.jape", "/jape/test/docfiles/Req-GATETao-8.1.2.txt", stringArray, nArray, nArray2, this.annoCreator81LocOrgDateJob);
    }

    public void test813OpWithin() throws Exception {
        String[] stringArray = new String[]{"OpWithin", "OpWithin", "OpWithin", "OpWithin", "OpWithin", "OpWithin"};
        int[] nArray = new int[]{1, 7, 54, 60, 101, 108};
        int[] nArray2 = new int[]{6, 15, 59, 68, 107, 110};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-LHSOP_within.jape", "/jape/test/docfiles/Req-GATETao-8.1.2.txt", stringArray, nArray, nArray2, this.annoCreator81LocOrgDateJob);
    }

    public void test813OpContainWithinNoMatch() throws Exception {
        Set<Annotation> set = this.doTest("/jape/test/docfiles/Req-GATETao-8.1.2.txt", "/jape/test/japefiles/Req-GATETao-8.1.3-LHSOP_within.jape", this.annoCreatorEmpty);
        TestConstraints.assertEquals((String)"There must be no transduced annotations.", (int)0, (int)set.size());
        set = this.doTest("/jape/test/docfiles/Req-GATETao-8.1.2.txt", "/jape/test/japefiles/Req-GATETao-8.1.3-LHSOP_contains.jape", this.annoCreatorEmpty);
        TestConstraints.assertEquals((String)"There must be no transduced annotations.", (int)0, (int)set.size());
    }

    public void test813OpEqualsStringSpecialChars() throws Exception {
        String[] stringArray = new String[]{"OpEquals"};
        int[] nArray = new int[]{6};
        int[] nArray2 = new int[]{13};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-string-wquot.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpEqualsStringEmptyFeature() throws Exception {
        String[] stringArray = new String[]{"OpEquals", "OpEquals"};
        int[] nArray = new int[]{1, 35};
        int[] nArray2 = new int[]{5, 43};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("string", "");
                this.add(1, 5, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "qu\"oted");
                this.add(6, 13, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("int", 101L);
                this.add(14, 17, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("int", -10);
                this.add(18, 21, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("double", Float.valueOf(3.14f));
                this.add(22, 26, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("double", -273.15);
                this.add(27, 34, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "");
                this.add(35, 43, "Token", featureMap);
                return this.as;
            }
        };
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-string-ef.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, baseAnnotationCreator);
    }

    public void test813OpEqualsIntegerNatural() throws Exception {
        String[] stringArray = new String[]{"OpEquals"};
        int[] nArray = new int[]{14};
        int[] nArray2 = new int[]{17};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-int-natural.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpEqualsIntegerNegative() throws Exception {
        String[] stringArray = new String[]{"OpEquals"};
        int[] nArray = new int[]{18};
        int[] nArray2 = new int[]{21};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-int-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpEqualsDoublePositive() throws Exception {
        String[] stringArray = new String[]{"OpEquals"};
        int[] nArray = new int[]{22};
        int[] nArray2 = new int[]{26};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-double-positive.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpEqualsDoubleNegative() throws Exception {
        String[] stringArray = new String[]{"OpEquals"};
        int[] nArray = new int[]{27};
        int[] nArray2 = new int[]{34};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-equals-double-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterThanString() throws Exception {
        String[] stringArray = new String[]{"OpGreaterThan", "OpGreaterThan", "OpGreaterThan"};
        int[] nArray = new int[]{1, 6, 35};
        int[] nArray2 = new int[]{5, 13, 43};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-gt-string.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterThanNaturalNumber() throws Exception {
        String[] stringArray = new String[]{"OpGreaterThan", "OpGreaterThan"};
        int[] nArray = new int[]{14, 22};
        int[] nArray2 = new int[]{17, 26};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-gt-int-positive.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterThanNegativeInteger() throws Exception {
        String[] stringArray = new String[]{"OpGreaterThan", "OpGreaterThan", "OpGreaterThan", "OpGreaterThan"};
        int[] nArray = new int[]{14, 18, 22, 27};
        int[] nArray2 = new int[]{17, 21, 26, 34};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-gt-int-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterThanPositiveDouble() throws Exception {
        String[] stringArray = new String[]{"OpGreaterThan", "OpGreaterThan"};
        int[] nArray = new int[]{14, 22};
        int[] nArray2 = new int[]{17, 26};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-gt-double-positive.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterThanNegativeDouble() throws Exception {
        String[] stringArray = new String[]{"OpGreaterThan", "OpGreaterThan", "OpGreaterThan", "OpGreaterThan"};
        int[] nArray = new int[]{14, 18, 22, 27};
        int[] nArray2 = new int[]{17, 21, 26, 34};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-gt-double-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterEqualsString() throws Exception {
        String[] stringArray = new String[]{"OpGreaterEquals"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{5};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-ge-string.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreater\u0415qualsPositiveInteger() throws Exception {
        String[] stringArray = new String[]{"OpGreaterEquals"};
        int[] nArray = new int[]{14};
        int[] nArray2 = new int[]{17};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-ge-int-positive.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterEqualsNegativeInteger() throws Exception {
        String[] stringArray = new String[]{"OpGreaterEquals", "OpGreaterEquals", "OpGreaterEquals"};
        int[] nArray = new int[]{14, 18, 22};
        int[] nArray2 = new int[]{17, 21, 26};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-ge-int-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterEqualsPositiveDouble() throws Exception {
        String[] stringArray = new String[]{"OpGreaterEquals", "OpGreaterEquals"};
        int[] nArray = new int[]{14, 22};
        int[] nArray2 = new int[]{17, 26};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-ge-double-positive.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test813OpGreaterEqualsNegativeDouble() throws Exception {
        String[] stringArray = new String[]{"OpGreaterEquals", "OpGreaterEquals", "OpGreaterEquals", "OpGreaterEquals"};
        int[] nArray = new int[]{14, 18, 22, 27};
        int[] nArray2 = new int[]{17, 21, 26, 34};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.3-op-ge-double-negative.jape", "/jape/test/docfiles/Req-GATETao-8.1.3.txt", stringArray, nArray, nArray2, this.annoCreator813Operators);
    }

    public void test814MetaLeftLength() throws Exception {
        String[] stringArray = new String[]{"MetaLength"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{61};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.4-meta-length.jape", "/jape/test/docfiles/Req-GATETao-8.1.4.txt", stringArray, nArray, nArray2, this.annoCreator814MetaProps);
    }

    public void test814MetaLeftString() throws Exception {
        String[] stringArray = new String[]{"MetaString"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{61};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.4-meta-string.jape", "/jape/test/docfiles/Req-GATETao-8.1.4.txt", stringArray, nArray, nArray2, this.annoCreator814MetaProps);
    }

    public void test814MetaLeftCleanString() throws Exception {
        String[] stringArray = new String[]{"MetaCleanString"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{61};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.4-meta-cleanString.jape", "/jape/test/docfiles/Req-GATETao-8.1.4.txt", stringArray, nArray, nArray2, this.annoCreator814MetaProps);
    }

    public void test814MetaRightString() throws Exception {
        String[] stringArray = new String[]{"MetaRightString"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{61};
        Set<Annotation> set = this.doTest("/jape/test/docfiles/Req-GATETao-8.1.4.txt", "/jape/test/japefiles/Req-GATETao-8.1.4-meta-rhs-string.jape", this.annoCreator814MetaProps);
        TestConstraints.compareResults(stringArray, set);
        TestConstraints.compareStartOffsets(set, nArray);
        TestConstraints.compareEndOffsets(set, nArray2);
        FeatureMap featureMap = set.iterator().next().getFeatures();
        Object v = featureMap.get("value");
        TestConstraints.assertNotNull((String)"Annotation features must contain \"value\" feature", v);
        TestConstraints.assertEquals((String)"RHS value must be equals to matched text", (String)"     and when    the   lamb opened  the     seventh     seal", (String)((String)v));
    }

    public void test815MultiPatternActionsSequential() throws Exception {
        String[] stringArray = new String[]{"PersonJobTitle1", "PersonJobTitle2"};
        int[] nArray = new int[]{6, 13};
        int[] nArray2 = new int[]{12, 21};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.5-multipat-seq.jape", "/jape/test/docfiles/Req-GATETao-8.1.5.txt", stringArray, nArray, nArray2, this.annoCreator815MultipleActions);
    }

    public void test815MultiPatternActionsNested() throws Exception {
        String[] stringArray = new String[]{"PersonJobTitle1", "PersonJobTitle2"};
        int[] nArray = new int[]{36, 36};
        int[] nArray2 = new int[]{50, 59};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.5-multipat-nest.jape", "/jape/test/docfiles/Req-GATETao-8.1.5.txt", stringArray, nArray, nArray2, this.annoCreator815MultipleActions);
    }

    public void test816Macro() throws Exception {
        String[] stringArray = new String[]{"MoneyCurrencyUnit", "MoneyCurrencyUnit"};
        int[] nArray = new int[]{31, 49};
        int[] nArray2 = new int[]{44, 57};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("kind", "number");
                this.add(31, 32, "Token", featureMap);
                this.add(33, 36, "Token", featureMap);
                this.add(49, 53, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", ",");
                this.add(32, 33, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("string", "K");
                this.add(36, 36, "Token", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("majorType", "currency_unit");
                this.add(41, 44, "Lookup", featureMap);
                featureMap = Factory.newFeatureMap();
                featureMap.put("majorType", "currency_unit");
                this.add(54, 57, "Lookup", featureMap);
                return this.as;
            }
        };
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.6-macro.jape", "/jape/test/docfiles/Req-GATETao-8.1.6.txt", stringArray, nArray, nArray2, baseAnnotationCreator);
    }

    public void test817ContextForeAndAft() throws Exception {
        String[] stringArray = new String[]{"Emailaddress1"};
        int[] nArray = new int[]{9};
        int[] nArray2 = new int[]{25};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.7-ctx-foreaft.jape", "/jape/test/docfiles/Req-GATETao-8.1.7.txt", stringArray, nArray, nArray2, this.annoCreator817Contexts);
    }

    public void test818ContextBeginsAt() throws Exception {
        String[] stringArray = new String[]{"SurnameStartingWithDe"};
        int[] nArray = new int[]{58};
        int[] nArray2 = new int[]{66};
        this.doCommonTest("/jape/test/japefiles/Req-GATETao-8.1.7-ctx-begins.jape", "/jape/test/docfiles/Req-GATETao-8.1.7.txt", stringArray, nArray, nArray2, this.annoCreator817Contexts);
    }

    public void testGoodOperators() throws Exception {
        String string = "/jape/operators/operator_tests.jape";
        String[] stringArray = new String[]{"AndEqual", "RegExMatch", "NotEqualandGreaterEqual", "NotEqual", "EqualAndNotEqualRegEx", "EqualAndNotExistance", "OntoTest", "OntoTest2"};
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, this.basicAnnotCreator, "http://gate.ac.uk/tests/demo.owl");
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void testBadCompare() throws Exception {
        String string = "/jape/operators/bad_operator_tests.jape";
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, this.basicAnnotCreator);
        TestConstraints.assertTrue((String)"No results should be found", (boolean)set.isEmpty());
    }

    public void testBadPattern() throws Exception {
        String string = "Phase: first\n Options: control = appelt\nRule: RuleOne\n({A.f1=~\"[a.\"}):abc-->{}";
        try {
            TestConstraints.parseJapeString(string);
            TestConstraints.assertTrue((String)"Should have thrown exception for bad grammer", (boolean)false);
        }
        catch (ParseException parseException) {
            Out.println(parseException.getMessage());
        }
        string = "Phase: first\n Options: control = appelt\nRule: RuleOne\n({A.f1=~[a.}):abc-->{}";
        try {
            TestConstraints.parseJapeString(string);
            TestConstraints.assertTrue((String)"Should have thrown exception for bad grammer", (boolean)false);
        }
        catch (ParseException parseException) {
            Out.println(parseException.getMessage());
        }
    }

    public void testMetaPropertyAccessors() throws Exception {
        String string = "foo bar blah word4    word5  ";
        String string2 = "/jape/operators/meta_property_tests.jape";
        String[] stringArray = new String[]{"LengthAccessorEqual", "StringAccessorEqual", "CleanStringAccessorEqual"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f1", "aval");
                featureMap.put("f2", "2");
                featureMap.put("f3", 3);
                this.add(4, 7, "A", featureMap);
                this.add(8, 12, "A");
                this.add(12, 28, "B");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest(Factory.newDocument(string), string2, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator, null);
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void testCustomPredicates() throws Exception {
        String string = "/jape/operators/custom_predicates_tests.jape";
        String[] stringArray = new String[]{"Contains", "IsContained", "Contains", "IsContained"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.add(4, 7, "A");
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f2", "bar");
                this.add(5, 6, "B", featureMap);
                this.add(12, 28, "F");
                this.add(14, 20, "E");
                this.add(30, 35, "A");
                this.add(30, 35, "B");
                this.add(40, 45, "F");
                this.add(40, 45, "E");
                this.add(36, 37, "A");
                this.add(36, 38, "B");
                this.add(37, 38, "B");
                this.add(40, 45, "F");
                this.add(40, 46, "E");
                this.add(41, 46, "E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void testCustomPredicatesWithConstraints() throws Exception {
        String string = "/jape/operators/custom_predicates_tests.jape";
        String[] stringArray = new String[]{"ContainsWithConstraints", "ContainsWithMetaProperty"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f1", "foo");
                this.add(4, 7, "C", featureMap);
                this.add(4, 8, "C", Factory.newFeatureMap());
                FeatureMap featureMap2 = Factory.newFeatureMap();
                featureMap2.put("f2", "bar");
                this.add(5, 6, "B", featureMap2);
                this.add(8, 10, "C", featureMap);
                this.add(8, 9, "B");
                this.add(11, 13, "C");
                this.add(12, 16, "C", featureMap);
                this.add(12, 15, "C");
                this.add(12, 16, "B");
                this.add(17, 20, "C", featureMap);
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void testRanges() throws Exception {
        String string = "/jape/operators/range_tests.jape";
        String[] stringArray = new String[]{"OneToTwoB", "ThreeA", "OneToTwoB", "ZeroToThreeC", "ThreeToFourB", "ThreeToFourB", "ZeroToThreeC", "ZeroToThreeC"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.addInc("F");
                this.addInc("B");
                this.addInc("G");
                this.addInc("A");
                this.addInc("A");
                this.addInc("A");
                this.addInc("F");
                this.addInc("G");
                this.addInc("A");
                this.addInc("A");
                this.addInc("F");
                this.addInc("B");
                this.addInc("G");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("D");
                this.addInc("E");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("D");
                this.addInc("C");
                this.addInc("D");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void testKleeneOperators() throws Exception {
        String string = "/jape/operators/kleene_tests.jape";
        String[] stringArray = new String[]{"OptionalB", "PlusA", "OptionalB", "PlusA", "StarC", "StarC", "StarC"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) throws InvalidOffsetException {
                this.addInc("B");
                this.addInc("C");
                this.addInc("A");
                this.addInc("A");
                this.addInc("A");
                this.addInc("C");
                this.addInc("C");
                this.addInc("A");
                this.addInc("B");
                this.addInc("D");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, baseAnnotationCreator);
        Out.println(set);
        TestConstraints.compareResults(stringArray, set);
    }

    public void doCommonTest(String string, String string2, String[] stringArray, int[] nArray, int[] nArray2, BaseJapeTests.AnnotationCreator annotationCreator) throws Exception {
        Set<Annotation> set = this.doTest(string2, string, annotationCreator);
        TestConstraints.compareResults(stringArray, set);
        TestConstraints.compareStartOffsets(set, nArray);
        TestConstraints.compareEndOffsets(set, nArray2);
    }

    protected static void parseJapeString(String string) throws ParseException {
        StringReader stringReader = new StringReader(string);
        ParseCpsl parseCpsl = Factory.newJapeParser(stringReader, new HashMap());
        MultiPhaseTransducer multiPhaseTransducer = parseCpsl.MultiPhaseTransducer();
        ((Transducer)multiPhaseTransducer).finish();
    }

    public static Test suite() {
        TestSetup testSetup = new TestSetup((Test)new TestSuite(TestConstraints.class)){

            protected void setUp() {
                BaseJapeTests.setUpGate();
                logger.info((Object)"GATE initialized and fixure set up.");
            }
        };
        return testSetup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestConstraints.suite());
    }
}

