/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Node;
import gate.annotation.AnnotationSetImpl;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.event.ProgressListener;
import gate.fsm.FSM;
import gate.fsm.FSMInstance;
import gate.fsm.RuleTime;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.Transducer;
import gate.util.Benchmark;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.SimpleSortedSet;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePhaseTransducer
extends Transducer
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -2749474684496896114L;
    protected static final Logger log = Logger.getLogger(SinglePhaseTransducer.class);
    protected int ruleApplicationStyle = 1;
    protected PrioritisedRuleList rules;
    protected FSM fsm;
    protected List<FSMInstance> activeFSMInstances;
    private Map<String, String> optionSettings = new HashMap<String, String>();
    protected boolean finishedAlready;
    public Set input = new HashSet();
    private transient Vector progressListeners;

    public SinglePhaseTransducer(String string) {
        this.name = string;
        this.rules = new PrioritisedRuleList();
        this.finishedAlready = false;
    }

    public void setRuleApplicationStyle(int n) {
        this.ruleApplicationStyle = n;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void setOption(String string, String string2) {
        this.optionSettings.put(string, string2);
    }

    public String getOption(String string) {
        return this.optionSettings.get(string);
    }

    @Override
    public void finish() {
        if (this.finishedAlready) {
            return;
        }
        this.finishedAlready = true;
        HashMap<String, String> hashMap = new HashMap<String, String>(this.rules.size());
        for (Rule rule : this.rules) {
            rule.finish();
            hashMap.put(rule.getRHS().getActionClassName(), rule.getRHS().getActionClassString());
        }
        try {
            Javac.loadClasses(hashMap);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
        this.fsm = this.createFSM();
        this.rules.clear();
        this.rules = null;
    }

    protected FSM createFSM() {
        return new FSM(this);
    }

    private void addAnnotationsByOffset(SimpleSortedSet simpleSortedSet, Set set) {
        for (Annotation annotation : set) {
            long l = annotation.getStartNode().getOffset();
            if (l == annotation.getEndNode().getOffset()) continue;
            simpleSortedSet.add(l, annotation);
        }
    }

    @Override
    public void transduce(Document document, AnnotationSet annotationSet, AnnotationSet annotationSet2) throws JapeException, ExecutionException {
        Object object;
        Serializable serializable;
        Object object2;
        SimpleSortedSet simpleSortedSet;
        this.interrupted = false;
        log.debug((Object)("Start: " + this.name));
        this.fireProgressChanged(0);
        SimpleSortedSet simpleSortedSet2 = simpleSortedSet = new SimpleSortedSet();
        if (this.input.isEmpty()) {
            this.addAnnotationsByOffset(simpleSortedSet, annotationSet);
        } else {
            object2 = this.input.iterator();
            serializable = null;
            while (object2.hasNext()) {
                serializable = annotationSet.get((String)object2.next());
                if (serializable == null) continue;
                this.addAnnotationsByOffset(simpleSortedSet, (Set)((Object)serializable));
            }
        }
        if (simpleSortedSet2.isEmpty()) {
            this.fireProcessFinished();
            return;
        }
        simpleSortedSet2.sort();
        if (this.activeFSMInstances == null) {
            this.activeFSMInstances = new LinkedList<FSMInstance>();
        } else {
            this.activeFSMInstances.clear();
        }
        object2 = new LinkedList();
        serializable = ((Annotation)((List)simpleSortedSet2.get(simpleSortedSet.first())).get(0)).getStartNode();
        long l = document.getContent().size();
        long l2 = serializable.getOffset();
        SearchState searchState = new SearchState((Node)serializable, l2, 0L);
        while (searchState.startNodeOff != -1L) {
            boolean bl;
            FSMInstance fSMInstance = new FSMInstance(this.fsm, this.fsm.getInitialState(), searchState.startNode, searchState.startNode, new HashMap<String, AnnotationSet>(), document);
            this.activeFSMInstances.clear();
            object2.clear();
            this.activeFSMInstances.add(fSMInstance);
            while (!this.activeFSMInstances.isEmpty()) {
                if (this.interrupted) {
                    throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
                }
                FSMInstance fSMInstance2 = this.activeFSMInstances.remove(0);
                object = this.attemptAdvance(fSMInstance2, simpleSortedSet, simpleSortedSet2, document, annotationSet);
                if (object == null) continue;
                if (((FSMMatcherResult)object).acceptingFSMInstances != null && !((FSMMatcherResult)object).acceptingFSMInstances.isEmpty()) {
                    object2.addAll(((FSMMatcherResult)object).acceptingFSMInstances);
                    if (this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) break;
                }
                if (((FSMMatcherResult)object).activeFSMInstances == null || ((FSMMatcherResult)object).activeFSMInstances.isEmpty()) continue;
                this.activeFSMInstances.addAll(((FSMMatcherResult)object).activeFSMInstances);
            }
            if (bl = this.fireRule((List<FSMInstance>)object2, searchState, l, simpleSortedSet, annotationSet, annotationSet2, document, simpleSortedSet2)) continue;
            return;
        }
        this.fireProcessFinished();
        if (Benchmark.isBenchmarkingEnabled()) {
            for (RuleTime ruleTime : this.fsm.getRuleTimes()) {
                object = ruleTime.getRuleName();
                long l3 = ruleTime.getTimeSpent();
                ruleTime.setTimeSpent(0L);
                Benchmark.checkPointWithDuration(l3, Benchmark.createBenchmarkId("rule__" + (String)object, this.getBenchmarkId()), this, this.benchmarkFeatures);
            }
        }
    }

    private FSMMatcherResult attemptAdvance(FSMInstance fSMInstance, SimpleSortedSet simpleSortedSet, SimpleSortedSet simpleSortedSet2, Document document, AnnotationSet annotationSet) {
        SimpleSortedSet simpleSortedSet3;
        long l;
        List list;
        long l2 = 0L;
        if (Benchmark.isBenchmarkingEnabled()) {
            l2 = Benchmark.startPoint();
        }
        ArrayList<FSMInstance> arrayList = null;
        ArrayList<FSMInstance> arrayList2 = null;
        FSMInstance fSMInstance2 = (FSMInstance)fSMInstance.clone();
        if (fSMInstance.getFSMPosition().isFinal()) {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<FSMInstance>();
            }
            arrayList2.add(fSMInstance2);
            if (this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) {
                if (Benchmark.isBenchmarkingEnabled()) {
                    this.updateRuleTime(fSMInstance, l2);
                }
                return new FSMMatcherResult(arrayList, arrayList2);
            }
        }
        List list2 = list = (l = (simpleSortedSet3 = simpleSortedSet.tailSet(fSMInstance.getAGPosition().getOffset())).first()) >= 0L ? (List)simpleSortedSet2.get(l) : null;
        if (list != null && !list.isEmpty()) {
            State state = fSMInstance2.getFSMPosition();
            Iterator<Transition> iterator = state.getTransitions().iterator();
            boolean bl = false;
            block0: while (iterator.hasNext()) {
                List list3;
                List<Annotation> list4;
                Object object;
                int n;
                Transition transition = iterator.next();
                Constraint[] constraintArray = transition.getConstraints().getConstraints();
                boolean bl2 = false;
                List[] listArray = new List[constraintArray.length];
                for (n = 0; n < listArray.length; ++n) {
                    listArray[n] = null;
                }
                for (n = 0; n < constraintArray.length; ++n) {
                    object = constraintArray[n];
                    if (!((Constraint)object).isNegated()) {
                        bl2 = true;
                        continue;
                    }
                    list4 = ((Constraint)object).matches(list, this.ontology, annotationSet);
                    if (!list4.isEmpty()) continue block0;
                }
                if (bl2) {
                    for (n = 0; n < constraintArray.length; ++n) {
                        object = constraintArray[n];
                        if (((Constraint)object).isNegated()) continue;
                        list4 = ((Constraint)object).matches(list, this.ontology, annotationSet);
                        if (list4.isEmpty()) continue block0;
                        listArray[n] = list4;
                    }
                } else {
                    listArray[0] = list;
                }
                ArrayList<List<Annotation>> arrayList3 = new ArrayList<List<Annotation>>();
                for (int i = 0; i < constraintArray.length; ++i) {
                    list4 = constraintArray[i];
                    list3 = listArray[i];
                    if (list3 == null) continue;
                    arrayList3.add(list3);
                }
                object = SinglePhaseTransducer.combine(arrayList3, arrayList3.size(), new LinkedList<Annotation>());
                list4 = object.iterator();
                while (list4.hasNext()) {
                    FSMInstance fSMInstance3;
                    list3 = (List)list4.next();
                    Annotation annotation = this.getRightMostAnnotation(list3);
                    if (bl) {
                        fSMInstance3 = (FSMInstance)fSMInstance2.clone();
                    } else {
                        fSMInstance3 = fSMInstance;
                        bl = true;
                    }
                    fSMInstance3.setAGPosition(annotation.getEndNode());
                    fSMInstance3.setFSMPosition(transition.getTarget());
                    HashMap<String, AnnotationSet> hashMap = fSMInstance3.getBindings();
                    for (String string : transition.getBindings()) {
                        AnnotationSet annotationSet2 = (AnnotationSet)hashMap.get(string);
                        AnnotationSetImpl annotationSetImpl = annotationSet2 != null ? new AnnotationSetImpl(annotationSet2) : new AnnotationSetImpl(document);
                        for (Annotation annotation2 : list3) {
                            annotationSetImpl.add(annotation2);
                        }
                        hashMap.put(string, annotationSetImpl);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<FSMInstance>();
                    }
                    arrayList.add(fSMInstance3);
                }
            }
        }
        if (Benchmark.isBenchmarkingEnabled()) {
            this.updateRuleTime(fSMInstance, l2);
        }
        return new FSMMatcherResult(arrayList, arrayList2);
    }

    private void updateRuleTime(FSMInstance fSMInstance, long l) {
        int n = fSMInstance.getFSMPosition().getIndexInRuleList();
        fSMInstance.getSupportGraph().getRuleTimes().get(n).addTime(Benchmark.startPoint() - l);
    }

    protected Annotation getRightMostAnnotation(Collection<Annotation> collection) {
        long l = -1L;
        Annotation annotation = null;
        for (Annotation annotation2 : collection) {
            Long l2 = annotation2.getEndNode().getOffset();
            if (l2 <= l) continue;
            l = l2;
            annotation = annotation2;
        }
        return annotation;
    }

    private static List<List<Annotation>> combine(List<List<Annotation>> list, int n, List<Annotation> list2) {
        LinkedList<List<Annotation>> linkedList = new LinkedList<List<Annotation>>();
        if (list2.size() == n) {
            linkedList.add(list2);
        } else {
            List<Annotation> list3 = list.get(list2.size());
            for (int i = 0; i < list3.size(); ++i) {
                List list4 = (List)((LinkedList)list2).clone();
                list4.add(list3.get(i));
                linkedList.addAll(SinglePhaseTransducer.combine(list, n, list4));
            }
        }
        return linkedList;
    }

    protected boolean fireRule(List<FSMInstance> list, SearchState searchState, long l, SimpleSortedSet simpleSortedSet, AnnotationSet annotationSet, AnnotationSet annotationSet2, Document document, SimpleSortedSet simpleSortedSet2) throws JapeException, ExecutionException {
        FSMInstance fSMInstance;
        Object object;
        Node node = searchState.startNode;
        long l2 = searchState.startNodeOff;
        long l3 = searchState.oldStartNodeOff;
        long l4 = -1L;
        if (list.isEmpty()) {
            l4 = l2 + 1L;
        } else if (this.ruleApplicationStyle == 1 || this.ruleApplicationStyle == 5) {
            object = list.iterator();
            l4 = node.getOffset();
            while (object.hasNext()) {
                long l5;
                fSMInstance = (FSMInstance)object.next();
                RightHandSide rightHandSide = fSMInstance.getFSMPosition().getAction();
                rightHandSide.transduce(document, fSMInstance.getBindings(), annotationSet, annotationSet2, this.ontology);
                if (this.ruleApplicationStyle != 1 || (l5 = fSMInstance.getAGPosition().getOffset().longValue()) <= l4) continue;
                l4 = l5;
            }
            if (this.ruleApplicationStyle == 5) {
                ++l4;
            }
        } else if (this.ruleApplicationStyle == 2 || this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) {
            Object object2;
            Cloneable cloneable;
            Object object3;
            Collections.sort(list, Collections.reverseOrder());
            object = list.iterator();
            fSMInstance = object.next();
            if (this.isDebugMode()) {
                object3 = list.iterator();
                cloneable = new ArrayList<FSMInstance>();
                while (object3.hasNext() && ((FSMInstance)(object2 = (FSMInstance)object3.next())).equals(fSMInstance)) {
                    cloneable.add(object2);
                }
                if (cloneable.size() > 1) {
                    log.info((Object)"Conflicts found during matching:\n================================");
                    object3 = cloneable.iterator();
                    int n = 0;
                    while (object3.hasNext()) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)(n++ + ") " + ((FSMInstance)object3.next()).toString()));
                    }
                }
            }
            object3 = fSMInstance.getFSMPosition().getAction();
            ((RightHandSide)object3).transduce(document, fSMInstance.getBindings(), annotationSet, annotationSet2, this.ontology);
            if (this.isMatchGroupMode()) {
                object2 = null;
                while (object.hasNext() && ((FSMInstance)(cloneable = (FSMInstance)object.next())).compareTo(fSMInstance) == 0) {
                    if (((FSMInstance)cloneable).equals(fSMInstance)) continue;
                    if (this.isDebugMode()) {
                        if (object2 == null) {
                            object2 = fSMInstance.toString();
                            if (log.isInfoEnabled()) {
                                log.info((Object)"~Jape Grammar Transducer : \nConcurrent Patterns by length,priority and index (all transduced):");
                                log.info(object2);
                                log.info((Object)("bindings : " + fSMInstance.getBindings()));
                                log.info((Object)"Rivals Follow: ");
                            }
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)cloneable);
                            log.info((Object)("bindings : " + ((FSMInstance)cloneable).getBindings()));
                        }
                    }
                    object3 = ((FSMInstance)cloneable).getFSMPosition().getAction();
                    ((RightHandSide)object3).transduce(document, ((FSMInstance)cloneable).getBindings(), annotationSet, annotationSet2, this.ontology);
                }
            }
            if (this.ruleApplicationStyle == 4) {
                searchState.startNodeOff = l2;
                return false;
            }
            l4 = fSMInstance.getAGPosition().getOffset();
        } else {
            throw new RuntimeException("Unknown rule application style!");
        }
        object = simpleSortedSet.tailSet(l4);
        long l6 = ((SimpleSortedSet)object).first();
        if (l6 < 0L) {
            l2 = -1L;
            this.fireProcessFinished();
        } else {
            long l7 = l6;
            node = ((Annotation)((List)simpleSortedSet2.get(l7)).get(0)).getStartNode();
            l2 = node.getOffset();
            if (l3 == l2) {
                l4 = l2 + 1L;
                object = simpleSortedSet.tailSet(l4);
                l6 = ((SimpleSortedSet)object).first();
                if (l6 < 0L) {
                    l2 = -1L;
                    this.fireProcessFinished();
                } else {
                    l7 = l6;
                    node = ((Annotation)((List)simpleSortedSet2.get(l6)).get(0)).getStartNode();
                    l2 = node.getOffset();
                }
            }
            if (l2 - l3 > 256L) {
                if (this.isInterrupted()) {
                    throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
                }
                this.fireProgressChanged((int)(100L * l2 / l));
                l3 = l2;
            }
        }
        searchState.oldStartNodeOff = l3;
        searchState.startNodeOff = l2;
        searchState.startNode = node;
        return true;
    }

    @Override
    public void cleanUp() {
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String string) {
        String string2 = Strings.getNl();
        String string3 = Strings.addPadding(string, 4);
        StringBuffer stringBuffer = new StringBuffer(string + "SPT: name(" + this.name + "); ruleApplicationStyle(");
        switch (this.ruleApplicationStyle) {
            case 2: {
                stringBuffer.append("APPELT_STYLE); ");
                break;
            }
            case 1: {
                stringBuffer.append("BRILL_STYLE); ");
                break;
            }
        }
        stringBuffer.append("rules(" + string2);
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Rule)iterator.next()).toString(string3) + " ");
        }
        stringBuffer.append(string2 + string + ")." + string2);
        return stringBuffer.toString();
    }

    public PrioritisedRuleList getRules() {
        return this.rules;
    }

    public void addInput(String string) {
        this.input.add(string);
    }

    public boolean hasInput(String string) {
        return this.input.isEmpty() || this.input.contains(string);
    }

    public boolean isInputRestricted() {
        return !this.input.isEmpty();
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    @Override
    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    @Override
    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    @Override
    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public int getRuleApplicationStyle() {
        return this.ruleApplicationStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FSMMatcherResult {
        private List<FSMInstance> acceptingFSMInstances;
        private List<FSMInstance> activeFSMInstances;

        public FSMMatcherResult(List<FSMInstance> list, List<FSMInstance> list2) {
            this.activeFSMInstances = list;
            this.acceptingFSMInstances = list2;
        }
    }

    protected static class SearchState {
        Node startNode;
        long startNodeOff;
        long oldStartNodeOff;

        SearchState(Node node, long l, long l2) {
            this.startNode = node;
            this.startNodeOff = l;
            this.oldStartNodeOff = l2;
        }
    }
}

