/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.gui.MainFrame;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class ValuesSelectionAction {
    protected JComboBox domainBox = new JComboBox();
    protected JList list = null;
    protected JButton add;
    protected JButton remove;
    protected JPanel panel;
    protected String[] ontologyClasses;
    protected boolean allowValueOutsideDropDownList = true;

    public ValuesSelectionAction() {
        this.domainBox.setEditable(true);
        this.list = new JList(new DefaultComboBoxModel());
        this.list.setVisibleRowCount(7);
        this.add = new JButton("Add");
        this.remove = new JButton("Remove");
        this.panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.panel, 1);
        this.panel.setLayout(boxLayout);
        this.panel.add(this.domainBox);
        this.domainBox.setEditable(true);
        this.domainBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextComponent)ValuesSelectionAction.this.domainBox.getEditor().getEditorComponent()).getText();
                if (string != null) {
                    if (keyEvent.getKeyCode() != 10) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < ValuesSelectionAction.this.ontologyClasses.length; ++i) {
                            String string2 = ValuesSelectionAction.this.ontologyClasses[i];
                            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                            arrayList.add(string2);
                        }
                        Collections.sort(arrayList);
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
                        ValuesSelectionAction.this.domainBox.setModel(defaultComboBoxModel);
                        if (!arrayList.isEmpty()) {
                            ValuesSelectionAction.this.domainBox.showPopup();
                        }
                    }
                    ((JTextComponent)ValuesSelectionAction.this.domainBox.getEditor().getEditorComponent()).setText(string);
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.add);
        jPanel.add(this.remove);
        this.panel.add(jPanel);
        this.panel.add(new JScrollPane(this.list));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ValuesSelectionAction.this.domainBox.getSelectedItem();
                if (!ValuesSelectionAction.this.allowValueOutsideDropDownList && !Arrays.asList(ValuesSelectionAction.this.ontologyClasses).contains(string)) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "The value \"" + string + "\" is not in the drop down list!");
                    return;
                }
                if (((DefaultComboBoxModel)ValuesSelectionAction.this.list.getModel()).getIndexOf(string) != -1) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Already added!");
                } else {
                    ((DefaultComboBoxModel)ValuesSelectionAction.this.list.getModel()).addElement(string);
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ValuesSelectionAction.this.list.getSelectedValues();
                if (objectArray != null && objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((DefaultComboBoxModel)ValuesSelectionAction.this.list.getModel()).removeElement(objectArray[i]);
                    }
                }
            }
        });
    }

    public int showGUI(String string, String[] stringArray, String[] stringArray2, boolean bl, Icon icon) {
        this.ontologyClasses = stringArray;
        this.allowValueOutsideDropDownList = bl;
        this.domainBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.list.setModel(new DefaultComboBoxModel<String>(stringArray2));
        JOptionPane jOptionPane = new JOptionPane(this.panel, 3, 2, icon){

            public void selectInitialValue() {
                ValuesSelectionAction.this.domainBox.requestFocusInWindow();
                ValuesSelectionAction.this.domainBox.getEditor().selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), string).setVisible(true);
        return jOptionPane.getValue() == null ? -1 : (Integer)jOptionPane.getValue();
    }

    public String[] getSelectedValues() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.list.getModel();
        String[] stringArray = new String[defaultComboBoxModel.getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)defaultComboBoxModel.getElementAt(i);
        }
        return stringArray;
    }
}

