/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.Restriction;
import gate.creole.ontology.SymmetricProperty;
import gate.creole.ontology.TransitiveProperty;
import gate.gui.MainFrame;
import gate.gui.ontology.OntologyEditor;
import gate.gui.ontology.OntologyItemComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class SearchAction
extends AbstractAction {
    protected JComboBox resourcesBox;
    protected JPanel guiPanel;
    protected OntologyEditor ontologyEditor;
    protected OResource[] resourcesArray = new OResource[0];
    protected RDFProperty[] propertiesArray = new RDFProperty[0];
    protected JComboBox properties;
    protected JCheckBox searchInPropertyValues;

    public SearchAction(String string, Icon icon, OntologyEditor ontologyEditor) {
        super(string, icon);
        this.ontologyEditor = ontologyEditor;
        this.guiPanel = new JPanel();
        this.guiPanel.setLayout(new BoxLayout(this.guiPanel, 1));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel.add(new JLabel("Find what: "));
        this.resourcesBox = new JComboBox();
        this.resourcesBox.setRenderer(new ComboRenderer());
        this.resourcesBox.setPrototypeDisplayValue("this is just an example, not a value. OK?");
        this.resourcesBox.setEditable(true);
        this.resourcesBox.setEditable(true);
        this.resourcesBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextComponent)SearchAction.this.resourcesBox.getEditor().getEditorComponent()).getText();
                if (string != null) {
                    if (keyEvent.getKeyCode() != 10) {
                        Object object;
                        HashSet<OResource> hashSet = new HashSet<OResource>();
                        for (int i = 0; i < SearchAction.this.resourcesArray.length; ++i) {
                            object = SearchAction.this.resourcesArray[i].getName();
                            if (!((String)object).toLowerCase().startsWith(string.toLowerCase())) continue;
                            hashSet.add(SearchAction.this.resourcesArray[i]);
                        }
                        if (SearchAction.this.searchInPropertyValues.isSelected()) {
                            RDFProperty rDFProperty = (RDFProperty)SearchAction.this.properties.getSelectedItem();
                            object = new ArrayList();
                            if (rDFProperty instanceof ObjectProperty) {
                                OResource oResource = SearchAction.this.ontologyEditor.ontology.getOResourceByName(string);
                                if (oResource != null) {
                                    object = SearchAction.this.ontologyEditor.ontology.getOResourcesWith(rDFProperty, oResource);
                                }
                            } else {
                                object = SearchAction.this.ontologyEditor.ontology.getOResourcesWith(rDFProperty, new Literal(string));
                            }
                            hashSet.addAll((Collection<OResource>)object);
                        }
                        ArrayList arrayList = new ArrayList(hashSet);
                        Collections.sort(arrayList, new OntologyItemComparator());
                        object = new DefaultComboBoxModel<Object>(arrayList.toArray());
                        SearchAction.this.resourcesBox.setModel(object);
                        try {
                            if (!arrayList.isEmpty()) {
                                SearchAction.this.resourcesBox.showPopup();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((JTextComponent)SearchAction.this.resourcesBox.getEditor().getEditorComponent()).setText(string);
                }
            }
        });
        jPanel.add(this.resourcesBox);
        this.properties = new JComboBox();
        this.properties.setRenderer(new ComboRenderer());
        this.properties.setEditable(true);
        this.properties.setPrototypeDisplayValue("this is just an example, not a value. OK?");
        this.properties.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextComponent)SearchAction.this.properties.getEditor().getEditorComponent()).getText();
                if (string != null) {
                    if (keyEvent.getKeyCode() != 10) {
                        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                        for (int i = 0; i < SearchAction.this.propertiesArray.length; ++i) {
                            String string2 = SearchAction.this.propertiesArray[i].getName();
                            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                            arrayList.add(SearchAction.this.propertiesArray[i]);
                        }
                        Collections.sort(arrayList, new OntologyItemComparator());
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
                        SearchAction.this.properties.setModel(defaultComboBoxModel);
                        try {
                            if (!arrayList.isEmpty()) {
                                SearchAction.this.properties.showPopup();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((JTextComponent)SearchAction.this.properties.getEditor().getEditorComponent()).setText(string);
                }
            }
        });
        this.searchInPropertyValues = new JCheckBox("In the values of: ");
        this.searchInPropertyValues.setSelected(false);
        jPanel2.add(this.searchInPropertyValues);
        jPanel2.add(this.properties);
        this.guiPanel.add(jPanel);
        this.guiPanel.add(jPanel2);
        this.resourcesBox.setPreferredSize(new Dimension(300, this.resourcesBox.getPreferredSize().height));
        this.properties.setPreferredSize(new Dimension(300, this.resourcesBox.getPreferredSize().height));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        List<OResource> list = this.ontologyEditor.ontology.getAllResources();
        Collections.sort(list, new OntologyItemComparator());
        this.resourcesArray = new OResource[list.size()];
        this.resourcesArray = list.toArray(this.resourcesArray);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.resourcesBox.setModel(defaultComboBoxModel);
        Set<RDFProperty> set = this.ontologyEditor.ontology.getRDFProperties();
        set.addAll(this.ontologyEditor.ontology.getAnnotationProperties());
        set.addAll(this.ontologyEditor.ontology.getObjectProperties());
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>(set);
        Collections.sort(arrayList, new OntologyItemComparator());
        this.propertiesArray = new RDFProperty[set.size()];
        this.propertiesArray = set.toArray(this.propertiesArray);
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.properties.setModel(defaultComboBoxModel2);
        list = null;
        set = null;
        arrayList = null;
        int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), this.guiPanel, "Find Ontology Resource", 2, 3, MainFrame.getIcon("search"), new String[]{"Find", "Cancel"}, "Find");
        if (n == 0) {
            Object object = this.resourcesBox.getSelectedItem();
            if (!(object instanceof OResource)) {
                return;
            }
            OResource oResource = (OResource)object;
            if (oResource instanceof RDFProperty) {
                this.ontologyEditor.propertyTree.setSelectionPath(new TreePath(this.ontologyEditor.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0).getPath()));
                this.ontologyEditor.propertyTree.scrollPathToVisible(this.ontologyEditor.propertyTree.getSelectionPath());
                this.ontologyEditor.tabbedPane.setSelectedComponent(this.ontologyEditor.propertyScroller);
            } else {
                this.ontologyEditor.tree.setSelectionPath(new TreePath(this.ontologyEditor.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0).getPath()));
                this.ontologyEditor.tree.scrollPathToVisible(this.ontologyEditor.tree.getSelectionPath());
                this.ontologyEditor.tabbedPane.setSelectedComponent(this.ontologyEditor.scroller);
            }
        }
    }

    public class ComboRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel label = new JLabel();
        private JLabel iconLabel = new JLabel();
        private JPanel labelPanel = new JPanel(new BorderLayout(5, 10));

        public ComboRenderer() {
            ((BorderLayout)this.labelPanel.getLayout()).setHgap(0);
            this.labelPanel.add(this.label);
            this.setLayout(new BorderLayout(5, 10));
            ((BorderLayout)this.getLayout()).setHgap(1);
            this.add((Component)this.iconLabel, "West");
            this.add((Component)this.labelPanel, "Center");
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof OResource)) {
                this.label.setBackground(Color.white);
                return this;
            }
            Icon icon = null;
            String string = ((OResource)object).getName();
            this.iconLabel.setVisible(true);
            if (object instanceof Restriction) {
                icon = MainFrame.getIcon("ontology-restriction");
            } else if (object instanceof OClass) {
                icon = MainFrame.getIcon("ontology-class");
            } else if (object instanceof OInstance) {
                icon = MainFrame.getIcon("ontology-instance");
            } else if (object instanceof AnnotationProperty) {
                icon = MainFrame.getIcon("ontology-annotation-property");
            } else if (object instanceof DatatypeProperty) {
                icon = MainFrame.getIcon("ontology-datatype-property");
            } else if (object instanceof SymmetricProperty) {
                icon = MainFrame.getIcon("ontology-symmetric-property");
            } else if (object instanceof TransitiveProperty) {
                icon = MainFrame.getIcon("ontology-transitive-property");
            } else if (object instanceof ObjectProperty) {
                icon = MainFrame.getIcon("ontology-object-property");
            } else if (object instanceof RDFProperty) {
                icon = MainFrame.getIcon("ontology-rdf-property");
            }
            this.iconLabel.setIcon(icon);
            this.label.setText(string);
            this.label.setFont(jList.getFont());
            return this;
        }
    }
}

