/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257844402729529651L;
    JTextField nameSpace;
    JTextField instanceName;
    JPanel mainPanel = new JPanel(new GridBagLayout());
    Ontology ontology;
    ArrayList<DefaultMutableTreeNode> selectedNodes;

    public InstanceAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Instance Name:"), gridBagConstraints);
        this.instanceName = new JTextField(30);
        this.mainPanel.add((Component)this.instanceName, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OResource oResource = ((OResourceNode)this.selectedNodes.get(0).getUserObject()).getResource();
        String string = oResource.getURI().getNameSpace();
        if (gate.creole.ontology.Utils.hasSystemNameSpace(oResource.getURI().toString())) {
            string = this.ontology.getDefaultNameSpace();
        }
        this.nameSpace.setText(string);
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-instance")){

            public void selectInitialValue() {
                InstanceAction.this.instanceName.requestFocusInWindow();
                InstanceAction.this.instanceName.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Instance").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string2 = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string2)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string2 + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.instanceName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Instance: " + this.instanceName.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string2 + this.instanceName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string2 + this.instanceName.getText() + "</b> already exists.");
                return;
            }
            for (int i = 0; i < this.selectedNodes.size(); ++i) {
                OResource oResource2 = ((OResourceNode)this.selectedNodes.get(i).getUserObject()).getResource();
                if (!(oResource2 instanceof OClass)) continue;
                this.ontology.addOInstance(new URI(this.nameSpace.getText() + this.instanceName.getText(), false), (OClass)oResource2);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

