/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.SearchExpressionsAction;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.JMenuButton;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(name="Document Editor", guiType=GuiType.LARGE, resourceDisplayed="gate.Document", mainViewer=true)
public class DocumentEditor
extends AbstractVisualResource
implements ActionsPublisher {
    private static final long serialVersionUID = 1L;
    static Settings settings = new Settings();
    protected JSplitPane horizontalSplit;
    protected JSplitPane topSplit;
    protected JSplitPane bottomSplit;
    private SearchDialog searchDialog;
    protected Action searchAction;
    private List<AnnotationData> selectedAnnotations = new ArrayList<AnnotationData>();
    protected JToolBar topBar;
    protected Document document;
    protected List<DocumentView> centralViews;
    protected List<DocumentView> verticalViews;
    protected List<DocumentView> horizontalViews;
    protected int centralViewIdx = -1;
    protected int rightViewIdx = -1;
    protected int topViewIdx = -1;
    protected int bottomViewIdx = -1;
    protected boolean viewsInited = false;
    protected int fKeyNumber = 2;

    @Override
    public List getActions() {
        Iterator<DocumentView> iterator;
        ArrayList arrayList = new ArrayList();
        if (this.getCentralViews() != null) {
            iterator = this.getCentralViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(iterator.next().getActions());
            }
        }
        if (this.getHorizontalViews() != null) {
            iterator = this.getHorizontalViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(iterator.next().getActions());
            }
        }
        if (this.getVerticalViews() != null) {
            iterator = this.getVerticalViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(iterator.next().getActions());
            }
        }
        return arrayList;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }
        });
        return this;
    }

    @Override
    public void cleanup() {
        Iterator<DocumentView> iterator;
        if (this.centralViews != null) {
            iterator = this.centralViews.iterator();
            while (iterator.hasNext()) {
                iterator.next().cleanup();
            }
            this.centralViews.clear();
        }
        if (this.horizontalViews != null) {
            iterator = this.horizontalViews.iterator();
            while (iterator.hasNext()) {
                iterator.next().cleanup();
            }
            this.horizontalViews.clear();
        }
        if (this.verticalViews != null) {
            iterator = this.verticalViews.iterator();
            while (iterator.hasNext()) {
                iterator.next().cleanup();
            }
            this.verticalViews.clear();
        }
    }

    protected void initViews() {
        Serializable serializable;
        this.viewsInited = true;
        this.setLayout(new BorderLayout());
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        jProgressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, jProgressBar.getPreferredSize().height));
        this.add((Component)jProgressBar, "Center");
        jProgressBar.setString("Building views");
        jProgressBar.setValue(10);
        this.topSplit = new JSplitPane(0, null, null);
        this.topSplit.setResizeWeight(0.3);
        this.topSplit.setContinuousLayout(true);
        this.topSplit.setOneTouchExpandable(true);
        this.bottomSplit = new JSplitPane(0, this.topSplit, null);
        this.bottomSplit.setResizeWeight(0.7);
        this.bottomSplit.setContinuousLayout(true);
        this.bottomSplit.setOneTouchExpandable(true);
        this.horizontalSplit = new JSplitPane(1, this.bottomSplit, null);
        this.horizontalSplit.setResizeWeight(0.7);
        this.horizontalSplit.setContinuousLayout(true);
        this.horizontalSplit.setOneTouchExpandable(true);
        this.topBar = new JToolBar(0);
        this.topBar.setFloatable(false);
        this.add((Component)this.topBar, "North");
        jProgressBar.setValue(40);
        this.centralViews = new ArrayList<DocumentView>();
        this.verticalViews = new ArrayList<DocumentView>();
        this.horizontalViews = new ArrayList<DocumentView>();
        Set<String> set = Gate.getCreoleRegister().getVrTypes();
        ArrayList<ResourceData> arrayList = new ArrayList<ResourceData>();
        for (String object2 : set) {
            serializable = (ResourceData)Gate.getCreoleRegister().get(object2);
            try {
                if (!DocumentView.class.isAssignableFrom(((ResourceData)serializable).getResourceClass())) continue;
                arrayList.add((ResourceData)serializable);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        Collections.sort(arrayList, new Comparator<ResourceData>(){

            @Override
            public int compare(ResourceData resourceData, ResourceData resourceData2) {
                return resourceData.getName().compareTo(resourceData2.getName());
            }
        });
        for (ResourceData resourceData : arrayList) {
            try {
                serializable = (DocumentView)Factory.createResource(resourceData.getClassName());
                serializable.setTarget(this.document);
                serializable.setOwner(this);
                this.addView((DocumentView)serializable, resourceData.getName());
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace();
            }
        }
        if (this.centralViews.size() > 0) {
            this.setCentralView(0);
        }
        this.remove(jProgressBar);
        this.add((Component)this.horizontalSplit, "Center");
        this.searchAction = new SearchAction();
        JButton jButton = new JButton(this.searchAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.topBar.add(Box.createHorizontalStrut(5));
        this.topBar.add(jButton);
        this.getInputMap(1).put(KeyStroke.getKeyStroke("control F"), "Search in text");
        this.getActionMap().put("Search in text", this.searchAction);
        final OptionsMap optionsMap = Gate.getUserConfig();
        serializable = new JPopupMenu("Options menu");
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Save Current Layout"){

            public void actionPerformed(ActionEvent actionEvent) {
                settings.saveSettings(DocumentEditor.this);
            }
        });
        ((JPopupMenu)serializable).add(jMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Restore Layout Automatically");
        jCheckBoxMenuItem.setSelected(Gate.getUserConfig().getBoolean(DocumentEditor.class.getName() + ".restoreLayoutAutomatically"));
        jCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                optionsMap.put((Object)(DocumentEditor.class.getName() + ".restoreLayoutAutomatically"), (Object)jCheckBoxMenuItem.isSelected());
            }
        });
        ((JPopupMenu)serializable).add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Read-only");
        jCheckBoxMenuItem2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                optionsMap.put((Object)"docedit_read-only", (Object)jCheckBoxMenuItem2.isSelected());
                DocumentEditor.this.setEditable(!jCheckBoxMenuItem2.isSelected());
            }
        });
        jCheckBoxMenuItem2.setSelected(optionsMap.getBoolean("docedit_read-only"));
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add(jCheckBoxMenuItem2);
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Insert Append");
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setSelected(optionsMap.getBoolean("docedit_insert_append"));
        jRadioButtonMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                optionsMap.put((Object)"docedit_insert_append", (Object)jRadioButtonMenuItem.isSelected());
            }
        });
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add(jRadioButtonMenuItem);
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Insert Prepend");
        buttonGroup.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem2.setSelected(optionsMap.getBoolean("docedit_insert_prepend"));
        jRadioButtonMenuItem2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                optionsMap.put((Object)"docedit_insert_prepend", (Object)jRadioButtonMenuItem2.isSelected());
            }
        });
        ((JPopupMenu)serializable).add(jRadioButtonMenuItem2);
        if (!jRadioButtonMenuItem.isSelected() && !jRadioButtonMenuItem2.isSelected()) {
            jRadioButtonMenuItem.setSelected(true);
        }
        JMenuButton jMenuButton = new JMenuButton((JPopupMenu)serializable);
        jMenuButton.setIcon(MainFrame.getIcon("expanded"));
        jMenuButton.setToolTipText("Options for the document editor");
        jMenuButton.setMargin(new Insets(0, 0, 0, 1));
        this.topBar.add(Box.createHorizontalGlue());
        this.topBar.add(jMenuButton);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                if (Gate.getUserConfig().getBoolean(DocumentEditor.class.getName() + ".restoreLayoutAutomatically").booleanValue()) {
                    settings.restoreSettings(DocumentEditor.this);
                }
            }
        });
        this.validate();
    }

    public List<DocumentView> getCentralViews() {
        return this.centralViews == null ? null : Collections.unmodifiableList(this.centralViews);
    }

    public List<DocumentView> getHorizontalViews() {
        return this.horizontalViews == null ? null : Collections.unmodifiableList(this.horizontalViews);
    }

    public List<DocumentView> getVerticalViews() {
        return this.verticalViews == null ? null : Collections.unmodifiableList(this.verticalViews);
    }

    protected void addView(DocumentView documentView, String string) {
        this.topBar.add(Box.createHorizontalStrut(5));
        final ViewButton viewButton = new ViewButton(documentView, string);
        switch (documentView.getType()) {
            case 0: {
                this.centralViews.add(documentView);
                this.topBar.add(viewButton);
                break;
            }
            case 1: {
                this.verticalViews.add(documentView);
                this.topBar.add(viewButton);
                break;
            }
            case 2: {
                this.horizontalViews.add(documentView);
                this.topBar.add(viewButton);
                break;
            }
            default: {
                throw new GateRuntimeException(this.getClass().getName() + ": Invalid view type");
            }
        }
        if (this.fKeyNumber == 5 || this.fKeyNumber == 7 || this.fKeyNumber == 9) {
            ++this.fKeyNumber;
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F" + (this.fKeyNumber + 1)), "Shows view " + this.fKeyNumber + 1);
        this.getActionMap().put("Shows view " + this.fKeyNumber + 1, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                viewButton.doClick();
            }
        });
        if (documentView instanceof AnnotationSetsView) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke("shift F" + (this.fKeyNumber + 1)), "Shows view " + this.fKeyNumber + 1);
            viewButton.setToolTipText("<html>Toggle the view of " + string + "&nbsp;&nbsp;<font color=#667799><small>F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font>" + "<br>Set last selected annotations " + "&nbsp;&nbsp;<font color=#667799><small>Shift+F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font></html>");
        } else {
            viewButton.setToolTipText("<html>Toggle the view of " + string + "&nbsp;&nbsp;<font color=#667799><small>F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font></html>");
        }
        ++this.fKeyNumber;
    }

    protected DocumentView getTopView() {
        return this.topViewIdx == -1 ? null : this.horizontalViews.get(this.topViewIdx);
    }

    public void setTopView(int n) {
        DocumentView documentView = this.getTopView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.topViewIdx = n;
        if (this.topViewIdx == -1) {
            this.setTopView(null);
        } else {
            DocumentView documentView2 = this.horizontalViews.get(this.topViewIdx);
            if (this.bottomViewIdx == this.topViewIdx) {
                this.setBottomView(null);
                this.bottomViewIdx = -1;
            }
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setTopView(documentView2);
        }
    }

    protected void setTopView(DocumentView documentView) {
        this.topSplit.setTopComponent(documentView == null ? null : documentView.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getCentralView() {
        return this.centralViewIdx == -1 ? null : this.centralViews.get(this.centralViewIdx);
    }

    public void setCentralView(int n) {
        DocumentView documentView = this.getCentralView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.centralViewIdx = n;
        if (this.centralViewIdx == -1) {
            this.setCentralView(null);
        } else {
            DocumentView documentView2 = this.centralViews.get(this.centralViewIdx);
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setCentralView(documentView2);
        }
    }

    protected void setCentralView(DocumentView documentView) {
        this.topSplit.setBottomComponent(documentView == null ? null : documentView.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getBottomView() {
        return this.bottomViewIdx == -1 ? null : this.horizontalViews.get(this.bottomViewIdx);
    }

    public void setBottomView(int n) {
        DocumentView documentView = this.getBottomView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.bottomViewIdx = n;
        if (this.bottomViewIdx == -1) {
            this.setBottomView(null);
        } else {
            DocumentView documentView2 = this.horizontalViews.get(this.bottomViewIdx);
            if (this.topViewIdx == this.bottomViewIdx) {
                this.setTopView(null);
                this.topViewIdx = -1;
            }
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setBottomView(documentView2);
        }
    }

    protected void setBottomView(DocumentView documentView) {
        this.bottomSplit.setBottomComponent(documentView == null ? null : documentView.getGUI());
        this.bottomSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getRightView() {
        return this.rightViewIdx == -1 ? null : this.verticalViews.get(this.rightViewIdx);
    }

    public void setRightView(int n) {
        DocumentView documentView = this.getRightView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.rightViewIdx = n;
        if (this.rightViewIdx == -1) {
            this.setRightView(null);
        } else {
            DocumentView documentView2 = this.verticalViews.get(this.rightViewIdx);
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setRightView(documentView2);
        }
    }

    protected void setRightView(DocumentView documentView) {
        this.horizontalSplit.setRightComponent(documentView == null ? null : documentView.getGUI());
        this.updateBar(this.topBar);
        this.validate();
    }

    public void setSelectedAnnotations(List<AnnotationData> list) {
        this.selectedAnnotations.clear();
        this.selectedAnnotations.addAll(list);
        for (DocumentView documentView : this.centralViews) {
            if (!documentView.isActive()) continue;
            documentView.setSelectedAnnotations(this.selectedAnnotations);
        }
        for (DocumentView documentView : this.horizontalViews) {
            if (!documentView.isActive()) continue;
            documentView.setSelectedAnnotations(this.selectedAnnotations);
        }
        for (DocumentView documentView : this.verticalViews) {
            if (!documentView.isActive()) continue;
            documentView.setSelectedAnnotations(this.selectedAnnotations);
        }
    }

    public List<AnnotationData> getSelectedAnnotations() {
        return this.selectedAnnotations;
    }

    protected void updateSplitLocation(JSplitPane jSplitPane, int n) {
        Component component = jSplitPane.getLeftComponent();
        Component component2 = jSplitPane.getRightComponent();
        if (component == null) {
            jSplitPane.setDividerLocation(0);
            return;
        }
        if (component2 == null) {
            jSplitPane.setDividerLocation(1);
            return;
        }
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component2.getPreferredSize();
        double d = jSplitPane.getOrientation() == 1 ? (double)dimension.width / (double)(dimension.width + dimension2.width) : (double)dimension.height / (double)(dimension.height + dimension2.height);
        jSplitPane.setDividerLocation(d);
    }

    @Override
    public void setTarget(Object object) {
        this.document = (Document)object;
    }

    protected void updateBar(JToolBar jToolBar) {
        Component[] componentArray = jToolBar.getComponents();
        if (componentArray != null) {
            for (Component component : componentArray) {
                if (!(component instanceof ViewButton)) continue;
                ((ViewButton)component).updateSelected();
            }
        }
    }

    protected JTextComponent getTextComponent() {
        return (JTextComponent)((JScrollPane)this.getCentralView().getGUI()).getViewport().getView();
    }

    public void setEditable(boolean bl) {
        this.getTextComponent().setEditable(bl);
    }

    protected class ViewButton
    extends JToggleButton {
        DocumentView view;
        boolean annotationSetsViewFirstTime = true;

        public ViewButton(DocumentView documentView, String string) {
            this.setSelected(false);
            this.view = documentView;
            this.setText(string);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ViewButton.this.isSelected()) {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(DocumentEditor.this.centralViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(DocumentEditor.this.verticalViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(DocumentEditor.this.horizontalViews.indexOf(ViewButton.this.view));
                            }
                        }
                        if (ViewButton.this.view instanceof AnnotationSetsView && ViewButton.this.annotationSetsViewFirstTime) {
                            ViewButton.this.annotationSetsViewFirstTime = false;
                            AnnotationSetsView annotationSetsView = (AnnotationSetsView)ViewButton.this.view;
                            if (actionEvent.getModifiers() == 1 || (long)actionEvent.getModifiers() == 17L) {
                                annotationSetsView.restoreSavedSelectedTypes();
                            } else {
                                annotationSetsView.getSetHandler(null).setExpanded(true);
                                if (DocumentEditor.this.document.getAnnotationSetNames() != null) {
                                    for (String string : DocumentEditor.this.document.getAnnotationSetNames()) {
                                        if (string.equals("Original markups")) continue;
                                        annotationSetsView.getSetHandler(string).setExpanded(true);
                                    }
                                }
                            }
                            ViewButton.this.setToolTipText(ViewButton.this.getToolTipText().replaceFirst("<br>.*</html>$", "</html>"));
                        }
                    } else {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(-1);
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(-1);
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(-1);
                            }
                        }
                    }
                    if (ViewButton.this.view instanceof TextualDocumentView) {
                        DocumentEditor.this.searchAction.setEnabled(ViewButton.this.isSelected());
                    }
                }
            });
        }

        public void updateSelected() {
            switch (this.view.getType()) {
                case 0: {
                    this.setSelected(DocumentEditor.this.getCentralView() == this.view);
                    break;
                }
                case 1: {
                    this.setSelected(DocumentEditor.this.getRightView() == this.view);
                    break;
                }
                case 2: {
                    this.setSelected(DocumentEditor.this.getBottomView() == this.view);
                }
            }
        }
    }

    protected class SearchDialog
    extends JDialog {
        JTextComponent textPane;
        JTextField patternTextField;
        JCheckBox ignoreCaseChk;
        JCheckBox wholeWordsChk;
        JCheckBox regularExpressionChk;
        JCheckBox highlightsChk;
        Pattern pattern;
        int nextMatchStartsFrom;
        String content;
        Action findFirstAction;
        Action findNextAction;
        Action cancelAction;

        SearchDialog(Frame frame) {
            super(frame, false);
            this.textPane = DocumentEditor.this.getTextComponent();
            this.setTitle("Search in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        SearchDialog(Dialog dialog) {
            super(dialog, false);
            this.textPane = DocumentEditor.this.getTextComponent();
            this.setTitle("Search in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        protected void initLocalData() {
            this.pattern = null;
            this.nextMatchStartsFrom = 0;
            this.content = DocumentEditor.this.document.getContent().toString();
            this.findFirstAction = new AbstractAction("Find first"){
                {
                    this.putValue("ShortDescription", "Finds first match");
                    this.putValue("MnemonicKey", 70);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.isValidRegularExpression()) {
                        return;
                    }
                    boolean bl = false;
                    int n = -1;
                    int n2 = -1;
                    SearchDialog.this.nextMatchStartsFrom = 0;
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        bl = false;
                        if (SearchDialog.this.highlightsChk.isSelected()) {
                            Highlighter.Highlight[] highlightArray;
                            for (Highlighter.Highlight highlight : highlightArray = SearchDialog.this.textPane.getHighlighter().getHighlights()) {
                                if (highlight.getStartOffset() > n || highlight.getEndOffset() < n2) continue;
                                bl = true;
                                break;
                            }
                        } else {
                            bl = true;
                        }
                        SearchDialog.this.nextMatchStartsFrom = n2;
                    }
                    if (bl) {
                        SearchDialog.this.setTitle("Found: \"" + SearchDialog.this.content.substring(Math.max(0, n - 13), n).replaceAll("\\s+", " ") + "[" + SearchDialog.this.content.substring(n, n2).replaceAll("\\s+", " ") + "]" + SearchDialog.this.content.substring(n2, Math.min(SearchDialog.this.content.length(), n2 + 13)).replaceAll("\\s+", " ") + "\"");
                        SearchDialog.this.textPane.setCaretPosition(n);
                        SearchDialog.this.textPane.moveCaretPosition(n2);
                    } else {
                        SearchDialog.this.setTitle("Expression not found at all in the document.");
                        SearchDialog.this.findFirstAction.setEnabled(false);
                        SearchDialog.this.findNextAction.setEnabled(false);
                    }
                    SearchDialog.this.patternTextField.requestFocusInWindow();
                }
            };
            this.findNextAction = new AbstractAction("Find next"){
                {
                    this.putValue("ShortDescription", "Finds next match");
                    this.putValue("MnemonicKey", 78);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.isValidRegularExpression()) {
                        return;
                    }
                    boolean bl = false;
                    int n = -1;
                    int n2 = -1;
                    SearchDialog.this.nextMatchStartsFrom = actionEvent == null ? SearchDialog.this.textPane.getSelectionStart() : SearchDialog.this.textPane.getCaretPosition();
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        bl = false;
                        if (SearchDialog.this.highlightsChk.isSelected()) {
                            Highlighter.Highlight[] highlightArray;
                            for (Highlighter.Highlight highlight : highlightArray = SearchDialog.this.textPane.getHighlighter().getHighlights()) {
                                if (highlight.getStartOffset() > n || highlight.getEndOffset() < n2) continue;
                                bl = true;
                                break;
                            }
                        } else {
                            bl = true;
                        }
                        SearchDialog.this.nextMatchStartsFrom = n2;
                    }
                    if (bl) {
                        SearchDialog.this.setTitle("Found: \"" + SearchDialog.this.content.substring(Math.max(0, n - 13), n).replaceAll("\\s+", " ") + "[" + SearchDialog.this.content.substring(n, n2).replaceAll("\\s+", " ") + "]" + SearchDialog.this.content.substring(n2, Math.min(SearchDialog.this.content.length(), n2 + 13)).replaceAll("\\s+", " ") + "\"");
                        SearchDialog.this.textPane.setCaretPosition(n);
                        SearchDialog.this.textPane.moveCaretPosition(n2);
                    } else {
                        SearchDialog.this.setTitle("Expression not found after the document caret.");
                        SearchDialog.this.findNextAction.setEnabled(false);
                    }
                    SearchDialog.this.patternTextField.requestFocusInWindow();
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){
                {
                    this.putValue("ShortDescription", "Cancel");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DocumentEditor.this.searchDialog.setVisible(false);
                }
            };
        }

        protected void initGuiComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(Box.createVerticalStrut(5));
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(6));
            box.add(new JLabel("Find:"));
            box.add(Box.createHorizontalStrut(6));
            this.patternTextField = new JTextField(20);
            box.add(this.patternTextField);
            box.add(Box.createHorizontalStrut(3));
            JButton jButton = new JButton("?");
            jButton.setMargin(new Insets(0, 2, 0, 2));
            jButton.setToolTipText("GATE search expression builder.");
            box.add(jButton);
            box.add(Box.createHorizontalGlue());
            box.add(Box.createHorizontalStrut(6));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(6));
            this.ignoreCaseChk = new JCheckBox("Ignore case", true);
            box.add(this.ignoreCaseChk);
            box.add(Box.createHorizontalStrut(6));
            this.wholeWordsChk = new JCheckBox("Whole word", false);
            box.add(this.wholeWordsChk);
            box.add(Box.createHorizontalStrut(6));
            this.regularExpressionChk = new JCheckBox("Regular Exp.", false);
            box.add(this.regularExpressionChk);
            this.regularExpressionChk.setToolTipText("Regular expression search.");
            box.add(Box.createHorizontalStrut(6));
            this.highlightsChk = new JCheckBox("Highlights", false);
            box.add(this.highlightsChk);
            this.highlightsChk.setToolTipText("Restrict the search on the highlighted annotations.");
            box.add(Box.createHorizontalStrut(6));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            JButton jButton2 = new JButton(this.findFirstAction);
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(6));
            box.add(new JButton(this.findNextAction));
            box.add(Box.createHorizontalStrut(6));
            box.add(new JButton(this.cancelAction));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.getRootPane().setDefaultButton(jButton2);
            jButton.addActionListener(new SearchExpressionsAction(this.patternTextField, this, this.regularExpressionChk));
        }

        protected void initListeners() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.patternTextField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer timer = new Timer("Document Editor search timer", true);
                private TimerTask timerTask;

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }

                private void update() {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                    }
                    SearchDialog.this.refresh();
                    Date date = new Date(System.currentTimeMillis() + 250L);
                    this.timerTask = new TimerTask(){

                        public void run() {
                            SearchDialog.this.findNextAction.actionPerformed(null);
                        }
                    };
                    this.timer.schedule(this.timerTask, date);
                }
            });
            this.wholeWordsChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.ignoreCaseChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.regularExpressionChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.highlightsChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                }
            });
            ((JComponent)this.getContentPane()).getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
            ((JComponent)this.getContentPane()).getActionMap().put("cancelAction", this.cancelAction);
        }

        protected boolean isValidRegularExpression() {
            String string = this.patternTextField.getText();
            boolean bl = true;
            try {
                String string2 = this.wholeWordsChk.isSelected() ? "\\b" : "";
                string2 = string2 + (this.regularExpressionChk.isSelected() ? "" : "\\Q");
                String string3 = this.regularExpressionChk.isSelected() ? "" : "\\E";
                string3 = string3 + (this.wholeWordsChk.isSelected() ? "\\b" : "");
                string = string2 + string + string3;
                this.pattern = this.ignoreCaseChk.isSelected() ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setTitle(patternSyntaxException.getMessage().replaceFirst("(?s) near index .+$", "."));
                int n = patternSyntaxException.getMessage().indexOf(" near index ");
                if (n != -1) {
                    this.patternTextField.setCaretPosition(Integer.valueOf(patternSyntaxException.getMessage().substring(n += " near index ".length(), n + 1)));
                }
                this.patternTextField.requestFocusInWindow();
                bl = false;
            }
            return bl;
        }

        protected void refresh() {
            String string = this.patternTextField.getText();
            if (string != null && string.length() > 0) {
                this.findFirstAction.setEnabled(true);
                this.findNextAction.setEnabled(true);
            } else {
                this.findFirstAction.setEnabled(false);
                this.findNextAction.setEnabled(false);
            }
        }
    }

    protected class SearchAction
    extends AbstractAction {
        public SearchAction() {
            this.putValue("ShortDescription", "<html>Search within the document.&nbsp;&nbsp;<font color=#667799><small>Ctrl-F&nbsp;&nbsp;</small></font></html>");
            this.putValue("SmallIcon", MainFrame.getIcon("search"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container;
            if (DocumentEditor.this.searchDialog == null) {
                container = SwingUtilities.getWindowAncestor(DocumentEditor.this);
                DocumentEditor.this.searchDialog = container instanceof Dialog ? new SearchDialog((Dialog)container) : new SearchDialog((Frame)container);
                DocumentEditor.this.searchDialog.pack();
                DocumentEditor.this.searchDialog.setLocationRelativeTo(DocumentEditor.this);
                DocumentEditor.this.searchDialog.setResizable(true);
                MainFrame.getGuiRoots().add(DocumentEditor.this.searchDialog);
            }
            container = DocumentEditor.this.getTextComponent();
            ((JComponent)container).requestFocusInWindow();
            if (((JTextComponent)container).getSelectedText() != null) {
                ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.setText(((JTextComponent)container).getSelectedText());
            }
            if (DocumentEditor.this.searchDialog.isVisible()) {
                DocumentEditor.this.searchDialog.toFront();
            } else {
                DocumentEditor.this.searchDialog.setVisible(true);
            }
            ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.selectAll();
            ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.requestFocusInWindow();
        }
    }

    static class Settings {
        int rightViewIdx = 0;
        int bottomViewIdx = 0;
        List<String[]> annotationSetsTypes = new ArrayList<String[]>();

        Settings() {
        }

        public void saveSettings(DocumentEditor documentEditor) {
            this.rightViewIdx = documentEditor.rightViewIdx;
            this.bottomViewIdx = documentEditor.bottomViewIdx;
            this.annotationSetsTypes.clear();
            DocumentView documentView = documentEditor.getRightView();
            if (documentView instanceof AnnotationSetsView) {
                AnnotationSetsView annotationSetsView = (AnnotationSetsView)documentView;
                for (AnnotationSetsView.SetHandler setHandler : annotationSetsView.setHandlers) {
                    for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                        if (!typeHandler.isSelected()) continue;
                        this.annotationSetsTypes.add(new String[]{setHandler.set.getName(), typeHandler.name});
                    }
                }
            }
        }

        public void restoreSettings(DocumentEditor documentEditor) {
            DocumentView documentView;
            if (documentEditor.rightViewIdx != this.rightViewIdx) {
                documentEditor.setRightView(this.rightViewIdx);
            }
            if (documentEditor.bottomViewIdx != this.bottomViewIdx) {
                documentEditor.setBottomView(this.bottomViewIdx);
            }
            if ((documentView = documentEditor.getRightView()) instanceof AnnotationSetsView) {
                AnnotationSetsView annotationSetsView = (AnnotationSetsView)documentView;
                for (AnnotationSetsView.SetHandler setHandler : annotationSetsView.setHandlers) {
                    for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                        typeHandler.setSelected(false);
                        for (String[] stringArray : this.annotationSetsTypes) {
                            String string = stringArray[0];
                            String string2 = stringArray[1];
                            if (annotationSetsView.getSetHandler(string) == null || annotationSetsView.getSetHandler(string).getTypeHandler(string2) == null) continue;
                            annotationSetsView.setTypeSelected(string, string2, true);
                        }
                    }
                }
            }
        }
    }
}

