/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.annedit.SchemaFeaturesEditor;
import gate.gui.annedit.SearchAndAnnotatePanel;
import gate.swing.JChoice;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SchemaAnnotationEditor
extends AbstractVisualResource
implements OwnedAnnotationEditor {
    private static final long serialVersionUID = 1L;
    protected static final int HIDE_DELAY = 1500;
    protected static final int SHIFT_INCREMENT = 5;
    protected static final int CTRL_SHIFT_INCREMENT = 10;
    protected Annotation annotation;
    protected AnnotationSet annSet;
    private AnnotationEditorOwner owner;
    private JTextComponent textComponent;
    protected JChoice typesChoice;
    protected Border typeDefaultBorder;
    protected Border typeHighlightBorder;
    protected JDialog dialog;
    protected CreoleListener creoleListener;
    protected AncestorListener textAncestorListener;
    protected Map<String, AnnotationSchema> schemasByType;
    protected Map<String, SchemaFeaturesEditor> featureEditorsByType;
    protected Box featuresBox;
    protected JToggleButton pinnedButton;
    protected SchemaFeaturesEditor featuresEditor = null;
    protected MouseEvent pressed;
    private Point dialogLocation = new Point(0, 0);
    protected IconOnlyButton solButton;
    protected IconOnlyButton sorButton;
    protected SmallButton delButton;
    protected IconOnlyButton eolButton;
    protected IconOnlyButton eorButton;
    protected JPanel mainPane;
    ActionMap actionMap;
    private StartOffsetLeftAction solAction;
    private StartOffsetRightAction sorAction;
    private DeleteAnnotationAction delAction;
    private EndOffsetLeftAction eolAction;
    private EndOffsetRightAction eorAction;

    public void editAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        SchemaFeaturesEditor schemaFeaturesEditor;
        String string;
        this.updateListeners();
        this.annotation = annotation;
        this.annSet = annotationSet;
        String string2 = string = this.annotation == null ? null : this.annotation.getType();
        if (string == null) {
            if (this.typesChoice.getBorder() != this.typeDefaultBorder) {
                this.typesChoice.setBorder(this.typeDefaultBorder);
            }
        } else if (this.schemasByType.containsKey(string)) {
            if (this.typesChoice.getBorder() != this.typeDefaultBorder) {
                this.typesChoice.setBorder(this.typeDefaultBorder);
            }
        } else if (this.typesChoice.getBorder() != this.typeHighlightBorder) {
            this.typesChoice.setBorder(this.typeHighlightBorder);
        }
        if ((schemaFeaturesEditor = this.featureEditorsByType.get(string)) != this.featuresEditor) {
            this.typesChoice.setSelectedItem(string);
            if (this.featuresEditor != null) {
                this.featuresBox.remove(this.featuresEditor);
                this.featuresEditor.editFeatureMap(null);
            }
            this.featuresEditor = schemaFeaturesEditor;
            if (this.featuresEditor != null) {
                this.featuresBox.add(this.featuresEditor);
            }
        }
        if (this.featuresEditor != null) {
            FeatureMap featureMap = annotation.getFeatures();
            if (featureMap == null) {
                featureMap = Factory.newFeatureMap();
                annotation.setFeatures(featureMap);
            }
            this.featuresEditor.editFeatureMap(featureMap);
        }
        this.setEditingEnabled(true);
        if (this.dialog != null) {
            if (this.annotation != null) {
                this.placeDialog(this.annotation.getStartNode().getOffset().intValue(), this.annotation.getEndNode().getOffset().intValue());
            } else {
                this.placeDialog(0, 0);
            }
        }
    }

    public boolean editingFinished() {
        Object v;
        if (this.annotation == null) {
            return true;
        }
        if (!this.dialog.isVisible()) {
            return true;
        }
        if (!this.schemasByType.containsKey(this.annotation.getType())) {
            return false;
        }
        if (this.annotation == null) {
            return true;
        }
        AnnotationSchema annotationSchema = this.schemasByType.get(this.annotation.getType());
        if (annotationSchema.getFeatureSchemaSet() == null || annotationSchema.getFeatureSchemaSet().isEmpty()) {
            return true;
        }
        FeatureMap featureMap = this.annotation.getFeatures();
        HashMap<String, FeatureSchema> hashMap = new HashMap<String, FeatureSchema>();
        for (FeatureSchema featureSchema : annotationSchema.getFeatureSchemaSet()) {
            hashMap.put(featureSchema.getFeatureName(), featureSchema);
            v = featureMap == null ? null : featureMap.get(featureSchema.getFeatureName());
            Object v0 = v;
            if (!featureSchema.isRequired() || v != null) continue;
            return false;
        }
        for (FeatureSchema featureSchema : featureMap.keySet()) {
            v = featureMap.get(featureSchema);
            FeatureSchema featureSchema2 = (FeatureSchema)hashMap.get(featureSchema);
            if (featureSchema2 == null || !(featureSchema2.getFeatureValueClass().equals(Boolean.class) || featureSchema2.getFeatureValueClass().equals(Integer.class) || featureSchema2.getFeatureValueClass().equals(Short.class) || featureSchema2.getFeatureValueClass().equals(Byte.class) || featureSchema2.getFeatureValueClass().equals(Float.class) || featureSchema2.getFeatureValueClass().equals(Double.class) ? !featureSchema2.getFeatureValueClass().isAssignableFrom(v.getClass()) : featureSchema2.getFeatureValueClass().equals(String.class) && featureSchema2.getPermittedValues() != null && !featureSchema2.getPermittedValues().contains(v))) continue;
            return false;
        }
        return true;
    }

    public void cancelAction() throws GateException {
    }

    public boolean canDisplayAnnotationType(String string) {
        return true;
    }

    public void okAction() throws GateException {
    }

    public boolean supportsCancel() {
        return false;
    }

    public boolean isActive() {
        return this.dialog.isVisible();
    }

    public void placeDialog(int n, int n2) {
        if (this.pinnedButton.isSelected()) {
            Point point = null;
            if (this.dialog.isVisible()) {
                point = this.dialog.getLocation();
            }
            this.dialog.pack();
            if (point != null) {
                this.dialogLocation.move(point.x, point.y);
                this.dialog.setLocation(this.dialogLocation);
            }
        } else {
            try {
                Rectangle rectangle = this.owner.getTextComponent().modelToView(n);
                Rectangle rectangle2 = this.owner.getTextComponent().modelToView(n2);
                Point point = this.owner.getTextComponent().getLocationOnScreen();
                int n3 = point.x + rectangle.x;
                int n4 = point.y + rectangle2.y + rectangle2.height;
                Rectangle rectangle3 = this.owner.getTextComponent().getVisibleRect();
                int n5 = point.y + rectangle3.y + rectangle3.height;
                this.dialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                boolean bl = false;
                if (this.dialog.getSize().width > dimension.width) {
                    this.dialog.setSize(dimension.width, this.dialog.getSize().height);
                    bl = true;
                }
                if (this.dialog.getSize().height > dimension.height) {
                    this.dialog.setSize(this.dialog.getSize().width, dimension.height);
                    bl = true;
                }
                if (bl) {
                    this.dialog.validate();
                }
                int n6 = dimension.width - this.dialog.getSize().width;
                if (n5 + this.dialog.getSize().height > dimension.height) {
                    n5 = dimension.height - this.dialog.getSize().height;
                }
                if (n4 > n5) {
                    n4 = n5;
                }
                if (n3 > n6) {
                    n3 = n6;
                }
                this.dialogLocation.move(n3, n4);
                this.dialog.setLocation(this.dialogLocation);
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException);
            }
        }
        if (!this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        }
    }

    public SchemaAnnotationEditor() {
        this.initData();
    }

    public Resource init() throws ResourceInstantiationException {
        super.init();
        this.initGui();
        this.initListeners();
        return this;
    }

    protected void updateListeners() {
        if (this.owner != null) {
            if (this.textComponent != this.getOwner().getTextComponent()) {
                if (this.textComponent != null) {
                    this.textComponent.removeAncestorListener(this.textAncestorListener);
                }
                this.textComponent = this.owner.getTextComponent();
                if (this.textComponent != null) {
                    this.textComponent.addAncestorListener(this.textAncestorListener);
                }
            }
        } else if (this.textComponent != null) {
            this.textComponent.removeAncestorListener(this.textAncestorListener);
        }
    }

    protected void initData() {
        this.schemasByType = new TreeMap<String, AnnotationSchema>();
        for (LanguageResource languageResource : Gate.getCreoleRegister().getLrInstances("gate.creole.AnnotationSchema")) {
            this.schemasByType.put(((AnnotationSchema)languageResource).getAnnotationName(), (AnnotationSchema)languageResource);
        }
        this.creoleListener = new CreoleListener(){

            public void resourceLoaded(CreoleEvent creoleEvent) {
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema) {
                    AnnotationSchema annotationSchema = (AnnotationSchema)resource;
                    SchemaAnnotationEditor.this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
                }
            }

            public void resourceUnloaded(CreoleEvent creoleEvent) {
                AnnotationSchema annotationSchema;
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema && SchemaAnnotationEditor.this.schemasByType.containsValue(annotationSchema = (AnnotationSchema)resource)) {
                    SchemaAnnotationEditor.this.schemasByType.remove(annotationSchema.getAnnotationName());
                }
            }

            public void datastoreOpened(CreoleEvent creoleEvent) {
            }

            public void datastoreCreated(CreoleEvent creoleEvent) {
            }

            public void datastoreClosed(CreoleEvent creoleEvent) {
            }

            public void resourceRenamed(Resource resource, String string, String string2) {
            }
        };
        Gate.getCreoleRegister().addCreoleListener(this.creoleListener);
        this.textAncestorListener = new AncestorListener(){
            private boolean dialogActive = false;

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (this.dialogActive) {
                    SchemaAnnotationEditor.this.placeDialog(SchemaAnnotationEditor.this.annotation.getStartNode().getOffset().intValue(), SchemaAnnotationEditor.this.annotation.getEndNode().getOffset().intValue());
                    this.dialogActive = false;
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (SchemaAnnotationEditor.this.dialog.isVisible() && SchemaAnnotationEditor.this.annotation != null) {
                    SchemaAnnotationEditor.this.placeDialog(SchemaAnnotationEditor.this.annotation.getStartNode().getOffset().intValue(), SchemaAnnotationEditor.this.annotation.getEndNode().getOffset().intValue());
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (SchemaAnnotationEditor.this.dialog.isVisible()) {
                    this.dialogActive = true;
                    SchemaAnnotationEditor.this.dialog.setVisible(false);
                }
            }
        };
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this.creoleListener);
    }

    protected void initGui() {
        Serializable serializable;
        Object object;
        Window window = SwingUtilities.windowForComponent(this.owner.getTextComponent());
        if (window != null) {
            this.dialog = window instanceof Frame ? new JDialog((Frame)window, "Annotation Editor Dialog", false) : new JDialog((Dialog)window, "Annotation Editor Dialog", false);
            this.dialog.setDefaultCloseOperation(0);
            MainFrame.getGuiRoots().add(this.dialog);
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.solButton = new IconOnlyButton(null);
        this.solButton.setIcon(MainFrame.getIcon("bounds-sol"));
        this.solButton.setPressedIcon(MainFrame.getIcon("bounds-sol-pressed"));
        jPanel.add((Component)this.solButton, gridBagConstraints);
        JLabel jLabel = new JLabel(MainFrame.getIcon("bounds-left"));
        jLabel.setBorder(null);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.sorButton = new IconOnlyButton(null);
        this.sorButton.setIcon(MainFrame.getIcon("bounds-sor"));
        this.sorButton.setPressedIcon(MainFrame.getIcon("bounds-sor-pressed"));
        jPanel.add((Component)this.sorButton, gridBagConstraints);
        jLabel = new JLabel(MainFrame.getIcon("bounds-span"));
        jLabel.setBorder(null);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.eolButton = new IconOnlyButton(null);
        this.eolButton.setIcon(MainFrame.getIcon("bounds-eol"));
        this.eolButton.setPressedIcon(MainFrame.getIcon("bounds-eol-pressed"));
        jPanel.add((Component)this.eolButton, gridBagConstraints);
        jLabel = new JLabel(MainFrame.getIcon("bounds-right"));
        jLabel.setBorder(null);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.eorButton = new IconOnlyButton(null);
        this.eorButton.setIcon(MainFrame.getIcon("bounds-eor"));
        this.eorButton.setPressedIcon(MainFrame.getIcon("bounds-eor-pressed"));
        jPanel.add((Component)this.eorButton, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut(15), gridBagConstraints);
        this.delButton = new SmallButton(null);
        jPanel.add((Component)this.delButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.pinnedButton = new JToggleButton(MainFrame.getIcon("pin"));
        this.pinnedButton.setSelectedIcon(MainFrame.getIcon("pin-in"));
        this.pinnedButton.setSelected(false);
        this.pinnedButton.setToolTipText("Press to pin window in place.");
        this.pinnedButton.setMargin(new Insets(0, 2, 0, 2));
        this.pinnedButton.setBorderPainted(false);
        this.pinnedButton.setContentAreaFilled(false);
        jPanel.add(this.pinnedButton);
        this.add((Component)jPanel, "North");
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BorderLayout());
        this.featureEditorsByType = new HashMap<String, SchemaFeaturesEditor>();
        for (String objectArray2 : this.schemasByType.keySet()) {
            object = this.schemasByType.get(objectArray2);
            serializable = new SchemaFeaturesEditor((AnnotationSchema)object);
            this.featureEditorsByType.put(objectArray2, (SchemaFeaturesEditor)serializable);
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.schemasByType.keySet());
        Collections.sort(arrayList);
        Object[] objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        this.typesChoice = new JChoice(objectArray);
        this.typesChoice.setDefaultButtonMargin(new Insets(0, 2, 0, 2));
        this.typesChoice.setMaximumFastChoices(20);
        this.typesChoice.setMaximumWidth(300);
        object = "Type ";
        serializable = BorderFactory.createTitledBorder((String)object);
        this.typeDefaultBorder = BorderFactory.createCompoundBorder((Border)((Object)serializable), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.typeHighlightBorder = BorderFactory.createCompoundBorder((Border)((Object)serializable), BorderFactory.createLineBorder(Color.RED, 2));
        this.typesChoice.setBorder(this.typeDefaultBorder);
        jLabel = new JLabel((String)object);
        this.typesChoice.setMinimumSize(new Dimension(jLabel.getPreferredSize().width, 0));
        this.mainPane.add((Component)this.typesChoice, "North");
        this.featuresBox = Box.createVerticalBox();
        object = "Features ";
        this.featuresBox.setBorder(BorderFactory.createTitledBorder((String)object));
        jLabel = new JLabel((String)object);
        this.mainPane.add((Component)this.featuresBox, "South");
        this.add((Component)this.mainPane, "Center");
        SearchAndAnnotatePanel searchAndAnnotatePanel = new SearchAndAnnotatePanel(this.mainPane.getBackground(), this, this.dialog);
        this.add((Component)searchAndAnnotatePanel, "South");
        this.dialog.add(this);
        this.dialog.pack();
    }

    protected void initListeners() {
        this.typesChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SchemaAnnotationEditor.this.typesChoice.getSelectedItem() == null ? "" : SchemaAnnotationEditor.this.typesChoice.getSelectedItem().toString();
                if (SchemaAnnotationEditor.this.annotation != null && SchemaAnnotationEditor.this.annSet != null && !SchemaAnnotationEditor.this.annotation.getType().equals(string)) {
                    Integer n = SchemaAnnotationEditor.this.annotation.getId();
                    Annotation annotation = SchemaAnnotationEditor.this.annotation;
                    SchemaAnnotationEditor.this.annSet.remove(annotation);
                    try {
                        SchemaAnnotationEditor.this.annSet.add(n, annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), string, annotation.getFeatures());
                        Annotation annotation2 = SchemaAnnotationEditor.this.annSet.get(n);
                        SchemaAnnotationEditor.this.getOwner().selectAnnotation(new AnnotationDataImpl(SchemaAnnotationEditor.this.annSet, annotation2));
                        SchemaAnnotationEditor.this.editAnnotation(annotation2, SchemaAnnotationEditor.this.annSet);
                        SchemaAnnotationEditor.this.owner.annotationChanged(annotation2, SchemaAnnotationEditor.this.annSet, annotation.getType());
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new LuckyException(invalidOffsetException);
                    }
                }
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (SchemaAnnotationEditor.this.editingFinished()) {
                    SchemaAnnotationEditor.this.dialog.setVisible(false);
                    if (SchemaAnnotationEditor.this.pinnedButton.isSelected()) {
                        SchemaAnnotationEditor.this.pinnedButton.setSelected(false);
                    }
                } else {
                    SchemaAnnotationEditor.this.getToolkit().beep();
                }
            }
        });
        this.dialog.getRootPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SchemaAnnotationEditor.this.pressed = mouseEvent;
            }
        });
        this.dialog.getRootPane().addMouseMotionListener(new MouseMotionAdapter(){
            Point location;

            public void mouseDragged(MouseEvent mouseEvent) {
                this.location = SchemaAnnotationEditor.this.dialog.getLocation(this.location);
                int n = this.location.x - SchemaAnnotationEditor.this.pressed.getX() + mouseEvent.getX();
                int n2 = this.location.y - SchemaAnnotationEditor.this.pressed.getY() + mouseEvent.getY();
                SchemaAnnotationEditor.this.dialog.setLocation(n, n2);
                SchemaAnnotationEditor.this.pinnedButton.setSelected(true);
            }
        });
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Point point = SchemaAnnotationEditor.this.dialog.getLocation();
                if (!point.equals(SchemaAnnotationEditor.this.dialogLocation)) {
                    SchemaAnnotationEditor.this.pinnedButton.setSelected(true);
                }
            }
        });
        InputMap inputMap = ((JComponent)this.dialog.getContentPane()).getInputMap(1);
        this.actionMap = ((JComponent)this.dialog.getContentPane()).getActionMap();
        this.solAction = new StartOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.solButton.setAction(this.solAction);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "solAction");
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "solAction");
        inputMap.put(KeyStroke.getKeyStroke("control shift released LEFT"), "solAction");
        this.actionMap.put("solAction", this.solAction);
        this.sorAction = new StartOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.sorButton.setAction(this.sorAction);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "sorAction");
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "sorAction");
        inputMap.put(KeyStroke.getKeyStroke("control shift released RIGHT"), "sorAction");
        this.actionMap.put("sorAction", this.sorAction);
        this.delAction = new DeleteAnnotationAction("", MainFrame.getIcon("remove-annotation"), "Delete the annotation", 127);
        this.delButton.setAction(this.delAction);
        inputMap.put(KeyStroke.getKeyStroke("alt DELETE"), "delAction");
        this.actionMap.put("delAction", this.delAction);
        this.eolAction = new EndOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.eolButton.setAction(this.eolAction);
        inputMap.put(KeyStroke.getKeyStroke("alt LEFT"), "eolAction");
        inputMap.put(KeyStroke.getKeyStroke("alt shift LEFT"), "eolAction");
        inputMap.put(KeyStroke.getKeyStroke("control alt shift released LEFT"), "eolAction");
        this.actionMap.put("eolAction", this.eolAction);
        this.eorAction = new EndOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.eorButton.setAction(this.eorAction);
        inputMap.put(KeyStroke.getKeyStroke("alt RIGHT"), "eorAction");
        inputMap.put(KeyStroke.getKeyStroke("alt shift RIGHT"), "eorAction");
        inputMap.put(KeyStroke.getKeyStroke("control alt shift released RIGHT"), "eorAction");
        this.actionMap.put("eorAction", this.eorAction);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaAnnotationEditor.this.dialog.setVisible(false);
            }
        };
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "dismissAction");
        this.actionMap.put("dismissAction", abstractAction);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            JFrame jFrame = new JFrame("New Annotation Editor");
            jFrame.setSize(800, 600);
            jFrame.setDefaultCloseOperation(2);
            JDialog jDialog = new JDialog(jFrame, "Annotation Editor Dialog", false);
            jDialog.setFocusableWindowState(false);
            SchemaAnnotationEditor schemaAnnotationEditor = new SchemaAnnotationEditor();
            jDialog.add(schemaAnnotationEditor);
            jDialog.pack();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 100; ++i) {
                stringBuffer.append("The quick brown fox jumped over the lazy dog.\n");
            }
            JTextArea jTextArea = new JTextArea(stringBuffer.toString());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jFrame.setVisible(true);
            System.out.println("Window up");
            jDialog.setVisible(true);
            System.out.println("Dialog up");
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        catch (GateException gateException) {
            gateException.printStackTrace();
        }
    }

    protected void moveAnnotation(AnnotationSet annotationSet, Annotation annotation, Long l, Long l2) throws InvalidOffsetException {
        Integer n;
        Annotation annotation2 = null;
        if (annotationSet.get(annotation.getType()).size() == 1) {
            n = annotationSet.add(annotation.getStartNode(), annotation.getStartNode(), annotation.getType(), annotation.getFeatures());
            annotation2 = annotationSet.get(n);
        }
        n = annotation.getId();
        annotationSet.remove(annotation);
        annotationSet.add(n, l, l2, annotation.getType(), annotation.getFeatures());
        Annotation annotation3 = annotationSet.get(n);
        this.getOwner().selectAnnotation(new AnnotationDataImpl(annotationSet, annotation3));
        this.editAnnotation(annotation3, annotationSet);
        if (annotation2 != null) {
            annotationSet.remove(annotation2);
        }
        this.owner.annotationChanged(annotation3, annotationSet, null);
    }

    public AnnotationEditorOwner getOwner() {
        return this.owner;
    }

    public void setOwner(AnnotationEditorOwner annotationEditorOwner) {
        if (this.owner != annotationEditorOwner) {
            this.owner = annotationEditorOwner;
            this.updateListeners();
        }
    }

    public AnnotationSet getAnnotationSetCurrentlyEdited() {
        return this.annSet;
    }

    public Annotation getAnnotationCurrentlyEdited() {
        return this.annotation;
    }

    public void setPinnedMode(boolean bl) {
        this.pinnedButton.setSelected(bl);
    }

    public void setEditingEnabled(boolean bl) {
        this.solButton.setEnabled(bl);
        this.sorButton.setEnabled(bl);
        this.delButton.setEnabled(bl);
        this.eolButton.setEnabled(bl);
        this.eorButton.setEnabled(bl);
        for (Component component : this.typesChoice.getComponents()) {
            component.setEnabled(bl);
        }
        Vector vector = new Vector();
        Collections.addAll(vector, this.featuresBox.getComponents());
        while (!vector.isEmpty()) {
            Component component = (Component)vector.remove(0);
            if (component instanceof JToggleButton || component instanceof JTextField) {
                component.setEnabled(bl);
                continue;
            }
            if (!(component instanceof Container)) continue;
            Collections.addAll(vector, ((Container)component).getComponents());
        }
        if (bl) {
            this.actionMap.put("solAction", this.solAction);
            this.actionMap.put("sorAction", this.sorAction);
            this.actionMap.put("delAction", this.delAction);
            this.actionMap.put("eolAction", this.eolAction);
            this.actionMap.put("eorAction", this.eorAction);
        } else {
            this.actionMap.put("solAction", null);
            this.actionMap.put("sorAction", null);
            this.actionMap.put("delAction", null);
            this.actionMap.put("eolAction", null);
            this.actionMap.put("eorAction", null);
        }
    }

    protected class IconOnlyButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public IconOnlyButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }
    }

    protected class SmallButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public SmallButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 2, 0, 2));
        }
    }

    protected class DeleteAnnotationAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public DeleteAnnotationAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SchemaAnnotationEditor.this.annSet.remove(SchemaAnnotationEditor.this.annotation);
            SchemaAnnotationEditor.this.editAnnotation(null, SchemaAnnotationEditor.this.annSet);
            if (!SchemaAnnotationEditor.this.pinnedButton.isSelected()) {
                SchemaAnnotationEditor.this.dialog.setVisible(false);
            } else {
                SchemaAnnotationEditor.this.setEditingEnabled(false);
            }
        }
    }

    protected class EndOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetRightAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = SchemaAnnotationEditor.this.owner.getDocument().getContent().size() - 1L;
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = SchemaAnnotationEditor.this.annotation.getEndNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                SchemaAnnotationEditor.this.moveAnnotation(SchemaAnnotationEditor.this.annSet, SchemaAnnotationEditor.this.annotation, SchemaAnnotationEditor.this.annotation.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class EndOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetLeftAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = SchemaAnnotationEditor.this.annotation.getStartNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = SchemaAnnotationEditor.this.annotation.getEndNode().getOffset() - (long)n) < l2) {
                l = l2;
            }
            try {
                SchemaAnnotationEditor.this.moveAnnotation(SchemaAnnotationEditor.this.annSet, SchemaAnnotationEditor.this.annotation, SchemaAnnotationEditor.this.annotation.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetRightAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = SchemaAnnotationEditor.this.annotation.getEndNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = SchemaAnnotationEditor.this.annotation.getStartNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                SchemaAnnotationEditor.this.moveAnnotation(SchemaAnnotationEditor.this.annSet, SchemaAnnotationEditor.this.annotation, new Long(l), SchemaAnnotationEditor.this.annotation.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetLeftAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = SchemaAnnotationEditor.this.annotation.getStartNode().getOffset() - (long)n) < 0L) {
                l = 0L;
            }
            try {
                SchemaAnnotationEditor.this.moveAnnotation(SchemaAnnotationEditor.this.annSet, SchemaAnnotationEditor.this.annotation, new Long(l), SchemaAnnotationEditor.this.annotation.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected abstract class AnnotationAction
    extends AbstractAction {
        public AnnotationAction(String string, Icon icon, String string2, int n) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }
    }
}

