/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationVisualResource;
import gate.gui.FeaturesEditor;
import gate.gui.ResizableVisualResource;
import gate.util.AbstractFeatureBearer;
import gate.util.FeatureBearer;
import gate.util.GateException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class UnrestrictedAnnotationEditor
extends AbstractVisualResource
implements AnnotationVisualResource,
ResizableVisualResource {
    AnnotationSet currentAnnotSet = null;
    Annotation currentAnnot = null;
    Long currentStartOffset = null;
    Long currentEndOffset = null;
    private MyCustomFeatureBearer data = null;
    JLabel annotTypeLabel = null;
    JTextField annotTypeTextField = null;
    JLabel featuresLabel = null;
    FeaturesEditor featuresEditor = null;

    public void editAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        if (annotation == null) {
            return;
        }
        this.currentAnnot = annotation;
        this.currentAnnotSet = annotationSet;
        this.currentStartOffset = this.currentAnnot.getStartNode().getOffset();
        this.currentEndOffset = this.currentAnnot.getEndNode().getOffset();
        this.initLocalData();
        this.initGuiComponents();
    }

    public void okAction() throws GateException {
        if (this.annotTypeTextField.getText().equals("")) {
            throw new GateException("An annotation type must be specified !");
        }
        this.data.setAnnotType(this.annotTypeTextField.getText());
        if (this.currentAnnot == null) {
            this.currentAnnotSet.add(this.currentStartOffset, this.currentEndOffset, this.getAnnotType(), this.getCurrentAnnotationFeatures());
        } else if (this.currentAnnot.getType().equals(this.getAnnotType())) {
            this.currentAnnot.setFeatures(this.getCurrentAnnotationFeatures());
        } else {
            this.currentAnnotSet.remove(this.currentAnnot);
            this.currentAnnotSet.add(this.currentStartOffset, this.currentEndOffset, this.getAnnotType(), this.getCurrentAnnotationFeatures());
        }
    }

    public void cancelAction() throws GateException {
    }

    public boolean canDisplayAnnotationType(String string) {
        return true;
    }

    public boolean editingFinished() {
        return true;
    }

    public Annotation getAnnotationCurrentlyEdited() {
        return this.currentAnnot;
    }

    public AnnotationSet getAnnotationSetCurrentlyEdited() {
        return this.currentAnnotSet;
    }

    public boolean isActive() {
        return this.isVisible();
    }

    public boolean supportsCancel() {
        return true;
    }

    protected void initLocalData() {
        this.data = new MyCustomFeatureBearer(this.currentAnnot);
    }

    protected void initGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(10));
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createHorizontalBox();
        this.annotTypeLabel = new JLabel("Annotation type");
        this.annotTypeLabel.setToolTipText("The type of the annotation you are creating or editing");
        this.annotTypeLabel.setOpaque(true);
        box3.add(this.annotTypeLabel);
        box3.add(Box.createHorizontalGlue());
        box2.add(box3);
        this.annotTypeTextField = new JTextField(this.data.getAnnotType());
        this.annotTypeTextField.setColumns(80);
        this.annotTypeTextField.setPreferredSize(this.annotTypeTextField.getPreferredSize());
        this.annotTypeTextField.setMinimumSize(this.annotTypeTextField.getPreferredSize());
        this.annotTypeTextField.setMaximumSize(this.annotTypeTextField.getPreferredSize());
        box3 = Box.createHorizontalBox();
        box3.add(this.annotTypeTextField);
        box3.add(Box.createHorizontalGlue());
        box2.add(box3);
        box2.add(Box.createVerticalStrut(10));
        box.add(box2);
        box2 = Box.createVerticalBox();
        this.featuresLabel = new JLabel("Features");
        this.featuresLabel.setToolTipText("The features of the annotation you are creating or editing");
        this.featuresLabel.setOpaque(true);
        box3 = Box.createHorizontalBox();
        box3.add(this.featuresLabel);
        box3.add(Box.createHorizontalGlue());
        box2.add(box3);
        box2.add(Box.createVerticalStrut(5));
        this.featuresEditor = new FeaturesEditor();
        this.featuresEditor.setFeatureBearer(this.data);
        box2.add(this.featuresEditor);
        box2.add(Box.createVerticalStrut(10));
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        this.add(box);
        this.add(Box.createVerticalStrut(10));
    }

    protected void initListeners() {
    }

    public String getAnnotType() {
        return this.data.getAnnotType();
    }

    protected FeatureMap getCurrentAnnotationFeatures() {
        return this.data.getFeatures();
    }

    class MyCustomFeatureBearer
    extends AbstractFeatureBearer
    implements FeatureBearer {
        private FeatureMap features = null;
        private String annotType = null;

        public MyCustomFeatureBearer(Annotation annotation) {
            if (annotation != null) {
                this.features = Factory.newFeatureMap();
                this.features.putAll(annotation.getFeatures());
                this.annotType = new String(annotation.getType());
            } else {
                this.features = Factory.newFeatureMap();
                this.annotType = new String("");
            }
        }

        public void setFeatures(FeatureMap featureMap) {
            this.features = featureMap;
        }

        public FeatureMap getFeatures() {
            return this.features;
        }

        public void setAnnotType(String string) {
            this.annotType = string;
        }

        public String getAnnotType() {
            return this.annotType;
        }
    }
}

