/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialAnalyserController;
import gate.creole.SerialController;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.ControllerEvent;
import gate.event.ControllerListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.ResourceParametersEditor;
import gate.gui.ResourceRenderer;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.util.Benchmark;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

@CreoleResource(name="Serial Application Editor", guiType=GuiType.LARGE, resourceDisplayed="gate.creole.SerialController", mainViewer=true)
public class SerialControllerEditor
extends AbstractVisualResource
implements CreoleListener,
ControllerListener,
ActionsPublisher {
    protected SerialController controller;
    protected Handle handle;
    protected List<Action> actionList;
    protected XJTable loadedPRsTable;
    protected LoadedPRsTableModel loadedPRsTableModel;
    protected XJTable memberPRsTable;
    protected MemberPRsTableModel memberPRsTableModel;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected ResourceParametersEditor parametersEditor;
    protected JPanel parametersPanel;
    protected TitledBorder parametersBorder;
    protected JPanel strategyPanel;
    protected TitledBorder strategyBorder;
    protected JRadioButton yes_RunRBtn;
    protected JRadioButton no_RunRBtn;
    protected JRadioButton conditional_RunRBtn;
    protected ButtonGroup runBtnGrp;
    protected JTextField featureNameTextField;
    protected JTextField featureValueTextField;
    protected JComboBox corpusCombo;
    protected CorporaComboModel corpusComboModel;
    protected RunAction runAction;
    protected boolean corpusControllerMode = false;
    protected boolean analyserMode = false;
    protected boolean conditionalMode = false;
    protected ProcessingResource selectedPR = null;
    protected RunningStrategy selectedPRRunStrategy = null;
    private transient Vector<StatusListener> statusListeners;
    private transient Vector<ProgressListener> progressListeners;
    private AddPRAction addPRAction;
    private RemovePRAction removePRAction;

    public void setTarget(Object object) {
        if (!(object instanceof SerialController)) {
            throw new IllegalArgumentException("gate.gui.ApplicationViewer can only be used for serial controllers\n" + object.getClass().toString() + " is not a gate.creole.SerialController!");
        }
        if (this.controller != null) {
            this.controller.removeControllerListener(this);
        }
        this.controller = (SerialController)object;
        this.controller.addControllerListener(this);
        this.corpusControllerMode = this.controller instanceof CorpusController;
        this.analyserMode = this.controller instanceof SerialAnalyserController || this.controller instanceof ConditionalSerialAnalyserController;
        this.conditionalMode = this.controller instanceof ConditionalController;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
        if (handle instanceof StatusListener) {
            this.addStatusListener(handle);
        }
        if (handle instanceof ProgressListener) {
            this.addProgressListener(handle);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        super.init();
        return this;
    }

    protected void initLocalData() {
        this.actionList = new ArrayList<Action>();
        this.runAction = new RunAction();
        this.actionList.add(null);
        this.actionList.add(this.runAction);
        this.addPRAction = new AddPRAction();
        this.removePRAction = new RemovePRAction();
    }

    protected void initGuiComponents() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        this.loadedPRsTableModel = new LoadedPRsTableModel();
        this.loadedPRsTable = new XJTable();
        this.loadedPRsTable.setAutoResizeMode(3);
        this.loadedPRsTable.setSortable(false);
        this.loadedPRsTable.setModel(this.loadedPRsTableModel);
        this.loadedPRsTable.setDragEnabled(true);
        this.loadedPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        this.loadedPRsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                if (dimension != null) {
                    dimension.width = Integer.MAX_VALUE;
                    this.setMaximumSize(dimension);
                }
                return dimension;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        });
        final int n = new JLabel((String)"Loaded Processing resources").getPreferredSize().width + 30;
        JScrollPane jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, n);
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, n);
                return dimension;
            }
        };
        jScrollPane.getViewport().setView(this.loadedPRsTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Loaded Processing resources "));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.addButton = new JButton(this.addPRAction);
        this.addButton.setText("");
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(this.removePRAction);
        this.removeButton.setText("");
        this.removeButton.setEnabled(false);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.addButton);
        box.add(Box.createVerticalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createVerticalGlue());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)box, gridBagConstraints);
        this.memberPRsTableModel = new MemberPRsTableModel();
        this.memberPRsTable = new XJTable();
        this.memberPRsTable.setSortable(false);
        this.memberPRsTable.setModel(this.memberPRsTableModel);
        this.memberPRsTable.setAutoResizeMode(3);
        this.memberPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        this.memberPRsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                if (dimension != null) {
                    dimension.width = Integer.MAX_VALUE;
                    this.setMaximumSize(dimension);
                }
                return dimension;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        });
        this.memberPRsTable.setDefaultRenderer(Icon.class, new IconRenderer());
        this.memberPRsTable.setDragEnabled(true);
        final int n2 = new JLabel((String)"Selected Processing resources").getPreferredSize().width + 30;
        jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, n2);
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, n2);
                return dimension;
            }
        };
        jScrollPane.getViewport().setView(this.memberPRsTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Selected Processing resources "));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.moveUpButton = new JButton(MainFrame.getIcon("up"));
        this.moveUpButton.setMnemonic(38);
        this.moveUpButton.setToolTipText("Move the selected resources up.");
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(MainFrame.getIcon("down"));
        this.moveDownButton.setMnemonic(40);
        this.moveDownButton.setToolTipText("Move the selected resources down.");
        this.moveDownButton.setEnabled(false);
        box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.moveUpButton);
        box.add(Box.createVerticalStrut(5));
        box.add(this.moveDownButton);
        box.add(Box.createVerticalGlue());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)box, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        if (this.conditionalMode) {
            this.strategyPanel = new JPanel();
            this.strategyPanel.setLayout(new BoxLayout(this.strategyPanel, 0));
            this.strategyPanel.setAlignmentX(0.0f);
            this.runBtnGrp = new ButtonGroup();
            this.yes_RunRBtn = new JRadioButton("Yes", true);
            this.yes_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.yes_RunRBtn);
            this.no_RunRBtn = new JRadioButton("No", false);
            this.no_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.no_RunRBtn);
            this.conditional_RunRBtn = new JRadioButton("If value of feature", false);
            this.conditional_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.conditional_RunRBtn);
            this.featureNameTextField = new JTextField("", 25);
            this.featureNameTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureNameTextField.getPreferredSize().height));
            this.featureValueTextField = new JTextField("", 25);
            this.featureValueTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureValueTextField.getPreferredSize().height));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("greenBall")));
            this.strategyPanel.add(this.yes_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("redBall")));
            this.strategyPanel.add(this.no_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("yellowBall")));
            this.strategyPanel.add(this.conditional_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureNameTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel("is"));
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureValueTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No processing resource selected... ");
            this.strategyPanel.setBorder(this.strategyBorder);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel2.add((Component)this.strategyPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        if (this.corpusControllerMode) {
            this.corpusComboModel = new CorporaComboModel();
            this.corpusCombo = new JComboBox(this.corpusComboModel);
            this.corpusCombo.setRenderer(new ResourceRenderer());
            this.corpusCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.corpusCombo.getPreferredSize().height));
            serializable = null;
            if (!(this.controller instanceof CorpusController)) {
                throw new GateRuntimeException("Controller editor in corpus controller mode but the target controller is not an CorpusController!");
            }
            serializable = ((CorpusController)((Object)this.controller)).getCorpus();
            if (serializable != null) {
                this.corpusCombo.setSelectedItem(serializable);
            } else if (this.corpusCombo.getModel().getSize() > 1) {
                this.corpusCombo.setSelectedIndex(1);
            } else {
                this.corpusCombo.setSelectedIndex(0);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setAlignmentX(0.0f);
            jPanel3.add(new JLabel("Corpus:"));
            jPanel3.add(Box.createHorizontalStrut(5));
            jPanel3.add(this.corpusCombo);
            jPanel3.add(Box.createHorizontalStrut(5));
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
        }
        this.parametersPanel = new JPanel();
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 1));
        this.parametersPanel.setAlignmentX(0.0f);
        this.parametersBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No selected processing resource ");
        this.parametersPanel.setBorder(this.parametersBorder);
        this.parametersEditor = new ResourceParametersEditor();
        this.parametersEditor.init(null, null);
        this.parametersPanel.add(new JScrollPane(this.parametersEditor));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.parametersPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel2.add((Component)new JButton(this.runAction), gridBagConstraints);
        serializable = new JSplitPane(0, jPanel, jPanel2);
        ((JComponent)serializable).addAncestorListener(new AncestorListener((JSplitPane)serializable){
            final /* synthetic */ JSplitPane val$splitPane;
            {
                this.val$splitPane = jSplitPane;
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        val$splitPane.setDividerLocation(0.5);
                    }
                });
                this.val$splitPane.removeAncestorListener(this);
            }
        });
        this.add((Component)serializable, "Center");
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && SerialControllerEditor.this.handle != null && SerialControllerEditor.this.handle.getPopup() != null) {
                    SerialControllerEditor.this.handle.getPopup().show(SerialControllerEditor.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    Arrays.sort(nArray);
                    for (int n : nArray) {
                        if (n <= 0) continue;
                        ProcessingResource processingResource = SerialControllerEditor.this.controller.remove(n);
                        SerialControllerEditor.this.controller.add(n - 1, processingResource);
                    }
                    for (int n : nArray) {
                        int n2 = n > 0 ? n - 1 : n;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n2, n2);
                    }
                    SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
                }
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n = nArray[i];
                        if (n >= SerialControllerEditor.this.controller.getPRs().size() - 1) continue;
                        ProcessingResource processingResource = SerialControllerEditor.this.controller.remove(n);
                        SerialControllerEditor.this.controller.add(n + 1, processingResource);
                    }
                    for (int n : nArray) {
                        int n2 = n < SerialControllerEditor.this.controller.getPRs().size() - 1 ? n + 1 : n;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n2, n2);
                    }
                    SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
                }
            }
        });
        this.loadedPRsTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n = SerialControllerEditor.this.loadedPRsTable.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                ProcessingResource processingResource = (ProcessingResource)SerialControllerEditor.this.loadedPRsTable.getValueAt(n, SerialControllerEditor.this.loadedPRsTable.convertColumnIndexToView(0));
                if (mouseEvent.isPopupTrigger()) {
                    if (!SerialControllerEditor.this.loadedPRsTable.isRowSelected(n)) {
                        SerialControllerEditor.this.loadedPRsTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    XJPopupMenu xJPopupMenu = new XJPopupMenu();
                    xJPopupMenu.add(SerialControllerEditor.this.addPRAction);
                    xJPopupMenu.show(SerialControllerEditor.this.loadedPRsTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                } else if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
                    SerialControllerEditor.this.addPRAction.actionPerformed(null);
                }
            }
        });
        this.loadedPRsTable.setTransferHandler(new TransferHandler(){
            String source = "";

            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            protected Transferable createTransferable(JComponent jComponent) {
                return new StringSelection("loadedPRsTable");
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    try {
                        this.source = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        if (this.source.startsWith("memberPRsTable")) {
                            SerialControllerEditor.this.removePRAction.actionPerformed(null);
                            return true;
                        }
                        return false;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        this.memberPRsTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n = SerialControllerEditor.this.memberPRsTable.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    if (!SerialControllerEditor.this.memberPRsTable.isRowSelected(n)) {
                        SerialControllerEditor.this.memberPRsTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    XJPopupMenu xJPopupMenu = new XJPopupMenu();
                    xJPopupMenu.add(SerialControllerEditor.this.removePRAction);
                    xJPopupMenu.show(SerialControllerEditor.this.memberPRsTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                } else if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
                    SerialControllerEditor.this.removePRAction.actionPerformed(null);
                }
            }
        });
        this.memberPRsTable.setTransferHandler(new TransferHandler(){
            String source = "";

            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            protected Transferable createTransferable(JComponent jComponent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                Arrays.sort(nArray);
                return new StringSelection("memberPRsTable" + Arrays.toString(nArray));
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    this.source = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (this.source.startsWith("memberPRsTable")) {
                        int n;
                        int n2 = n = SerialControllerEditor.this.memberPRsTable.getSelectedRow();
                        ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>();
                        this.source = this.source.replaceFirst("^memberPRsTable\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        String[] stringArray = this.source.split(", ");
                        if (Integer.valueOf(stringArray[0]) < n) {
                            ++n;
                        }
                        for (String string : stringArray) {
                            if (Integer.valueOf(string) == n2) {
                                return false;
                            }
                            arrayList.add((ProcessingResource)SerialControllerEditor.this.memberPRsTable.getValueAt(Integer.valueOf(string), SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)));
                            if (Integer.valueOf(string) >= n2) continue;
                            --n;
                        }
                        for (ProcessingResource processingResource : arrayList) {
                            SerialControllerEditor.this.controller.remove(processingResource);
                        }
                        for (ProcessingResource processingResource : arrayList) {
                            SerialControllerEditor.this.controller.add(n, processingResource);
                            ++n;
                        }
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n - stringArray.length, n - 1);
                        return true;
                    }
                    if (this.source.equals("loadedPRsTable")) {
                        SerialControllerEditor.this.addPRAction.actionPerformed(null);
                        return true;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        });
        this.loadedPRsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SerialControllerEditor.this.addButton.setEnabled(SerialControllerEditor.this.loadedPRsTable.getSelectedRowCount() > 0);
            }
        });
        this.memberPRsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SerialControllerEditor.this.removeButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0);
                SerialControllerEditor.this.moveUpButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0 && !SerialControllerEditor.this.memberPRsTable.isRowSelected(0));
                SerialControllerEditor.this.moveDownButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0 && !SerialControllerEditor.this.memberPRsTable.isRowSelected(SerialControllerEditor.this.memberPRsTable.getRowCount() - 1));
                if (SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() == 1) {
                    SerialControllerEditor.this.selectPR(SerialControllerEditor.this.memberPRsTable.getSelectedRow());
                } else {
                    SerialControllerEditor.this.selectPR(-1);
                }
            }
        });
        if (this.conditionalMode) {
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null) {
                        if (SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                            AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                            if (SerialControllerEditor.this.yes_RunRBtn.isSelected()) {
                                analyserRunningStrategy.setRunMode(1);
                            } else if (SerialControllerEditor.this.no_RunRBtn.isSelected()) {
                                analyserRunningStrategy.setRunMode(2);
                            } else if (SerialControllerEditor.this.conditional_RunRBtn.isSelected()) {
                                analyserRunningStrategy.setRunMode(4);
                            }
                        } else if (SerialControllerEditor.this.selectedPRRunStrategy instanceof RunningStrategy.UnconditionalRunningStrategy) {
                            RunningStrategy.UnconditionalRunningStrategy unconditionalRunningStrategy = (RunningStrategy.UnconditionalRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                            if (SerialControllerEditor.this.yes_RunRBtn.isSelected()) {
                                unconditionalRunningStrategy.shouldRun(true);
                            } else if (SerialControllerEditor.this.no_RunRBtn.isSelected()) {
                                unconditionalRunningStrategy.shouldRun(false);
                            }
                        }
                    }
                    SerialControllerEditor.this.memberPRsTable.repaint();
                }
            };
            this.yes_RunRBtn.addItemListener(itemListener);
            this.no_RunRBtn.addItemListener(itemListener);
            this.conditional_RunRBtn.addItemListener(itemListener);
            this.featureNameTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                protected void changeOccured(DocumentEvent documentEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        analyserRunningStrategy.setFeatureName(SerialControllerEditor.this.featureNameTextField.getText());
                    }
                    SerialControllerEditor.this.conditional_RunRBtn.setSelected(true);
                }
            });
            this.featureValueTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                protected void changeOccured(DocumentEvent documentEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        analyserRunningStrategy.setFeatureValue(SerialControllerEditor.this.featureValueTextField.getText());
                    }
                    SerialControllerEditor.this.conditional_RunRBtn.setSelected(true);
                }
            });
        }
        if (this.corpusControllerMode) {
            this.corpusCombo.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    SerialControllerEditor.this.corpusComboModel.fireDataChanged();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                SerialControllerEditor.this.loadedPRsTableModel.fireTableDataChanged();
                SerialControllerEditor.this.memberPRsTableModel.fireTableDataChanged();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F3"), "Run");
        this.getActionMap().put("Run", this.runAction);
    }

    public List getActions() {
        return this.actionList;
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.controller.removeControllerListener(this);
        this.controller = null;
        this.progressListeners.clear();
        this.statusListeners.clear();
        this.parametersEditor.cleanup();
        this.handle = null;
    }

    protected void selectPR(int n) {
        Object object;
        if (this.parametersEditor.getResource() != null) {
            try {
                this.parametersEditor.setParameters();
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                JOptionPane.showMessageDialog(this, "Failed to set parameters for \"" + this.parametersEditor.getResource().getName() + "\"!\n", "GATE", 0);
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
            if (this.conditionalMode) {
                if (this.selectedPRRunStrategy != null && this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                    object = (AnalyserRunningStrategy)this.selectedPRRunStrategy;
                    ((AnalyserRunningStrategy)object).setFeatureName(this.featureNameTextField.getText());
                    ((AnalyserRunningStrategy)object).setFeatureValue(this.featureValueTextField.getText());
                }
                this.selectedPRRunStrategy = null;
            }
        }
        object = null;
        if (n >= 0 && n < this.controller.getPRs().size()) {
            object = (ProcessingResource)((List)this.controller.getPRs()).get(n);
        }
        if (object != null) {
            Object object2;
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(object.getClass().getName());
            this.parametersBorder.setTitle(" Runtime Parameters for the \"" + object.getName() + "\" " + resourceData.getName() + ": ");
            List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
            if (this.corpusControllerMode) {
                object2 = list;
                list = new ArrayList<List<Parameter>>();
                Iterator<List<Parameter>> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    List<Parameter> list2 = iterator.next();
                    ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
                    for (Parameter parameter : list2) {
                        if (parameter.getName().equals("corpus") || parameter.getName().equals("document")) continue;
                        arrayList.add(parameter);
                    }
                    if (arrayList.isEmpty()) continue;
                    list.add(arrayList);
                }
            }
            this.parametersEditor.init((Resource)object, list);
            if (this.conditionalMode) {
                this.strategyBorder.setTitle(" Run \"" + object.getName() + "\"? ");
                this.yes_RunRBtn.setEnabled(true);
                this.no_RunRBtn.setEnabled(true);
                this.conditional_RunRBtn.setEnabled(true);
                this.selectedPRRunStrategy = null;
                object2 = (RunningStrategy)((List)((ConditionalController)((Object)this.controller)).getRunningStrategies()).get(n);
                if (object2 instanceof AnalyserRunningStrategy) {
                    this.featureNameTextField.setEnabled(true);
                    this.featureValueTextField.setEnabled(true);
                    this.conditional_RunRBtn.setEnabled(true);
                    this.featureNameTextField.setText(((AnalyserRunningStrategy)object2).getFeatureName());
                    this.featureValueTextField.setText(((AnalyserRunningStrategy)object2).getFeatureValue());
                } else {
                    this.featureNameTextField.setEnabled(false);
                    this.featureValueTextField.setEnabled(false);
                    this.conditional_RunRBtn.setEnabled(false);
                }
                switch (object2.getRunMode()) {
                    case 1: {
                        this.yes_RunRBtn.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.no_RunRBtn.setSelected(true);
                        break;
                    }
                    case 4: {
                        this.conditional_RunRBtn.setSelected(true);
                    }
                }
                this.selectedPRRunStrategy = object2;
            }
        } else {
            this.parametersBorder.setTitle(" No processing resource selected... ");
            this.parametersEditor.init(null, null);
            if (this.conditionalMode) {
                this.strategyBorder.setTitle(" No processing resource selected... ");
                this.yes_RunRBtn.setEnabled(false);
                this.no_RunRBtn.setEnabled(false);
                this.conditional_RunRBtn.setEnabled(false);
                this.featureNameTextField.setText("");
                this.featureNameTextField.setEnabled(false);
                this.featureValueTextField.setText("");
                this.featureValueTextField.setEnabled(false);
            }
        }
        this.repaint(100L);
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        if (Gate.getHiddenAttribute(creoleEvent.getResource().getFeatures())) {
            return;
        }
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            this.loadedPRsTableModel.fireTableDataChanged();
            this.memberPRsTableModel.fireTableDataChanged();
        } else if (creoleEvent.getResource() instanceof LanguageResource && creoleEvent.getResource() instanceof Corpus && this.corpusControllerMode) {
            this.corpusComboModel.fireDataChanged();
        }
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (Gate.getHiddenAttribute(creoleEvent.getResource().getFeatures())) {
            return;
        }
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            ProcessingResource processingResource = (ProcessingResource)creoleEvent.getResource();
            if (this.controller.getPRs().contains(processingResource)) {
                this.controller.remove(processingResource);
            }
            this.loadedPRsTableModel.fireTableDataChanged();
            this.memberPRsTableModel.fireTableDataChanged();
        } else if (creoleEvent.getResource() instanceof LanguageResource && creoleEvent.getResource() instanceof Corpus && this.corpusControllerMode) {
            Corpus corpus = (Corpus)creoleEvent.getResource();
            if (this.controller instanceof CorpusController) {
                if (corpus == ((CorpusController)((Object)this.controller)).getCorpus()) {
                    ((CorpusController)((Object)this.controller)).setCorpus(null);
                }
            } else {
                throw new GateRuntimeException("Controller editor in analyser mode but the target controller is not an analyser!");
            }
            this.corpusComboModel.fireDataChanged();
        }
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        if (Gate.getHiddenAttribute(resource.getFeatures())) {
            return;
        }
        if (resource instanceof ProcessingResource) {
            this.repaint(100L);
        }
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public void resourceAdded(ControllerEvent controllerEvent) {
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public void resourceRemoved(ControllerEvent controllerEvent) {
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    private boolean firstIncludesOrEqualsSecond(Controller controller, Controller controller2) {
        if (controller.equals(controller2)) {
            return true;
        }
        for (Object e : controller.getPRs()) {
            if (!(e instanceof Controller) || !this.firstIncludesOrEqualsSecond((Controller)e, controller2)) continue;
            return true;
        }
        return false;
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector<StatusListener> vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).statusChanged(string);
            }
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                vector.elementAt(i).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).processFinished();
            }
        }
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        public void statusChanged(String string) {
            SerialControllerEditor.this.fireStatusChanged(string);
        }
    }

    protected class InternalProgressListener
    implements ProgressListener {
        protected InternalProgressListener() {
        }

        public void progressChanged(int n) {
            SerialControllerEditor.this.fireProgressChanged(n);
        }

        public void processFinished() {
            SerialControllerEditor.this.fireProcessFinished();
        }
    }

    class RunAction
    extends AbstractAction {
        RunAction() {
            super("Run this Application");
            super.putValue("ShortDescription", "<html>Run this application&nbsp;&nbsp;<font color=#667799><small>F3&nbsp;&nbsp;</small></font></html>");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    long l;
                    InternalProgressListener internalProgressListener;
                    Object object;
                    block18: {
                        Object object2;
                        if (SerialControllerEditor.this.memberPRsTable.getRowCount() == 0) {
                            JOptionPane.showMessageDialog(SerialControllerEditor.this, "Add at least one processing resource in the right table\nthat contains the resources of the application to be run.", "GATE", 0);
                            return;
                        }
                        try {
                            SerialControllerEditor.this.parametersEditor.setParameters();
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not set parameters for the \"" + SerialControllerEditor.this.parametersEditor.getResource().getName() + "\" processing resource:\nSee \"Messages\" tab for details!", "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                            return;
                        }
                        if (SerialControllerEditor.this.corpusControllerMode) {
                            object2 = SerialControllerEditor.this.corpusCombo.getSelectedItem();
                            Object object3 = object = object2.equals("<none>") ? null : (Corpus)object2;
                            if (SerialControllerEditor.this.analyserMode && object == null) {
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "No corpus provided!\nPlease select a corpus and try again!", "GATE", 0);
                                SerialControllerEditor.this.corpusCombo.requestFocusInWindow();
                                return;
                            }
                            if (SerialControllerEditor.this.controller instanceof CorpusController) {
                                ((CorpusController)((Object)SerialControllerEditor.this.controller)).setCorpus((Corpus)object);
                            }
                        }
                        try {
                            object2 = SerialControllerEditor.this.controller.getOffendingPocessingResources();
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not check runtime parameters for the processing resources:\n" + resourceInstantiationException.toString(), "GATE", 0);
                            return;
                        }
                        if (object2 != null && !object2.isEmpty()) {
                            object = "";
                            Iterator iterator = object2.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Some required runtime parameters are not set\nin the following resources:\n" + (String)object, "GATE", 0);
                                    return;
                                }
                                Object e = iterator.next();
                                object = (String)object + "- " + ((ProcessingResource)e).getName() + "\n";
                            }
                        }
                        object = new InternalStatusListener();
                        internalProgressListener = new InternalProgressListener();
                        SerialControllerEditor.this.controller.addStatusListener((StatusListener)object);
                        SerialControllerEditor.this.controller.addProgressListener(internalProgressListener);
                        Gate.setExecutable(SerialControllerEditor.this.controller);
                        int n = 1;
                        if (SerialControllerEditor.this.controller instanceof CorpusController) {
                            n = ((CorpusController)((Object)SerialControllerEditor.this.controller)).getCorpus().size();
                        }
                        MainFrame.lockGUI("Running " + SerialControllerEditor.this.controller.getName() + " on " + n + (n == 1 ? " document" : " documents"));
                        l = System.currentTimeMillis();
                        SerialControllerEditor.this.fireStatusChanged("Start running " + SerialControllerEditor.this.controller.getName() + " on " + n + (n == 1 ? " document" : " documents"));
                        SerialControllerEditor.this.fireProgressChanged(0);
                        try {
                            try {
                                Benchmark.executeWithBenchmarking(SerialControllerEditor.this.controller, Benchmark.createBenchmarkId(SerialControllerEditor.this.controller.getName(), null), RunAction.this, null);
                            }
                            catch (ExecutionInterruptedException executionInterruptedException) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Interrupted!\n" + executionInterruptedException.toString(), "GATE", 0);
                                Object var9_11 = null;
                                MainFrame.unlockGUI();
                                Gate.setExecutable(null);
                                break block18;
                            }
                            catch (ExecutionException executionException) {
                                executionException.printStackTrace(Err.getPrintWriter());
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Execution error while running \"" + SerialControllerEditor.this.controller.getName() + "\" :\nSee \"Messages\" tab for details!", "GATE", 0);
                                Object var9_12 = null;
                                MainFrame.unlockGUI();
                                Gate.setExecutable(null);
                                break block18;
                            }
                            catch (Exception exception) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Unhandled execution error!\n See \"Messages\" tab for details!", "GATE", 0);
                                exception.printStackTrace(Err.getPrintWriter());
                                Object var9_13 = null;
                                MainFrame.unlockGUI();
                                Gate.setExecutable(null);
                                break block18;
                            }
                            Object var9_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            MainFrame.unlockGUI();
                            Gate.setExecutable(null);
                            throw throwable;
                        }
                        MainFrame.unlockGUI();
                        Gate.setExecutable(null);
                    }
                    SerialControllerEditor.this.controller.removeStatusListener((StatusListener)object);
                    SerialControllerEditor.this.controller.removeProgressListener(internalProgressListener);
                    long l2 = System.currentTimeMillis();
                    SerialControllerEditor.this.fireProcessFinished();
                    SerialControllerEditor.this.fireStatusChanged(SerialControllerEditor.this.controller.getName() + " run in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "ApplicationViewer1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class RemovePRAction
    extends AbstractAction {
        RemovePRAction() {
            this.putValue("Name", "Remove selected resouces from the application");
            this.putValue("ShortDescription", "Remove selected resouces from the application");
            this.putValue("SmallIcon", MainFrame.getIcon("left-arrow"));
            this.putValue("MnemonicKey", 37);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>();
            for (int n : SerialControllerEditor.this.memberPRsTable.getSelectedRows()) {
                arrayList.add((ProcessingResource)SerialControllerEditor.this.memberPRsTable.getValueAt(n, SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)));
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                ProcessingResource processingResource = (ProcessingResource)object.next();
                SerialControllerEditor.this.controller.remove(processingResource);
            }
            for (ProcessingResource processingResource : arrayList) {
                for (int i = 0; i < SerialControllerEditor.this.loadedPRsTable.getRowCount(); ++i) {
                    if (SerialControllerEditor.this.loadedPRsTable.getValueAt(i, SerialControllerEditor.this.loadedPRsTable.convertColumnIndexToView(0)) != processingResource) continue;
                    SerialControllerEditor.this.loadedPRsTable.addRowSelectionInterval(i, i);
                }
            }
            SerialControllerEditor.this.loadedPRsTable.requestFocusInWindow();
            if (SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() == 0) {
                SerialControllerEditor.this.parametersEditor.init(null, null);
                SerialControllerEditor.this.parametersBorder.setTitle("No selected processing resource");
            }
        }
    }

    class AddPRAction
    extends AbstractAction {
        AddPRAction() {
            this.putValue("Name", "Add selected resources to the application");
            this.putValue("ShortDescription", "Add selected resources to the application");
            this.putValue("SmallIcon", MainFrame.getIcon("right-arrow"));
            this.putValue("MnemonicKey", 39);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>();
                int[] nArray = SerialControllerEditor.this.loadedPRsTable.getSelectedRows();
                Arrays.sort(nArray);
                for (int n2 : nArray) {
                    arrayList.add((ProcessingResource)SerialControllerEditor.this.loadedPRsTable.getValueAt(n2, SerialControllerEditor.this.loadedPRsTable.convertColumnIndexToView(0)));
                }
                nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                Arrays.sort(nArray);
                int n = nArray.length == 0 ? SerialControllerEditor.this.memberPRsTable.getRowCount() : nArray[nArray.length - 1] + 1;
                for (ProcessingResource processingResource : arrayList) {
                    SerialControllerEditor.this.controller.add(n, processingResource);
                    ++n;
                }
                for (ProcessingResource processingResource : arrayList) {
                    for (int n2 = 0; n2 < SerialControllerEditor.this.memberPRsTable.getRowCount(); ++n2) {
                        if (SerialControllerEditor.this.memberPRsTable.getValueAt(n2, SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)) != processingResource) continue;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n2, n2);
                    }
                }
                SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
            }
            catch (GateRuntimeException gateRuntimeException) {
                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not add PR to pipeline:\n" + gateRuntimeException.getMessage(), "GATE", 0);
                return;
            }
        }
    }

    class MemberPRsTableModel
    extends AbstractTableModel {
        protected Icon green = MainFrame.getIcon("greenBall");
        protected Icon red = MainFrame.getIcon("redBall");
        protected Icon yellow = MainFrame.getIcon("yellowBall");

        public int getRowCount() {
            return SerialControllerEditor.this.controller == null ? 0 : SerialControllerEditor.this.controller.getPRs().size();
        }

        public Object getValueAt(int n, int n2) {
            ProcessingResource processingResource = (ProcessingResource)((List)SerialControllerEditor.this.controller.getPRs()).get(n);
            switch (n2) {
                case 0: {
                    if (SerialControllerEditor.this.conditionalMode) {
                        RunningStrategy runningStrategy = (RunningStrategy)((List)((ConditionalController)((Object)SerialControllerEditor.this.controller)).getRunningStrategies()).get(n);
                        switch (runningStrategy.getRunMode()) {
                            case 1: {
                                return this.green;
                            }
                            case 2: {
                                return this.red;
                            }
                            case 4: {
                                return this.yellow;
                            }
                        }
                    }
                    return this.green;
                }
                case 1: {
                    return processingResource;
                }
                case 2: {
                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                    if (resourceData == null) {
                        return processingResource.getClass();
                    }
                    return resourceData.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "!";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Type";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return ProcessingResource.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
            this.setIcon((Icon)object);
            return this;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    protected class CorporaComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected CorporaComboModel() {
        }

        public int getSize() {
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? 1 : list.size() + 1;
        }

        public Object getElementAt(int n) {
            if (n == 0) {
                return "<none>";
            }
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? "" : list.get(n - 1);
        }

        public void setSelectedItem(Object object) {
            if (SerialControllerEditor.this.controller instanceof CorpusController) {
                ((CorpusController)((Object)SerialControllerEditor.this.controller)).setCorpus((Corpus)(object.equals("<none>") ? null : object));
            }
        }

        public Object getSelectedItem() {
            Corpus corpus = null;
            if (!(SerialControllerEditor.this.controller instanceof CorpusController)) {
                throw new GateRuntimeException("Controller editor in corpus controller mode but the target controller is not a CorpusController!");
            }
            corpus = ((CorpusController)((Object)SerialControllerEditor.this.controller)).getCorpus();
            return corpus == null ? "<none>" : corpus;
        }

        void fireDataChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    class LoadedPRsTableModel
    extends AbstractTableModel {
        NameComparator nameComparator = new NameComparator();

        LoadedPRsTableModel() {
        }

        public int getRowCount() {
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                arrayList.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ProcessingResource processingResource = (ProcessingResource)iterator.next();
                if (!Gate.getHiddenAttribute(processingResource.getFeatures()) && (!(processingResource instanceof Controller) || !SerialControllerEditor.this.firstIncludesOrEqualsSecond((Controller)((Object)processingResource), SerialControllerEditor.this.controller))) continue;
                iterator.remove();
            }
            return arrayList.size();
        }

        public Object getValueAt(int n, int n2) {
            ProcessingResource processingResource;
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                arrayList.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                processingResource = (ProcessingResource)iterator.next();
                if (!Gate.getHiddenAttribute(processingResource.getFeatures()) && (!(processingResource instanceof Controller) || !SerialControllerEditor.this.firstIncludesOrEqualsSecond((Controller)((Object)processingResource), SerialControllerEditor.this.controller))) continue;
                iterator.remove();
            }
            Collections.sort(arrayList, this.nameComparator);
            processingResource = (ProcessingResource)arrayList.get(n);
            switch (n2) {
                case 0: {
                    return processingResource;
                }
                case 1: {
                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                    if (resourceData == null) {
                        return processingResource.getClass();
                    }
                    return resourceData.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return ProcessingResource.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

