/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.FeatureMapListener;
import gate.event.StatusListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.gui.ResizableVisualResource;
import gate.gui.TextAttributesChooser;
import gate.print.JComponentPrinter;
import gate.swing.ColorGenerator;
import gate.swing.XJMenu;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.swing.XJTextPane;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DocumentEditor
extends AbstractVisualResource
implements ANNIEConstants {
    private transient PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    private Document document;
    protected ColorGenerator colGenerator = new ColorGenerator();
    protected JTextPane textPane;
    protected JScrollPane textScroll;
    protected XJTable annotationsTable;
    protected AnnotationsTableModel annotationsTableModel;
    protected JScrollPane tableScroll;
    protected JSplitPane leftSplit;
    protected JSplitPane rightSplit;
    protected JSplitPane mainSplit;
    protected JTree stylesTree;
    protected JToolBar toolbar;
    protected JScrollPane stylesTreeScroll;
    protected DefaultMutableTreeNode stylesTreeRoot;
    protected DefaultTreeModel stylesTreeModel;
    protected SearchDialog searchDialog;
    protected TextAttributesChooser styleChooser;
    protected JTree corefTree;
    protected DefaultMutableTreeNode corefTreeRoot;
    protected DefaultTreeModel corefTreeModel;
    protected JScrollPane corefScroll;
    protected Box progressBox;
    protected JProgressBar progressBar;
    protected Highlighter highlighter;
    protected Highlighter selectionHighlighter;
    protected SelectionBlinker selectionBlinker;
    protected Handle myHandle;
    protected List data;
    protected List ranges;
    protected Map typeDataMap;
    protected EventsHandler eventHandler;
    protected Object lock;
    private boolean editable = true;
    private JToggleButton textVisibleBtn;
    private JToggleButton typesTreeVisibleBtn;
    private JToggleButton annotationsTableVisibleBtn;
    private JToggleButton coreferenceVisibleBtn;
    private boolean annotationsTableVisible = false;
    private boolean coreferenceVisible = false;
    private boolean textVisible = true;
    private boolean typesTreeVisible = false;
    private boolean corefOptionAvailable = false;
    private final int MAX_LINE_SIZE = 2048;
    private Vector longLinesCorrectionPositions;

    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initListeners() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("annotationsTableVisible") || propertyChangeEvent.getPropertyName().equals("coreferenceVisible") || propertyChangeEvent.getPropertyName().equals("textVisible") || propertyChangeEvent.getPropertyName().equals("typesTreeVisible")) {
                    DocumentEditor.this.layoutComponents();
                } else if (propertyChangeEvent.getPropertyName().equals("corefOptionAvailable")) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        if (DocumentEditor.this.toolbar.getComponentIndex(DocumentEditor.this.coreferenceVisibleBtn) == -1) {
                            DocumentEditor.this.toolbar.add((Component)DocumentEditor.this.coreferenceVisibleBtn, 3);
                        }
                    } else {
                        DocumentEditor.this.toolbar.remove(DocumentEditor.this.coreferenceVisibleBtn);
                    }
                    DocumentEditor.this.layoutComponents();
                }
            }
        });
        this.textVisibleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentEditor.this.setTextVisible(DocumentEditor.this.textVisibleBtn.isSelected());
            }
        });
        this.annotationsTableVisibleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentEditor.this.setAnnotationsTableVisible(DocumentEditor.this.annotationsTableVisibleBtn.isSelected());
            }
        });
        this.typesTreeVisibleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentEditor.this.setTypesTreeVisible(DocumentEditor.this.typesTreeVisibleBtn.isSelected());
            }
        });
        this.coreferenceVisibleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentEditor.this.setCoreferenceVisible(DocumentEditor.this.coreferenceVisibleBtn.isSelected());
            }
        });
        this.stylesTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                int n2;
                TreePath treePath;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (treePath = DocumentEditor.this.stylesTree.getPathForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    TypeData typeData = (TypeData)defaultMutableTreeNode.getUserObject();
                    Rectangle rectangle = DocumentEditor.this.stylesTree.getPathBounds(treePath);
                    Component component = DocumentEditor.this.stylesTree.getCellRenderer().getTreeCellRendererComponent(DocumentEditor.this.stylesTree, defaultMutableTreeNode, true, false, false, 0, true);
                    component.setBounds(rectangle);
                    Component component2 = component.getComponentAt(n2 -= rectangle.x, n -= rectangle.y);
                    if (component2 instanceof JCheckBox) {
                        typeData.setVisible(!typeData.getVisible());
                        DocumentEditor.this.stylesTreeModel.nodeChanged(defaultMutableTreeNode);
                    } else if (mouseEvent.getClickCount() == 1 && component2 instanceof JLabel && DocumentEditor.this.isTextSelected()) {
                        if (!DocumentEditor.this.editable) {
                            return;
                        }
                        Long l = new Long(DocumentEditor.this.textPane.getSelectionStart());
                        Long l2 = new Long(DocumentEditor.this.textPane.getSelectionEnd());
                        TreePath treePath2 = DocumentEditor.this.stylesTree.getSelectionPath();
                        TypeData typeData2 = (TypeData)((DefaultMutableTreeNode)treePath2.getLastPathComponent()).getUserObject();
                        String string = typeData2.getSet();
                        if (typeData2.getType() == null) {
                            DocumentEditor.this.textPane.setSelectionStart(l.intValue());
                            DocumentEditor.this.textPane.setSelectionEnd(l.intValue());
                            return;
                        }
                        try {
                            if ("Default".equals(string)) {
                                DocumentEditor.this.document.getAnnotations().add(l, l2, typeData2.getType(), Factory.newFeatureMap());
                            } else {
                                DocumentEditor.this.document.getAnnotations(string).add(l, l2, typeData2.getType(), Factory.newFeatureMap());
                            }
                        }
                        catch (InvalidOffsetException invalidOffsetException) {
                            throw new GateRuntimeException(invalidOffsetException.getMessage());
                        }
                        DocumentEditor.this.textPane.setSelectionStart(l.intValue());
                        DocumentEditor.this.textPane.setSelectionEnd(l.intValue());
                    } else if (component2 instanceof JLabel && mouseEvent.getClickCount() == 2) {
                        if (DocumentEditor.this.styleChooser == null) {
                            Window window = SwingUtilities.getWindowAncestor(DocumentEditor.this);
                            DocumentEditor.this.styleChooser = window instanceof Frame ? new TextAttributesChooser((Frame)window, "Please select your options", true) : new TextAttributesChooser((Dialog)window, "Please select your options", true);
                        }
                        DocumentEditor.this.styleChooser.setLocationRelativeTo(DocumentEditor.this.stylesTree);
                        typeData.setAttributes(DocumentEditor.this.styleChooser.show(typeData.getAttributes().copyAttributes()));
                        DocumentEditor.this.stylesTreeModel.nodeChanged(defaultMutableTreeNode);
                    }
                }
            }
        });
        this.stylesTree.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Enumeration<TreeNode> enumeration = DocumentEditor.this.stylesTreeRoot.depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            DocumentEditor.this.stylesTreeModel.nodeChanged(enumeration.nextElement());
                        }
                    }
                });
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.tableScroll.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                if (!DocumentEditor.this.tableScroll.getViewport().getView().getBounds().contains(point)) {
                    DocumentEditor.this.annotationsTable.clearSelection();
                }
            }
        });
        this.annotationsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = DocumentEditor.this.annotationsTable.rowAtPoint(mouseEvent.getPoint());
                Annotation annotation = (Annotation)DocumentEditor.this.annotationsTable.getModel().getValueAt(n, -1);
                String string = (String)DocumentEditor.this.annotationsTable.getModel().getValueAt(n, 1);
                AnnotationSet annotationSet = string.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(string);
                EditAnnotationAction editAnnotationAction = new EditAnnotationAction(annotationSet, annotation);
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.getClickCount() != 1 && mouseEvent.getClickCount() == 2 && DocumentEditor.this.editable) {
                        editAnnotationAction.actionPerformed(null);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    XJPopupMenu xJPopupMenu = new XJPopupMenu();
                    xJPopupMenu.add(new AbstractAction(){
                        {
                            this.putValue("Name", "Select all");
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentEditor.this.annotationsTable.selectAll();
                        }
                    });
                    if (DocumentEditor.this.editable) {
                        xJPopupMenu.addSeparator();
                        xJPopupMenu.add(new DeleteSelectedAnnotationsAction(DocumentEditor.this.annotationsTable));
                        xJPopupMenu.addSeparator();
                        xJPopupMenu.add(new XJMenuItem(editAnnotationAction, DocumentEditor.this.myHandle));
                    }
                    xJPopupMenu.show(DocumentEditor.this.annotationsTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.annotationsTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Delete");
        this.annotationsTable.getActionMap().put("Delete", new DeleteSelectedAnnotationsAction(this.annotationsTable));
        this.stylesTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Delete");
        this.stylesTree.getActionMap().put("Delete", new DeleteSelectedAnnotationsAction(this.stylesTree));
        this.corefTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Delete");
        this.corefTree.getActionMap().put("Delete", new DeleteSelectedAnnotationsAction(this.corefTree));
        this.annotationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = DocumentEditor.this.annotationsTable.getSelectedRows();
                Highlighter highlighter = DocumentEditor.this.selectionHighlighter;
                synchronized (highlighter) {
                    DocumentEditor.this.selectionHighlighter.removeAllHighlights();
                }
                for (int i = 0; i < nArray.length; ++i) {
                    Object object;
                    int n = ((Long)DocumentEditor.this.annotationsTable.getModel().getValueAt(nArray[i], 2)).intValue();
                    int n2 = ((Long)DocumentEditor.this.annotationsTable.getModel().getValueAt(nArray[i], 3)).intValue();
                    n += DocumentEditor.this.longLinesCorrection(n);
                    n2 += DocumentEditor.this.longLinesCorrection(n2);
                    try {
                        object = DocumentEditor.this.textPane.modelToView(n);
                        Rectangle rectangle = DocumentEditor.this.textPane.modelToView(n2);
                        SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (Rectangle)object);
                        DocumentEditor.this.textPane.scrollRectToVisible((Rectangle)object);
                        DocumentEditor.this.annotationsTable.requestFocus();
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException.toString());
                    }
                    try {
                        object = DocumentEditor.this.selectionHighlighter;
                        synchronized (object) {
                            DocumentEditor.this.selectionHighlighter.addHighlight(n, n2, DefaultHighlighter.DefaultPainter);
                            continue;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException.toString());
                    }
                }
                DocumentEditor.this.selectionBlinker.testAndStart();
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n = DocumentEditor.this.textPane.viewToModel(mouseEvent.getPoint());
                    if (DocumentEditor.this.textPane.getSelectionStart() == DocumentEditor.this.textPane.getSelectionEnd()) {
                        Object object;
                        XJPopupMenu xJPopupMenu = new XJPopupMenu("Select:");
                        Iterator<Annotation> iterator = DocumentEditor.this.document.getAnnotations().get(new Long(n), new Long(n)).iterator();
                        if (iterator.hasNext()) {
                            object = new XJMenu("Default");
                            xJPopupMenu.add((JMenuItem)object);
                            while (iterator.hasNext()) {
                                Annotation annotation = iterator.next();
                                ((JMenu)object).add(new HighlightAnnotationMenu(annotation, DocumentEditor.this.document.getAnnotations()));
                            }
                        }
                        if ((object = DocumentEditor.this.document.getNamedAnnotationSets()) != null) {
                            for (AnnotationSet annotationSet : object.values()) {
                                iterator = annotationSet.get(new Long(n), new Long(n)).iterator();
                                if (!iterator.hasNext()) continue;
                                XJMenu xJMenu = new XJMenu(annotationSet.getName());
                                xJPopupMenu.add(xJMenu);
                                while (iterator.hasNext()) {
                                    Annotation annotation = iterator.next();
                                    xJMenu.add(new HighlightAnnotationMenu(annotation, annotationSet));
                                }
                            }
                        }
                        xJPopupMenu.show(DocumentEditor.this.textPane, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    } else {
                        Iterator<String> iterator;
                        if (!DocumentEditor.this.editable) {
                            return;
                        }
                        Long l = new Long(DocumentEditor.this.textPane.getSelectionStart());
                        Long l2 = new Long(DocumentEditor.this.textPane.getSelectionEnd());
                        XJPopupMenu xJPopupMenu = new XJPopupMenu();
                        XJMenu xJMenu = new XJMenu("Add annotation to \"Default\"");
                        xJMenu.add(new XJMenuItem(new NewAnnotationAction(DocumentEditor.this.document.getAnnotations(), l, l2), DocumentEditor.this.myHandle));
                        List<String> list = Gate.getCreoleRegister().getVREnabledAnnotationTypes();
                        if (!list.isEmpty()) {
                            xJMenu.addSeparator();
                            iterator = list.iterator();
                            while (iterator.hasNext()) {
                                xJMenu.add(new XJMenuItem(new NewAnnotationAction(DocumentEditor.this.document.getAnnotations(), iterator.next(), l, l2), DocumentEditor.this.myHandle));
                            }
                        }
                        xJPopupMenu.add(xJMenu);
                        if (DocumentEditor.this.document.getNamedAnnotationSets() != null) {
                            iterator = DocumentEditor.this.document.getNamedAnnotationSets().keySet().iterator();
                            if (iterator.hasNext()) {
                                xJPopupMenu.addSeparator();
                            }
                            while (iterator.hasNext()) {
                                AnnotationSet annotationSet = DocumentEditor.this.document.getAnnotations(iterator.next());
                                xJMenu = new XJMenu("Add annotation to \"" + annotationSet.getName() + "\"");
                                xJMenu.add(new XJMenuItem(new NewAnnotationAction(annotationSet, l, l2), DocumentEditor.this.myHandle));
                                if (!list.isEmpty()) {
                                    xJMenu.addSeparator();
                                    Iterator<String> iterator2 = list.iterator();
                                    while (iterator2.hasNext()) {
                                        xJMenu.add(new XJMenuItem(new NewAnnotationAction(annotationSet, iterator2.next(), l, l2), DocumentEditor.this.myHandle));
                                    }
                                }
                                xJPopupMenu.add(xJMenu);
                            }
                        }
                        xJMenu = new XJMenu("Add annotation to a new set");
                        xJMenu.add(new XJMenuItem(new NewAnnotationAction(null, l, l2), DocumentEditor.this.myHandle));
                        if (!list.isEmpty()) {
                            xJMenu.addSeparator();
                            iterator = list.iterator();
                            while (iterator.hasNext()) {
                                xJMenu.add(new XJMenuItem(new NewAnnotationAction(null, iterator.next(), l, l2), DocumentEditor.this.myHandle));
                            }
                        }
                        xJPopupMenu.add(xJMenu);
                        xJPopupMenu.show(DocumentEditor.this.textPane, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.textPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("highlighter")) {
                    DocumentEditor.this.highlighter = DocumentEditor.this.textPane.getHighlighter();
                    DocumentEditor.this.selectionHighlighter.install(DocumentEditor.this.textPane);
                }
            }
        });
        this.corefTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                int n2;
                TreePath treePath;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (treePath = DocumentEditor.this.corefTree.getPathForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Rectangle rectangle = DocumentEditor.this.corefTree.getPathBounds(treePath);
                    Component component = DocumentEditor.this.corefTree.getCellRenderer().getTreeCellRendererComponent(DocumentEditor.this.corefTree, defaultMutableTreeNode, true, false, false, 0, true);
                    component.setBounds(rectangle);
                    Component component2 = component.getComponentAt(n2 -= rectangle.x, n -= rectangle.y);
                    if (component2 instanceof LazyJPanel) {
                        component2 = component2.getComponentAt(n2, n);
                    }
                    if (defaultMutableTreeNode.getUserObject() instanceof CorefData && component2 instanceof JCheckBox) {
                        CorefData corefData;
                        corefData.setVisible(!(corefData = (CorefData)defaultMutableTreeNode.getUserObject()).getVisible());
                        DocumentEditor.this.corefTreeModel.nodeChanged(defaultMutableTreeNode);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.corefTree.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Enumeration<TreeNode> enumeration = DocumentEditor.this.corefTreeRoot.depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            DocumentEditor.this.corefTreeModel.nodeChanged(enumeration.nextElement());
                        }
                    }
                });
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    protected void initLocalData() {
        this.lock = new Object();
        this.data = Collections.synchronizedList(new ArrayList());
        this.ranges = new ArrayList();
        this.typeDataMap = new HashMap();
        this.eventHandler = new EventsHandler();
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar(0);
        this.toolbar.setAlignmentX(0.0f);
        this.toolbar.setAlignmentY(0.0f);
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.textVisibleBtn = new JToggleButton("Text", this.textVisible);
        this.toolbar.add(this.textVisibleBtn);
        this.annotationsTableVisibleBtn = new JToggleButton("Annotations", this.annotationsTableVisible);
        this.toolbar.add(this.annotationsTableVisibleBtn);
        this.typesTreeVisibleBtn = new JToggleButton("Annotation Sets", this.typesTreeVisible);
        this.toolbar.add(this.typesTreeVisibleBtn);
        this.coreferenceVisibleBtn = new JToggleButton("Coreference", this.coreferenceVisible);
        if (this.isCorefOptionAvailable()) {
            this.toolbar.add(this.coreferenceVisibleBtn);
        }
        this.toolbar.add(Box.createHorizontalStrut(20));
        this.toolbar.add(new PrintAction());
        this.toolbar.add(new SearchAction());
        this.toolbar.add(Box.createHorizontalGlue());
        this.textPane = new XJTextPane();
        this.textPane.setEnabled(true);
        this.textPane.setEditorKit(new CustomStyledEditorKit());
        Style style = this.textPane.getStyle("default");
        StyleConstants.setBackground(style, Color.white);
        StyleConstants.setFontFamily(style, "Arial Unicode MS");
        this.textScroll = new JScrollPane(this.textPane);
        this.textScroll.setAlignmentY(0.0f);
        this.textScroll.setAlignmentX(0.0f);
        this.annotationsTableModel = new AnnotationsTableModel();
        this.annotationsTable = new XJTable(this.annotationsTableModel);
        this.tableScroll = new JScrollPane(this.annotationsTable);
        this.tableScroll.setOpaque(true);
        this.tableScroll.setAlignmentY(0.0f);
        this.tableScroll.setAlignmentX(0.0f);
        this.stylesTreeRoot = new DefaultMutableTreeNode(null, true);
        this.stylesTreeModel = new DefaultTreeModel(this.stylesTreeRoot, true);
        this.stylesTree = new JTree(this.stylesTreeModel){

            public void updateUI() {
                super.updateUI();
                this.setRowHeight(0);
            }
        };
        this.stylesTree.setRootVisible(false);
        this.stylesTree.setCellRenderer(new NodeRenderer());
        this.stylesTree.setRowHeight(0);
        this.stylesTree.setShowsRootHandles(true);
        this.stylesTree.setToggleClickCount(0);
        this.stylesTreeScroll = new JScrollPane(this.stylesTree);
        this.stylesTreeScroll.setAlignmentY(0.0f);
        this.stylesTreeScroll.setAlignmentX(0.0f);
        this.corefTreeRoot = new DefaultMutableTreeNode("Co-reference data", true);
        this.corefTreeModel = new DefaultTreeModel(this.corefTreeRoot, true);
        this.corefTree = new JTree(this.corefTreeModel);
        this.corefTree.setCellRenderer(new CorefNodeRenderer());
        this.corefTree.setRowHeight(0);
        this.corefTree.setRootVisible(true);
        this.corefTree.setShowsRootHandles(false);
        this.corefScroll = new JScrollPane(this.corefTree);
        this.corefScroll.setAlignmentX(0.0f);
        this.corefScroll.setAlignmentY(0.0f);
        this.updateCorefTree();
        this.leftSplit = new JSplitPane(0, false);
        this.leftSplit.setOneTouchExpandable(true);
        this.leftSplit.setOpaque(true);
        this.leftSplit.setAlignmentY(0.0f);
        this.leftSplit.setAlignmentX(0.0f);
        this.leftSplit.setResizeWeight(0.75);
        this.rightSplit = new JSplitPane(0, false);
        this.rightSplit.setOneTouchExpandable(true);
        this.rightSplit.setOpaque(true);
        this.rightSplit.setAlignmentY(0.0f);
        this.rightSplit.setAlignmentX(0.0f);
        this.rightSplit.setResizeWeight(0.75);
        this.mainSplit = new JSplitPane(1, false);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setOpaque(true);
        this.mainSplit.setAlignmentY(0.0f);
        this.mainSplit.setAlignmentX(0.0f);
        this.mainSplit.setResizeWeight(0.75);
        this.layoutComponents();
        this.progressBox = new Box(0);
        this.progressBox.add(Box.createHorizontalStrut(5));
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBox.add(this.progressBar);
        this.progressBox.add(Box.createHorizontalStrut(5));
        this.highlighter = this.textPane.getHighlighter();
        if (this.highlighter instanceof DefaultHighlighter) {
            ((DefaultHighlighter)this.highlighter).setDrawsLayeredHighlights(true);
        }
        this.selectionHighlighter = new DefaultHighlighter();
        this.selectionHighlighter.install(this.textPane);
        this.selectionBlinker = new SelectionBlinker();
    }

    private boolean isTextSelected() {
        return this.textPane.getSelectionStart() != this.textPane.getSelectionEnd();
    }

    protected Set getAnnotationSchemas() {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get("gate.creole.AnnotationSchema");
        if (resourceData != null) {
            hashSet.addAll(resourceData.getInstantiations());
        }
        return hashSet;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
        this.propertyChangeListeners.addPropertyChangeListener(string, propertyChangeListener);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setTarget(Object object) {
        if (object == null) {
            this.document = null;
            return;
        }
        if (!(object instanceof Document)) {
            throw new IllegalArgumentException("The document editor can only display GATE documents!\nThe provided resource is not a document but a: " + object.getClass().toString() + "!");
        }
        Document document = this.document;
        this.document = (Document)object;
        if (document != this.document) {
            this.this_documentChanged();
        }
        this.propertyChangeListeners.firePropertyChange("document", document, object);
    }

    public void setHandle(Handle handle) {
        this.myHandle = handle;
    }

    public void cleanup() {
        this.document = null;
        this.stylesTreeRoot.removeAllChildren();
        this.data.clear();
        this.ranges.clear();
        this.myHandle = null;
    }

    public Set getDisplayedAnnotations() {
        if (this.annotationsTableModel == null || this.annotationsTableModel.getRowCount() == 0) {
            return null;
        }
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        for (int i = 0; i < this.annotationsTableModel.getRowCount(); ++i) {
            Annotation annotation = (Annotation)this.annotationsTableModel.getValueAt(i, -1);
            hashSet.add(annotation);
        }
        return hashSet;
    }

    private Vector getBreakPositions(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = string.length();
        block6: for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    n3 = 0;
                    n2 = -1;
                    continue block6;
                }
                case '\r': {
                    n3 = 0;
                    n2 = -1;
                    continue block6;
                }
                case '\t': {
                    n2 = i;
                    ++n3;
                    continue block6;
                }
                case ' ': {
                    n2 = i;
                    ++n3;
                    continue block6;
                }
                default: {
                    if (n3 >= 2048) {
                        if (n2 == -1) {
                            n2 = i;
                        }
                        vector.add(new Integer(n2 + 1));
                        n3 = i - n2;
                        n2 = -1;
                        continue block6;
                    }
                    ++n3;
                }
            }
        }
        return vector;
    }

    private Vector correctLongLines(StringBuffer stringBuffer) {
        Vector vector = this.getBreakPositions(stringBuffer.toString());
        for (int i = vector.size() - 1; i >= 0; --i) {
            Integer n = (Integer)vector.get(i);
            int n2 = n;
            stringBuffer.insert(n2, '\n');
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    private int longLinesCorrection(int n) {
        int n2 = 0;
        if (this.longLinesCorrectionPositions != null) {
            boolean bl = true;
            Iterator iterator = this.longLinesCorrectionPositions.iterator();
            while (bl && iterator.hasNext()) {
                Integer n3 = (Integer)iterator.next();
                if (n > n3 + n2) {
                    ++n2;
                    continue;
                }
                bl = false;
            }
        }
        return n2;
    }

    protected void this_documentChanged() {
        this.initLocalData();
        Enumeration<TreeNode> enumeration = this.stylesTreeRoot.children();
        while (enumeration.hasMoreElements()) {
            this.stylesTreeModel.removeNodeFromParent((DefaultMutableTreeNode)enumeration.nextElement());
        }
        if (this.document == null) {
            return;
        }
        String string = this.document.getContent().toString();
        StringBuffer stringBuffer = new StringBuffer(string);
        this.longLinesCorrectionPositions = this.correctLongLines(stringBuffer);
        if (this.longLinesCorrectionPositions != null) {
            string = stringBuffer.toString();
        }
        this.textPane.setText(string);
        this.textPane.getDocument().addDocumentListener(new SwingDocumentListener());
        this.eventHandler.annotationSetAdded(new gate.event.DocumentEvent(this.document, 101, null));
        this.document.addDocumentListener(this.eventHandler);
        this.annotationsTableModel.fireTableDataChanged();
        this.document.getFeatures().addFeatureMapListener(new FeatureMapListener(){

            public void featureMapUpdated() {
                DocumentEditor.this.updateCorefTree();
            }
        });
        this.updateCorefTree();
        Map<String, AnnotationSet> map = this.document.getNamedAnnotationSets();
        if (map != null) {
            for (AnnotationSet annotationSet : map.values()) {
                if (annotationSet == null) continue;
                this.eventHandler.annotationSetAdded(new gate.event.DocumentEvent(this.document, 101, annotationSet.getName()));
            }
        }
    }

    protected TypeData getTypeData(String string, String string2) {
        Map map = (Map)this.typeDataMap.get(string);
        if (map != null) {
            return (TypeData)map.get(string2);
        }
        return null;
    }

    protected void showHighlights(Set set, AttributeSet attributeSet) {
        int n = this.textPane.getSelectionStart();
        int n2 = this.textPane.getSelectionEnd();
        final int n3 = this.textPane.viewToModel(this.textScroll.getViewport().getViewPosition());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DocumentEditor.this.progressBar.setValue(0);
                DocumentEditor.this.textScroll.getViewport().setView(DocumentEditor.this.progressBox);
                DocumentEditor.this.textScroll.paintImmediately(DocumentEditor.this.textScroll.getBounds());
            }
        });
        this.paintHighlights(set, attributeSet);
        this.textPane.select(n, n2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DocumentEditor.this.textScroll.getViewport().setView(DocumentEditor.this.textPane);
                try {
                    DocumentEditor.this.textScroll.getViewport().setViewPosition(DocumentEditor.this.textPane.modelToView(n3).getLocation());
                    DocumentEditor.this.textScroll.paintImmediately(DocumentEditor.this.textScroll.getBounds());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    protected void paintHighlights(Set set, AttributeSet attributeSet) {
        int n = set.size();
        int n2 = 0;
        int n3 = 0;
        for (Annotation annotation : set) {
            int n4 = annotation.getStartNode().getOffset().intValue();
            int n5 = annotation.getEndNode().getOffset().intValue();
            n4 += this.longLinesCorrection(n4);
            n5 += this.longLinesCorrection(n5);
            this.textPane.select(n4, n5);
            this.textPane.setCharacterAttributes(attributeSet, true);
            if (!this.progressBar.isVisible()) continue;
            int n6 = n2 * 100 / n;
            if (n6 - n3 >= 5) {
                this.progressBar.setValue(n6);
                this.progressBar.paintImmediately(this.progressBar.getBounds());
                n3 = n6;
            }
            ++n2;
        }
    }

    protected void repairHighlights(int n, int n2) {
        int n3 = this.textPane.getSelectionStart();
        int n4 = this.textPane.getSelectionEnd();
        this.textPane.select(n, n2);
        this.textPane.setCharacterAttributes(this.textPane.getStyle("default"), true);
        Iterator iterator = this.typeDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)this.typeDataMap.get(iterator.next());
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                AnnotationSet annotationSet;
                TypeData typeData = (TypeData)map.get(iterator2.next());
                if (!typeData.getVisible()) continue;
                String string = typeData.getSet();
                AnnotationSet annotationSet2 = annotationSet = string.equals("Default") ? this.document.getAnnotations() : this.document.getAnnotations(string);
                if ((annotationSet = annotationSet.get(typeData.getType())) == null) continue;
                AnnotationSet annotationSet3 = annotationSet.get(new Long(n), new Long(n2));
                this.paintHighlights(annotationSet3, typeData.getActualStyle());
            }
        }
        this.textPane.select(n3, n4);
    }

    protected void selectAnnotation(String string, Annotation annotation) {
        TypeData typeData = this.getTypeData(string, annotation.getType());
        if (!typeData.getVisible()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            typeData.setVisible(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (defaultMutableTreeNode = (DefaultMutableTreeNode)this.stylesTreeRoot.getFirstChild(); defaultMutableTreeNode != null && !((TypeData)defaultMutableTreeNode.getUserObject()).getSet().equals(string); defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
            }
            if (defaultMutableTreeNode != null) {
                String string2 = annotation.getType();
                for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode != null && !((TypeData)defaultMutableTreeNode.getUserObject()).getType().equals(string2); defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
                }
                if (defaultMutableTreeNode != null) {
                    this.stylesTreeModel.nodeChanged(defaultMutableTreeNode);
                }
            }
        }
        int n = -1;
        n = this.data.indexOf(annotation);
        if (n != -1 && (n = this.annotationsTable.getTableRow(n)) != -1) {
            this.annotationsTable.clearSelection();
            this.annotationsTable.addRowSelectionInterval(n, n);
            this.annotationsTable.scrollRectToVisible(this.annotationsTable.getCellRect(n, 0, true));
        }
    }

    protected void layoutComponents() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl;
                JComponent jComponent = null;
                JComponent jComponent2 = null;
                if (DocumentEditor.this.isTextVisible() && DocumentEditor.this.isAnnotationsTableVisible()) {
                    DocumentEditor.this.leftSplit.setTopComponent(DocumentEditor.this.textScroll);
                    DocumentEditor.this.leftSplit.setBottomComponent(DocumentEditor.this.tableScroll);
                    jComponent = DocumentEditor.this.leftSplit;
                } else if (DocumentEditor.this.isTextVisible()) {
                    jComponent = DocumentEditor.this.textScroll;
                } else if (DocumentEditor.this.isAnnotationsTableVisible()) {
                    jComponent = DocumentEditor.this.tableScroll;
                }
                boolean bl2 = bl = DocumentEditor.this.isCoreferenceVisible() && DocumentEditor.this.isCorefOptionAvailable();
                if (bl) {
                    DocumentEditor.this.updateCorefTree();
                }
                if (DocumentEditor.this.isTypesTreeVisible() && bl) {
                    DocumentEditor.this.rightSplit.setTopComponent(DocumentEditor.this.stylesTreeScroll);
                    DocumentEditor.this.rightSplit.setBottomComponent(DocumentEditor.this.corefScroll);
                    jComponent2 = DocumentEditor.this.rightSplit;
                } else if (DocumentEditor.this.isTypesTreeVisible()) {
                    jComponent2 = DocumentEditor.this.stylesTreeScroll;
                } else if (bl) {
                    jComponent2 = DocumentEditor.this.corefScroll;
                }
                if (DocumentEditor.this.getComponentCount() > 1) {
                    DocumentEditor.this.remove(1);
                }
                if (jComponent != null && jComponent2 != null) {
                    DocumentEditor.this.mainSplit.setLeftComponent(jComponent);
                    DocumentEditor.this.mainSplit.setRightComponent(jComponent2);
                    DocumentEditor.this.add((Component)DocumentEditor.this.mainSplit, "Center");
                } else if (jComponent != null) {
                    DocumentEditor.this.add((Component)jComponent, "Center");
                } else if (jComponent2 != null) {
                    DocumentEditor.this.add((Component)jComponent2, "Center");
                }
                DocumentEditor.this.validate();
                DocumentEditor.this.repaint();
            }
        });
    }

    protected void updateCorefTree() {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object[] objectArray;
        if (this.document == null || this.document.getFeatures() == null) {
            this.corefTreeRoot.removeAllChildren();
            this.corefTreeModel.nodeStructureChanged(this.corefTreeRoot);
            this.setCorefOptionAvailable(false);
            return;
        }
        Map map = null;
        try {
            map = (Map)this.document.getFeatures().get("MatchesAnnots");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (map == null) {
            Enumeration<TreeNode> enumeration = this.corefTreeRoot.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(defaultMutableTreeNode.getUserObject() instanceof CorefData)) continue;
                ((CorefData)defaultMutableTreeNode.getUserObject()).setVisible(false);
            }
            this.corefTreeRoot.removeAllChildren();
            this.corefTreeModel.nodeStructureChanged(this.corefTreeRoot);
            this.setCorefOptionAvailable(false);
            return;
        }
        Iterator iterator = map.keySet().iterator();
        block3: while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            cloneable = objectArray == null ? this.document.getAnnotations() : this.document.getAnnotations((String)objectArray);
            object3 = ((List)map.get(objectArray)).iterator();
            while (object3.hasNext()) {
                object2 = ((List)object3.next()).iterator();
                while (object2.hasNext()) {
                    if (cloneable.get((Integer)object2.next()) != null) continue;
                    iterator.remove();
                    Err.prln("Coreference data for the \"" + (String)(objectArray == null ? "Default" : objectArray) + "\" annotation set of document \"" + this.document.getName() + "\" was invalid and has been removed");
                    continue block3;
                }
            }
        }
        if (map.isEmpty()) {
            this.corefTreeRoot.removeAllChildren();
            this.corefTreeModel.nodeStructureChanged(this.corefTreeRoot);
            this.setCorefOptionAvailable(false);
            return;
        }
        objectArray = map.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        cloneable = new ArrayList(this.corefTreeRoot.getChildCount());
        object3 = this.corefTreeRoot.children();
        while (object3.hasMoreElements()) {
            object2 = (String)((DefaultMutableTreeNode)object3.nextElement()).getUserObject();
            ((ArrayList)cloneable).add(((String)object2).equals("Default") ? null : object2);
        }
        object2 = new ArrayList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object42;
            DefaultMutableTreeNode defaultMutableTreeNode;
            object = objectArray[i];
            int n = ((ArrayList)cloneable).indexOf(object);
            DefaultMutableTreeNode defaultMutableTreeNode2 = n != -1 ? (DefaultMutableTreeNode)this.corefTreeRoot.getChildAt(n) : (defaultMutableTreeNode = new DefaultMutableTreeNode(object == null ? "Default" : object, true));
            if (n != -1) {
                ((ArrayList)cloneable).remove(n);
            }
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            for (Object object42 : (List)map.get(object)) {
                CorefData corefData = null;
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (corefData == null && enumeration.hasMoreElements()) {
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                    List list = ((CorefData)defaultMutableTreeNode3.getUserObject()).getAnnoationIDs();
                    ArrayList arrayList2 = new ArrayList(list);
                    arrayList2.retainAll((Collection<?>)object42);
                    if (arrayList2.isEmpty()) continue;
                    corefData = (CorefData)defaultMutableTreeNode3.getUserObject();
                    if (arrayList2.size() == object42.size()) continue;
                    corefData.setAnnotationIDs((List)object42);
                }
                if (corefData == null) {
                    corefData = new CorefData((List)object42, false, (String)(object == null ? "Default" : object));
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(corefData, false);
                }
                arrayList.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode.removeAllChildren();
            object42 = arrayList.iterator();
            while (object42.hasNext()) {
                defaultMutableTreeNode.add((DefaultMutableTreeNode)object42.next());
            }
            ((ArrayList)object2).add(defaultMutableTreeNode);
        }
        this.corefTreeRoot.removeAllChildren();
        Iterator iterator2 = ((ArrayList)object2).iterator();
        while (iterator2.hasNext()) {
            object = (DefaultMutableTreeNode)iterator2.next();
            this.corefTreeRoot.add((MutableTreeNode)object);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DocumentEditor.this.highlighter.removeAllHighlights();
                DocumentEditor.this.corefTreeModel.nodeStructureChanged(DocumentEditor.this.corefTreeRoot);
                DocumentEditor.this.corefTree.expandPath(new TreePath(new Object[]{DocumentEditor.this.corefTreeRoot}));
                Enumeration<TreeNode> enumeration = DocumentEditor.this.corefTreeRoot.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    DocumentEditor.this.corefTree.expandPath(new TreePath(DocumentEditor.this.corefTreeModel.getPathToRoot(defaultMutableTreeNode)));
                    if (!(defaultMutableTreeNode.getUserObject() instanceof CorefData)) continue;
                    CorefData corefData = (CorefData)defaultMutableTreeNode.getUserObject();
                    corefData.setVisible(corefData.getVisible());
                }
            }
        });
        this.setCorefOptionAvailable(true);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setAnnotationsTableVisible(boolean bl) {
        boolean bl2 = this.annotationsTableVisible;
        this.annotationsTableVisible = bl;
        this.propertyChangeListeners.firePropertyChange("annotationsTableVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isAnnotationsTableVisible() {
        return this.annotationsTableVisible;
    }

    public void setCoreferenceVisible(boolean bl) {
        boolean bl2 = this.coreferenceVisible;
        this.coreferenceVisible = bl;
        this.propertyChangeListeners.firePropertyChange("coreferenceVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isCoreferenceVisible() {
        return this.coreferenceVisible;
    }

    public void setTextVisible(boolean bl) {
        boolean bl2 = this.textVisible;
        this.textVisible = bl;
        this.propertyChangeListeners.firePropertyChange("textVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTypesTreeVisible(boolean bl) {
        boolean bl2 = this.typesTreeVisible;
        this.typesTreeVisible = bl;
        this.propertyChangeListeners.firePropertyChange("typesTreeVisible", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isTypesTreeVisible() {
        return this.typesTreeVisible;
    }

    public void setCorefOptionAvailable(boolean bl) {
        boolean bl2 = this.corefOptionAvailable;
        this.corefOptionAvailable = bl;
        this.propertyChangeListeners.firePropertyChange("corefOptionAvailable", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isCorefOptionAvailable() {
        return this.corefOptionAvailable;
    }

    public class CustomStyledViewFactory
    implements ViewFactory {
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new CustomLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new CustomLabelView(element);
        }
    }

    public class CustomStyledEditorKit
    extends StyledEditorKit {
        private final ViewFactory defaultFactory;

        public CustomStyledEditorKit() {
            this.defaultFactory = new CustomStyledViewFactory();
        }

        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }

        public void read(Reader reader, javax.swing.text.Document document, int n) throws IOException, BadLocationException {
            char[] cArray = new char[65536];
            int n2 = 0;
            while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
                document.insertString(n, new String(cArray, 0, n2), null);
                n += n2;
            }
        }
    }

    class NewAnnotationAction
    extends AbstractAction {
        AnnotationSet set;
        Long startOffset;
        Long endOffset;
        String type;

        public NewAnnotationAction(AnnotationSet annotationSet, Long l, Long l2) {
            super("New annotation");
            this.putValue("ShortDescription", "Creates a new annotation");
            this.set = annotationSet;
            this.startOffset = l;
            this.endOffset = l2;
            this.type = null;
        }

        public NewAnnotationAction(AnnotationSet annotationSet, String string, Long l, Long l2) {
            super("New \"" + string + "\" annotation");
            this.putValue("ShortDescription", "Creates a new annotation of type \"" + string + "\"");
            this.set = annotationSet;
            this.startOffset = l;
            this.endOffset = l2;
            this.type = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (this.set == null) {
                object = JOptionPane.showInputDialog(DocumentEditor.this, "Please provide a name for the new annotation set", "GATE", 3);
                if (object == null) {
                    return;
                }
                this.set = DocumentEditor.this.document.getAnnotations((String)object);
            }
            try {
                object = this.set.add(this.startOffset, this.endOffset, this.type == null ? "_New_" : this.type, Factory.newFeatureMap());
                Annotation annotation = this.set.get((Integer)object);
                new EditAnnotationAction(this.set, annotation).actionPerformed(actionEvent);
            }
            catch (GateException gateException) {
                JOptionPane.showMessageDialog(DocumentEditor.this, "There was an error:\n" + gateException.toString(), "GATE", 0);
            }
        }
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        protected AnnotationSet set;
        protected Annotation annotation;

        public EditAnnotationAction(AnnotationSet annotationSet, Annotation annotation) {
            super("Edit");
            this.set = annotationSet;
            this.annotation = annotation;
            this.putValue("ShortDescription", "Edits the annotation");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            List<String> list = Gate.getCreoleRegister().getAnnotationVRs(this.annotation.getType());
            List<String> list2 = Gate.getCreoleRegister().getAnnotationVRs();
            JTabbedPane jTabbedPane = new JTabbedPane(3);
            for (String string : list) {
                try {
                    serializable = (AnnotationVisualResource)Factory.createResource(string);
                    if (serializable instanceof ResizableVisualResource) {
                        jTabbedPane.add((Component)serializable, ((ResourceData)Gate.getCreoleRegister().get(string)).getName());
                    } else {
                        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
                        jTabbedPane.add((Component)jScrollPane, ((ResourceData)Gate.getCreoleRegister().get(string)).getName());
                    }
                    serializable.editAnnotation(this.annotation, this.set);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            for (String string : list2) {
                try {
                    serializable = (AnnotationVisualResource)Factory.createResource(string);
                    if (!serializable.canDisplayAnnotationType(this.annotation.getType())) continue;
                    serializable.editAnnotation(this.annotation, this.set);
                    if (serializable instanceof ResizableVisualResource) {
                        jTabbedPane.add((Component)serializable, ((ResourceData)Gate.getCreoleRegister().get(string)).getName());
                        continue;
                    }
                    jTabbedPane.add((Component)new JScrollPane((Component)serializable), ((ResourceData)Gate.getCreoleRegister().get(string)).getName());
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            boolean bl = false;
            while (!bl) {
                if (OkCancelDialog.showDialog(DocumentEditor.this, jTabbedPane, "Edit Annotation")) {
                    try {
                        serializable = jTabbedPane.getSelectedComponent();
                        if (serializable instanceof AnnotationVisualResource) {
                            serializable.okAction();
                        } else if (serializable instanceof JScrollPane) {
                            ((AnnotationVisualResource)((Object)((JScrollPane)serializable).getViewport().getView())).okAction();
                        } else {
                            throw new LuckyException("DocumentEditor.EditAnnotationAction1");
                        }
                        bl = true;
                    }
                    catch (GateException gateException) {
                        JOptionPane.showMessageDialog(DocumentEditor.this, "There was an error:\n" + gateException.toString(), "GATE", 0);
                        gateException.printStackTrace(Err.getPrintWriter());
                        bl = false;
                    }
                    continue;
                }
                if (OkCancelDialog.userHasPressedCancel) {
                    try {
                        serializable = jTabbedPane.getSelectedComponent();
                        if (serializable instanceof AnnotationVisualResource) {
                            ((AnnotationVisualResource)serializable).cancelAction();
                        } else if (serializable instanceof JScrollPane) {
                            ((AnnotationVisualResource)((Object)((JScrollPane)serializable).getViewport().getView())).cancelAction();
                        } else {
                            throw new LuckyException("DocumentEditor.EditAnnotationAction");
                        }
                        bl = true;
                    }
                    catch (GateException gateException) {
                        JOptionPane.showMessageDialog(DocumentEditor.this, "There was an error:\n" + gateException.toString(), "GATE", 0);
                        bl = false;
                    }
                }
                bl = true;
            }
        }
    }

    protected class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super("Print");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    if (printerJob.printDialog()) {
                        try {
                            PageFormat pageFormat = printerJob.defaultPage();
                            JComponentPrinter jComponentPrinter = new JComponentPrinter(DocumentEditor.this.textPane, pageFormat);
                            printerJob.setPageable(jComponentPrinter);
                            printerJob.print();
                            StatusListener statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                            if (statusListener != null) {
                                statusListener.statusChanged("Document printed!");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Print thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    protected class SearchDialog
    extends JDialog {
        JTextField patternTextField;
        JCheckBox ignoreCaseChk;
        JCheckBox wholeWordsChk;
        Pattern pattern;
        int nextMatchStartsFrom;
        String content;
        Action findFirstAction;
        Action findNextAction;
        Action cancelAction;

        SearchDialog(Frame frame) {
            super(frame, false);
            this.setTitle("Find in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        SearchDialog(Dialog dialog) {
            super(dialog, false);
            this.setTitle("Find in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        protected void initLocalData() {
            this.pattern = null;
            this.nextMatchStartsFrom = 0;
            this.content = DocumentEditor.this.document.getContent().toString();
            this.findFirstAction = new AbstractAction("Find first"){
                {
                    this.putValue("ShortDescription", "Finds first match");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    DocumentEditor.this.textPane.setCaretPosition(DocumentEditor.this.textPane.getCaretPosition());
                    boolean bl = false;
                    int n = SearchDialog.this.nextMatchStartsFrom - 1;
                    int n2 = -1;
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find() && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        if (SearchDialog.this.wholeWordsChk.isSelected()) {
                            bl = !(n != 0 && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n - 1)) || n2 != SearchDialog.this.content.length() && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n2)));
                            continue;
                        }
                        bl = true;
                    }
                    if (bl) {
                        SearchDialog.this.nextMatchStartsFrom = n + 1;
                        SwingUtilities.getWindowAncestor(DocumentEditor.this.textPane).requestFocus();
                        DocumentEditor.this.textPane.requestFocus();
                        DocumentEditor.this.textPane.setCaretPosition(n);
                        DocumentEditor.this.textPane.moveCaretPosition(n2);
                    } else {
                        JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "String not found!", "GATE", 1);
                    }
                }
            };
            this.findNextAction = new AbstractAction("Find next"){
                {
                    this.putValue("ShortDescription", "Finds next match");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    DocumentEditor.this.textPane.setCaretPosition(DocumentEditor.this.textPane.getCaretPosition());
                    boolean bl = false;
                    int n = SearchDialog.this.nextMatchStartsFrom - 1;
                    int n2 = -1;
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find() && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        if (SearchDialog.this.wholeWordsChk.isSelected()) {
                            bl = !(n != 0 && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n - 1)) || n2 != SearchDialog.this.content.length() && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n2)));
                            continue;
                        }
                        bl = true;
                    }
                    if (bl) {
                        SearchDialog.this.nextMatchStartsFrom = n + 1;
                        SwingUtilities.getWindowAncestor(DocumentEditor.this.textPane).requestFocus();
                        DocumentEditor.this.textPane.requestFocus();
                        DocumentEditor.this.textPane.setCaretPosition(n);
                        DocumentEditor.this.textPane.moveCaretPosition(n2);
                    } else {
                        JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "String not found!", "GATE", 1);
                    }
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){
                {
                    this.putValue("ShortDescription", "Cancel");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DocumentEditor.this.searchDialog.setVisible(false);
                }
            };
        }

        protected void initGuiComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(Box.createVerticalStrut(5));
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            box.add(new JLabel("Find what:"));
            box.add(Box.createHorizontalStrut(5));
            this.patternTextField = new JTextField(20);
            box.add(this.patternTextField);
            box.add(Box.createHorizontalStrut(5));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            this.ignoreCaseChk = new JCheckBox("Ignore case", false);
            box.add(this.ignoreCaseChk);
            box.add(Box.createHorizontalStrut(5));
            this.wholeWordsChk = new JCheckBox("Whole words only", false);
            box.add(this.wholeWordsChk);
            box.add(Box.createHorizontalStrut(5));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(new JButton(this.findFirstAction));
            box.add(Box.createHorizontalStrut(5));
            box.add(new JButton(this.findNextAction));
            box.add(Box.createHorizontalStrut(5));
            box.add(new JButton(this.cancelAction));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
        }

        protected void initListeners() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.patternTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }
            });
        }

        protected void refresh() {
            String string = this.patternTextField.getText();
            if (string != null && string.length() > 0) {
                this.findFirstAction.setEnabled(true);
                this.findNextAction.setEnabled(true);
                try {
                    this.pattern = this.ignoreCaseChk.isSelected() ? Pattern.compile(string, 2) : Pattern.compile(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "Invalid pattern!\n" + exception.toString(), "GATE", 0);
                }
            } else {
                this.findFirstAction.setEnabled(false);
                this.findNextAction.setEnabled(false);
            }
            if (this.pattern == null) {
                // empty if block
            }
        }
    }

    protected class SearchAction
    extends AbstractAction {
        public SearchAction() {
            super("Search");
            this.putValue("ShortDescription", "Search within the text");
            this.putValue("SmallIcon", MainFrame.getIcon("search"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DocumentEditor.this.searchDialog == null) {
                Window window = SwingUtilities.getWindowAncestor(DocumentEditor.this);
                DocumentEditor.this.searchDialog = window instanceof Dialog ? new SearchDialog((Dialog)window) : new SearchDialog((Frame)window);
                DocumentEditor.this.searchDialog.pack();
                DocumentEditor.this.searchDialog.setLocationRelativeTo(DocumentEditor.this);
                DocumentEditor.this.searchDialog.setResizable(false);
                MainFrame.getGuiRoots().add(DocumentEditor.this.searchDialog);
            }
            if (DocumentEditor.this.searchDialog.isVisible()) {
                DocumentEditor.this.searchDialog.toFront();
            } else {
                DocumentEditor.this.searchDialog.setVisible(true);
            }
        }
    }

    protected class DeleteSelectedAnnotationsAction
    extends AbstractAction {
        JComponent source;

        public DeleteSelectedAnnotationsAction(JComponent jComponent) {
            super("Delete selected annotations");
            this.source = jComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                block10: {
                    block8: {
                        if (this.source != DocumentEditor.this.annotationsTable) break block8;
                        HashMap<String, ArrayList<Annotation>> hashMap = new HashMap<String, ArrayList<Annotation>>();
                        int[] nArray = DocumentEditor.this.annotationsTable.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            int n = nArray[i];
                            Annotation annotation = (Annotation)DocumentEditor.this.annotationsTable.getModel().getValueAt(n, -1);
                            String string = (String)DocumentEditor.this.annotationsTable.getModel().getValueAt(n, 1);
                            ArrayList<Annotation> arrayList = (ArrayList<Annotation>)hashMap.get(string);
                            if (arrayList == null) {
                                arrayList = new ArrayList<Annotation>();
                                hashMap.put(string, arrayList);
                            }
                            arrayList.add(annotation);
                        }
                        for (String string : hashMap.keySet()) {
                            AnnotationSet annotationSet = string.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(string);
                            annotationSet.removeAll((List)hashMap.get(string));
                        }
                        break block9;
                    }
                    if (this.source != DocumentEditor.this.stylesTree) break block10;
                    TreePath[] treePathArray = DocumentEditor.this.stylesTree.getSelectionPaths();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        AnnotationSet annotationSet;
                        AnnotationSet annotationSet2;
                        TypeData typeData = (TypeData)((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getUserObject();
                        String string = typeData.getSet();
                        if (typeData.getType() == null) {
                            if (string.equals("Default")) {
                                JOptionPane.showMessageDialog(DocumentEditor.this, "The default annotation set cannot be deleted!\nIt will only be cleared...", "GATE", 0);
                                DocumentEditor.this.document.getAnnotations().clear();
                                continue;
                            }
                            DocumentEditor.this.document.removeAnnotationSet(string);
                            continue;
                        }
                        if (!string.equals("Default") && !DocumentEditor.this.document.getNamedAnnotationSets().containsKey(string)) {
                            return;
                        }
                        AnnotationSet annotationSet3 = annotationSet2 = string.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(string);
                        if (annotationSet2 == null || (annotationSet = annotationSet2.get(typeData.getType())) == null) continue;
                        annotationSet2.removeAll(new ArrayList<Annotation>(annotationSet));
                    }
                    break block9;
                }
                if (this.source != DocumentEditor.this.corefTree) break block9;
                TreePath[] treePathArray = DocumentEditor.this.corefTree.getSelectionPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    CorefData corefData = (CorefData)((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getUserObject();
                    class CorefClearer
                    implements Runnable {
                        CorefData cData;

                        CorefClearer(CorefData corefData) {
                            this.cData = corefData;
                        }

                        public void run() {
                            this.cData.removeAnnotations();
                        }
                    }
                    Thread thread = new Thread(new CorefClearer(corefData));
                    thread.setPriority(1);
                    thread.start();
                }
            }
        }
    }

    protected class HighlightAnnotationMenu
    extends JMenu {
        int start;
        int end;
        AnnotationSet set;
        String setName;
        Annotation annotation;
        Object highlight;

        public HighlightAnnotationMenu(Annotation annotation, AnnotationSet annotationSet) {
            super(annotation.getType());
            this.setToolTipText("<html><b>Features:</b><br>" + (annotation.getFeatures() == null ? "" : annotation.getFeatures().toString()) + "</html>");
            this.annotation = annotation;
            this.set = annotationSet;
            this.setName = this.set.getName() == null ? "Default" : this.set.getName();
            this.start = annotation.getStartNode().getOffset().intValue();
            this.end = annotation.getEndNode().getOffset().intValue();
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    try {
                        HighlightAnnotationMenu.this.highlight = DocumentEditor.this.highlighter.addHighlight(HighlightAnnotationMenu.this.start, HighlightAnnotationMenu.this.end, DefaultHighlighter.DefaultPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException.toString());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (HighlightAnnotationMenu.this.highlight != null) {
                        DocumentEditor.this.highlighter.removeHighlight(HighlightAnnotationMenu.this.highlight);
                        HighlightAnnotationMenu.this.highlight = null;
                    }
                }
            });
            this.add(new AbstractAction(){
                {
                    this.putValue("Name", "Select");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (HighlightAnnotationMenu.this.highlight != null) {
                                DocumentEditor.this.highlighter.removeHighlight(HighlightAnnotationMenu.this.highlight);
                                HighlightAnnotationMenu.this.highlight = null;
                            }
                            DocumentEditor.this.selectAnnotation(HighlightAnnotationMenu.this.setName, HighlightAnnotationMenu.this.annotation);
                        }
                    };
                    Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "AnnotationEditor5");
                    thread.start();
                }
            });
            this.add(new AbstractAction(){
                {
                    this.putValue("Name", "Delete");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (HighlightAnnotationMenu.this.highlight != null) {
                                DocumentEditor.this.highlighter.removeHighlight(HighlightAnnotationMenu.this.highlight);
                                HighlightAnnotationMenu.this.highlight = null;
                            }
                            HighlightAnnotationMenu.this.set.remove(HighlightAnnotationMenu.this.annotation);
                        }
                    };
                    Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "AnnotationEditor5");
                    thread.start();
                }
            });
        }
    }

    public class CustomLabelView
    extends LabelView {
        public CustomLabelView(Element element) {
            super(element);
        }

        public Color getBackground() {
            AttributeSet attributeSet = this.getAttributes();
            if (attributeSet != null) {
                javax.swing.text.Document document = super.getDocument();
                if (document instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)document;
                    return styledDocument.getBackground(attributeSet);
                }
                return null;
            }
            return null;
        }
    }

    class SelectionBlinker
    implements Runnable {
        ArrayList actualHighlights = new ArrayList();
        Thread thread;
        Highlighter.Highlight[] highlights;

        SelectionBlinker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Highlighter highlighter = DocumentEditor.this.selectionHighlighter;
            synchronized (highlighter) {
                this.highlights = DocumentEditor.this.selectionHighlighter.getHighlights();
            }
            while (this.highlights != null && this.highlights.length > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectionBlinker.this.showHighlights();
                    }
                });
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace(Err.getPrintWriter());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectionBlinker.this.hideHighlights();
                    }
                });
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace(Err.getPrintWriter());
                }
                highlighter = DocumentEditor.this.selectionHighlighter;
                synchronized (highlighter) {
                    this.highlights = DocumentEditor.this.selectionHighlighter.getHighlights();
                }
            }
            highlighter = DocumentEditor.this.selectionHighlighter;
            synchronized (highlighter) {
                this.thread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void testAndStart() {
            Highlighter highlighter = DocumentEditor.this.selectionHighlighter;
            synchronized (highlighter) {
                if (this.thread == null) {
                    this.thread = new Thread(Thread.currentThread().getThreadGroup(), this, "AnnotationEditor2");
                    this.thread.setPriority(1);
                    this.thread.start();
                }
            }
        }

        protected void showHighlights() {
            this.actualHighlights.clear();
            try {
                for (int i = 0; i < this.highlights.length; ++i) {
                    this.actualHighlights.add(DocumentEditor.this.highlighter.addHighlight(this.highlights[i].getStartOffset(), this.highlights[i].getEndOffset(), this.highlights[i].getPainter()));
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(Err.getPrintWriter());
            }
        }

        protected void hideHighlights() {
            Iterator iterator = this.actualHighlights.iterator();
            while (iterator.hasNext()) {
                DocumentEditor.this.highlighter.removeHighlight(iterator.next());
            }
        }
    }

    class SwingDocumentListener
    implements DocumentListener {
        SwingDocumentListener() {
        }

        public void insertUpdate(final DocumentEvent documentEvent) {
            try {
                DocumentEditor.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset()), new DocumentContentImpl(documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength())));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentEditor.this.annotationsTable.repaint();
                        DocumentEditor.this.repairHighlights(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength());
                    }
                });
                this.updateBlinks();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(Err.getPrintWriter());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            try {
                DocumentEditor.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset() + documentEvent.getLength()), new DocumentContentImpl(""));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentEditor.this.annotationsTable.repaint();
                    }
                });
                this.updateBlinks();
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateBlinks() {
            int[] nArray = DocumentEditor.this.annotationsTable.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                DocumentEditor.this.selectionHighlighter.removeAllHighlights();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = ((Long)DocumentEditor.this.annotationsTable.getModel().getValueAt(nArray[i], 2)).intValue();
                    int n2 = ((Long)DocumentEditor.this.annotationsTable.getModel().getValueAt(nArray[i], 3)).intValue();
                    n += DocumentEditor.this.longLinesCorrection(n);
                    n2 += DocumentEditor.this.longLinesCorrection(n2);
                    try {
                        Highlighter highlighter = DocumentEditor.this.selectionHighlighter;
                        synchronized (highlighter) {
                            DocumentEditor.this.selectionHighlighter.addHighlight(n, n2, DefaultHighlighter.DefaultPainter);
                            continue;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException.toString());
                    }
                }
            }
        }
    }

    class EventsHandler
    implements gate.event.DocumentListener,
    AnnotationSetListener {
        EventsHandler() {
        }

        public void annotationSetAdded(gate.event.DocumentEvent documentEvent) {
            String string = documentEvent.getAnnotationSetName();
            AnnotationSet annotationSet = string == null ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(string);
            annotationSet.addAnnotationSetListener(this);
            if (string == null) {
                string = "Default";
            }
            TypeData typeData = new TypeData(string, null, false);
            typeData.setAnnotations(annotationSet);
            SwingUtilities.invokeLater(new NodeAdder(typeData));
            ArrayList<String> arrayList = new ArrayList<String>(annotationSet.getAllTypes());
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                TypeData typeData2 = new TypeData(string, string2, false);
                AnnotationSet annotationSet2 = annotationSet.get(string2);
                typeData2.setAnnotations(annotationSet2);
                SwingUtilities.invokeLater(new NodeAdder(typeData2));
            }
        }

        public void annotationSetRemoved(gate.event.DocumentEvent documentEvent) {
            SwingUtilities.invokeLater(new SetRemovedOperation(documentEvent.getAnnotationSetName()));
        }

        public void contentEdited(gate.event.DocumentEvent documentEvent) {
        }

        public void annotationAdded(AnnotationSetEvent annotationSetEvent) {
            AnnotationSet annotationSet = (AnnotationSet)annotationSetEvent.getSource();
            String string = annotationSet.getName();
            if (string == null) {
                string = "Default";
            }
            Annotation annotation = annotationSetEvent.getAnnotation();
            String string2 = annotation.getType();
            TypeData typeData = DocumentEditor.this.getTypeData(string, string2);
            boolean bl = false;
            if (typeData != null) {
                if (typeData.getVisible()) {
                    DocumentEditor.this.data.add(((TypeData)typeData).range.end, annotation);
                    ++((TypeData)typeData).range.end;
                    for (Range range : DocumentEditor.this.ranges.subList(DocumentEditor.this.ranges.indexOf(typeData.range) + 1, DocumentEditor.this.ranges.size())) {
                        ++range.start;
                        ++range.end;
                    }
                    bl = true;
                    SwingUtilities.invokeLater(new HihglightsShower(annotation, DocumentEditor.this.textPane.getStyle("_" + string + "." + string2 + "_")));
                }
            } else {
                HashMap<String, TypeData> hashMap = (HashMap<String, TypeData>)DocumentEditor.this.typeDataMap.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap<String, TypeData>();
                    DocumentEditor.this.typeDataMap.put(string, hashMap);
                }
                typeData = new TypeData(string, string2, false);
                typeData.setAnnotations(annotationSet.get(string2));
                hashMap.put(string2, typeData);
                SwingUtilities.invokeLater(new NodeAdder(typeData));
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DocumentEditor.this.annotationsTableModel != null) {
                            DocumentEditor.this.annotationsTableModel.fireTableDataChanged();
                        }
                    }
                });
            }
        }

        public void annotationRemoved(AnnotationSetEvent annotationSetEvent) {
            AnnotationSet annotationSet = (AnnotationSet)annotationSetEvent.getSource();
            String string = annotationSet.getName();
            if (string == null) {
                string = "Default";
            }
            Annotation annotation = annotationSetEvent.getAnnotation();
            String string2 = annotation.getType();
            TypeData typeData = DocumentEditor.this.getTypeData(string, string2);
            boolean bl = false;
            if (typeData != null) {
                if (typeData.getVisible()) {
                    DocumentEditor.this.data.remove(annotation);
                    --((TypeData)typeData).range.end;
                    for (Range range : DocumentEditor.this.ranges.subList(DocumentEditor.this.ranges.indexOf(typeData.range) + 1, DocumentEditor.this.ranges.size())) {
                        --range.start;
                        --range.end;
                    }
                    bl = true;
                }
                SwingUtilities.invokeLater(new HighlightsRemover(annotation));
                if (typeData.annotations.size() == 1 && typeData.annotations.iterator().next() == annotation || typeData.annotations.size() == 0) {
                    SwingUtilities.invokeLater(new NodeRemover(typeData));
                    Map map = (Map)DocumentEditor.this.typeDataMap.get(string);
                    map.remove(typeData.getType());
                }
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DocumentEditor.this.annotationsTableModel != null) {
                            DocumentEditor.this.annotationsTableModel.fireTableDataChanged();
                        }
                    }
                });
            }
        }

        class SetRemovedOperation
        implements Runnable {
            String setName;

            SetRemovedOperation(String string) {
                this.setName = string;
            }

            public void run() {
                Enumeration<TreeNode> enumeration = DocumentEditor.this.stylesTreeRoot.children();
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                boolean bl = false;
                while (!bl && enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    bl = ((TypeData)defaultMutableTreeNode.getUserObject()).getSet().equals(this.setName);
                }
                if (!((TypeData)defaultMutableTreeNode.getUserObject()).getSet().equals(this.setName)) {
                    throw new GateRuntimeException("Could not find the tree node for the " + this.setName + " annotation set!");
                }
                boolean bl2 = false;
                Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode.children();
                while (enumeration2.hasMoreElements()) {
                    Object object2;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration2.nextElement();
                    TypeData typeData = (TypeData)defaultMutableTreeNode2.getUserObject();
                    if (!typeData.getVisible()) continue;
                    DocumentEditor.this.data.subList(((TypeData)typeData).range.start, ((TypeData)typeData).range.end).clear();
                    int n = ((TypeData)typeData).range.end - ((TypeData)typeData).range.start;
                    for (Object object2 : DocumentEditor.this.ranges.subList(DocumentEditor.this.ranges.indexOf(typeData.range) + 1, DocumentEditor.this.ranges.size())) {
                        ((Range)object2).start -= n;
                        ((Range)object2).end -= n;
                    }
                    DocumentEditor.this.ranges.remove(typeData.range);
                    bl2 = true;
                    object2 = typeData.getAnnotations().iterator();
                    while (object2.hasNext()) {
                        Annotation annotation = (Annotation)object2.next();
                        new HighlightsRemover(annotation).run();
                    }
                }
                if (bl2 && DocumentEditor.this.annotationsTableModel != null) {
                    DocumentEditor.this.annotationsTableModel.fireTableDataChanged();
                }
                DocumentEditor.this.typeDataMap.remove(this.setName);
                DocumentEditor.this.stylesTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
        }

        class NodeAdder
        implements Runnable {
            TypeData tData;

            NodeAdder(TypeData typeData) {
                this.tData = typeData;
            }

            public void run() {
                int n;
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.tData, this.tData.getType() == null);
                this.tData.setNode(defaultMutableTreeNode);
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (this.tData.getType() == null) {
                    defaultMutableTreeNode2 = DocumentEditor.this.stylesTreeRoot;
                } else {
                    if (DocumentEditor.this.stylesTreeRoot.getChildCount() == 0) {
                        return;
                    }
                    for (defaultMutableTreeNode2 = (DefaultMutableTreeNode)DocumentEditor.this.stylesTreeRoot.getFirstChild(); defaultMutableTreeNode2 != null && !((TypeData)defaultMutableTreeNode2.getUserObject()).getSet().equals(this.tData.getSet()); defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextSibling()) {
                    }
                }
                if (this.tData.getType() == null) {
                    for (n = 0; n < defaultMutableTreeNode2.getChildCount() && ((TypeData)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n)).getUserObject()).getSet().compareTo(this.tData.getSet()) < 0; ++n) {
                    }
                } else {
                    while (n < defaultMutableTreeNode2.getChildCount() && ((TypeData)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n)).getUserObject()).getType().compareTo(this.tData.getType()) < 0) {
                        ++n;
                    }
                }
                DocumentEditor.this.stylesTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n);
                if (this.tData.getType() == null) {
                    DocumentEditor.this.stylesTree.expandPath(new TreePath(new Object[]{DocumentEditor.this.stylesTreeRoot, defaultMutableTreeNode}));
                }
            }
        }

        class NodeRemover
        implements Runnable {
            TypeData tData;

            NodeRemover(TypeData typeData) {
                this.tData = typeData;
            }

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = this.tData.getNode();
                if (defaultMutableTreeNode != null) {
                    DocumentEditor.this.stylesTreeModel.removeNodeFromParent(this.tData.getNode());
                } else {
                    Err.prln("Could not find node for " + this.tData.set + "->" + this.tData.type);
                }
            }
        }

        class HihglightsShower
        implements Runnable {
            Annotation ann;
            Style style;

            HihglightsShower(Annotation annotation, Style style) {
                this.ann = annotation;
                this.style = style;
            }

            public void run() {
                DocumentEditor.this.textPane.select(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
                DocumentEditor.this.textPane.setCharacterAttributes(this.style, true);
            }
        }

        class HighlightsRemover
        implements Runnable {
            Annotation ann;

            HighlightsRemover(Annotation annotation) {
                this.ann = annotation;
            }

            public void run() {
                int n = DocumentEditor.this.textPane.getSelectionStart();
                int n2 = DocumentEditor.this.textPane.getSelectionEnd();
                DocumentEditor.this.textPane.select(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
                DocumentEditor.this.textPane.setCharacterAttributes(DocumentEditor.this.textPane.getStyle("default"), true);
                DocumentEditor.this.textPane.select(n, n2);
            }
        }
    }

    class Range
    implements Comparable {
        String setName;
        String type;
        int start;
        int end;

        public Range(String string, String string2, int n, int n2) {
            this.setName = string;
            this.type = string2;
            this.start = n;
            this.end = n2;
        }

        public String toString() {
            return this.setName + ", " + this.type + " (" + this.start + ", " + this.end + ")";
        }

        public int compareTo(Object object) {
            if (object instanceof Range) {
                return this.start - ((Range)object).start;
            }
            throw new ClassCastException("Can't compare a " + object.getClass() + " to a " + this.getClass() + "!");
        }
    }

    public class TypeData {
        private String set;
        private String type;
        private boolean visible;
        private Style style;
        private Style middleStyle;
        private Style actualStyle;
        private Set annotations = null;
        private Range range = null;
        private DefaultMutableTreeNode node = null;

        public TypeData(String string, String string2, boolean bl) {
            this.set = string;
            this.type = string2;
            this.visible = bl;
            HashMap<String, TypeData> hashMap = (HashMap<String, TypeData>)DocumentEditor.this.typeDataMap.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, TypeData>();
                DocumentEditor.this.typeDataMap.put(string, hashMap);
            }
            if (string2 == null) {
                this.style = DocumentEditor.this.textPane.addStyle(string, DocumentEditor.this.textPane.getStyle("default"));
            } else {
                this.style = DocumentEditor.this.textPane.addStyle(string + "." + string2, DocumentEditor.this.textPane.getStyle(string));
                StyleConstants.setBackground(this.style, DocumentEditor.this.colGenerator.getNextColor().brighter());
                this.middleStyle = bl ? DocumentEditor.this.textPane.addStyle("_" + string + "." + string2, this.style) : DocumentEditor.this.textPane.addStyle("_" + string + "." + string2, DocumentEditor.this.textPane.getStyle("default"));
                this.actualStyle = DocumentEditor.this.textPane.addStyle("_" + string + "." + string2 + "_", DocumentEditor.this.textPane.getStyle("_" + string + "." + string2));
                hashMap.put(string2, this);
            }
        }

        public String getSet() {
            return this.set;
        }

        public void setSet(String string) {
            this.set = string;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.type == null ? this.set + " annotations" : this.type;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            if (this.visible == bl) {
                return;
            }
            this.visible = bl;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (TypeData.this.visible) {
                        List list = DocumentEditor.this.data;
                        synchronized (list) {
                            TypeData.this.range = new Range(TypeData.this.set, TypeData.this.type, DocumentEditor.this.data.size(), DocumentEditor.this.data.size() + TypeData.this.annotations.size());
                            DocumentEditor.this.ranges.add(TypeData.this.range);
                            DocumentEditor.this.data.addAll(TypeData.this.annotations);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DocumentEditor.this.annotationsTableModel.fireTableDataChanged();
                                }
                            });
                        }
                        TypeData.this.middleStyle.setResolveParent(TypeData.this.style);
                        DocumentEditor.this.showHighlights(TypeData.this.annotations, TypeData.this.actualStyle);
                    } else {
                        Collections.sort(DocumentEditor.this.ranges);
                        Iterator iterator = DocumentEditor.this.ranges.iterator();
                        while (iterator.hasNext()) {
                            Range range = (Range)iterator.next();
                            if (range != TypeData.this.range) continue;
                            iterator.remove();
                            int n = ((TypeData)TypeData.this).range.end - ((TypeData)TypeData.this).range.start;
                            DocumentEditor.this.data.subList(((TypeData)TypeData.this).range.start, ((TypeData)TypeData.this).range.end).clear();
                            while (iterator.hasNext()) {
                                range = (Range)iterator.next();
                                range.start -= n;
                                range.end -= n;
                            }
                        }
                        TypeData.this.range = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DocumentEditor.this.annotationsTableModel.fireTableDataChanged();
                            }
                        });
                        TypeData.this.middleStyle.setResolveParent(DocumentEditor.this.textPane.getStyle("default"));
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "AnnotationEditor4");
            thread.setPriority(1);
            thread.start();
        }

        public AttributeSet getAttributes() {
            return this.style;
        }

        private AttributeSet getActualStyle() {
            return this.actualStyle;
        }

        public void setAttributes(AttributeSet attributeSet) {
            this.style.removeAttributes(this.style.copyAttributes());
            this.style.addAttributes(attributeSet);
        }

        public void setAnnotations(Set set) {
            this.annotations = set;
        }

        public Set getAnnotations() {
            return this.annotations;
        }

        public void setNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.node = defaultMutableTreeNode;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.getTitle();
        }
    }

    class NodeRenderer1
    extends LazyJPanel
    implements TreeCellRenderer {
        Border selectedBorder;
        Border normalBorder;
        JCheckBox visibleChk;
        JTextPane textComponent;
        Component spacer;

        public NodeRenderer1() {
            this.visibleChk = new JCheckBox("", false);
            this.visibleChk.setOpaque(false);
            this.visibleChk.setBorderPaintedFlat(true);
            this.textComponent = new JTextPane();
            this.selectedBorder = BorderFactory.createLineBorder(Color.blue, 1);
            this.normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.spacer = Box.createHorizontalStrut(3);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.removeAll();
            this.add(this.spacer);
            int n2 = this.spacer.getWidth();
            this.textComponent.setSize(1000, 1000);
            TypeData typeData = (TypeData)((DefaultMutableTreeNode)object).getUserObject();
            if (typeData != null) {
                this.textComponent.setText(typeData.getTitle());
                this.textComponent.selectAll();
                this.textComponent.setCharacterAttributes(typeData.getAttributes(), false);
                this.textComponent.select(0, 0);
                if (typeData.getType() != null) {
                    this.visibleChk.setSelected(typeData.getVisible());
                    this.add(this.visibleChk);
                    n2 += this.visibleChk.getMinimumSize().width;
                }
            } else {
                this.textComponent.setText(object == null || object.toString() == null ? "" : object.toString());
            }
            this.setTextComponentSize(this.textComponent);
            this.add(this.textComponent);
            n2 += this.textComponent.getPreferredSize().width;
            if (bl) {
                this.setBorder(this.selectedBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
            this.setPreferredSize(null);
            this.setPreferredSize(new Dimension(n2 += this.getInsets().left + this.getInsets().right, super.getPreferredSize().height));
            return this;
        }

        protected void setTextComponentSize(JTextComponent jTextComponent) {
            try {
                Cloneable cloneable;
                if (jTextComponent.getDocument() == null || jTextComponent.getDocument().getLength() <= 0) {
                    return;
                }
                int n = 0;
                Rectangle rectangle = jTextComponent.modelToView(0);
                int n2 = rectangle.height;
                int n3 = jTextComponent.getDocument().getLength();
                if (n3 > 0 && (cloneable = jTextComponent.modelToView(n3)) != null) {
                    n = rectangle.x < ((Rectangle)cloneable).x ? ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - rectangle.x : rectangle.x + rectangle.width - ((Rectangle)cloneable).x;
                    n2 = Math.max(n2, ((Rectangle)cloneable).height);
                }
                cloneable = jTextComponent.getInsets();
                Dimension dimension = new Dimension(n + cloneable.left + cloneable.right + 5, n2 + cloneable.top + cloneable.bottom);
                jTextComponent.setPreferredSize(dimension);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class NodeRenderer
    extends LazyJPanel
    implements TreeCellRenderer {
        Border selectedBorder;
        Border normalBorder;
        JCheckBox visibleChk;
        JLabel label;
        Map fontAttrs;
        Component spacer;

        public NodeRenderer() {
            this.visibleChk = new JCheckBox("", false);
            this.visibleChk.setOpaque(false);
            this.visibleChk.setBorderPaintedFlat(true);
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.fontAttrs = new HashMap();
            this.selectedBorder = BorderFactory.createLineBorder(Color.blue, 1);
            this.normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.spacer = Box.createHorizontalStrut(3);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.removeAll();
            this.add(this.spacer);
            int n2 = this.spacer.getWidth();
            TypeData typeData = (TypeData)((DefaultMutableTreeNode)object).getUserObject();
            if (typeData != null) {
                this.label.setText(typeData.getTitle());
                this.setLabelAttributes(typeData.getAttributes());
                if (typeData.getType() != null) {
                    this.visibleChk.setSelected(typeData.getVisible());
                    this.add(this.visibleChk);
                    n2 += this.visibleChk.getMinimumSize().width;
                }
            } else {
                this.label.setText(object == null || object.toString() == null ? "" : object.toString());
            }
            this.add(this.label);
            if (bl) {
                this.setBorder(this.selectedBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
            return this;
        }

        protected void setLabelAttributes(AttributeSet attributeSet) {
            this.label.setForeground(StyleConstants.getForeground(attributeSet));
            this.label.setBackground(StyleConstants.getBackground(attributeSet));
            this.fontAttrs.clear();
            this.fontAttrs.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attributeSet));
            this.fontAttrs.put(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(attributeSet)));
            if (StyleConstants.isBold(attributeSet)) {
                this.fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                this.fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
            if (StyleConstants.isItalic(attributeSet)) {
                this.fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                this.fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            }
            if (StyleConstants.isUnderline(attributeSet)) {
                this.fontAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else {
                this.fontAttrs.remove(TextAttribute.UNDERLINE);
            }
            if (StyleConstants.isStrikeThrough(attributeSet)) {
                this.fontAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                this.fontAttrs.remove(TextAttribute.STRIKETHROUGH);
            }
            if (StyleConstants.isSuperscript(attributeSet)) {
                this.fontAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            } else if (StyleConstants.isSubscript(attributeSet)) {
                this.fontAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            } else {
                this.fontAttrs.remove(TextAttribute.SUPERSCRIPT);
            }
            this.label.setFont(new Font(this.fontAttrs));
        }
    }

    class CorefNodeRenderer1
    implements TreeCellRenderer {
        JLabel label = new JLabel();
        JToggleButton toggleButton;
        JPanel panel;
        Border selectedBorder;
        Border normalBorder;
        Component topSpacer;
        Component bottomSpacer;

        CorefNodeRenderer1() {
            this.label.setOpaque(true);
            this.toggleButton = new JToggleButton();
            this.toggleButton.setMargin(new Insets(0, 3, 0, 3));
            this.panel = new LazyJPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setOpaque(false);
            this.topSpacer = Box.createVerticalStrut(2);
            this.bottomSpacer = Box.createVerticalStrut(2);
            this.selectedBorder = BorderFactory.createLineBorder(Color.blue, 1);
            this.normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.panel.removeAll();
            this.panel.add(this.topSpacer);
            if (object instanceof DefaultMutableTreeNode) {
                object = ((DefaultMutableTreeNode)object).getUserObject();
            }
            if (object instanceof CorefData) {
                CorefData corefData = (CorefData)object;
                this.toggleButton.setSelected(corefData.getVisible());
                this.toggleButton.setBackground(corefData.getColour());
                this.toggleButton.setForeground(jTree.getForeground());
                this.toggleButton.setText(corefData.getTitle());
                this.toggleButton.setFont(jTree.getFont());
                this.panel.add(this.toggleButton);
            } else {
                this.label.setText(object.toString());
                this.label.setForeground(jTree.getForeground());
                this.label.setBackground(jTree.getBackground());
                this.label.setFont(jTree.getFont());
                this.panel.add(this.label);
            }
            this.panel.add(this.bottomSpacer);
            if (bl) {
                this.panel.setBorder(this.selectedBorder);
            } else {
                this.panel.setBorder(this.normalBorder);
            }
            return this.panel;
        }
    }

    class CorefNodeRenderer
    implements TreeCellRenderer {
        JLabel label = new JLabel();
        JCheckBox checkBox;
        JPanel panel;
        JPanel hBox;
        Border selectedBorder;
        Border normalBorder;
        Component leftSpacer;
        Component rightSpacer;

        CorefNodeRenderer() {
            this.label.setOpaque(true);
            this.checkBox = new JCheckBox();
            this.checkBox.setBorderPaintedFlat(true);
            this.panel = new LazyJPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setOpaque(false);
            this.hBox = new LazyJPanel();
            this.hBox.setLayout(new BoxLayout(this.hBox, 0));
            this.hBox.setOpaque(false);
            this.panel.add(Box.createVerticalStrut(2));
            this.panel.add(this.hBox);
            this.panel.add(Box.createVerticalStrut(2));
            this.leftSpacer = Box.createHorizontalStrut(3);
            this.rightSpacer = Box.createHorizontalStrut(3);
            this.selectedBorder = BorderFactory.createLineBorder(Color.blue, 1);
            this.normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.hBox.removeAll();
            this.hBox.add(this.leftSpacer);
            if (object instanceof DefaultMutableTreeNode) {
                object = ((DefaultMutableTreeNode)object).getUserObject();
            }
            if (object instanceof CorefData) {
                CorefData corefData = (CorefData)object;
                this.checkBox.setSelected(corefData.getVisible());
                this.checkBox.setBackground(jTree.getBackground());
                this.label.setBackground(corefData.getColour());
                this.label.setForeground(jTree.getForeground());
                this.label.setText(corefData.getTitle());
                this.label.setFont(jTree.getFont());
                this.hBox.add(this.checkBox);
                this.hBox.add(this.label);
                this.hBox.add(this.rightSpacer);
            } else {
                this.label.setText(object == null ? "" : object.toString());
                this.label.setForeground(jTree.getForeground());
                this.label.setBackground(jTree.getBackground());
                this.label.setFont(jTree.getFont());
                this.hBox.add(this.label);
            }
            if (bl) {
                this.panel.setBorder(this.selectedBorder);
            } else {
                this.panel.setBorder(this.normalBorder);
            }
            return this.panel;
        }
    }

    class LazyJPanel
    extends JPanel {
        LazyJPanel() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        public void firePropertyChange(String string, byte by, byte by2) {
        }

        public void firePropertyChange(String string, char c, char c2) {
        }

        public void firePropertyChange(String string, short s, short s2) {
        }

        public void firePropertyChange(String string, int n, int n2) {
        }

        public void firePropertyChange(String string, long l, long l2) {
        }

        public void firePropertyChange(String string, float f, float f2) {
        }

        public void firePropertyChange(String string, double d, double d2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    protected class CorefData {
        private boolean visible;
        private String title;
        private String setName;
        private Color colour;
        private List highlights;
        private List annotationIDs;

        CorefData(List list, boolean bl, String string) {
            this.visible = bl;
            this.setName = string;
            this.colour = DocumentEditor.this.colGenerator.getNextColor();
            this.highlights = new ArrayList();
            this.annotationIDs = list;
            this.title = this.getNameForCorefList(list);
        }

        String getNameForCorefList(List list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            Integer n = (Integer)list.get(0);
            AnnotationSet annotationSet = this.setName.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(this.setName);
            Annotation annotation = annotationSet.get(n);
            String string = null;
            try {
                string = DocumentEditor.this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
            }
            catch (InvalidOffsetException invalidOffsetException) {
                // empty catch block
            }
            return string;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void removeAnnotations() {
            AnnotationSet annotationSet = this.setName.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(this.setName);
            Iterator iterator = this.annotationIDs.iterator();
            while (iterator.hasNext()) {
                annotationSet.remove(annotationSet.get((Integer)iterator.next()));
            }
            ((List)((Map)DocumentEditor.this.document.getFeatures().get("MatchesAnnots")).get(this.setName.equals("Default") ? null : this.setName)).remove(this.annotationIDs);
            this.annotationIDs.clear();
            DocumentEditor.this.updateCorefTree();
        }

        public void setVisible(boolean bl) {
            if (this.visible == bl) {
                return;
            }
            this.visible = bl;
            if (this.visible) {
                AnnotationSet annotationSet = this.setName.equals("Default") ? DocumentEditor.this.document.getAnnotations() : DocumentEditor.this.document.getAnnotations(this.setName);
                Iterator iterator = this.annotationIDs.iterator();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    Annotation annotation = annotationSet.get(n);
                    if (annotation == null) {
                        arrayList.add(n);
                        continue;
                    }
                    try {
                        this.highlights.add(DocumentEditor.this.highlighter.addHighlight(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(this.colour)));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (!arrayList.isEmpty()) {
                    this.annotationIDs.removeAll(arrayList);
                }
            } else if (!this.highlights.isEmpty()) {
                Iterator iterator = this.highlights.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    DocumentEditor.this.highlighter.removeHighlight(e);
                    iterator.remove();
                }
            }
        }

        public String getTitle() {
            return this.title;
        }

        public Color getColour() {
            return this.colour;
        }

        public void setColour(Color color) {
            this.colour = color;
            if (this.visible) {
                this.setVisible(false);
                this.setVisible(true);
            }
        }

        public List getAnnoationIDs() {
            return this.annotationIDs;
        }

        public String getSetName() {
            return this.setName;
        }

        public String toString() {
            return this.title;
        }

        public void setAnnotationIDs(List list) {
            this.annotationIDs = list;
            this.title = this.getNameForCorefList(this.annotationIDs);
            if (this.visible) {
                this.setVisible(false);
                this.setVisible(true);
            }
        }
    }

    protected class AnnotationsTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return DocumentEditor.this.data.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Set";
                }
                case 2: {
                    return "Start";
                }
                case 3: {
                    return "End";
                }
                case 4: {
                    return "Features";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return Long.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public Object getValueAt(int n, int n2) {
            Annotation annotation = (Annotation)DocumentEditor.this.data.get(n);
            switch (n2) {
                case -1: {
                    return annotation;
                }
                case 0: {
                    return annotation.getType();
                }
                case 1: {
                    for (Range range : DocumentEditor.this.ranges) {
                        if (range.start > n || n >= range.end) continue;
                        return range.setName;
                    }
                    return "?";
                }
                case 2: {
                    return annotation.getStartNode().getOffset();
                }
                case 3: {
                    return annotation.getEndNode().getOffset();
                }
                case 4: {
                    if (annotation.getFeatures() == null) {
                        return null;
                    }
                    return annotation.getFeatures().toString();
                }
            }
            return null;
        }
    }
}

