/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.gui.AnnotationDiffGUI;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.AnnotationDiffer;
import gate.util.ClassificationMeasures;
import gate.util.ExtensionFileFilter;
import gate.util.OntologyMeasures;
import gate.util.OptionsMap;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.Position;

@CreoleResource(name="Corpus Quality Assurance", guiType=GuiType.LARGE, resourceDisplayed="gate.Corpus", mainViewer=false, helpURL="http://gate.ac.uk/userguide/sec:eval:corpusqualityassurance")
public class CorpusQualityAssurance
extends AbstractVisualResource
implements CorpusListener {
    protected Corpus corpus;
    protected boolean corpusChanged;
    protected TreeSet<String> types;
    protected final Map<String, TreeMap<String, TreeMap<String, TreeSet<String>>>> docsSetsTypesFeatures = Collections.synchronizedMap(new LinkedHashMap());
    protected ArrayList<HashMap<String, AnnotationDiffer>> differsByDocThenType = new ArrayList();
    protected ArrayList<String> documentNames = new ArrayList();
    protected String keySetName;
    protected String responseSetName;
    protected Object[] typesSelected;
    protected Object[] featuresSelected;
    protected Timer timer = new Timer("CorpusQualityAssurance", true);
    protected TimerTask timerTask;
    protected Thread readSetsTypesFeaturesThread;
    protected int measuresType;
    protected static final int FSCORE_MEASURES = 0;
    protected static final int CLASSIFICATION_MEASURES = 1;
    protected Collator collator;
    protected Comparator<String> doubleComparator;
    protected Comparator<String> totalComparator;
    protected OptionsMap userConfig = Gate.getUserConfig();
    protected URL bdmFileUrl;
    protected XJTable documentTable;
    protected DefaultTableModel documentTableModel;
    protected XJTable annotationTable;
    protected DefaultTableModel annotationTableModel;
    protected XJTable document2Table;
    protected DefaultTableModel document2TableModel;
    protected XJTable confusionTable;
    protected DefaultTableModel confusionTableModel;
    protected JTabbedPane tableTabbedPane;
    protected JList setList;
    protected JList typeList;
    protected JList featureList;
    protected JToggleButton optionsButton;
    protected JTabbedPane measureTabbedPane;
    protected JList measureList;
    protected JList measure2List;
    protected JCheckBox setCheck;
    protected JCheckBox typeCheck;
    protected JCheckBox featureCheck;
    protected JProgressBar progressBar;
    protected JCheckBox verboseOptionCheckBox;
    protected OpenDocumentAction openDocumentAction;
    protected OpenAnnotationDiffAction openAnnotationDiffAction;
    protected ExportToHtmlAction exportToHtmlAction;
    protected ReloadCacheAction reloadCacheAction;
    protected CompareAction compareAction;

    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.collator = Collator.getInstance(Locale.ENGLISH);
        this.collator.setStrength(2);
        this.documentTableModel = new DefaultTableModel();
        this.documentTableModel.addColumn("Document");
        this.documentTableModel.addColumn("Match");
        this.documentTableModel.addColumn("Only A");
        this.documentTableModel.addColumn("Only B");
        this.documentTableModel.addColumn("Overlap");
        this.annotationTableModel = new DefaultTableModel();
        this.annotationTableModel.addColumn("Annotation");
        this.annotationTableModel.addColumn("Match");
        this.annotationTableModel.addColumn("Only A");
        this.annotationTableModel.addColumn("Only B");
        this.annotationTableModel.addColumn("Overlap");
        this.document2TableModel = new DefaultTableModel();
        this.document2TableModel.addColumn("Document");
        this.document2TableModel.addColumn("Agreed");
        this.document2TableModel.addColumn("Total");
        this.confusionTableModel = new DefaultTableModel();
        this.types = new TreeSet<Object>(this.collator);
        this.corpusChanged = false;
        this.measuresType = 0;
        this.doubleComparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == null || string2 == null) {
                    return 0;
                }
                if (string.equals("")) {
                    return 1;
                }
                if (string2.equals("")) {
                    return -1;
                }
                return Double.valueOf(string).compareTo(Double.valueOf(string2));
            }
        };
        this.totalComparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == null || string2 == null) {
                    return 0;
                }
                if (string.equals("Micro summary")) {
                    return string2.equals("Macro summary") ? -1 : 1;
                }
                if (string.equals("Macro summary")) {
                    return string2.equals("Micro summary") ? -1 : 1;
                }
                if (string2.equals("Micro summary")) {
                    return string.equals("Macro summary") ? 1 : -1;
                }
                if (string2.equals("Macro summary")) {
                    return string.equals("Micro summary") ? 1 : -1;
                }
                return string.compareTo(string2);
            }
        };
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.openDocumentAction = new OpenDocumentAction();
        jToolBar.add(this.openDocumentAction);
        this.openDocumentAction.setEnabled(false);
        this.openAnnotationDiffAction = new OpenAnnotationDiffAction();
        jToolBar.add(this.openAnnotationDiffAction);
        this.openAnnotationDiffAction.setEnabled(false);
        this.exportToHtmlAction = new ExportToHtmlAction();
        jToolBar.add(this.exportToHtmlAction);
        this.reloadCacheAction = new ReloadCacheAction();
        jToolBar.add(this.reloadCacheAction);
        jToolBar.add(new HelpAction());
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        JLabel jLabel = new JLabel("Annotation Sets A/Key & B/Response");
        jLabel.setToolTipText("aka 'Key & Response sets'");
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.setList = new JList();
        this.setList.setSelectionModel(new ToggleSelectionABModel(this.setList));
        this.setList.setPrototypeCellValue("present in every document");
        this.setList.setVisibleRowCount(4);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.setList), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.setCheck = new JCheckBox("present in every document", false);
        this.setCheck.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorpusQualityAssurance.this.updateSetList();
            }
        });
        jPanel.add((Component)this.setCheck, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        jLabel = new JLabel("Annotation Types");
        jLabel.setToolTipText("Annotation types to compare");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.typeList = new JList();
        this.typeList.setSelectionModel(new ToggleSelectionModel());
        this.typeList.setPrototypeCellValue("present in every document");
        this.typeList.setVisibleRowCount(4);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.typeList), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.typeCheck = new JCheckBox("present in every selected set", false);
        this.typeCheck.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorpusQualityAssurance.this.setList.getListSelectionListeners()[0].valueChanged(null);
            }
        });
        jPanel.add((Component)this.typeCheck, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        jLabel = new JLabel("Annotation Features");
        jLabel.setToolTipText("Annotation features to compare");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.featureList = new JList();
        this.featureList.setSelectionModel(new ToggleSelectionModel());
        this.featureList.setPrototypeCellValue("present in every document");
        this.featureList.setVisibleRowCount(4);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.featureList), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        this.featureCheck = new JCheckBox("present in every selected type", false);
        this.featureCheck.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorpusQualityAssurance.this.typeList.getListSelectionListeners()[0].valueChanged(null);
            }
        });
        jPanel.add((Component)this.featureCheck, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        jLabel = new JLabel("Measures");
        jLabel.setToolTipText("Measures used to compare annotations");
        this.optionsButton = new JToggleButton("Options");
        this.optionsButton.setMargin(new Insets(1, 1, 1, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.optionsButton, "East");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
        final JScrollPane jScrollPane = new JScrollPane();
        this.measureList = new JList();
        this.measureList.setSelectionModel(new ToggleSelectionModel());
        String string = this.getClass().getName() + '.';
        double d = this.userConfig.getDouble(string + "fscorebeta") == null ? 1.0 : this.userConfig.getDouble(string + "fscorebeta");
        double d2 = this.userConfig.getDouble(string + "fscorebeta2") == null ? 0.5 : this.userConfig.getDouble(string + "fscorebeta2");
        String string2 = "F" + d + "-score ";
        String string3 = "F" + d2 + "-score ";
        this.measureList.setModel(new ExtendedListModel(new String[]{string2 + "strict", string2 + "lenient", string2 + "average", string2 + "strict BDM", string2 + "lenient BDM", string2 + "average BDM", string3 + "strict", string3 + "lenient", string3 + "average", string3 + "strict BDM", string3 + "lenient BDM", string3 + "average BDM"}));
        this.measureList.setPrototypeCellValue("present in every document");
        this.measureList.setVisibleRowCount(4);
        jScrollPane.setViewportView(this.measureList);
        final JScrollPane jScrollPane2 = new JScrollPane();
        this.measure2List = new JList();
        this.measure2List.setSelectionModel(new ToggleSelectionModel());
        this.measure2List.setModel(new ExtendedListModel(new String[]{"Observed agreement", "Cohen's Kappa", "Pi's Kappa"}));
        this.measure2List.setPrototypeCellValue("present in every document");
        this.measure2List.setVisibleRowCount(4);
        jScrollPane2.setViewportView(this.measure2List);
        this.measureTabbedPane = new JTabbedPane();
        this.measureTabbedPane.addTab("F-Score", null, jScrollPane, "Inter-annotator agreement");
        this.measureTabbedPane.addTab("Classification", null, jScrollPane2, "Classification agreement");
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.measureTabbedPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        final JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        JLabel jLabel2 = new JLabel("Fscore Beta 1:");
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(d, 0.0, 1.0, 0.1));
        jSpinner.setToolTipText("<html>Relative weight of precision and recall.<ul><li>1 weights equally precision and recall<li>0.5 weights precision twice as much as recall<li>2 weights recall twice as much as precision</ul></html>");
        jPanel4.add(jLabel2);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(jSpinner);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel3.add(jPanel4);
        jSpinner.setMaximumSize(new Dimension(Integer.MAX_VALUE, Math.round((float)jLabel2.getPreferredSize().height * 1.5f)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JLabel jLabel3 = new JLabel("Fscore Beta 2:");
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(d2, 0.0, 1.0, 0.1));
        jSpinner2.setToolTipText(jSpinner.getToolTipText());
        jPanel5.add(jLabel3);
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(jSpinner2);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel3.add(jPanel5);
        jSpinner2.setMaximumSize(new Dimension(Integer.MAX_VALUE, Math.round((float)jLabel3.getPreferredSize().height * 1.5f)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JLabel jLabel4 = new JLabel("BDM file:");
        JButton jButton = new JButton(new SetBdmFileAction());
        jPanel6.add(jLabel4);
        jPanel6.add(Box.createHorizontalStrut(5));
        jPanel6.add(jButton);
        jPanel6.add(Box.createHorizontalGlue());
        jPanel3.add(jPanel6);
        final JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        boolean bl = this.userConfig.getBoolean(string + "verbose") == null ? false : this.userConfig.getBoolean(string + "verbose");
        this.verboseOptionCheckBox = new JCheckBox("Output ignored annotations", bl);
        jPanel8.add(this.verboseOptionCheckBox);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel7.add(jPanel8);
        this.optionsButton.setAction(new AbstractAction("Options"){
            int[] selectedIndices;

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                if (jToggleButton.isSelected()) {
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        this.selectedIndices = CorpusQualityAssurance.this.measureList.getSelectedIndices();
                        jScrollPane.setViewportView(jPanel3);
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        this.selectedIndices = CorpusQualityAssurance.this.measure2List.getSelectedIndices();
                        jScrollPane2.setViewportView(jPanel7);
                    }
                } else {
                    String string = this.getClass().getEnclosingClass().getName() + '.';
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        String string2 = "F" + jSpinner.getValue() + "-score ";
                        String string3 = "F" + jSpinner2.getValue() + "-score ";
                        CorpusQualityAssurance.this.measureList.setModel(new ExtendedListModel(new String[]{string2 + "strict", string2 + "lenient", string2 + "average", string2 + "strict BDM", string2 + "lenient BDM", string2 + "average BDM", string3 + "strict", string3 + "lenient", string3 + "average", string3 + "strict BDM", string3 + "lenient BDM", string3 + "average BDM"}));
                        CorpusQualityAssurance.this.userConfig.put((Object)(string + "fscorebeta"), jSpinner.getValue());
                        CorpusQualityAssurance.this.userConfig.put((Object)(string + "fscorebeta2"), jSpinner2.getValue());
                        jScrollPane.setViewportView(CorpusQualityAssurance.this.measureList);
                        CorpusQualityAssurance.this.measureList.setSelectedIndices(this.selectedIndices);
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        CorpusQualityAssurance.this.userConfig.put((Object)(string + "verbose"), (Object)CorpusQualityAssurance.this.verboseOptionCheckBox.isSelected());
                        jScrollPane2.setViewportView(CorpusQualityAssurance.this.measure2List);
                        CorpusQualityAssurance.this.measure2List.setSelectedIndices(this.selectedIndices);
                    }
                }
            }
        });
        this.compareAction = new CompareAction();
        JButton jButton2 = new JButton(this.compareAction);
        this.compareAction.setEnabled(false);
        jPanel.add((Component)jButton2, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        this.annotationTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        int n = this.columnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
                        if (n == -1) {
                            return null;
                        }
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        String string = this.table.getModel().getColumnName(n2);
                        return CorpusQualityAssurance.this.createToolTipFromColumnName(string);
                    }
                };
            }
        };
        this.annotationTable.setModel(this.annotationTableModel);
        this.annotationTable.setSortable(false);
        this.annotationTable.setEnableHidingColumns(true);
        this.annotationTable.setAutoResizeMode(4);
        this.documentTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        int n = this.columnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
                        if (n == -1) {
                            return null;
                        }
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        String string = this.table.getModel().getColumnName(n2);
                        return CorpusQualityAssurance.this.createToolTipFromColumnName(string);
                    }
                };
            }
        };
        this.documentTable.setModel(this.documentTableModel);
        this.documentTable.setSortable(false);
        this.documentTable.setEnableHidingColumns(true);
        this.documentTable.setAutoResizeMode(4);
        this.document2Table = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.document2Table.setModel(this.document2TableModel);
        this.confusionTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.confusionTable.setModel(this.confusionTableModel);
        this.confusionTable.setSortable(false);
        this.tableTabbedPane = new JTabbedPane();
        this.tableTabbedPane.addTab("Corpus statistics", null, new JScrollPane(this.annotationTable), "Compare each annotation type for the whole corpus");
        this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(this.documentTable), "Compare each documents in the corpus with theirs annotations");
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.8);
        jSplitPane.setLeftComponent(this.tableTabbedPane);
        jSplitPane.setRightComponent(new JScrollPane(jPanel));
        this.add(jSplitPane);
    }

    protected void initListeners() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (!CorpusQualityAssurance.this.isShowing() || !CorpusQualityAssurance.this.corpusChanged) {
                    return;
                }
                if (CorpusQualityAssurance.this.timerTask != null) {
                    CorpusQualityAssurance.this.timerTask.cancel();
                }
                Date date = new Date(System.currentTimeMillis() + 1000L);
                CorpusQualityAssurance.this.timerTask = new TimerTask(){

                    public void run() {
                        CorpusQualityAssurance.this.readSetsTypesFeatures(0);
                    }
                };
                CorpusQualityAssurance.this.timer.schedule(CorpusQualityAssurance.this.timerTask, date);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CorpusQualityAssurance.this.typesSelected == null) {
                    CorpusQualityAssurance.this.typesSelected = CorpusQualityAssurance.this.typeList.getSelectedValues();
                }
                CorpusQualityAssurance.this.typeList.setModel(new ExtendedListModel());
                CorpusQualityAssurance.this.keySetName = ((ToggleSelectionABModel)CorpusQualityAssurance.this.setList.getSelectionModel()).getSelectedValueA();
                CorpusQualityAssurance.this.responseSetName = ((ToggleSelectionABModel)CorpusQualityAssurance.this.setList.getSelectionModel()).getSelectedValueB();
                if (CorpusQualityAssurance.this.keySetName == null || CorpusQualityAssurance.this.responseSetName == null || CorpusQualityAssurance.this.setList.getSelectionModel().getValueIsAdjusting()) {
                    CorpusQualityAssurance.this.compareAction.setEnabled(false);
                    return;
                }
                CorpusQualityAssurance.this.setList.setEnabled(false);
                CorpusQualityAssurance.this.setCheck.setEnabled(false);
                TreeSet<String> treeSet = new TreeSet<String>();
                boolean bl = true;
                Object[] objectArray = CorpusQualityAssurance.this.docsSetsTypesFeatures;
                synchronized (CorpusQualityAssurance.this.docsSetsTypesFeatures) {
                    for (TreeMap<String, TreeMap<String, TreeSet<String>>> treeMap : CorpusQualityAssurance.this.docsSetsTypesFeatures.values()) {
                        TreeMap<String, TreeSet<String>> treeMap2 = treeMap.get(CorpusQualityAssurance.this.keySetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.keySetName);
                        if (treeMap2 != null) {
                            if (CorpusQualityAssurance.this.typeCheck.isSelected() && !bl) {
                                treeSet.retainAll(treeMap2.keySet());
                            } else {
                                treeSet.addAll(treeMap2.keySet());
                            }
                        } else if (CorpusQualityAssurance.this.typeCheck.isSelected()) break;
                        treeMap2 = treeMap.get(CorpusQualityAssurance.this.responseSetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.responseSetName);
                        if (treeMap2 != null) {
                            if (CorpusQualityAssurance.this.typeCheck.isSelected()) {
                                treeSet.retainAll(treeMap2.keySet());
                            } else {
                                treeSet.addAll(treeMap2.keySet());
                            }
                        } else if (CorpusQualityAssurance.this.typeCheck.isSelected()) break;
                        bl = false;
                    }
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    CorpusQualityAssurance.this.typeList.setModel(new ExtendedListModel(treeSet.toArray()));
                    if (treeSet.size() > 0) {
                        for (Object object : CorpusQualityAssurance.this.typesSelected) {
                            int n = CorpusQualityAssurance.this.typeList.getNextMatch((String)object, 0, Position.Bias.Forward);
                            if (n == -1) continue;
                            CorpusQualityAssurance.this.typeList.setSelectedIndex(n);
                        }
                    }
                    CorpusQualityAssurance.this.typesSelected = null;
                    CorpusQualityAssurance.this.setList.setEnabled(true);
                    CorpusQualityAssurance.this.setCheck.setEnabled(true);
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        CorpusQualityAssurance.this.compareAction.setEnabled(true);
                    }
                    return;
                }
            }
        });
        this.typeList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CorpusQualityAssurance.this.featuresSelected == null) {
                    CorpusQualityAssurance.this.featuresSelected = CorpusQualityAssurance.this.featureList.getSelectedValues();
                }
                CorpusQualityAssurance.this.featureList.setModel(new ExtendedListModel());
                if (CorpusQualityAssurance.this.typeList.getSelectedValues().length == 0 || CorpusQualityAssurance.this.typeList.getSelectionModel().getValueIsAdjusting()) {
                    return;
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (Object objectArray2 : CorpusQualityAssurance.this.typeList.getSelectedValues()) {
                    hashSet.add((String)objectArray2);
                }
                CorpusQualityAssurance.this.typeList.setEnabled(false);
                CorpusQualityAssurance.this.typeCheck.setEnabled(false);
                TreeSet<Object> treeSet = new TreeSet<Object>(CorpusQualityAssurance.this.collator);
                int n = 1;
                Map<String, TreeMap<String, TreeMap<String, TreeSet<String>>>> map = CorpusQualityAssurance.this.docsSetsTypesFeatures;
                synchronized (map) {
                    for (TreeMap<String, TreeMap<String, TreeSet<String>>> treeMap : CorpusQualityAssurance.this.docsSetsTypesFeatures.values()) {
                        String n2;
                        Object object;
                        TreeMap<String, TreeSet<String>> treeMap2 = treeMap.get(CorpusQualityAssurance.this.keySetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.keySetName);
                        if (treeMap2 != null) {
                            object = treeMap2.keySet().iterator();
                            while (object.hasNext()) {
                                n2 = object.next();
                                if (!hashSet.contains(n2)) continue;
                                if (CorpusQualityAssurance.this.featureCheck.isSelected() && n == 0) {
                                    treeSet.retainAll((Collection)treeMap2.get(n2));
                                    continue;
                                }
                                treeSet.addAll((Collection)treeMap2.get(n2));
                            }
                        } else if (CorpusQualityAssurance.this.featureCheck.isSelected()) break;
                        if ((treeMap2 = treeMap.get(CorpusQualityAssurance.this.responseSetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.responseSetName)) != null) {
                            object = treeMap2.keySet().iterator();
                            while (object.hasNext()) {
                                n2 = object.next();
                                if (!hashSet.contains(n2)) continue;
                                if (CorpusQualityAssurance.this.featureCheck.isSelected()) {
                                    treeSet.retainAll((Collection)treeMap2.get(n2));
                                    continue;
                                }
                                treeSet.addAll((Collection)treeMap2.get(n2));
                            }
                        } else if (CorpusQualityAssurance.this.featureCheck.isSelected()) break;
                        n = 0;
                    }
                }
                CorpusQualityAssurance.this.featureList.setModel(new ExtendedListModel(treeSet.toArray()));
                if (treeSet.size() > 0) {
                    for (Object object : CorpusQualityAssurance.this.featuresSelected) {
                        int n2 = CorpusQualityAssurance.this.featureList.getNextMatch((String)object, 0, Position.Bias.Forward);
                        if (n2 == -1) continue;
                        CorpusQualityAssurance.this.featureList.setSelectedIndex(n2);
                    }
                }
                CorpusQualityAssurance.this.featuresSelected = null;
                CorpusQualityAssurance.this.typeList.setEnabled(true);
                CorpusQualityAssurance.this.typeCheck.setEnabled(true);
            }
        });
        this.featureList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CorpusQualityAssurance.this.measuresType == 1) {
                    if (CorpusQualityAssurance.this.typeList.getSelectedIndices().length == 1 && CorpusQualityAssurance.this.featureList.getSelectedIndices().length == 1) {
                        CorpusQualityAssurance.this.compareAction.setEnabled(true);
                        CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "Compare annotations between sets A and B");
                    } else {
                        CorpusQualityAssurance.this.compareAction.setEnabled(false);
                        CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "You must select exactly one type and one feature");
                    }
                }
            }
        });
        this.measureTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                CorpusQualityAssurance.this.tableTabbedPane.removeAll();
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(false);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(false);
                if (CorpusQualityAssurance.this.optionsButton.isSelected()) {
                    CorpusQualityAssurance.this.optionsButton.doClick();
                }
                if (jTabbedPane.getTitleAt(n).equals("F-Score")) {
                    CorpusQualityAssurance.this.measuresType = 0;
                    CorpusQualityAssurance.this.compareAction.setEnabled(CorpusQualityAssurance.this.keySetName != null && CorpusQualityAssurance.this.responseSetName != null);
                    CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "Compare annotations between sets A and B");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Corpus statistics", null, new JScrollPane(CorpusQualityAssurance.this.annotationTable), "Compare each annotation type for the whole corpus");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(CorpusQualityAssurance.this.documentTable), "Compare each documents in the corpus with theirs annotations");
                } else {
                    CorpusQualityAssurance.this.measuresType = 1;
                    CorpusQualityAssurance.this.featureList.getListSelectionListeners()[0].valueChanged(null);
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(CorpusQualityAssurance.this.document2Table), "Compare each documents in the corpus with theirs annotations");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Confusion Matrices", null, new JScrollPane(CorpusQualityAssurance.this.confusionTable), "Describe how annotations in one set are classified in the other and vice versa.");
                }
            }
        });
        this.documentTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = CorpusQualityAssurance.this.documentTable.getSelectedRow() != -1 && !((String)CorpusQualityAssurance.this.documentTableModel.getValueAt(CorpusQualityAssurance.this.documentTable.getSelectedRow(), 0)).endsWith("summary");
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(bl);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(bl);
            }
        });
        this.document2Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = CorpusQualityAssurance.this.document2Table.getSelectedRow() != -1 && !((String)CorpusQualityAssurance.this.document2TableModel.getValueAt(CorpusQualityAssurance.this.document2Table.getSelectedRow(), 0)).endsWith("summary");
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(bl);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(bl);
            }
        });
        this.documentTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && CorpusQualityAssurance.this.openDocumentAction.isEnabled()) {
                    CorpusQualityAssurance.this.openDocumentAction.actionPerformed(null);
                }
            }
        });
        this.document2Table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && CorpusQualityAssurance.this.openDocumentAction.isEnabled()) {
                    CorpusQualityAssurance.this.openDocumentAction.actionPerformed(null);
                }
            }
        });
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", new HelpAction());
    }

    protected String createToolTipFromColumnName(String string) {
        String string2 = string.equals("Document") || string.equals("Annotation") ? null : (string.equals("Match") ? "aka Correct" : (string.equals("Only A") ? "aka Missing" : (string.equals("Only B") ? "aka Spurious" : (string.equals("Overlap") ? "aka Partial" : (string.equals("Rec.B/A") ? "Recall for B relative to A" : (string.equals("Prec.B/A") ? "Precision for B relative to A" : string.replaceFirst("s.", "score strict").replaceFirst("l.", "score lenient").replaceFirst("a.", "score average").replaceFirst("B.", " BDM")))))));
        return string2;
    }

    public void cleanup() {
        super.cleanup();
        this.corpus = null;
    }

    public void setTarget(Object object) {
        if (this.corpus != null && this.corpus != object) {
            this.corpus.removeCorpusListener(this);
        }
        if (!(object instanceof Corpus)) {
            throw new IllegalArgumentException("This view can only be used with a GATE corpus!\n" + object.getClass().toString() + " is not a GATE corpus!");
        }
        this.corpus = (Corpus)object;
        this.corpus.addCorpusListener(this);
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date date = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, date);
    }

    public void documentAdded(CorpusEvent corpusEvent) {
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date date = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, date);
    }

    public void documentRemoved(CorpusEvent corpusEvent) {
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date date = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, date);
    }

    protected void readSetsTypesFeatures(final int n) {
        if (!this.isShowing()) {
            return;
        }
        this.corpusChanged = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusQualityAssurance.this.progressBar.setMaximum(CorpusQualityAssurance.this.corpus.size() - 1);
                CorpusQualityAssurance.this.progressBar.setString("Read sets, types, features");
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(false);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(3));
        Runnable runnable = new Runnable(){

            public void run() {
                if (CorpusQualityAssurance.this.docsSetsTypesFeatures.size() != CorpusQualityAssurance.this.corpus.getDocumentNames().size() || !CorpusQualityAssurance.this.docsSetsTypesFeatures.keySet().containsAll(CorpusQualityAssurance.this.corpus.getDocumentNames())) {
                    if (n == 0) {
                        CorpusQualityAssurance.this.docsSetsTypesFeatures.clear();
                    }
                    for (int i = n; i < CorpusQualityAssurance.this.corpus.size(); ++i) {
                        boolean bl = CorpusQualityAssurance.this.corpus.isDocumentLoaded(i);
                        Document document = (Document)CorpusQualityAssurance.this.corpus.get(i);
                        if (document != null && document.getAnnotationSetNames() != null) {
                            TreeMap treeMap = new TreeMap(CorpusQualityAssurance.this.collator);
                            HashSet<String> hashSet = new HashSet<String>(document.getAnnotationSetNames());
                            hashSet.add("");
                            for (String string : hashSet) {
                                TreeMap<Object, TreeSet<Object>> treeMap2 = new TreeMap<Object, TreeSet<Object>>(CorpusQualityAssurance.this.collator);
                                AnnotationSet annotationSet = document.getAnnotations(string);
                                for (String string2 : annotationSet.getAllTypes()) {
                                    TreeSet<Object> treeSet = new TreeSet<Object>(CorpusQualityAssurance.this.collator);
                                    for (Annotation annotation : annotationSet.get(string2)) {
                                        for (Object k : annotation.getFeatures().keySet()) {
                                            treeSet.add((String)k);
                                        }
                                    }
                                    treeMap2.put(string2, treeSet);
                                }
                                treeMap.put(string, treeMap2);
                            }
                            CorpusQualityAssurance.this.docsSetsTypesFeatures.put(document.getName(), treeMap);
                        }
                        if (!bl) {
                            CorpusQualityAssurance.this.corpus.unloadDocument(document);
                            Factory.deleteResource(document);
                        }
                        final int n2 = i + 1;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CorpusQualityAssurance.this.progressBar.setValue(n2);
                                if ((n2 + 1) % 5 == 0) {
                                    CorpusQualityAssurance.this.updateSetList();
                                }
                            }
                        });
                        if (!Thread.interrupted()) continue;
                        return;
                    }
                }
                CorpusQualityAssurance.this.updateSetList();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CorpusQualityAssurance.this.progressBar.setValue(CorpusQualityAssurance.this.progressBar.getMinimum());
                        CorpusQualityAssurance.this.progressBar.setString("");
                        CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                        CorpusQualityAssurance.this.reloadCacheAction.setEnabled(true);
                    }
                });
            }
        };
        this.readSetsTypesFeaturesThread = new Thread(runnable, "readSetsTypesFeatures");
        this.readSetsTypesFeaturesThread.setPriority(1);
        this.readSetsTypesFeaturesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSetList() {
        final TreeSet<Object> treeSet = new TreeSet<Object>(this.collator);
        boolean bl = true;
        Map<String, TreeMap<String, TreeMap<String, TreeSet<String>>>> map = this.docsSetsTypesFeatures;
        synchronized (map) {
            for (String string : this.docsSetsTypesFeatures.keySet()) {
                Set<String> set = this.docsSetsTypesFeatures.get(string).keySet();
                if (!set.isEmpty()) {
                    if (this.setCheck.isSelected() && !bl) {
                        treeSet.retainAll(set);
                    } else {
                        treeSet.addAll(set);
                    }
                } else if (this.setCheck.isSelected()) break;
                bl = false;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                treeSet.remove("");
                treeSet.add("[Default set]");
                String string = CorpusQualityAssurance.this.keySetName;
                String string2 = CorpusQualityAssurance.this.responseSetName;
                CorpusQualityAssurance.this.setList.setModel(new ExtendedListModel(treeSet.toArray()));
                if (treeSet.size() > 0) {
                    int n;
                    if (string != null && (n = CorpusQualityAssurance.this.setList.getNextMatch(string, 0, Position.Bias.Forward)) != -1) {
                        CorpusQualityAssurance.this.setList.setSelectedIndex(n);
                    }
                    if (string2 != null && (n = CorpusQualityAssurance.this.setList.getNextMatch(string2, 0, Position.Bias.Forward)) != -1) {
                        CorpusQualityAssurance.this.setList.setSelectedIndex(n);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void compareAnnotation() {
        List<String> list;
        int n = -1;
        if (this.readSetsTypesFeaturesThread != null && this.readSetsTypesFeaturesThread.isAlive()) {
            n = this.progressBar.getValue();
            this.readSetsTypesFeaturesThread.interrupt();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusQualityAssurance.this.progressBar.setMaximum(CorpusQualityAssurance.this.corpus.size() - 1);
                CorpusQualityAssurance.this.progressBar.setString("Compare annotations");
                CorpusQualityAssurance.this.setList.setEnabled(false);
                CorpusQualityAssurance.this.setCheck.setEnabled(false);
                CorpusQualityAssurance.this.typeList.setEnabled(false);
                CorpusQualityAssurance.this.typeCheck.setEnabled(false);
                CorpusQualityAssurance.this.featureList.setEnabled(false);
                CorpusQualityAssurance.this.featureCheck.setEnabled(false);
                CorpusQualityAssurance.this.optionsButton.setEnabled(false);
                CorpusQualityAssurance.this.measureTabbedPane.setEnabled(false);
                CorpusQualityAssurance.this.measureList.setEnabled(false);
                CorpusQualityAssurance.this.exportToHtmlAction.setEnabled(false);
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(false);
            }
        });
        boolean bl = false;
        if (this.measuresType == 0) {
            this.differsByDocThenType.clear();
            this.documentNames.clear();
            for (Object object2 : this.measureList.getSelectedValues()) {
                if (!((String)object2).contains("BDM")) continue;
                bl = true;
                break;
            }
        }
        Object[] objectArray = new ArrayList();
        ArrayList<OntologyMeasures> arrayList = new ArrayList<OntologyMeasures>();
        ArrayList<OntologyMeasures> arrayList2 = new ArrayList<OntologyMeasures>();
        for (int i = 0; i < this.corpus.size(); ++i) {
            Object object;
            void var10_26;
            Object object2;
            Object object32;
            boolean bl2 = this.corpus.isDocumentLoaded(i);
            Document serializable2 = (Document)this.corpus.get(i);
            this.documentNames.add(serializable2.getName());
            list = new HashSet();
            HashSet hashSet = new HashSet();
            if (this.keySetName.equals("[Default set]")) {
                list = serializable2.getAnnotations();
            } else if (serializable2.getAnnotationSetNames() != null && serializable2.getAnnotationSetNames().contains(this.keySetName)) {
                list = serializable2.getAnnotations(this.keySetName);
            }
            if (this.responseSetName.equals("[Default set]")) {
                AnnotationSet annotationSet = serializable2.getAnnotations();
            } else if (serializable2.getAnnotationSetNames() != null && serializable2.getAnnotationSetNames().contains(this.responseSetName)) {
                AnnotationSet annotationSet = serializable2.getAnnotations(this.responseSetName);
            }
            if (!bl2) {
                this.corpus.unloadDocument(serializable2);
                Factory.deleteResource(serializable2);
            }
            if (this.measuresType == 0) {
                List<String> list2;
                this.types.clear();
                for (Object object32 : this.typeList.getSelectedValues()) {
                    this.types.add((String)object32);
                }
                if (this.typeList.isSelectionEmpty()) {
                    for (int j = 0; j < this.typeList.getModel().getSize(); ++j) {
                        this.types.add((String)this.typeList.getModel().getElementAt(j));
                    }
                }
                HashSet hashSet2 = new HashSet();
                for (Object object4 : this.featureList.getSelectedValues()) {
                    hashSet2.add((String)object4);
                }
                object2 = new HashMap();
                object32 = new HashSet();
                HashSet hashSet3 = new HashSet();
                for (String string : this.types) {
                    void var15_53;
                    if (!list.isEmpty() && !this.types.isEmpty()) {
                        object32 = ((AnnotationSet)((Object)list)).get(string);
                    }
                    if (!var10_26.isEmpty() && !this.types.isEmpty()) {
                        AnnotationSet annotationSet = ((AnnotationSet)var10_26).get(string);
                    }
                    AnnotationDiffer annotationDiffer = new AnnotationDiffer();
                    annotationDiffer.setSignificantFeaturesSet(hashSet2);
                    annotationDiffer.calculateDiff((Collection)object32, (Collection)var15_53);
                    ((HashMap)object2).put(string, annotationDiffer);
                }
                this.differsByDocThenType.add((HashMap<String, AnnotationDiffer>)object2);
                object = new AnnotationDiffer(((HashMap)object2).values());
                if (bl) {
                    OntologyMeasures ontologyMeasures = new OntologyMeasures();
                    ontologyMeasures.setBdmFile(this.bdmFileUrl);
                    ontologyMeasures.calculateBdm(((HashMap)object2).values());
                    arrayList.add(ontologyMeasures);
                    list2 = ontologyMeasures.getMeasuresRow(this.measureList.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                } else {
                    list2 = ((AnnotationDiffer)object).getMeasuresRow(this.measureList.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                }
                this.documentTableModel.addRow(list2.toArray());
            } else if (this.measuresType == 1 && !list.isEmpty() && !var10_26.isEmpty()) {
                ClassificationMeasures classificationMeasures = new ClassificationMeasures();
                classificationMeasures.calculateConfusionMatrix((AnnotationSet)((Object)list), (AnnotationSet)var10_26, (String)this.typeList.getSelectedValue(), (String)this.featureList.getSelectedValue(), this.verboseOptionCheckBox.isSelected());
                objectArray.add(classificationMeasures);
                object2 = classificationMeasures.getMeasuresRow(this.measure2List.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                this.document2TableModel.addRow(object2.toArray());
                object = classificationMeasures.getConfusionMatrix(this.documentNames.get(this.documentNames.size() - 1));
                object32 = object.iterator();
                while (object32.hasNext()) {
                    List list3 = (List)object32.next();
                    while (this.confusionTableModel.getColumnCount() < object.size()) {
                        this.confusionTableModel.addColumn(" ");
                    }
                    this.confusionTableModel.addRow(list3.toArray());
                }
            }
            final int n2 = i + 1;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CorpusQualityAssurance.this.progressBar.setValue(n2);
                }
            });
        }
        if (this.measuresType == 0) {
            for (String string : this.types) {
                ArrayList<AnnotationDiffer> arrayList3 = new ArrayList<AnnotationDiffer>();
                for (HashMap hashMap : this.differsByDocThenType) {
                    arrayList3.add((AnnotationDiffer)hashMap.get(string));
                }
                if (bl) {
                    OntologyMeasures ontologyMeasures = new OntologyMeasures();
                    ontologyMeasures.setBdmFile(this.bdmFileUrl);
                    ontologyMeasures.calculateBdm(arrayList3);
                    arrayList2.add(ontologyMeasures);
                    list = ontologyMeasures.getMeasuresRow(this.measureList.getSelectedValues(), string);
                } else {
                    AnnotationDiffer annotationDiffer = new AnnotationDiffer(arrayList3);
                    list = annotationDiffer.getMeasuresRow(this.measureList.getSelectedValues(), string);
                }
                this.annotationTableModel.addRow(list.toArray());
            }
        }
        if (this.measuresType == 0) {
            if (bl) {
                OntologyMeasures ontologyMeasures = new OntologyMeasures(arrayList);
                this.printSummary(ontologyMeasures, this.documentTableModel, 5, this.documentTableModel.getRowCount(), this.measureList.getSelectedValues());
                ontologyMeasures = new OntologyMeasures(arrayList2);
                this.printSummary(ontologyMeasures, this.annotationTableModel, 5, this.annotationTableModel.getRowCount(), this.measureList.getSelectedValues());
            } else {
                ArrayList<AnnotationDiffer> arrayList3 = new ArrayList<AnnotationDiffer>();
                for (HashMap<String, AnnotationDiffer> hashMap : this.differsByDocThenType) {
                    arrayList3.addAll(hashMap.values());
                }
                AnnotationDiffer annotationDiffer = new AnnotationDiffer(arrayList3);
                this.printSummary(annotationDiffer, this.documentTableModel, 5, this.documentTableModel.getRowCount(), this.measureList.getSelectedValues());
                this.printSummary(annotationDiffer, this.annotationTableModel, 5, this.annotationTableModel.getRowCount(), this.measureList.getSelectedValues());
            }
        } else if (this.measuresType == 1) {
            ClassificationMeasures classificationMeasures = new ClassificationMeasures((Collection<ClassificationMeasures>)objectArray);
            this.printSummary(classificationMeasures, this.document2TableModel, 3, this.document2TableModel.getRowCount(), this.measure2List.getSelectedValues());
            List<List<String>> list3 = classificationMeasures.getConfusionMatrix("Whole corpus");
            boolean bl2 = false;
            for (List list4 : list3) {
                void var8_24;
                while (this.confusionTableModel.getColumnCount() < list3.size()) {
                    this.confusionTableModel.addColumn(" ");
                }
                this.confusionTableModel.insertRow((int)(++var8_24), list4.toArray());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusQualityAssurance.this.progressBar.setValue(CorpusQualityAssurance.this.progressBar.getMinimum());
                CorpusQualityAssurance.this.progressBar.setString("");
                CorpusQualityAssurance.this.setList.setEnabled(true);
                CorpusQualityAssurance.this.setCheck.setEnabled(true);
                CorpusQualityAssurance.this.typeList.setEnabled(true);
                CorpusQualityAssurance.this.typeCheck.setEnabled(true);
                CorpusQualityAssurance.this.featureList.setEnabled(true);
                CorpusQualityAssurance.this.featureCheck.setEnabled(true);
                CorpusQualityAssurance.this.optionsButton.setEnabled(true);
                CorpusQualityAssurance.this.measureTabbedPane.setEnabled(true);
                CorpusQualityAssurance.this.measureList.setEnabled(true);
                CorpusQualityAssurance.this.exportToHtmlAction.setEnabled(true);
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(true);
            }
        });
        if (n > -1) {
            this.readSetsTypesFeatures(n);
        }
    }

    protected void printSummary(Object object, DefaultTableModel defaultTableModel, int n, int n2, Object[] objectArray) {
        int n3;
        int n4;
        AnnotationDiffer annotationDiffer = null;
        ClassificationMeasures classificationMeasures = null;
        OntologyMeasures ontologyMeasures = null;
        if (object instanceof AnnotationDiffer) {
            annotationDiffer = (AnnotationDiffer)object;
        } else if (object instanceof ClassificationMeasures) {
            classificationMeasures = (ClassificationMeasures)object;
        } else if (object instanceof OntologyMeasures) {
            ontologyMeasures = (OntologyMeasures)object;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Macro summary");
        for (n4 = 1; n4 < defaultTableModel.getColumnCount(); ++n4) {
            if (n4 < n) {
                arrayList.add("");
                continue;
            }
            float f = 0.0f;
            for (n3 = 0; n3 < defaultTableModel.getRowCount(); ++n3) {
                try {
                    f += Float.parseFloat((String)defaultTableModel.getValueAt(n3, n4));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            arrayList.add(numberFormat.format(f / (float)defaultTableModel.getRowCount()));
        }
        defaultTableModel.insertRow(n2, arrayList.toArray());
        arrayList.clear();
        arrayList.add("Micro summary");
        for (n4 = 1; n4 < n; ++n4) {
            int n5 = 0;
            for (n3 = 0; n3 < defaultTableModel.getRowCount() - 1; ++n3) {
                try {
                    n5 += Integer.valueOf((String)defaultTableModel.getValueAt(n3, n4)).intValue();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            arrayList.add(Integer.toString(n5));
        }
        if (object instanceof OntologyMeasures) {
            ArrayList<AnnotationDiffer> arrayList2 = new ArrayList<AnnotationDiffer>(ontologyMeasures.getDifferByTypeMap().values());
            annotationDiffer = new AnnotationDiffer(arrayList2);
        }
        for (Object object2 : objectArray) {
            float f;
            double d;
            String string = (String)object2;
            int n6 = string.indexOf(45);
            double d2 = d = n6 == -1 ? 1.0 : Double.valueOf(string.substring(1, n6));
            if (string.endsWith("strict")) {
                arrayList.add(numberFormat.format(annotationDiffer.getRecallStrict()));
                arrayList.add(numberFormat.format(annotationDiffer.getPrecisionStrict()));
                arrayList.add(numberFormat.format(annotationDiffer.getFMeasureStrict(d)));
                continue;
            }
            if (string.endsWith("strict BDM")) {
                arrayList.add(numberFormat.format(ontologyMeasures.getRecallStrictBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getPrecisionStrictBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getFMeasureStrictBdm(d)));
                continue;
            }
            if (string.endsWith("lenient")) {
                arrayList.add(numberFormat.format(annotationDiffer.getRecallLenient()));
                arrayList.add(numberFormat.format(annotationDiffer.getPrecisionLenient()));
                arrayList.add(numberFormat.format(annotationDiffer.getFMeasureLenient(d)));
                continue;
            }
            if (string.endsWith("lenient BDM")) {
                arrayList.add(numberFormat.format(ontologyMeasures.getRecallLenientBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getPrecisionLenientBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getFMeasureLenientBdm(d)));
                continue;
            }
            if (string.endsWith("average")) {
                arrayList.add(numberFormat.format(annotationDiffer.getRecallAverage()));
                arrayList.add(numberFormat.format(annotationDiffer.getPrecisionAverage()));
                arrayList.add(numberFormat.format(annotationDiffer.getFMeasureAverage(d)));
                continue;
            }
            if (string.endsWith("average BDM")) {
                arrayList.add(numberFormat.format(ontologyMeasures.getRecallAverageBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getPrecisionAverageBdm()));
                arrayList.add(numberFormat.format(ontologyMeasures.getFMeasureAverageBdm(d)));
                continue;
            }
            if (string.equals("Observed agreement")) {
                arrayList.add(numberFormat.format(classificationMeasures.getObservedAgreement()));
                continue;
            }
            if (string.equals("Cohen's Kappa")) {
                f = classificationMeasures.getKappaCohen();
                arrayList.add(Float.isNaN(f) ? "" : numberFormat.format(f));
                continue;
            }
            if (!string.equals("Pi's Kappa")) continue;
            f = classificationMeasures.getKappaPi();
            arrayList.add(Float.isNaN(f) ? "" : numberFormat.format(f));
        }
        defaultTableModel.insertRow(n2 + 1, arrayList.toArray());
    }

    protected class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", "User guide for this tool");
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-action-info"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.getInstance().showHelpFrame("sec:eval:corpusqualityassurance", CorpusQualityAssurance.class.getName());
        }
    }

    class ReloadCacheAction
    extends AbstractAction {
        public ReloadCacheAction() {
            super("Reload cache", MainFrame.getIcon("crystal-clear-action-reload"));
            this.putValue("ShortDescription", "Reload cache for set, type and feature names list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CorpusQualityAssurance.this.docsSetsTypesFeatures.clear();
            CorpusQualityAssurance.this.readSetsTypesFeatures(0);
        }
    }

    protected class ExportToHtmlAction
    extends AbstractAction {
        final String nl;
        static final String BEGINHTML = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>";
        static final String ENDHTML = "</body></html>";
        static final String BEGINHEAD = "<head><meta content=\"text/html; charset=utf-8\" http-equiv=\"content-type\"><title>";
        static final String ENDHEAD = "</title></head><body>";
        static final String BEGINTABLE = "<table cellpadding=\"0\" border=\"1\">";
        static final String ENDTABLE = "</table>";

        public ExportToHtmlAction() {
            super("Export to HTML");
            this.nl = Strings.getNl();
            this.putValue("ShortDescription", "Export the tables to HTML");
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-app-download-manager"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setAcceptAllFileFilterUsed(true);
            xJFileChooser.setDialogTitle("Choose a file where to export the tables");
            xJFileChooser.setFileSelectionMode(0);
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("HTML files", "html");
            xJFileChooser.addChoosableFileFilter(extensionFileFilter);
            String string = CorpusQualityAssurance.this.corpus.getName();
            string = string + "_" + CorpusQualityAssurance.this.keySetName;
            string = string + "-" + CorpusQualityAssurance.this.responseSetName;
            xJFileChooser.setFileName(string + ".html");
            xJFileChooser.setResource(CorpusQualityAssurance.class.getName());
            int n = xJFileChooser.showSaveDialog(CorpusQualityAssurance.this);
            if (n != 0) {
                return;
            }
            File file = xJFileChooser.getSelectedFile();
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(BEGINHTML + this.nl);
            bufferedWriter.write(BEGINHEAD);
            bufferedWriter.write(string);
            bufferedWriter.write(ENDHEAD + this.nl);
            bufferedWriter.write("<H1>Corpus Quality Assurance</H1>" + this.nl);
            bufferedWriter.write("<P>Corpus: " + CorpusQualityAssurance.this.corpus.getName() + "<BR>" + this.nl);
            bufferedWriter.write("Key set: " + CorpusQualityAssurance.this.keySetName + "<BR>" + this.nl);
            bufferedWriter.write("Response set: " + CorpusQualityAssurance.this.responseSetName + "<BR>" + this.nl);
            bufferedWriter.write("Types: " + Strings.toString(CorpusQualityAssurance.this.typeList.getSelectedValues()) + "<BR>" + this.nl);
            bufferedWriter.write("Features: " + Strings.toString(CorpusQualityAssurance.this.featureList.getSelectedValues()) + "</P>" + this.nl);
            bufferedWriter.write("<P>&nbsp;</P>" + this.nl);
            ArrayList<XJTable> arrayList = new ArrayList<XJTable>();
            arrayList.add(CorpusQualityAssurance.this.annotationTable);
            arrayList.add(CorpusQualityAssurance.this.documentTable);
            arrayList.add(CorpusQualityAssurance.this.document2Table);
            arrayList.add(CorpusQualityAssurance.this.confusionTable);
            for (JTable jTable : arrayList) {
                int n2;
                bufferedWriter.write(BEGINTABLE + this.nl + "<TR>" + this.nl);
                for (n2 = 0; n2 < jTable.getColumnCount(); ++n2) {
                    bufferedWriter.write("<TH align=\"left\">" + jTable.getColumnName(n2) + "</TH>" + this.nl);
                }
                bufferedWriter.write("</TR>" + this.nl);
                for (n2 = 0; n2 < jTable.getRowCount(); ++n2) {
                    bufferedWriter.write("<TR>" + this.nl);
                    for (int i = 0; i < jTable.getColumnCount(); ++i) {
                        String string2 = (String)jTable.getValueAt(n2, i);
                        if (string2 == null) {
                            string2 = "";
                        }
                        bufferedWriter.write("<TD>" + string2 + "</TD>" + this.nl);
                    }
                    bufferedWriter.write("</TR>" + this.nl);
                }
                bufferedWriter.write(ENDTABLE + this.nl);
                bufferedWriter.write("<P>&nbsp;</P>" + this.nl);
            }
            bufferedWriter.write(ENDHTML + this.nl);
            ((Writer)bufferedWriter).flush();
            Object var15_15 = null;
            if (bufferedWriter == null) return;
            try {
                ((Writer)bufferedWriter).close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
            {
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(CorpusQualityAssurance.this, iOException.toString(), "GATE", 0);
                    iOException.printStackTrace();
                    Object var15_16 = null;
                    if (bufferedWriter == null) return;
                    try {
                        ((Writer)bufferedWriter).close();
                        return;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (bufferedWriter == null) throw throwable;
                try {
                    ((Writer)bufferedWriter).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    class OpenAnnotationDiffAction
    extends AbstractAction {
        public OpenAnnotationDiffAction() {
            super("Open annotation diff", MainFrame.getIcon("annDiff"));
            this.putValue("ShortDescription", "Opens annotation diff for the selected row in the document table");
            this.putValue("MnemonicKey", 39);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document = (Document)CorpusQualityAssurance.this.corpus.get(CorpusQualityAssurance.this.measuresType == 0 ? CorpusQualityAssurance.this.documentTable.rowViewToModel(CorpusQualityAssurance.this.documentTable.getSelectedRow()) : CorpusQualityAssurance.this.document2Table.rowViewToModel(CorpusQualityAssurance.this.document2Table.getSelectedRow()));
            String string = document.getName();
            String string2 = (String)CorpusQualityAssurance.this.typeList.getSelectedValue();
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object : CorpusQualityAssurance.this.featureList.getSelectedValues()) {
                hashSet.add((String)object);
            }
            AnnotationDiffGUI annotationDiffGUI = new AnnotationDiffGUI("Annotation Difference", string, string, CorpusQualityAssurance.this.keySetName, CorpusQualityAssurance.this.responseSetName, string2, hashSet);
            annotationDiffGUI.pack();
            annotationDiffGUI.setLocationRelativeTo(MainFrame.getInstance());
            annotationDiffGUI.setVisible(true);
        }
    }

    class OpenDocumentAction
    extends AbstractAction {
        public OpenDocumentAction() {
            super("Open documents", MainFrame.getIcon("document"));
            this.putValue("ShortDescription", "Opens document for the selected row in a document editor");
            this.putValue("MnemonicKey", 38);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final Document document = (Document)CorpusQualityAssurance.this.corpus.get(CorpusQualityAssurance.this.measuresType == 0 ? CorpusQualityAssurance.this.documentTable.rowViewToModel(CorpusQualityAssurance.this.documentTable.getSelectedRow()) : CorpusQualityAssurance.this.document2Table.rowViewToModel(CorpusQualityAssurance.this.document2Table.getSelectedRow()));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.getInstance().select(document);
                }
            });
        }
    }

    protected class CompareAction
    extends AbstractAction {
        public CompareAction() {
            super("Compare");
            this.putValue("ShortDescription", "Compare annotations between sets A and B");
            this.putValue("MnemonicKey", 10);
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-action-run"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            for (Object object : CorpusQualityAssurance.this.measureList.getSelectedValues()) {
                if (!((String)object).contains("BDM")) continue;
                bl = true;
                break;
            }
            if (bl && CorpusQualityAssurance.this.measuresType == 0 && CorpusQualityAssurance.this.bdmFileUrl == null) {
                new SetBdmFileAction().actionPerformed(null);
                if (CorpusQualityAssurance.this.bdmFileUrl == null) {
                    return;
                }
            }
            CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(3));
            this.setEnabled(false);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        CorpusQualityAssurance.this.documentTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.annotationTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Document");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Annotation");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Match");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Match");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Only A");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Only A");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Only B");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Only B");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Overlap");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Overlap");
                        for (Object object : CorpusQualityAssurance.this.measureList.getSelectedValues()) {
                            String string = ((String)object).replaceFirst("score strict", "s.").replaceFirst("score lenient", "l.").replaceFirst("score average", "a.").replaceFirst(" BDM", "B.");
                            CorpusQualityAssurance.this.documentTableModel.addColumn("Rec.B/A");
                            CorpusQualityAssurance.this.annotationTableModel.addColumn("Rec.B/A");
                            CorpusQualityAssurance.this.documentTableModel.addColumn("Prec.B/A");
                            CorpusQualityAssurance.this.annotationTableModel.addColumn("Prec.B/A");
                            CorpusQualityAssurance.this.documentTableModel.addColumn(string);
                            CorpusQualityAssurance.this.annotationTableModel.addColumn(string);
                        }
                        CorpusQualityAssurance.this.compareAnnotation();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int n;
                                CorpusQualityAssurance.this.documentTable.setModel(CorpusQualityAssurance.this.documentTableModel);
                                for (n = 0; n < CorpusQualityAssurance.this.documentTable.getColumnCount(); ++n) {
                                    CorpusQualityAssurance.this.documentTable.setComparator(n, CorpusQualityAssurance.this.doubleComparator);
                                }
                                CorpusQualityAssurance.this.documentTable.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.documentTable.setSortedColumn(0);
                                CorpusQualityAssurance.this.annotationTable.setModel(CorpusQualityAssurance.this.annotationTableModel);
                                for (n = 0; n < CorpusQualityAssurance.this.annotationTable.getColumnCount(); ++n) {
                                    CorpusQualityAssurance.this.annotationTable.setComparator(n, CorpusQualityAssurance.this.doubleComparator);
                                }
                                CorpusQualityAssurance.this.annotationTable.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.annotationTable.setSortedColumn(0);
                                CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                                CompareAction.this.setEnabled(true);
                            }
                        });
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        CorpusQualityAssurance.this.document2TableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Document");
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Agreed");
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Total");
                        for (Object object : CorpusQualityAssurance.this.measure2List.getSelectedValues()) {
                            CorpusQualityAssurance.this.document2TableModel.addColumn(object);
                        }
                        CorpusQualityAssurance.this.confusionTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.compareAnnotation();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CorpusQualityAssurance.this.document2Table.setSortable(false);
                                CorpusQualityAssurance.this.document2Table.setModel(CorpusQualityAssurance.this.document2TableModel);
                                CorpusQualityAssurance.this.document2Table.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.document2Table.setComparator(1, CorpusQualityAssurance.this.doubleComparator);
                                CorpusQualityAssurance.this.document2Table.setSortedColumn(0);
                                CorpusQualityAssurance.this.document2Table.setSortable(true);
                                CorpusQualityAssurance.this.confusionTable.setModel(CorpusQualityAssurance.this.confusionTableModel);
                                CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                                CompareAction.this.setEnabled(true);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "CompareAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    protected class SetBdmFileAction
    extends AbstractAction {
        public SetBdmFileAction() {
            super("Browse");
            this.putValue("ShortDescription", "Choose a BDM file to compute BDM measures");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setAcceptAllFileFilterUsed(true);
            xJFileChooser.setDialogTitle("Choose a BDM file");
            xJFileChooser.setFileSelectionMode(0);
            xJFileChooser.setResource(CorpusQualityAssurance.class.getName() + ".BDMfile");
            int n = xJFileChooser.showOpenDialog(CorpusQualityAssurance.this);
            if (n != 0) {
                return;
            }
            try {
                CorpusQualityAssurance.this.bdmFileUrl = xJFileChooser.getSelectedFile().toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    protected static class ToggleSelectionABModel
    extends DefaultListSelectionModel {
        JList list;
        String selectedValueA;
        String selectedValueB;

        public ToggleSelectionABModel(JList jList) {
            this.list = jList;
        }

        public void setSelectionInterval(int n, int n2) {
            ExtendedListModel extendedListModel = (ExtendedListModel)this.list.getModel();
            String string = (String)extendedListModel.getElementAt(n);
            if (string.endsWith(" (A)") || string.endsWith(" (B)")) {
                extendedListModel.removeElementAt(n);
                extendedListModel.insertElementAt(string.substring(0, string.length() - " (A)".length()), n);
                if (string.endsWith(" (A)")) {
                    this.selectedValueA = null;
                } else {
                    this.selectedValueB = null;
                }
                this.removeSelectionInterval(n, n2);
            } else if (this.selectedValueA == null) {
                extendedListModel.removeElementAt(n);
                extendedListModel.insertElementAt(string + " (A)", n);
                this.selectedValueA = string;
                this.addSelectionInterval(n, n2);
            } else if (this.selectedValueB == null) {
                extendedListModel.removeElementAt(n);
                extendedListModel.insertElementAt(string + " (B)", n);
                this.selectedValueB = string;
                this.addSelectionInterval(n, n2);
            }
        }

        public void clearSelection() {
            this.selectedValueA = null;
            this.selectedValueB = null;
            super.clearSelection();
        }

        public String getSelectedValueA() {
            return this.selectedValueA;
        }

        public String getSelectedValueB() {
            return this.selectedValueB;
        }
    }

    protected static class ToggleSelectionModel
    extends DefaultListSelectionModel {
        boolean gestureStarted = false;

        protected ToggleSelectionModel() {
        }

        public void setSelectionInterval(int n, int n2) {
            if (this.isSelectedIndex(n) && !this.gestureStarted) {
                super.removeSelectionInterval(n, n2);
            } else {
                super.addSelectionInterval(n, n2);
            }
            this.gestureStarted = true;
        }

        public void setValueIsAdjusting(boolean bl) {
            if (!bl) {
                this.gestureStarted = false;
            }
        }
    }

    protected static class ExtendedListModel
    extends DefaultListModel {
        public ExtendedListModel() {
        }

        public ExtendedListModel(Object[] objectArray) {
            for (Object object : objectArray) {
                super.addElement(object);
            }
        }
    }
}

