/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Node;
import gate.fsm.FSM;
import gate.fsm.State;
import gate.jape.RightHandSide;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSMInstance
implements Comparable,
Cloneable,
Serializable {
    private static final boolean DEBUG = false;
    private FSM supportGraph;
    private State FSMPosition;
    private Node AGPosition;
    private Node startNode;
    private HashMap<String, AnnotationSet> bindings;
    private long length = 0L;
    private int fileIndex;
    private Document document;
    private int priority;
    private static LinkedList myInstances = new LinkedList();

    public FSMInstance(FSM fSM, State state, Node node, Node node2, HashMap<String, AnnotationSet> hashMap, Document document) {
        this.supportGraph = fSM;
        this.FSMPosition = state;
        this.startNode = node;
        this.AGPosition = node2;
        this.bindings = hashMap;
        this.document = document;
        this.length = node2.getOffset() - node.getOffset();
        this.fileIndex = state.getFileIndex();
        this.priority = state.getPriority();
    }

    public FSM getSupportGraph() {
        return this.supportGraph;
    }

    public State getFSMPosition() {
        return this.FSMPosition;
    }

    public void setFSMPosition(State state) {
        this.FSMPosition = state;
        this.fileIndex = this.FSMPosition.getFileIndex();
        this.priority = this.FSMPosition.getPriority();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public Node getStartAGPosition() {
        return this.startNode;
    }

    public Node getAGPosition() {
        return this.AGPosition;
    }

    public void setAGPosition(Node node) {
        this.AGPosition = node;
        this.length = this.AGPosition.getOffset() - this.startNode.getOffset();
    }

    public HashMap<String, AnnotationSet> getBindings() {
        return this.bindings;
    }

    public long getLength() {
        return this.length;
    }

    public int hashCode() {
        return (int)this.length ^ this.priority ^ this.fileIndex ^ this.bindings.hashCode() ^ this.FSMPosition.getAction().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FSMInstance) {
            FSMInstance fSMInstance = (FSMInstance)object;
            boolean bl = this.length == fSMInstance.length && this.priority == fSMInstance.priority && this.fileIndex == fSMInstance.fileIndex && this.bindings.equals(fSMInstance.bindings) && this.FSMPosition.getAction().equals(fSMInstance.FSMPosition.getAction());
            return bl;
        }
        throw new ClassCastException(object.getClass().toString());
    }

    public Object clone() {
        try {
            FSMInstance fSMInstance = (FSMInstance)super.clone();
            fSMInstance.bindings = (HashMap)this.bindings.clone();
            return fSMInstance;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(Err.getPrintWriter());
            return null;
        }
    }

    public int compareTo(Object object) {
        if (object instanceof FSMInstance) {
            if (object == this) {
                return 0;
            }
            FSMInstance fSMInstance = (FSMInstance)object;
            if (this.length < fSMInstance.getLength()) {
                return -1;
            }
            if (this.length > fSMInstance.getLength()) {
                return 1;
            }
            if (this.priority < fSMInstance.priority) {
                return -1;
            }
            if (this.priority > fSMInstance.priority) {
                return 1;
            }
            return fSMInstance.fileIndex - this.fileIndex;
        }
        throw new ClassCastException("Attempt to compare a FSMInstance object to an object of type " + object.getClass() + "!");
    }

    public String toString() {
        String string = "";
        RightHandSide rightHandSide = this.getFSMPosition().getAction();
        if (rightHandSide != null) {
            string = string + rightHandSide.getPhaseName() + "." + rightHandSide.getRuleName() + ": \"";
            try {
                string = string + this.document.getContent().getContent(this.getStartAGPosition().getOffset(), this.getAGPosition().getOffset()).toString() + "\"";
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            Iterator<String> iterator = this.bindings.keySet().iterator();
            string = string + "\n{";
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Collection collection = this.bindings.get(string2);
                string = string + "\n" + string2 + ": ";
                for (Annotation annotation : collection) {
                    string = string + annotation.getType() + "(\"";
                    try {
                        string = string + this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        invalidOffsetException.printStackTrace(Err.getPrintWriter());
                    }
                    string = string + "\") ";
                }
            }
            string = string + "\n}";
        } else {
            string = string + "FSM position :" + this.FSMPosition.getIndex() + "\nFirst matched ANN at:" + this.startNode.getId() + "\nLast matched ANN at :" + this.AGPosition.getId() + "\nPriority :" + this.priority + "\nFile index :" + this.fileIndex + "\nBindings     :" + this.bindings;
        }
        return string;
    }

    public static FSMInstance getNewInstance(FSM fSM, State state, Node node, Node node2, HashMap<String, AnnotationSet> hashMap, Document document) {
        FSMInstance fSMInstance;
        if (myInstances.isEmpty()) {
            fSMInstance = new FSMInstance(fSM, state, node, node2, hashMap, document);
        } else {
            fSMInstance = (FSMInstance)myInstances.removeFirst();
            fSMInstance.supportGraph = fSM;
            fSMInstance.FSMPosition = state;
            fSMInstance.startNode = node;
            fSMInstance.AGPosition = node2;
            fSMInstance.bindings = hashMap;
        }
        return fSMInstance;
    }

    public static void returnInstance(FSMInstance fSMInstance) {
        myInstances.addFirst(fSMInstance);
    }

    public static void clearInstances() {
        myInstances = new LinkedList();
    }
}

