/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.SearchException;
import gate.creole.annic.Searcher;
import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.LuceneSearchThread;
import gate.creole.annic.lucene.StatsCalculator;
import gate.persist.LuceneDataStoreImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearcher
implements Searcher {
    private List<String> indexLocations = null;
    private String query = null;
    private int contextWindow = 5;
    private List<Pattern> annicPatterns = new ArrayList<Pattern>();
    public Map<String, List<String>> annotationTypesMap = new HashMap<String, List<String>>();
    private Map<String, Object> parameters = null;
    private String corpusToSearchIn = null;
    private String annotationSetToSearchIn = null;
    private Hits luceneHits = null;
    private boolean wasDeleteQuery = false;
    private List<LuceneSearchThread> luceneSearchThreads = null;
    private boolean success = false;
    private int luceneSearchThreadIndex = 0;
    private boolean fwdIterationEnded = false;
    private LuceneDataStoreImpl datastore;
    private Map<String, List<String>> queryTokens = new HashMap<String, List<String>>();

    @Override
    public Hit[] next(int n) throws SearchException {
        this.annicPatterns = new ArrayList<Pattern>();
        if (!this.success) {
            this.annicPatterns = new ArrayList<Pattern>();
            return this.getHits();
        }
        if (this.fwdIterationEnded) {
            this.annicPatterns = new ArrayList<Pattern>();
            return this.getHits();
        }
        try {
            if (this.wasDeleteQuery) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < this.luceneHits.length(); ++i) {
                    Document document = this.luceneHits.doc(i);
                    String string = document.get("DOCUMENT_ID");
                    String string2 = document.get("ANNOTATION_SET_ID");
                    int n2 = arrayList.indexOf(string);
                    if (n2 == -1) {
                        arrayList.add(string);
                        arrayList2.add(string2);
                        continue;
                    }
                    if (((String)arrayList2.get(n2)).equals(string2)) continue;
                    arrayList.add(string);
                    arrayList2.add(string2);
                }
                Hit[] hitArray = new Hit[arrayList.size()];
                for (int i = 0; i < hitArray.length; ++i) {
                    hitArray[i] = new Hit((String)arrayList.get(i), (String)arrayList2.get(i), 0, 0, "");
                }
                return hitArray;
            }
            while (this.luceneSearchThreadIndex < this.luceneSearchThreads.size()) {
                LuceneSearchThread luceneSearchThread = this.luceneSearchThreads.get(this.luceneSearchThreadIndex);
                List<Pattern> list = luceneSearchThread.next(n);
                if (list != null) {
                    if (n != -1) {
                        n -= list.size();
                    }
                    this.annicPatterns.addAll(list);
                    if (n == 0) {
                        return this.getHits();
                    }
                }
                ++this.luceneSearchThreadIndex;
            }
            this.fwdIterationEnded = true;
            return this.getHits();
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public boolean search(String string, Map<String, Object> map) throws SearchException {
        Object object;
        String string2;
        this.luceneHits = null;
        this.annicPatterns = new ArrayList<Pattern>();
        this.annotationTypesMap = new HashMap<String, List<String>>();
        this.luceneSearchThreads = new ArrayList<LuceneSearchThread>();
        this.luceneSearchThreadIndex = 0;
        this.success = false;
        this.fwdIterationEnded = false;
        this.wasDeleteQuery = false;
        if (map == null) {
            throw new SearchException("Parameters cannot be null");
        }
        this.parameters = map;
        if (map.size() == 2 && map.get("INDEX_LOCATION_URL") != null) {
            string2 = (String)map.get("CORPUS_ID");
            object = null;
            try {
                object = new File(((URL)map.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                object = new File(((URL)map.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
            }
            if (string2 != null && object != null) {
                this.wasDeleteQuery = true;
                Term term = new Term("CORPUS_ID", string2);
                TermQuery termQuery = new TermQuery(term);
                try {
                    IndexSearcher indexSearcher = new IndexSearcher((String)object);
                    this.luceneHits = indexSearcher.search(termQuery);
                    this.success = this.luceneHits.length() > 0;
                    return this.success;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new SearchException(iOException);
                }
            }
        }
        if (map.get("INDEX_LOCATIONS") == null) {
            try {
                string2 = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                string2 = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
            }
            object = new ArrayList();
            ((ArrayList)object).add(string2);
            map.put("INDEX_LOCATIONS", object);
        }
        this.indexLocations = new ArrayList<String>((List)map.get("INDEX_LOCATIONS"));
        if (this.indexLocations.size() == 0) {
            throw new SearchException("Corpus is not initialized");
        }
        if (map.get("CONTEXT_WINDOW") == null) {
            throw new SearchException("Parameter CONTEXT_WINDOW is not provided!");
        }
        this.contextWindow = (Integer)map.get("CONTEXT_WINDOW");
        if (this.getContextWindow() <= 0) {
            throw new SearchException("Context Window must be atleast 1 or > 1");
        }
        if (string == null) {
            throw new SearchException("Query is not initialized");
        }
        this.query = string;
        this.corpusToSearchIn = (String)map.get("CORPUS_ID");
        this.annotationSetToSearchIn = (String)map.get("ANNOTATION_SET_ID");
        this.annicPatterns = new ArrayList<Pattern>();
        this.annotationTypesMap = new HashMap<String, List<String>>();
        this.luceneSearchThreads = new ArrayList<LuceneSearchThread>();
        for (int i = 0; i < this.indexLocations.size(); ++i) {
            LuceneSearchThread luceneSearchThread = new LuceneSearchThread();
            object = this.indexLocations.get(i);
            if (!luceneSearchThread.search(string, this.contextWindow, (String)object, this.corpusToSearchIn, this.annotationSetToSearchIn, this)) continue;
            this.luceneSearchThreads.add(luceneSearchThread);
        }
        this.success = this.luceneSearchThreads.size() > 0;
        return this.success;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public Integer getContextWindow() {
        return new Integer(this.contextWindow);
    }

    @Override
    public Hit[] getHits() {
        if (this.annicPatterns == null) {
            this.annicPatterns = new ArrayList<Pattern>();
        }
        Hit[] hitArray = new Hit[this.annicPatterns.size()];
        for (int i = 0; i < this.annicPatterns.size(); ++i) {
            hitArray[i] = this.annicPatterns.get(i);
        }
        return hitArray;
    }

    @Override
    public Map<String, List<String>> getAnnotationTypesMap() {
        return this.annotationTypesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getIndexedAnnotationSetNames() throws SearchException {
        String string;
        try {
            string = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            string = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        this.annotationTypesMap = new HashMap<String, List<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            IndexReader indexReader;
            block20: {
                String[] stringArray;
                block19: {
                    indexReader = IndexReader.open(string);
                    try {
                        TermEnum termEnum = indexReader.terms(new Term("CORPUS_ID", ""));
                        if (termEnum == null || termEnum.term() == null) {
                            stringArray = new String[]{};
                            Object var38_9 = null;
                            break block19;
                        }
                        HashSet<String> hashSet2 = new HashSet<String>();
                        while ("CORPUS_ID".equals(termEnum.term().field())) {
                            hashSet2.add(termEnum.term().text());
                            if (termEnum.next()) continue;
                        }
                        for (String string2 : hashSet2) {
                            Term term = new Term("CORPUS_ID", string2);
                            TermQuery termQuery = new TermQuery(term);
                            try {
                                Object var36_41;
                                IndexSearcher indexSearcher = new IndexSearcher(string);
                                try {
                                    Hits hits = indexSearcher.search(termQuery);
                                    for (int i = 0; i < hits.length(); ++i) {
                                        Object var34_40;
                                        Document document = hits.doc(i);
                                        String string3 = document.get("ANNOTATION_SET_ID");
                                        if (hashSet.contains(string2 + ";" + string3)) continue;
                                        hashSet.add(string2 + ";" + string3);
                                        Term term2 = new Term("ANNOTATION_SET_ID", string3);
                                        TermQuery termQuery2 = new TermQuery(term2);
                                        BooleanQuery booleanQuery = new BooleanQuery();
                                        booleanQuery.add(termQuery, true, false);
                                        booleanQuery.add(termQuery2, true, false);
                                        IndexSearcher indexSearcher2 = new IndexSearcher(string);
                                        try {
                                            Hits hits2 = indexSearcher.search(booleanQuery);
                                            for (int j = 0; j < hits2.length(); ++j) {
                                                String[] stringArray2;
                                                Document document2 = hits2.doc(j);
                                                String string4 = document2.get("INDEXED_FEATURES");
                                                if (string4 == null) continue;
                                                for (String string5 : stringArray2 = string4.split(";")) {
                                                    int n = string5.indexOf(".");
                                                    if (n == -1) continue;
                                                    String string6 = string5.substring(0, n);
                                                    String string7 = string5.substring(n + 1);
                                                    String string8 = string2 + ";" + string3 + ";" + string6;
                                                    List<String> list = this.annotationTypesMap.get(string8);
                                                    if (list == null) {
                                                        list = new ArrayList<String>();
                                                        this.annotationTypesMap.put(string8, list);
                                                    }
                                                    if (list.contains(string7)) continue;
                                                    list.add(string7);
                                                }
                                            }
                                            var34_40 = null;
                                        }
                                        catch (Throwable throwable) {
                                            var34_40 = null;
                                            indexSearcher2.close();
                                            throw throwable;
                                        }
                                        indexSearcher2.close();
                                    }
                                    var36_41 = null;
                                }
                                catch (Throwable throwable) {
                                    var36_41 = null;
                                    indexSearcher.close();
                                    throw throwable;
                                }
                                indexSearcher.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                throw new SearchException(iOException);
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var38_11 = null;
                        indexReader.close();
                        throw throwable;
                    }
                }
                indexReader.close();
                return stringArray;
            }
            Object var38_10 = null;
            indexReader.close();
            return hashSet.toArray(new String[0]);
        }
        catch (IOException iOException) {
            throw new SearchException(iOException);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public synchronized List<String> getQueryTokens(String string) {
        return this.queryTokens.get(string);
    }

    public synchronized void addQueryTokens(String string, List<String> list) {
        this.queryTokens.put(string, list);
    }

    @Override
    public void exportResults(File file) {
        throw new RuntimeException("ExportResults method is not implemented yet!");
    }

    @Override
    public int freq(String string, String string2, String string3, String string4, String string5) throws SearchException {
        IndexSearcher indexSearcher;
        String string6;
        try {
            string6 = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            string6 = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try {
            indexSearcher = new IndexSearcher(string6);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        int n = StatsCalculator.freq(indexSearcher, string, string2, string3, string4, string5);
        try {
            indexSearcher.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        return n;
    }

    @Override
    public int freq(String string, String string2, String string3) throws SearchException {
        return this.freq(string, string2, string3, null, null);
    }

    @Override
    public int freq(String string, String string2, String string3, String string4) throws SearchException {
        return this.freq(string, string2, string3, string4, null);
    }

    @Override
    public int freq(List<Hit> list, String string, String string2, String string3, boolean bl, boolean bl2) throws SearchException {
        return StatsCalculator.freq(list, string, string2, string3, bl, bl2);
    }

    @Override
    public int freq(List<Hit> list, String string, boolean bl, boolean bl2) throws SearchException {
        return StatsCalculator.freq(list, string, bl, bl2);
    }

    @Override
    public Map<String, Integer> freqForAllValues(List<Hit> list, String string, String string2, boolean bl, boolean bl2) throws SearchException {
        return StatsCalculator.freqForAllValues(list, string, string2, bl, bl2);
    }

    public void setLuceneDatastore(LuceneDataStoreImpl luceneDataStoreImpl) {
        this.datastore = luceneDataStoreImpl;
    }
}

