/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.TermScorer;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;

public class TermQuery
extends Query {
    private Term term;

    public TermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected Weight createWeight(Searcher searcher) {
        return new TermWeight(searcher);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.term.field().equals(string)) {
            stringBuffer.append(this.term.field());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TermQuery)) {
            return false;
        }
        TermQuery termQuery = (TermQuery)object;
        try {
            throw new Exception("My Error");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.getBoost() == termQuery.getBoost() && this.term.equals(termQuery.term);
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    private class TermWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public TermWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        public Query getQuery() {
            return TermQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = TermQuery.this.getSimilarity(this.searcher).idf(TermQuery.this.term, this.searcher);
            this.queryWeight = this.idf * TermQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader indexReader, Searcher searcher) throws IOException {
            this.searcher = searcher;
            TermDocs termDocs = indexReader.termDocs(TermQuery.this.term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(this, termDocs, TermQuery.this.getSimilarity(searcher), indexReader.norms(TermQuery.this.term.field()), TermQuery.this.term);
        }

        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Explanation explanation = new Explanation();
            explanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            Explanation explanation2 = new Explanation(this.idf, "idf(docFreq=" + this.searcher.docFreq(TermQuery.this.term) + ")");
            Explanation explanation3 = new Explanation();
            explanation3.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation4 = new Explanation(TermQuery.this.getBoost(), "boost");
            if (TermQuery.this.getBoost() != 1.0f) {
                explanation3.addDetail(explanation4);
            }
            explanation3.addDetail(explanation2);
            Explanation explanation5 = new Explanation(this.queryNorm, "queryNorm");
            explanation3.addDetail(explanation5);
            explanation3.setValue(explanation4.getValue() * explanation2.getValue() * explanation5.getValue());
            explanation.addDetail(explanation3);
            String string = TermQuery.this.term.field();
            Explanation explanation6 = new Explanation();
            explanation6.setDescription("fieldWeight(" + TermQuery.this.term + " in " + n + "), product of:");
            Explanation explanation7 = this.scorer(indexReader, this.searcher).explain(n);
            explanation6.addDetail(explanation7);
            explanation6.addDetail(explanation2);
            Explanation explanation8 = new Explanation();
            byte[] byArray = indexReader.norms(string);
            float f = byArray != null ? Similarity.decodeNorm(byArray[n]) : 0.0f;
            explanation8.setValue(f);
            explanation8.setDescription("fieldNorm(field=" + string + ", doc=" + n + ")");
            explanation6.addDetail(explanation8);
            explanation6.setValue(explanation7.getValue() * explanation2.getValue() * explanation8.getValue());
            explanation.addDetail(explanation6);
            explanation.setValue(explanation3.getValue() * explanation6.getValue());
            if (explanation3.getValue() == 1.0f) {
                return explanation6;
            }
            return explanation;
        }
    }
}

