/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.DefaultSimilarity;
import gate.creole.annic.apache.lucene.search.Searcher;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public abstract class Similarity {
    private static Similarity defaultImpl = new DefaultSimilarity();
    private static final float[] NORM_TABLE = new float[256];

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte by) {
        return NORM_TABLE[by & 0xFF];
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return Similarity.floatToByte(f);
    }

    private static float byteToFloat(byte by) {
        if (by == 0) {
            return 0.0f;
        }
        int n = by & 7;
        int n2 = by >> 3 & 0x1F;
        int n3 = n2 + 48 << 24 | n << 21;
        return Float.intBitsToFloat(n3);
    }

    private static byte floatToByte(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f == 0.0f) {
            return 0;
        }
        int n = Float.floatToIntBits(f);
        int n2 = (n & 0xFFFFFF) >> 21;
        int n3 = (n >> 24 & 0x7F) - 63 + 15;
        if (n3 > 31) {
            n3 = 31;
            n2 = 7;
        }
        if (n3 < 0) {
            n3 = 0;
            n2 = 1;
        }
        return (byte)(n3 << 3 | n2);
    }

    public float tf(int n) {
        return this.tf((float)n);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public float idf(Term term, Searcher searcher) throws IOException {
        return this.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    public float idf(Collection collection, Searcher searcher) throws IOException {
        float f = 0.0f;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            f += this.idf((Term)iterator.next(), searcher);
        }
        return f;
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = Similarity.byteToFloat((byte)i);
        }
    }
}

