/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.BooleanClause;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public abstract class Query
implements Serializable,
Cloneable {
    private float boost = 1.0f;

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    protected Weight createWeight(Searcher searcher) {
        throw new UnsupportedOperationException();
    }

    public Weight weight(Searcher searcher) throws IOException {
        Query query = searcher.rewrite(this);
        Weight weight = query.createWeight(searcher);
        float f = weight.sumOfSquaredWeights();
        float f2 = this.getSimilarity(searcher).queryNorm(f);
        weight.normalize(f2);
        return weight;
    }

    public Query rewrite(IndexReader indexReader) throws IOException {
        return this;
    }

    public Query combine(Query[] queryArray) {
        throw new UnsupportedOperationException();
    }

    public static Query mergeBooleanQueries(Query[] queryArray) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < queryArray.length; ++i) {
            object = ((BooleanQuery)queryArray[i]).getClauses();
            for (int j = 0; j < ((Object)object).length; ++j) {
                hashSet.add(object[j]);
            }
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        object = hashSet.iterator();
        while (object.hasNext()) {
            booleanQuery.add((BooleanClause)object.next());
        }
        return booleanQuery;
    }

    public Similarity getSimilarity(Searcher searcher) {
        return searcher.getSimilarity();
    }

    public Object clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported: " + cloneNotSupportedException.getMessage());
        }
    }
}

