/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.SegmentTermEnum;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import java.io.IOException;

final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private ThreadLocal enumerators = new ThreadLocal();
    private SegmentTermEnum origEnum;
    private long size;
    Term[] indexTerms = null;
    TermInfo[] indexInfos;
    long[] indexPointers;

    TermInfosReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.directory = directory;
        this.segment = string;
        this.fieldInfos = fieldInfos;
        this.origEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tis"), this.fieldInfos, false);
        this.size = this.origEnum.size;
        this.readIndex();
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
    }

    final long size() {
        return this.size;
    }

    private SegmentTermEnum getEnum() {
        SegmentTermEnum segmentTermEnum = (SegmentTermEnum)this.enumerators.get();
        if (segmentTermEnum == null) {
            segmentTermEnum = this.terms();
            this.enumerators.set(segmentTermEnum);
        }
        return segmentTermEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readIndex() throws IOException {
        SegmentTermEnum segmentTermEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tii"), this.fieldInfos, true);
        try {
            int n = (int)segmentTermEnum.size;
            this.indexTerms = new Term[n];
            this.indexInfos = new TermInfo[n];
            this.indexPointers = new long[n];
            int n2 = 0;
            while (segmentTermEnum.next()) {
                this.indexTerms[n2] = segmentTermEnum.term();
                this.indexInfos[n2] = segmentTermEnum.termInfo();
                this.indexPointers[n2] = segmentTermEnum.indexPointer;
                ++n2;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            segmentTermEnum.close();
            throw throwable;
        }
        segmentTermEnum.close();
    }

    private final int getIndexOffset(Term term) throws IOException {
        int n = 0;
        int n2 = this.indexTerms.length - 1;
        while (n2 >= n) {
            int n3 = n + n2 >>> 1;
            int n4 = term.indexCompareTo(this.indexTerms[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return n2;
    }

    private final void seekEnum(int n) throws IOException {
        this.getEnum().seek(this.indexPointers[n], n * this.getEnum().indexInterval - 1, this.indexTerms[n], this.indexInfos[n]);
    }

    TermInfo get(Term term) throws IOException {
        int n;
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum segmentTermEnum = this.getEnum();
        if (segmentTermEnum.term() != null && (segmentTermEnum.prev != null && term.indexCompareTo(segmentTermEnum.prev) > 0 || term.indexCompareTo(segmentTermEnum.term()) >= 0) && (this.indexTerms.length == (n = (int)(segmentTermEnum.position / (long)segmentTermEnum.indexInterval) + 1) || term.indexCompareTo(this.indexTerms[n]) < 0)) {
            return this.scanEnum(term);
        }
        this.seekEnum(this.getIndexOffset(term));
        return this.scanEnum(term);
    }

    private final TermInfo scanEnum(Term term) throws IOException {
        SegmentTermEnum segmentTermEnum = this.getEnum();
        while (term.indexCompareTo(segmentTermEnum.term()) > 0 && segmentTermEnum.next()) {
        }
        if (segmentTermEnum.term() != null && term.indexCompareTo(segmentTermEnum.term()) == 0) {
            return segmentTermEnum.termInfo();
        }
        return null;
    }

    final Term get(int n) throws IOException {
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum segmentTermEnum = this.getEnum();
        if (segmentTermEnum != null && segmentTermEnum.term() != null && (long)n >= segmentTermEnum.position && (long)n < segmentTermEnum.position + (long)segmentTermEnum.indexInterval) {
            return this.scanEnum(n);
        }
        this.seekEnum(n / segmentTermEnum.indexInterval);
        return this.scanEnum(n);
    }

    private final Term scanEnum(int n) throws IOException {
        SegmentTermEnum segmentTermEnum = this.getEnum();
        while (segmentTermEnum.position < (long)n) {
            if (segmentTermEnum.next()) continue;
            return null;
        }
        return segmentTermEnum.term();
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        int n = this.getIndexOffset(term);
        this.seekEnum(n);
        SegmentTermEnum segmentTermEnum = this.getEnum();
        while (term.indexCompareTo(segmentTermEnum.term()) > 0 && segmentTermEnum.next()) {
        }
        if (term.indexCompareTo(segmentTermEnum.term()) == 0) {
            return segmentTermEnum.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term);
        return (SegmentTermEnum)this.getEnum().clone();
    }
}

