/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.LanguageAnalyser;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.util.Err;
import gate.util.profile.Profiler;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

@CreoleResource(name="Real-Time Corpus Pipeline", comment="A serial controller for PR pipelines over corpora which limits the run time of each PR.", icon="application-realtime", helpURL="http://gate.ac.uk/userguide/sec:creole-model:applications")
public class RealtimeCorpusController
extends SerialAnalyserController {
    private static final boolean DEBUG = false;
    private static final Logger logger = Logger.getLogger(RealtimeCorpusController.class);
    protected Profiler prof;
    protected HashMap<String, Long> timeMap;
    protected ExecutorService threadSource;
    protected volatile Thread currentWorkingThread;
    protected Long timeout;
    protected Long graceful;
    private static final int POLL_INTERVAL = 50;

    public void cleanup() {
        this.threadSource.shutdownNow();
        super.cleanup();
    }

    public Resource init() throws ResourceInstantiationException {
        this.threadSource = Executors.newSingleThreadExecutor();
        return super.init();
    }

    /*
     * Unable to fully structure code
     */
    public void executeImpl() throws ExecutionException {
        this.interrupted = false;
        if (this.corpus == null) {
            throw new ExecutionException("(SerialAnalyserController) \"" + this.getName() + "\":\n" + "The corpus supplied for execution was null!");
        }
        for (var1_1 = 0; var1_1 < this.corpus.size(); ++var1_1) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            var2_2 = this.corpus.isDocumentLoaded(var1_1);
            var3_3 = (Document)this.corpus.get(var1_1);
            var4_4 = this.threadSource.submit(new DocRunner(var3_3));
            var5_5 = 0L;
            if (this.graceful != -1L && (this.timeout == -1L || this.graceful < this.timeout)) {
                try {
                    var4_4.get(this.graceful, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException var7_6) {
                    var5_5 += this.graceful.longValue();
                    RealtimeCorpusController.logger.info((Object)"Execution timeout, attempting to gracefully stop worker thread...");
                    var4_4.cancel(true);
                    for (var8_11 = 0; var8_11 < this.prList.size(); ++var8_11) {
                        ((Executable)this.prList.get(var8_11)).interrupt();
                    }
                    var8_10 = this.timeout != -1L ? (this.timeout - this.graceful) / 2L : this.graceful / 2L;
                    try {
                        var4_4.get(var8_10, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException var10_17) {
                        var5_5 += var8_10;
                        RealtimeCorpusController.logger.info((Object)"Execution timeout, attempting to induce exception in order to stop worker thread...");
                        for (var11_20 = 0; var11_20 < this.prList.size(); ++var11_20) {
                            ((LanguageAnalyser)this.prList.get(var11_20)).setDocument(null);
                            ((LanguageAnalyser)this.prList.get(var11_20)).setCorpus(null);
                        }
                    }
                    catch (InterruptedException var10_18) {
                        Thread.currentThread().interrupt();
                    }
                    catch (java.util.concurrent.ExecutionException var10_19) {
                        throw new ExecutionException(var10_19);
                    }
                }
                catch (java.util.concurrent.ExecutionException var7_7) {
                    throw new ExecutionException(var7_7);
                }
                catch (InterruptedException var7_8) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.timeout != -1L) {
                var7_9 = this.timeout - var5_5;
                if (var7_9 > 0L) {
                    try {
                        var4_4.get(var7_9, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException var9_13) {
                        RealtimeCorpusController.logger.info((Object)"Execution timeout, worker thread will be forcibly terminated!");
                        var10_16 = this.currentWorkingThread;
                        if (var10_16 == null) ** GOTO lbl69
                        var10_16.stop();
                    }
                    catch (InterruptedException var9_14) {
                        Thread.currentThread().interrupt();
                    }
                    catch (java.util.concurrent.ExecutionException var9_15) {
                        throw new ExecutionException(var9_15);
                    }
                } else {
                    RealtimeCorpusController.logger.info((Object)"Execution timeout, worker thread will be forcibly terminated!");
                    var9_12 = this.currentWorkingThread;
                    if (var9_12 != null) {
                        var9_12.stop();
                    }
                }
            }
lbl69:
            // 9 sources

            if (var2_2) continue;
            this.getCorpus().unloadDocument(var3_3);
            Factory.deleteResource(var3_3);
        }
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @CreoleParameter(defaultValue="60000", comment="Timeout in milliseconds before execution on a document is forcibly stopped (forcibly stopping execution may result in memory leaks and/or unexpected behaviour)")
    public void setTimeout(Long l) {
        this.timeout = l;
    }

    public Long getGracefulTimeout() {
        return this.graceful;
    }

    @CreoleParameter(defaultValue="-1", comment="Timeout in milliseconds before execution on a document is gracefully stopped. Defaults to -1 which disables this functionality and relies, as previously, on forcibly stoping execution.")
    public void setGracefulTimeout(Long l) {
        this.graceful = l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DocRunner
    implements Callable<Object> {
        private Document document;

        public DocRunner(Document document) {
            this.document = document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object call() {
            try {
                try {
                    int n;
                    RealtimeCorpusController.this.currentWorkingThread = Thread.currentThread();
                    for (n = 0; n < RealtimeCorpusController.this.prList.size(); ++n) {
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(n)).setDocument(this.document);
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(n)).setCorpus(RealtimeCorpusController.this.corpus);
                    }
                    RealtimeCorpusController.this.interrupted = false;
                    RealtimeCorpusController.this.checkParameters();
                    RealtimeCorpusController.this.interrupted = false;
                    for (n = 0; n < RealtimeCorpusController.this.prList.size(); ++n) {
                        if (RealtimeCorpusController.this.isInterrupted()) {
                            throw new ExecutionInterruptedException("The execution of the " + RealtimeCorpusController.this.getName() + " application has been abruptly interrupted!");
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            Err.println("Execution on document " + this.document.getName() + " has been stopped");
                            break;
                        }
                        try {
                            RealtimeCorpusController.this.runComponent(n);
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (!Thread.currentThread().isInterrupted()) {
                                throw throwable;
                            }
                            Err.println("Execution on document " + this.document.getName() + " has been stopped");
                            break;
                        }
                    }
                    Object var4_5 = null;
                    RealtimeCorpusController.this.currentWorkingThread = null;
                }
                catch (ThreadDeath threadDeath) {
                    Err.prln("Execution on document " + this.document.getName() + " has been stopped");
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Err.prln("Execution on document " + this.document.getName() + " has caused an error:\n=========================");
                    throwable.printStackTrace(Err.getPrintWriter());
                    Err.prln("=========================\nError ignored...\n");
                    Object var4_6 = null;
                    RealtimeCorpusController.this.currentWorkingThread = null;
                    for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                        ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                RealtimeCorpusController.this.currentWorkingThread = null;
                int i = 0;
                while (true) {
                    if (i >= RealtimeCorpusController.this.prList.size()) {
                        throw throwable;
                    }
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
                    ++i;
                }
            }
            for (int i = 0; i < RealtimeCorpusController.this.prList.size(); ++i) {
                ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setDocument(null);
                ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(i)).setCorpus(null);
            }
            return null;
        }
    }
}

