/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ANNIETransducer;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.POSTagger;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.GateException;
import gate.util.Out;
import gate.util.profile.Profiler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ProfilePRs {
    private static String usage = "usage: ProfilePRs [-dir directory-name | file(s)]";
    private static double totalDocLength = 0.0;
    private static int docs = 0;
    private static Profiler prof = new Profiler();
    private static double maxDocLength = 0.0;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Out.prln("processing command line arguments");
        List<Object> list = null;
        if (stringArray.length < 1) {
            throw new GateException(usage);
        }
        if (stringArray[0].equals("-dir")) {
            if (stringArray.length < 2) {
                throw new GateException(usage);
            }
            object2 = new File(stringArray[1]);
            object = ((File)object2).listFiles();
            if (object == null) {
                throw new GateException(((File)object2).getPath() + " is not a directory; " + usage);
            }
            list = Arrays.asList(object);
        } else {
            list = new ArrayList<File>();
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(new File(stringArray[i]));
            }
        }
        prof.initRun("Measuring performance on directory " + stringArray[1]);
        prof.checkPoint("Before GATE.init()");
        Gate.init();
        prof.checkPoint("Before creating the processing resources");
        object2 = Factory.newFeatureMap();
        object = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", (FeatureMap)object2);
        prof.checkPoint("Tokeniser initialised");
        object2 = Factory.newFeatureMap();
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", (FeatureMap)object2);
        prof.checkPoint("Gazetteer initialised");
        object2 = Factory.newFeatureMap();
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter", (FeatureMap)object2);
        prof.checkPoint("Sentence splitter initialised");
        object2 = Factory.newFeatureMap();
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger", (FeatureMap)object2);
        prof.checkPoint("POSTagger initialised");
        object2 = Factory.newFeatureMap();
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer", (FeatureMap)object2);
        prof.checkPoint("Grammars initialised");
        object2 = Factory.newFeatureMap();
        OrthoMatcher orthoMatcher = (OrthoMatcher)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher", (FeatureMap)object2);
        prof.checkPoint("Orthomatcher initialised");
        Out.prln("\nLooping on input files list");
        Iterator<Object> iterator = list.iterator();
        docs = list.size();
        int n = 0;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            ++n;
            object2.clear();
            object2.put("sourceUrl", file.toURI().toURL().toExternalForm());
            object2.put("encoding", "");
            Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object2);
            totalDocLength += (double)document.getContent().size().longValue();
            if (maxDocLength < (double)document.getContent().size().longValue()) {
                maxDocLength = document.getContent().size().longValue();
            }
            ((AbstractLanguageAnalyser)object).setDocument(document);
            prof.checkPoint("Processing file " + file.getPath() + ", #" + n + "/" + docs, new String[0], true, false, false);
            ((DefaultTokeniser)object).execute();
            prof.checkPoint("", new String[]{"Tokenizer", "Processing"}, false, false, false);
            defaultGazetteer.setDocument(document);
            defaultGazetteer.execute();
            prof.checkPoint("", new String[]{"Gazettier", "Processing"}, false, false, false);
            sentenceSplitter.setDocument(document);
            sentenceSplitter.execute();
            prof.checkPoint("", new String[]{"Splitter", "Processing"}, false, false, false);
            pOSTagger.setDocument(document);
            pOSTagger.execute();
            prof.checkPoint("", new String[]{"Tagger", "Processing"}, false, false, false);
            aNNIETransducer.setDocument(document);
            aNNIETransducer.execute();
            prof.checkPoint("", new String[]{"JAPE grammars", "Processing"}, false, false, false);
            orthoMatcher.setDocument(document);
            orthoMatcher.execute();
            prof.checkPoint("", new String[]{"Orthomatcher", "Processing"}, false, false, false);
            Factory.deleteResource(document);
        }
        prof.checkPoint("Done!");
        Out.prln("\nTotal KBytes processed: " + (long)(totalDocLength /= 1024.0));
        Out.prln("\nMax document size in bytes: " + (long)maxDocLength + " (" + (long)maxDocLength / 1024L + " Kb)");
        prof.printCategAvg("Processing", docs, totalDocLength, "kb");
        prof.printCategAvg("Tokenizer", docs, totalDocLength, "kb");
        prof.printCategAvg("Gazettier", docs, totalDocLength, "kb");
        prof.printCategAvg("Splitter", docs, totalDocLength, "kb");
        prof.printCategAvg("Tagger", docs, totalDocLength, "kb");
        prof.printCategAvg("JAPE grammars", docs, totalDocLength, "kb");
        prof.printCategAvg("Orthomatcher", docs, totalDocLength, "kb");
    }
}

