/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterList
implements Serializable {
    private static final boolean DEBUG = false;
    protected List<List<Parameter>> runtimeParameters = new ArrayList<List<Parameter>>();
    protected List<List<Parameter>> initimeParameters = new ArrayList<List<Parameter>>();
    protected boolean fullyDefaulted = false;

    public List<List<Parameter>> getRuntimeParameters() {
        return this.runtimeParameters;
    }

    public List<List<Parameter>> getInitimeParameters() {
        return this.initimeParameters;
    }

    public boolean add(List<Parameter> list) {
        boolean bl = false;
        Iterator<Parameter> iterator = list.iterator();
        Parameter parameter = iterator.next();
        bl = parameter.isRuntime() ? this.runtimeParameters.add(list) : this.initimeParameters.add(list);
        return bl;
    }

    public boolean addAll(List<Parameter> list) {
        boolean bl = false;
        Iterator<Parameter> iterator = list.iterator();
        while (iterator.hasNext()) {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            Parameter parameter = iterator.next();
            arrayList.add(parameter);
            bl = this.add(arrayList);
        }
        return bl;
    }

    public FeatureMap getRuntimeDefaults() throws ParameterException {
        return this.getDefaults(this.runtimeParameters);
    }

    public FeatureMap getInitimeDefaults() throws ParameterException {
        return this.getDefaults(this.initimeParameters);
    }

    public FeatureMap getDefaults(List<List<Parameter>> list) throws ParameterException {
        FeatureMap featureMap = Factory.newFeatureMap();
        Iterator<List<Parameter>> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            boolean bl = false;
            List<Parameter> list2 = iterator.next();
            Iterator<Parameter> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Parameter parameter = iterator2.next();
                if (!bl) {
                    bl = parameter.isOptional();
                }
                if ((object = parameter.calculateDefaultValue()) == null) {
                    if (bl || iterator2.hasNext()) continue;
                    this.fullyDefaulted = false;
                    continue;
                }
                featureMap.put(parameter.getName(), object);
                continue block0;
            }
        }
        return featureMap;
    }

    public boolean isFullyDefaulted() {
        return this.fullyDefaulted;
    }

    public String toString() {
        Iterator<Parameter> iterator;
        List<Parameter> list;
        StringBuffer stringBuffer = new StringBuffer(Strings.getNl() + "  ParameterList:");
        Iterator<List<Parameter>> iterator2 = this.getRuntimeParameters().iterator();
        if (iterator2.hasNext()) {
            stringBuffer.append(Strings.getNl() + "  runtime params=");
        }
        while (iterator2.hasNext()) {
            stringBuffer.append(Strings.getNl() + "    ");
            list = iterator2.next();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + Strings.getNl() + "    ");
            }
        }
        iterator2 = this.getInitimeParameters().iterator();
        if (iterator2.hasNext()) {
            stringBuffer.append(Strings.getNl() + "  initime params=");
        }
        while (iterator2.hasNext()) {
            stringBuffer.append(Strings.getNl() + "    ");
            list = iterator2.next();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + Strings.getNl() + "    ");
            }
        }
        return stringBuffer.toString();
    }
}

