/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.SimpleAnnotation;
import gate.SimpleDocument;
import gate.annotation.AnnotationSetImpl;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final OffsetComparator OFFSET_COMPARATOR = new OffsetComparator();
    private static final Set<String> alreadyLoggedMessages = Collections.synchronizedSet(new HashSet());

    public static int length(SimpleAnnotation simpleAnnotation) {
        long l = Utils.lengthLong(simpleAnnotation);
        if (l > Integer.MAX_VALUE) {
            throw new GateRuntimeException("Length of annotation too big to be returned as an int: " + l);
        }
        return (int)l;
    }

    public static long lengthLong(SimpleAnnotation simpleAnnotation) {
        return simpleAnnotation.getEndNode().getOffset() - simpleAnnotation.getStartNode().getOffset();
    }

    public static int length(Document document) {
        long l = document.getContent().size();
        if (l > Integer.MAX_VALUE) {
            throw new GateRuntimeException("Length of document too big to be returned as an int: " + l);
        }
        return (int)l;
    }

    public static long lengthLong(Document document) {
        return document.getContent().size();
    }

    public static DocumentContent contentFor(SimpleDocument simpleDocument, SimpleAnnotation simpleAnnotation) {
        try {
            return simpleDocument.getContent().getContent(simpleAnnotation.getStartNode().getOffset(), simpleAnnotation.getEndNode().getOffset());
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new GateRuntimeException(invalidOffsetException.getMessage());
        }
    }

    public static String stringFor(Document document, SimpleAnnotation simpleAnnotation) {
        try {
            return document.getContent().getContent(simpleAnnotation.getStartNode().getOffset(), simpleAnnotation.getEndNode().getOffset()).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new GateRuntimeException(invalidOffsetException.getMessage());
        }
    }

    public static String stringFor(Document document, Long l, Long l2) {
        try {
            return document.getContent().getContent(l, l2).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new GateRuntimeException(invalidOffsetException.getMessage());
        }
    }

    public static DocumentContent contentFor(SimpleDocument simpleDocument, AnnotationSet annotationSet) {
        try {
            return simpleDocument.getContent().getContent(annotationSet.firstNode().getOffset(), annotationSet.lastNode().getOffset());
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new GateRuntimeException(invalidOffsetException.getMessage());
        }
    }

    public static String stringFor(Document document, AnnotationSet annotationSet) {
        try {
            return document.getContent().getContent(annotationSet.firstNode().getOffset(), annotationSet.lastNode().getOffset()).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new GateRuntimeException(invalidOffsetException.getMessage());
        }
    }

    public static Long start(SimpleAnnotation simpleAnnotation) {
        return simpleAnnotation.getStartNode() == null ? null : simpleAnnotation.getStartNode().getOffset();
    }

    public static Long start(AnnotationSet annotationSet) {
        return annotationSet.firstNode() == null ? null : annotationSet.firstNode().getOffset();
    }

    public static Long start(SimpleDocument simpleDocument) {
        return 0L;
    }

    public static Long end(SimpleAnnotation simpleAnnotation) {
        return simpleAnnotation.getEndNode() == null ? null : simpleAnnotation.getEndNode().getOffset();
    }

    public static Long end(AnnotationSet annotationSet) {
        return annotationSet.lastNode() == null ? null : annotationSet.lastNode().getOffset();
    }

    public static Long end(SimpleDocument simpleDocument) {
        return simpleDocument.getContent().size();
    }

    public static AnnotationSet getAnnotationsAtOffset(AnnotationSet annotationSet, Long l) {
        AnnotationSet annotationSet2 = annotationSet.get(l);
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(annotationSet.getDocument());
        for (Annotation annotation : annotationSet2) {
            if (!annotation.getStartNode().getOffset().equals(l)) continue;
            annotationSetImpl.add(annotation);
        }
        return annotationSetImpl;
    }

    public static List<Annotation> inDocumentOrder(AnnotationSet annotationSet) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        if (annotationSet != null) {
            arrayList.addAll(annotationSet);
            Collections.sort(arrayList, OFFSET_COMPARATOR);
        }
        return arrayList;
    }

    public static FeatureMap featureMap(Object ... objectArray) {
        FeatureMap featureMap = Factory.newFeatureMap();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                featureMap.put(objectArray[i], objectArray[++i]);
            }
        }
        return featureMap;
    }

    public static FeatureMap toFeatureMap(Map map) {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.putAll(map);
        return featureMap;
    }

    public static void logOnce(Logger logger, Level level, String string) {
        if (!alreadyLoggedMessages.contains(string)) {
            logger.log((Priority)level, (Object)string);
            alreadyLoggedMessages.add(string);
        }
    }
}

