/*
 * Decompiled with CFR 0.152.
 */
package hepple.postag;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import hepple.postag.InvalidRuleException;
import hepple.postag.Lexicon;
import hepple.postag.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class POSTagger {
    protected Map rules;
    Lexicon lexicon;
    private String encoding;
    static final String staart = "STAART";
    private String[] staartLex = new String[]{"STAART"};
    private String[] deflex_NNP = new String[]{"NNP"};
    private String[] deflex_JJ = new String[]{"JJ"};
    private String[] deflex_CD = new String[]{"CD"};
    private String[] deflex_NNS = new String[]{"NNS"};
    private String[] deflex_RB = new String[]{"RB"};
    private String[] deflex_VBG = new String[]{"VBG"};
    private String[] deflex_NN = new String[]{"NN"};
    public String[] wordBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[] tagBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[][] lexBuff = new String[][]{this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex};

    public POSTagger(URL uRL, URL uRL2) throws InvalidRuleException, IOException {
        this(uRL, uRL2, null);
    }

    public POSTagger(URL uRL, URL uRL2, String string) throws InvalidRuleException, IOException {
        this.encoding = string;
        this.lexicon = new Lexicon(uRL, string);
        this.rules = new HashMap();
        this.readRules(uRL2);
    }

    public Rule createNewRule(String string) throws InvalidRuleException {
        try {
            String string2 = "hepple.postag.rules.Rule_" + string;
            Class<?> clazz = Class.forName(string2);
            return (Rule)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new InvalidRuleException("Could not create rule " + string + "!\n" + exception.toString());
        }
    }

    public List runTagger(List list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (List list2 : list) {
            for (String string : list2) {
                this.oneStep(string, arrayList2);
            }
            for (int i = 0; i < 6; ++i) {
                this.oneStep(staart, arrayList2);
            }
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
        }
        return arrayList;
    }

    public void setEncoding(String string) {
        throw new IllegalStateException("Cannot change encoding once POS tagger has been constructed.  Use the three argument constructor to specify encoding.");
    }

    protected boolean oneStep(String string, List list) {
        Object object;
        for (int i = 1; i < 7; ++i) {
            this.wordBuff[i - 1] = this.wordBuff[i];
            this.tagBuff[i - 1] = this.tagBuff[i];
            this.lexBuff[i - 1] = this.lexBuff[i];
        }
        this.wordBuff[6] = string;
        this.lexBuff[6] = this.classifyWord(string);
        this.tagBuff[6] = this.lexBuff[6][0];
        List list2 = (List)this.rules.get(this.lexBuff[3][0]);
        if (list2 != null && list2.size() > 0) {
            object = list2.iterator();
            while (object.hasNext() && !((Rule)object.next()).apply(this)) {
            }
        }
        if ((object = this.wordBuff[0]) != staart) {
            list.add(new String[]{object, this.tagBuff[0]});
            if (this.wordBuff[1] == staart) {
                return true;
            }
        }
        return false;
    }

    public void readRules(URL uRL) throws IOException, InvalidRuleException {
        BufferedReader bufferedReader = this.encoding == null ? new BufferedReader(new InputStreamReader(uRL.openStream())) : new BufferedReader(new InputStreamReader(uRL.openStream(), this.encoding));
        String string = bufferedReader.readLine();
        while (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() < 3) {
                throw new InvalidRuleException(string);
            }
            Rule rule = this.createNewRule((String)arrayList.get(2));
            rule.initialise(arrayList);
            ArrayList<Rule> arrayList2 = (ArrayList<Rule>)this.rules.get(rule.from);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Rule>();
                this.rules.put(rule.from, arrayList2);
            }
            arrayList2.add(rule);
            string = bufferedReader.readLine();
        }
    }

    public void showRules() {
        System.out.println(this.rules);
    }

    protected String[] classifyWord(String string) {
        int n;
        if (string == staart) {
            return this.staartLex;
        }
        List list = (List)this.lexicon.get(string);
        if (list != null) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)list.get(i);
            }
            return stringArray;
        }
        if ('A' <= string.charAt(0) && string.charAt(0) <= 'Z') {
            return this.deflex_NNP;
        }
        for (n = 1; n < string.length() - 1; ++n) {
            if (string.charAt(n) != '-') continue;
            return this.deflex_JJ;
        }
        for (n = 0; n < string.length(); ++n) {
            if ('0' > string.charAt(n) || string.charAt(n) > '9') continue;
            return this.deflex_CD;
        }
        if (string.endsWith("ed") || string.endsWith("us") || string.endsWith("ic") || string.endsWith("ble") || string.endsWith("ive") || string.endsWith("ary") || string.endsWith("ful") || string.endsWith("ical") || string.endsWith("less")) {
            return this.deflex_JJ;
        }
        if (string.endsWith("s")) {
            return this.deflex_NNS;
        }
        if (string.endsWith("ly")) {
            return this.deflex_RB;
        }
        if (string.endsWith("ing")) {
            return this.deflex_VBG;
        }
        return this.deflex_NN;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            POSTagger.help();
        }
        try {
            int n;
            LongOpt[] longOptArray = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("lexicon", 0, null, 108), new LongOpt("rules", 0, null, 114)};
            Getopt getopt = new Getopt("HepTag", stringArray, "hl:r:", longOptArray);
            String string = null;
            String string2 = null;
            block7: while ((n = getopt.getopt()) != -1) {
                switch (n) {
                    case 104: {
                        POSTagger.help();
                        System.exit(0);
                        continue block7;
                    }
                    case 108: {
                        string = getopt.getOptarg();
                        continue block7;
                    }
                    case 114: {
                        string2 = getopt.getOptarg();
                        continue block7;
                    }
                }
                System.err.println("Invalid option " + stringArray[getopt.getOptind() - 1] + "!");
                System.exit(1);
            }
            String[] stringArray2 = new String[stringArray.length - getopt.getOptind()];
            for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
                stringArray2[i - getopt.getOptind()] = stringArray[i];
            }
            URL uRL = string == null ? POSTagger.class.getResource("/hepple/resources/sample_lexicon") : new File(string).toURI().toURL();
            URL uRL2 = string2 == null ? POSTagger.class.getResource("/hepple/resources/sample_ruleset.big") : new File(string2).toURI().toURL();
            POSTagger pOSTagger = new POSTagger(uRL, uRL2);
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
                    arrayList2.add(arrayList);
                    List list = pOSTagger.runTagger(arrayList2);
                    for (List list2 : list) {
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String[] stringArray3 = (String[])iterator.next();
                            System.out.print(stringArray3[0] + "/" + stringArray3[1]);
                            if (iterator.hasNext()) {
                                System.out.print(" ");
                                continue;
                            }
                            System.out.println();
                        }
                    }
                    string4 = bufferedReader.readLine();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("NAME\nHepTag - a Part-of-Speech tagger\nsee http://www.dcs.shef.ac.uk/~hepple/papers/acl00/abstract.html \n\nSYNOPSIS\n\tjava hepple.postag.POSTagger [options] file1 [file2 ...]\n\nOPTIONS:\n-h, --help \n\tdisplays this message\n-l, --lexicon <lexicon file>\n\tuses specified lexicon\n-r, --rules <rules file>\n\tuses specified rules");
    }

    private static List readInput(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        ArrayList arrayList = new ArrayList();
        while (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(stringTokenizer.nextToken());
            }
            arrayList.add(arrayList2);
            string2 = bufferedReader.readLine();
        }
        return arrayList;
    }
}

