/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.DataStore;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.GateRuntimeException;
import gate.util.MethodNotImplementedException;
import gate.wordnet.SynsetImpl;
import gate.wordnet.WNHelper;
import gate.wordnet.WordNet;
import gate.wordnet.WordNetException;
import gate.wordnet.WordSense;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class IndexFileWordNetImpl
extends AbstractLanguageResource
implements WordNet {
    private Dictionary wnDictionary;
    private URL propertyUrl;

    public Resource init() throws ResourceInstantiationException {
        if (null == this.propertyUrl) {
            throw new ResourceInstantiationException("property file not set");
        }
        try {
            InputStream inputStream = this.propertyUrl.openStream();
            JWNL.initialize((InputStream)inputStream);
            this.wnDictionary = Dictionary.getInstance();
            Assert.assertNotNull((Object)this.wnDictionary);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
        return this;
    }

    public Dictionary getJWNLDictionary() {
        return this.wnDictionary;
    }

    public void setPropertyUrl(URL uRL) {
        Assert.assertNotNull((Object)uRL);
        if (null != this.propertyUrl) {
            throw new GateRuntimeException("props are alredy set");
        }
        this.propertyUrl = uRL;
    }

    public URL getPropertyUrl() {
        return this.propertyUrl;
    }

    public String getVersion() {
        JWNL.Version version = JWNL.getVersion();
        return version.toString();
    }

    public Iterator getSynsets(int n) throws WordNetException {
        POS pOS = WNHelper.int2POS(n);
        try {
            Object var3_3 = null;
            Iterator iterator = this.wnDictionary.getSynsetIterator(pOS);
            return new SynsetIterator(iterator);
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }

    public Iterator getUniqueBeginners() {
        throw new MethodNotImplementedException();
    }

    public void setParent(LanguageResource languageResource) throws PersistenceException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public LanguageResource getParent() throws PersistenceException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        return false;
    }

    public void sync() throws PersistenceException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void setLRPersistenceId(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object getLRPersistenceId() {
        throw new UnsupportedOperationException();
    }

    public DataStore getDataStore() {
        return null;
    }

    public void setDataStore(DataStore dataStore) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    public List lookupWord(String string) throws WordNetException {
        try {
            IndexWord[] indexWordArray = this.wnDictionary.lookupAllIndexWords(string).getIndexWordArray();
            return this._lookupWord(string, indexWordArray);
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }

    public List lookupWord(String string, int n) throws WordNetException {
        try {
            IndexWord indexWord = this.wnDictionary.lookupIndexWord(WNHelper.int2POS(n), string);
            if (null == indexWord) {
                return new ArrayList();
            }
            IndexWord[] indexWordArray = new IndexWord[]{indexWord};
            return this._lookupWord(string, indexWordArray);
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }

    private List _lookupWord(String string, IndexWord[] indexWordArray) throws WordNetException {
        ArrayList<WordSense> arrayList = new ArrayList<WordSense>();
        try {
            for (int i = 0; i < indexWordArray.length; ++i) {
                IndexWord indexWord = indexWordArray[i];
                Synset[] synsetArray = indexWord.getSenses();
                block3: for (int j = 0; j < synsetArray.length; ++j) {
                    Synset synset = synsetArray[j];
                    SynsetImpl synsetImpl = new SynsetImpl(synset, this.wnDictionary);
                    List list = synsetImpl.getWordSenses();
                    for (WordSense wordSense : list) {
                        if (!wordSense.getWord().getLemma().equalsIgnoreCase(string)) continue;
                        arrayList.add(wordSense);
                        continue block3;
                    }
                }
            }
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
        return arrayList;
    }

    class SynsetIterator
    implements Iterator {
        private Iterator it;

        public SynsetIterator(Iterator iterator) {
            Assert.assertNotNull((Object)iterator);
            this.it = iterator;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            Synset synset = (Synset)this.it.next();
            SynsetImpl synsetImpl = new SynsetImpl(synset, IndexFileWordNetImpl.this.wnDictionary);
            return synsetImpl;
        }
    }
}

