/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Controller;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.SerialController;
import gate.util.spring.ResourceCustomiser;

public class AddPRResourceCustomiser
implements ResourceCustomiser {
    private int index = -1;
    private String addBefore = null;
    private String addAfter = null;
    private ProcessingResource pr;

    public void customiseResource(Resource resource) throws Exception {
        if (!(resource instanceof SerialController)) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only customise serial controllers");
        }
        SerialController serialController = (SerialController)resource;
        int n = this.index;
        if (n < 0) {
            if (this.addBefore != null) {
                if (this.addAfter != null) {
                    throw new IllegalArgumentException("Use either addBefore or addAfter, but not both");
                }
                n = this.findPR(this.addBefore, serialController);
            } else if (this.addAfter != null) {
                n = this.findPR(this.addAfter, serialController) + 1;
            }
        }
        if (n >= 0) {
            serialController.add(n, this.pr);
        } else {
            serialController.add(this.pr);
        }
    }

    private int findPR(String string, Controller controller) {
        int n = 0;
        for (Object e : controller.getPRs()) {
            if (string.equals(((ProcessingResource)e).getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    public void setAddAfter(String string) {
        this.addAfter = string;
    }

    public void setPr(ProcessingResource processingResource) {
        this.pr = processingResource;
    }
}

