/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;

public class GazetteerLists
extends DataType
implements ResourceCollection {
    private File definition;
    private String encoding = null;
    private String[] listNames = null;

    public void setDefinition(File file) {
        this.definition = file;
    }

    public Iterator iterator() {
        this.load();
        if (this.listNames.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new FileResourceIterator(this.definition.getParentFile(), this.listNames);
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public int size() {
        this.load();
        return this.listNames.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.log("Listing gazetteer lists", 3);
        if (this.definition == null) {
            throw new BuildException("\"definition\" attribute is required for gazetteerlists");
        }
        this.log("definition file: " + this.definition, 3);
        HashSet<String> hashSet = new HashSet<String>();
        File file = this.definition.getParentFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.definition);
            try {
                String string;
                InputStreamReader inputStreamReader = null;
                inputStreamReader = this.encoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, this.encoding);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf(58);
                    if (n <= 0) continue;
                    String string2 = string.substring(0, n);
                    hashSet.add(string2);
                    this.log("Found list file " + string2, 3);
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            {
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error reading gazetteer definition file " + this.definition, (Throwable)iOException);
        }
        this.listNames = hashSet.toArray(new String[hashSet.size()]);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

