/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.ReloadingClassLoader;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestReload
extends TestCase {
    private static final boolean DEBUG = false;

    public TestReload(String string) {
        super(string);
    }

    public void setUp() {
    }

    public static Test suite() {
        return new TestSuite(TestReload.class);
    }

    public void testReload() throws Exception {
        ReloadingClassLoader reloadingClassLoader = new ReloadingClassLoader();
        URL uRL = new URL("http://gate.ac.uk/tests/first.jar");
        reloadingClassLoader.load(uRL);
        Class clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
        String string = clazz.newInstance().toString();
        reloadingClassLoader.unload(uRL);
        try {
            clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
            Assert.assertTrue((String)"Class was found after being unloaded!", (boolean)false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        uRL = new URL("http://gate.ac.uk/tests/second.jar");
        reloadingClassLoader.load(uRL);
        clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
        String string2 = clazz.newInstance().toString();
        Assert.assertTrue((String)"Got same result from different versions of the class", (!string.equals(string2) ? 1 : 0) != 0);
    }

    public void testUnload() throws Exception {
        ReloadingClassLoader reloadingClassLoader = new ReloadingClassLoader();
        URL uRL = new URL("http://gate.ac.uk/tests/first.jar");
        reloadingClassLoader.load(uRL);
        Class clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
        String string = clazz.newInstance().toString();
        reloadingClassLoader.unload(uRL);
        try {
            clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
            Assert.assertTrue((String)"Class was found after being unloaded!", (boolean)false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void doNottestCache() throws Exception {
        long l;
        long l2;
        ReloadingClassLoader reloadingClassLoader = new ReloadingClassLoader();
        long l3 = 0L;
        URL uRL = new URL("http://gate.ac.uk/tests/first.jar");
        for (int i = 0; i < 100; ++i) {
            reloadingClassLoader.load(uRL);
            l2 = System.currentTimeMillis();
            Class clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
            l = System.currentTimeMillis();
            l3 += l - l2;
            reloadingClassLoader.unload(uRL);
        }
        reloadingClassLoader.load(uRL);
        Class clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
        long l4 = 0L;
        for (int i = 0; i < 100; ++i) {
            l2 = System.currentTimeMillis();
            clazz = reloadingClassLoader.loadClass("loader.Scratch", true);
            l = System.currentTimeMillis();
            l4 += l - l2;
        }
        Assert.assertTrue((String)"Cached classes load slower than fresh ones!", (l4 < l3 ? 1 : 0) != 0);
    }
}

