/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.util.AnnotationMerging;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAnnotationMerging
extends TestCase {
    int caseN;

    public TestAnnotationMerging(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(TestAnnotationMerging.class);
    }

    private Document loadDocument(String string, String string2) throws Exception {
        Document document = Factory.newDocument(Gate.getUrl(string), "UTF-8");
        document.setName(string2);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationMerging() throws Exception {
        Boolean bl = Gate.getUserConfig().getBoolean("Document_add_space_on_unpack");
        Gate.getUserConfig().put("Document_add_space_on_unpack", Boolean.FALSE);
        try {
            Corpus corpus = Factory.newCorpus("data");
            String string = "";
            String string2 = "";
            corpus.add(this.loadDocument("tests/iaa/beijing-opera.xml", "beijing-opera.xml"));
            String string3 = "ann1;ann2;ann3";
            boolean bl2 = false;
            string = "sent";
            string2 = "Op";
            this.caseN = 1;
            bl2 = true;
            this.testWithfeat(string3, string, string2, corpus, bl2);
            this.caseN = 2;
            bl2 = false;
            this.testWithfeat(string3, string, string2, corpus, bl2);
            string = "Os";
            string2 = null;
            this.caseN = 3;
            bl2 = true;
            this.testWithfeat(string3, string, string2, corpus, bl2);
            this.caseN = 4;
            bl2 = false;
            this.testWithfeat(string3, string, string2, corpus, bl2);
            Object var8_7 = null;
            Gate.getUserConfig().put("Document_add_space_on_unpack", bl);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Gate.getUserConfig().put("Document_add_space_on_unpack", bl);
            throw throwable;
        }
    }

    public void testWithfeat(String string, String string2, String string3, Corpus corpus, boolean bl) {
        int n;
        int n2;
        String[] stringArray = string.split(";");
        int n3 = stringArray.length;
        int n4 = corpus.size();
        AnnotationSet[][] annotationSetArray = new AnnotationSet[n4][n3];
        for (n2 = 0; n2 < n4; n2 += 1) {
            Document document = (Document)corpus.get(n2);
            for (n = 0; n < n3; ++n) {
                annotationSetArray[n2][n] = document.getAnnotations(stringArray[n]).get(string2);
            }
        }
        n2 = 1;
        for (int i = 0; i < annotationSetArray.length; ++i) {
            if (AnnotationMerging.isSameInstancesForAnnotators(annotationSetArray[i], 1)) continue;
            n2 = 0;
            break;
        }
        HashMap<Annotation, String> hashMap = new HashMap<Annotation, String>();
        if (bl) {
            AnnotationMerging.mergeAnnotationMajority(annotationSetArray[0], string3, hashMap, n2 != 0);
        } else {
            AnnotationMerging.mergeAnnotation(annotationSetArray[0], string3, hashMap, 2, n2 != 0);
        }
        n = 0;
        if (n2) {
            for (Annotation annotation : hashMap.keySet()) {
                if (annotation.getFeatures().get(string3) == null) continue;
                ++n;
            }
        } else {
            n = hashMap.size();
        }
        this.checkNumbers(n);
    }

    private void checkNumbers(int n) {
        switch (this.caseN) {
            case 1: {
                TestAnnotationMerging.assertEquals((int)n, (int)9);
                break;
            }
            case 2: {
                TestAnnotationMerging.assertEquals((int)n, (int)9);
                break;
            }
            case 3: {
                TestAnnotationMerging.assertEquals((int)n, (int)2);
                break;
            }
            case 4: {
                TestAnnotationMerging.assertEquals((int)n, (int)2);
                break;
            }
            default: {
                System.out.println("The test case " + this.caseN + " is not defined yet.");
            }
        }
    }
}

