/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleMapImpl
implements Map<Object, Object>,
Cloneable,
Serializable {
    int capacity = 3;
    int count = 0;
    Object[] theKeys = new Object[this.capacity];
    Object[] theValues = new Object[this.capacity];
    static final long serialVersionUID = -6747241616127229116L;
    static transient Object nullKey = new Object();
    public static transient HashMap theKeysHere = new HashMap();

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("SimpleMapImpl.values() not implemented!");
    }

    @Override
    public Set keySet() {
        HashSet<Object> hashSet = new HashSet<Object>(this.size());
        for (int i = 0; i < this.count; ++i) {
            Object object = this.theKeys[i];
            if (object == nullKey) {
                hashSet.add(null);
                continue;
            }
            hashSet.add(object);
        }
        return hashSet;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.theKeys[i] = null;
            this.theValues[i] = null;
        }
        this.count = 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getPostionByKey(object) != -1;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.getPostionByValue(object) != -1;
    }

    @Override
    public Object get(Object object) {
        int n = this.getPostionByKey(object);
        return n == -1 ? null : this.theValues[n];
    }

    @Override
    public Object put(Object object, Object object2) {
        Object object3;
        if (object == null) {
            object = nullKey;
            object3 = nullKey;
        } else {
            object3 = theKeysHere.get(object);
        }
        if (object3 != null) {
            for (int i = 0; i < this.count; ++i) {
                if (object3 != this.theKeys[i]) continue;
                Object object4 = this.theValues[i];
                this.theValues[i] = object2;
                return object4;
            }
        } else {
            theKeysHere.put(object, object);
            object3 = object;
        }
        if (this.count == this.capacity) {
            this.increaseCapacity();
        }
        this.theKeys[this.count] = object3;
        this.theValues[this.count] = object2;
        ++this.count;
        return null;
    }

    @Override
    public Object remove(Object object) {
        int n = this.getPostionByKey(object);
        if (n == -1) {
            return null;
        }
        Object object2 = this.theValues[n];
        --this.count;
        if (this.count != 0) {
            this.theKeys[n] = this.theKeys[this.count];
            this.theValues[n] = this.theValues[this.count];
        }
        this.theKeys[this.count] = null;
        this.theValues[this.count] = null;
        return object2;
    }

    @Override
    public void putAll(Map map) {
        if (map == null) {
            throw new UnsupportedOperationException("SimpleMapImpl.putAll argument is null");
        }
        if (map instanceof SimpleMapImpl) {
            SimpleMapImpl simpleMapImpl = (SimpleMapImpl)map;
            for (int i = 0; i < simpleMapImpl.count; ++i) {
                Object object = simpleMapImpl.theKeys[i];
                this.put(object, simpleMapImpl.theValues[i]);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private int getPostionByKey(Object object) {
        if (object == null) {
            object = nullKey;
        }
        if ((object = theKeysHere.get(object)) == null) {
            return -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (object != this.theKeys[i]) continue;
            return i;
        }
        return -1;
    }

    protected int getSubsumeKey(Object object) {
        for (int i = 0; i < this.count; ++i) {
            if (object != this.theKeys[i]) continue;
            return i;
        }
        return -1;
    }

    private int getPostionByValue(Object object) {
        for (int i = 0; i < this.count; ++i) {
            Object object2 = this.theValues[i];
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return i;
        }
        return -1;
    }

    private void increaseCapacity() {
        int n = this.capacity;
        this.capacity *= 2;
        Object[] objectArray = this.theKeys;
        this.theKeys = new Object[this.capacity];
        Object[] objectArray2 = this.theValues;
        this.theValues = new Object[this.capacity];
        System.arraycopy(objectArray, 0, this.theKeys, 0, n);
        System.arraycopy(objectArray2, 0, this.theValues, 0, n);
    }

    @Override
    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>(this.size());
        for (int i = 0; i < this.count; ++i) {
            Object object = this.theKeys[i];
            hashSet.add(new Entry(object.hashCode(), object == nullKey ? null : object, this.theValues[i]));
        }
        return hashSet;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            Object object2 = this.theKeys[i];
            Object v = map.get(object2);
            if (!(v == null ? this.theValues[i] != null : !v.equals(this.theValues[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public Object clone() {
        SimpleMapImpl simpleMapImpl;
        try {
            simpleMapImpl = (SimpleMapImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        simpleMapImpl.count = this.count;
        simpleMapImpl.theKeys = new Object[this.capacity];
        System.arraycopy(this.theKeys, 0, simpleMapImpl.theKeys, 0, this.capacity);
        simpleMapImpl.theValues = new Object[this.capacity];
        System.arraycopy(this.theValues, 0, simpleMapImpl.theValues, 0, this.capacity);
        return simpleMapImpl;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            Entry entry = (Entry)iterator.next();
            stringBuffer.append(entry.getKey() + "=" + entry.getValue());
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (theKeysHere == null) {
            theKeysHere = new HashMap();
            theKeysHere.put(nullKey, nullKey);
        }
        for (int i = 0; i < this.theKeys.length; ++i) {
            Object v = theKeysHere.get(this.theKeys[i]);
            if (v != null) {
                this.theKeys[i] = v;
                continue;
            }
            theKeysHere.put(this.theKeys[i], this.theKeys[i]);
        }
    }

    static {
        theKeysHere.put(nullKey, nullKey);
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;

        Entry(int n, Object object, Object object2) {
            this.hash = n;
            this.key = object;
            this.value = object2;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.key == null ? 0 : this.key.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

