/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.FeatureMap;
import gate.creole.ANNIEConstants;
import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.event.FeatureMapListener;
import gate.util.GateRuntimeException;
import gate.util.SimpleMapImpl;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;

public class SimpleFeatureMapImpl
extends SimpleMapImpl
implements FeatureMap,
Serializable,
Cloneable,
ANNIEConstants {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = -2747241616127229116L;
    private transient Vector mapListeners;

    public boolean subsumes(FeatureMap featureMap) {
        if (featureMap == null) {
            return true;
        }
        if (this.size() < featureMap.size()) {
            return false;
        }
        SimpleFeatureMapImpl simpleFeatureMapImpl = (SimpleFeatureMapImpl)featureMap;
        for (int i = 0; i < simpleFeatureMapImpl.count; ++i) {
            Object object = simpleFeatureMapImpl.theKeys[i];
            Object object2 = simpleFeatureMapImpl.theValues[i];
            int n = super.getSubsumeKey(object);
            if (n < 0) {
                return false;
            }
            Object object3 = this.theValues[n];
            if (object3 == null && object2 != null || object3 != null && object2 == null) {
                return false;
            }
            if (object3 == null || object2 == null || object3.equals(object2)) continue;
            return false;
        }
        return true;
    }

    public boolean subsumes(Ontology ontology, FeatureMap featureMap) {
        if (ontology == null) {
            return this.subsumes(featureMap);
        }
        if (featureMap == null) {
            return true;
        }
        if (this.size() < featureMap.size()) {
            return false;
        }
        SimpleFeatureMapImpl simpleFeatureMapImpl = (SimpleFeatureMapImpl)featureMap;
        for (int i = 0; i < simpleFeatureMapImpl.count; ++i) {
            Object object = simpleFeatureMapImpl.theKeys[i];
            Object object2 = simpleFeatureMapImpl.theValues[i];
            int n = super.getSubsumeKey(object);
            if (n < 0) {
                return false;
            }
            Object object3 = this.theValues[n];
            if (object3 == null && object2 != null || object3 != null && object2 == null) {
                return false;
            }
            if (object3 == null || object2 == null) continue;
            if (object.equals("class")) {
                try {
                    OClass oClass = (OClass)ontology.getOResourceByName(object2.toString());
                    OClass oClass2 = (OClass)ontology.getOResourceByName(object3.toString());
                    if (oClass == null || oClass2 == null) {
                        return false;
                    }
                    return oClass2 == oClass || oClass2.isSubClassOf(oClass, (byte)1);
                }
                catch (Exception exception) {
                    throw new GateRuntimeException(exception);
                }
            }
            if (object3.equals(object2)) continue;
            return false;
        }
        return true;
    }

    public boolean subsumes(FeatureMap featureMap, Set set) {
        if (set == null) {
            return this.subsumes(featureMap);
        }
        if (featureMap == null) {
            return true;
        }
        if (set.isEmpty()) {
            return true;
        }
        SimpleFeatureMapImpl simpleFeatureMapImpl = (SimpleFeatureMapImpl)featureMap;
        for (int i = 0; i < simpleFeatureMapImpl.count; ++i) {
            Object object = simpleFeatureMapImpl.theKeys[i];
            if (!set.contains(object)) continue;
            Object object2 = simpleFeatureMapImpl.theValues[i];
            Object object3 = this.get(object);
            if (object3 == null && object2 != null || object3 != null && object2 == null) {
                return false;
            }
            if (object3 == null || object2 == null || object3.equals(object2)) continue;
            return false;
        }
        return true;
    }

    public Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        this.fireMapUpdatedEvent();
        return object3;
    }

    public Object remove(Object object) {
        Object object2 = super.remove(object);
        this.fireMapUpdatedEvent();
        return object2;
    }

    public void clear() {
        super.clear();
        this.fireMapUpdatedEvent();
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public synchronized void removeFeatureMapListener(FeatureMapListener featureMapListener) {
        if (this.mapListeners != null && this.mapListeners.contains(featureMapListener)) {
            Vector vector = (Vector)this.mapListeners.clone();
            vector.removeElement(featureMapListener);
            this.mapListeners = vector;
        }
    }

    public synchronized void addFeatureMapListener(FeatureMapListener featureMapListener) {
        Vector vector;
        Vector vector2 = vector = this.mapListeners == null ? new Vector(2) : (Vector)this.mapListeners.clone();
        if (!vector.contains(featureMapListener)) {
            vector.addElement(featureMapListener);
            this.mapListeners = vector;
        }
    }

    protected void fireMapUpdatedEvent() {
        if (this.mapListeners != null) {
            Vector vector = this.mapListeners;
            int n = vector.size();
            if (n == 0) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                ((FeatureMapListener)vector.elementAt(i)).featureMapUpdated();
            }
        }
    }
}

