/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReloadingClassLoader
extends ClassLoader {
    protected Map loaders;
    protected ClassLoader parent;

    public ReloadingClassLoader(ClassLoader classLoader) {
        this.parent = classLoader;
        this.loaders = new HashMap();
    }

    public ReloadingClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public void load(URL uRL) {
        LocationClassLoader locationClassLoader = new LocationClassLoader(uRL);
        this.loaders.put(uRL, locationClassLoader);
    }

    public void unload(URL uRL) {
        this.loaders.remove(uRL);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = null;
        if (this.parent != null) {
            try {
                clazz = this.parent.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            Iterator iterator = this.loaders.values().iterator();
            while (clazz == null && iterator.hasNext()) {
                LocationClassLoader locationClassLoader = (LocationClassLoader)iterator.next();
                try {
                    clazz = locationClassLoader.loadClass(string, false);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected class LocationClassLoader
    extends URLClassLoader {
        protected Map classCache;
        protected URL location;

        public LocationClassLoader(URL uRL) {
            super(new URL[]{uRL}, (ClassLoader)null);
            this.location = uRL;
            this.classCache = new HashMap();
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (ReloadingClassLoader.this.parent != null) {
                try {
                    clazz = ReloadingClassLoader.this.parent.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = (Class<?>)this.classCache.get(string);
            }
            if (clazz == null) {
                clazz = this.findClass(string);
                this.classCache.put(string, clazz);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

