/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class ObjectWriter
extends Thread {
    private static final boolean DEBUG = false;
    private Object object;
    private InputStream inputStream;
    private PipedOutputStream outputStream;
    private int size = 0;
    private int lastOffset;
    private LinkedList buffer;
    private int buffSize = 1024;

    public ObjectWriter(Object object) throws IOException {
        Writer writer = new Writer(object);
        InputStream inputStream = writer.getInputStream();
        writer.start();
        boolean bl = false;
        this.buffer = new LinkedList();
        int n = this.buffSize;
        int n2 = 0;
        byte[] byArray = new byte[this.buffSize];
        while (!bl) {
            int n3 = inputStream.read(byArray, n2, n);
            if (n3 == -1) {
                this.lastOffset = n2;
                this.buffer.addLast(byArray);
                bl = true;
                continue;
            }
            this.size += n3;
            if ((n -= n3) == 0) {
                this.buffer.addLast(byArray);
                n = this.buffSize;
                n2 = 0;
                byArray = new byte[this.buffSize];
                continue;
            }
            n2 += n3;
        }
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.outputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getSize() {
        return this.size;
    }

    public void run() {
        try {
            Iterator iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                if (iterator.hasNext()) {
                    this.outputStream.write(byArray, 0, this.buffSize);
                    continue;
                }
                this.outputStream.write(byArray, 0, this.lastOffset);
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private class Writer
    extends Thread {
        private Object _object;
        private InputStream _inputStream;
        private PipedOutputStream _outputStream;

        public Writer(Object object) {
            this._object = object;
            this._outputStream = new PipedOutputStream();
            try {
                this._inputStream = new PipedInputStream(this._outputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(Err.getPrintWriter());
            }
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        public void run() {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this._outputStream);
                objectOutputStream.writeObject(this._object);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

