/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import gate.util.GateException;
import gate.util.Out;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;

public class JarFiles {
    private static final boolean DEBUG = false;
    private StringBuffer dbgString = new StringBuffer();
    private boolean warning = false;
    String buggyJar = null;
    private static final int BUFF_SIZE = 65000;
    private Set directorySet = new HashSet();
    private byte[] buffer = new byte[65000];

    public void merge(Set set, String string) throws GateException {
        String string22 = null;
        JarOutputStream jarOutputStream = null;
        JarFile jarFile = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(string));
            this.dbgString.append("Creating " + string + " from these JARs:\n");
            for (String string22 : set) {
                jarFile = new JarFile(string22);
                this.addJar(jarOutputStream, jarFile);
                if (jarFile.getName().equals(this.buggyJar)) {
                    this.dbgString.append(string22 + "...problems occured ! \n");
                } else {
                    this.dbgString.append(string22 + "...added OK ! \n");
                }
                jarFile.close();
            }
            jarOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(Err.getPrintWriter());
        }
        if (this.warning) {
            Out.prln(this.dbgString);
        }
    }

    private void addJar(JarOutputStream jarOutputStream, JarFile jarFile) throws GateException {
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.getName().equalsIgnoreCase("META-INF/") || jarEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || jarEntry.isDirectory() && this.directorySet.contains(jarEntry.getName())) continue;
                try {
                    if (jarEntry.isDirectory()) {
                        this.directorySet.add(jarEntry.getName());
                    }
                    jarOutputStream.putNextEntry(new JarEntry(jarEntry.getName()));
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    int n = 0;
                    while ((n = inputStream.read(this.buffer, 0, 65000)) != -1) {
                        jarOutputStream.write(this.buffer, 0, n);
                    }
                    inputStream.close();
                    jarOutputStream.flush();
                    jarOutputStream.closeEntry();
                }
                catch (ZipException zipException) {
                    if (jarEntry.isDirectory()) continue;
                    this.warning = true;
                    this.buggyJar = jarFile.getName();
                    Out.prln("WARNING: Duplicate file entry " + jarEntry.getName() + " (this file will be discarded)..." + "It happened while adding " + jarFile.getName() + " !\n");
                    this.dbgString.append(jarEntry.getName() + " file from " + jarFile.getName() + " was discarded :( !\n");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(Err.getPrintWriter());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            Err.println("USAGE : JarFiles arg0 arg1 ... argN(must be at least 2 args)");
        } else {
            JarFiles jarFiles = new JarFiles();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 1; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            try {
                jarFiles.merge(hashSet, stringArray[0]);
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

