/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.security.SecurityException;
import gate.util.AnnotationDiffer;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.OffsetComparator;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.SwingUtilities;

public class CorpusBenchmarkTool {
    private static final String MARKED_DIR_NAME = "marked";
    private static final String CLEAN_DIR_NAME = "clean";
    private static final String CVS_DIR_NAME = "Cvs";
    private static final String PROCESSED_DIR_NAME = "processed";
    private static final String ERROR_DIR_NAME = "err";
    private static final boolean DEBUG = true;
    private double precisionSumCalc = 0.0;
    private double recallSumCalc = 0.0;
    private double fMeasureSumCalc = 0.0;
    private File startDir;
    private File currDir;
    private static List annotTypes;
    private Controller application = null;
    private File applicationFile = null;
    private double precisionSum = 0.0;
    private double recallSum = 0.0;
    private double fMeasureSum = 0.0;
    private HashMap precisionByType = new HashMap();
    private HashMap prCountByType = new HashMap();
    private HashMap recallByType = new HashMap();
    private HashMap recCountByType = new HashMap();
    private HashMap fMeasureByType = new HashMap();
    private HashMap fMeasureCountByType = new HashMap();
    private HashMap missingByType = new HashMap();
    private HashMap spurByType = new HashMap();
    private HashMap correctByType = new HashMap();
    private HashMap partialByType = new HashMap();
    static boolean hasProcessed;
    private double proc_precisionSum = 0.0;
    private double proc_recallSum = 0.0;
    private double proc_fMeasureSum = 0.0;
    private HashMap proc_precisionByType = new HashMap();
    private HashMap proc_prCountByType = new HashMap();
    private HashMap proc_recallByType = new HashMap();
    private HashMap proc_recCountByType = new HashMap();
    private HashMap proc_fMeasureByType = new HashMap();
    private HashMap proc_fMeasureCountByType = new HashMap();
    private HashMap proc_missingByType = new HashMap();
    private HashMap proc_spurByType = new HashMap();
    private HashMap proc_correctByType = new HashMap();
    private HashMap proc_partialByType = new HashMap();
    double beta = 1.0;
    private int docNumber = 0;
    private boolean isGenerateMode = false;
    private boolean isVerboseMode = false;
    private boolean isMoreInfoMode = false;
    private Set diffFeaturesSet;
    private boolean isMarkedStored = false;
    private boolean isMarkedClean = false;
    private boolean isMarkedDS = false;
    private String annotSetName = "Key";
    private String outputSetName = null;
    private double threshold = 0.5;
    private Properties configs = new Properties();
    private static int corpusWordCount;
    private String documentEncoding = "";
    private static String usage;

    public void initPRs() {
        try {
            if (this.applicationFile == null) {
                Out.prln("Application not set!");
            }
            Out.prln("App file is: " + this.applicationFile.getAbsolutePath());
            this.application = (Controller)PersistenceManager.loadObjectFromFile(this.applicationFile);
        }
        catch (Exception exception) {
            throw (GateRuntimeException)new GateRuntimeException("Corpus Benchmark Tool:" + exception.getMessage()).initCause(exception);
        }
    }

    public void unloadPRs() {
        if (this.isMarkedStored) {
            return;
        }
    }

    public void execute() {
        this.execute(this.startDir);
        if (this.application != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator iterator = new ArrayList(CorpusBenchmarkTool.this.application.getPRs()).iterator();
                    while (iterator.hasNext()) {
                        Factory.deleteResource((Resource)iterator.next());
                    }
                    Factory.deleteResource(CorpusBenchmarkTool.this.application);
                }
            });
        }
    }

    public void init() {
        File file = new File("corpus_tool.properties");
        Out.prln(file.getAbsolutePath());
        if (file.exists()) {
            try {
                Object object;
                String string;
                String string2;
                String string3;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.configs.load(fileInputStream);
                String string4 = this.configs.getProperty("threshold");
                if (string4 != null && !string4.equals("")) {
                    string4 = string4.trim();
                    this.threshold = new Double(string4);
                    Out.prln("New threshold is: " + this.threshold + "<P>\n");
                }
                if ((string3 = this.configs.getProperty("annotSetName")) != null && !string3.equals("")) {
                    string3 = string3.trim();
                    Out.prln("Annotation set in marked docs is: " + string3 + " <P>\n");
                    this.annotSetName = string3;
                }
                if ((string3 = this.configs.getProperty("outputSetName")) != null && !string3.equals("")) {
                    string3 = string3.trim();
                    Out.prln("Annotation set in processed docs is: " + string3 + " <P>\n");
                    this.outputSetName = string3;
                }
                if ((string2 = this.configs.getProperty("encoding")) != null && !string2.equals("")) {
                    this.documentEncoding = string2 = string2.trim();
                    Out.prln("New encoding is: " + this.documentEncoding + "<P>\n");
                }
                if ((string = this.configs.getProperty("annotTypes")) != null && !string.equals("")) {
                    string = string.trim();
                    Out.prln("Using annotation types from the properties file. <P>\n");
                    object = new StringTokenizer(string, ";");
                    annotTypes = new ArrayList();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        annotTypes.add(((StringTokenizer)object).nextToken());
                    }
                } else {
                    annotTypes = new ArrayList();
                    annotTypes.add("Organization");
                    annotTypes.add("Person");
                    annotTypes.add("Date");
                    annotTypes.add("Location");
                    annotTypes.add("Address");
                    annotTypes.add("Money");
                    annotTypes.add("Percent");
                    annotTypes.add("GPE");
                    annotTypes.add("Facility");
                }
                object = this.configs.getProperty("annotFeatures");
                HashSet<String> hashSet = new HashSet<String>();
                if (object != null && !((String)object).equals("")) {
                    object = ((String)object).trim();
                    Out.pr("Using annotation features from the properties file. \n");
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        hashSet.add(string5);
                    }
                }
                this.diffFeaturesSet = hashSet;
                Out.prln("Features: " + this.diffFeaturesSet + " <P>\n");
            }
            catch (IOException iOException) {
                this.configs = new Properties();
            }
        } else {
            this.configs = new Properties();
        }
        if (!this.isMarkedStored) {
            this.initPRs();
        }
    }

    public void execute(File file) {
        int n;
        if (file == null) {
            return;
        }
        this.currDir = file;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.currDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isFile() || fileArray[n].getName().equals(CVS_DIR_NAME)) continue;
            if (fileArray[n].getName().equals(CLEAN_DIR_NAME)) {
                file3 = fileArray[n];
                continue;
            }
            if (fileArray[n].getName().equals(MARKED_DIR_NAME)) {
                file4 = fileArray[n];
                continue;
            }
            if (fileArray[n].getName().equals(PROCESSED_DIR_NAME)) {
                file2 = fileArray[n];
                continue;
            }
            if (fileArray[n].getName().equals(ERROR_DIR_NAME)) {
                file5 = fileArray[n];
                continue;
            }
            arrayList.add(fileArray[n]);
        }
        if (file3 == null) {
            return;
        }
        Out.prln("Processing directory: " + this.currDir + "<P>");
        if (this.isGenerateMode) {
            this.generateCorpus(file3, file2);
        } else {
            this.evaluateCorpus(file3, file2, file4, file5);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.execute((File)arrayList.get(n));
        }
    }

    public static void main(String[] stringArray) throws GateException {
        String string;
        File file;
        int n;
        Out.prln("<HTML>");
        Out.prln("<HEAD>");
        Out.prln("<TITLE> Corpus benchmark tool: ran with args ");
        for (int i = 0; i < stringArray.length; ++i) {
            Out.pr(stringArray[i] + " ");
        }
        Out.pr(" on " + new Date() + "</TITLE> </HEAD>");
        Out.prln("<BODY>");
        Out.prln("Please wait while GATE tools are initialised. <P>");
        Gate.init();
        CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
        Object var2_3 = null;
        if (stringArray.length < 1) {
            throw new GateException(usage);
        }
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-generate")) {
                Out.prln("Generating the corpus... <P>");
                corpusBenchmarkTool.setGenerateMode(true);
                continue;
            }
            if (stringArray[n].equals("-marked_clean")) {
                Out.prln("Evaluating current grammars against human-annotated...<P>");
                corpusBenchmarkTool.setMarkedClean(true);
                continue;
            }
            if (stringArray[n].equals("-marked_stored")) {
                Out.prln("Evaluating stored documents against human-annotated...<P>");
                corpusBenchmarkTool.setMarkedStored(true);
                continue;
            }
            if (stringArray[n].equals("-marked_ds")) {
                Out.prln("Looking for marked docs in a datastore...<P>");
                corpusBenchmarkTool.setMarkedDS(true);
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                Out.prln("Running in verbose mode. Will generate annotation information when precision/recall are lower than " + corpusBenchmarkTool.getThreshold() + "<P>");
                corpusBenchmarkTool.setVerboseMode(true);
                continue;
            }
            if (!stringArray[n].equals("-moreinfo")) continue;
            Out.prln("Show more details in document table...<P>");
            corpusBenchmarkTool.setMoreInfo(true);
        }
        String string2 = stringArray[n];
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            throw new GateException(usage);
        }
        if (!(file = new File(string = stringArray[++n])).isFile()) {
            throw new GateException(usage);
        }
        corpusBenchmarkTool.setApplicationFile(file);
        corpusBenchmarkTool.init();
        corpusWordCount = 0;
        Out.prln("Measuring annotaitions of types: " + annotTypes + "<P>");
        corpusBenchmarkTool.setStartDirectory(file2);
        corpusBenchmarkTool.execute();
        if (!corpusBenchmarkTool.getGenerateMode()) {
            corpusBenchmarkTool.printStatistics();
        }
        Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
        Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
        Out.prln("<BR>Overall average fMeasure: " + corpusBenchmarkTool.getFMeasureAverage());
        if (corpusWordCount == 0) {
            Out.prln("<BR>No Token annotations to count words in the corpus.");
        } else {
            Out.prln("<BR>Overall word count: " + corpusWordCount);
        }
        if (hasProcessed) {
            Out.prln("<P>Old Processed: ");
            Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverageProc());
            Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverageProc());
            Out.prln("<BR>Overall average fMeasure: " + corpusBenchmarkTool.getFMeasureAverageProc());
        }
        Out.prln("<BR>Finished! <P>");
        Out.prln("</BODY>");
        Out.prln("</HTML>");
        System.exit(0);
    }

    public void setGenerateMode(boolean bl) {
        this.isGenerateMode = bl;
    }

    public boolean getGenerateMode() {
        return this.isGenerateMode;
    }

    public boolean getVerboseMode() {
        return this.isVerboseMode;
    }

    public void setVerboseMode(boolean bl) {
        this.isVerboseMode = bl;
    }

    public void setMoreInfo(boolean bl) {
        this.isMoreInfoMode = bl;
    }

    public boolean getMoreInfo() {
        return this.isMoreInfoMode;
    }

    public void setDiffFeaturesList(Set set) {
        this.diffFeaturesSet = set;
    }

    public Set getDiffFeaturesList() {
        return this.diffFeaturesSet;
    }

    public void setMarkedStored(boolean bl) {
        this.isMarkedStored = bl;
    }

    public boolean getMarkedStored() {
        return this.isMarkedStored;
    }

    public void setMarkedClean(boolean bl) {
        this.isMarkedClean = bl;
    }

    public boolean getMarkedClean() {
        return this.isMarkedClean;
    }

    public void setMarkedDS(boolean bl) {
        this.isMarkedDS = bl;
    }

    public boolean getMarkedDS() {
        return this.isMarkedDS;
    }

    public void setApplicationFile(File file) {
        this.applicationFile = file;
    }

    public double getPrecisionAverage() {
        return this.precisionSum / (double)this.docNumber;
    }

    public double getRecallAverage() {
        return this.recallSum / (double)this.docNumber;
    }

    public double getFMeasureAverage() {
        return this.fMeasureSum / (double)this.docNumber;
    }

    public double getPrecisionAverageProc() {
        return this.proc_precisionSum / (double)this.docNumber;
    }

    public double getRecallAverageProc() {
        return this.proc_recallSum / (double)this.docNumber;
    }

    public double getFMeasureAverageProc() {
        return this.proc_fMeasureSum / (double)this.docNumber;
    }

    public boolean isGenerateMode() {
        return this.isGenerateMode;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public File getStartDirectory() {
        return this.startDir;
    }

    public void setStartDirectory(File file) {
        this.startDir = file;
    }

    protected void generateCorpus(File file, File file2) {
        if (file == null) {
            return;
        }
        File file3 = file2;
        if (file2 == null) {
            file3 = new File(this.currDir, PROCESSED_DIR_NAME);
        } else if (!Files.rmdir(file3)) {
            Out.prln("cannot delete old output directory: " + file3);
        }
        file3.mkdir();
        try {
            SerialDataStore serialDataStore = new SerialDataStore(file3.toURI().toURL().toString());
            serialDataStore.create();
            serialDataStore.open();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                Out.prln("Processing and storing document: " + fileArray[i].toURI().toURL() + "<P>");
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("sourceUrl", fileArray[i].toURI().toURL());
                featureMap.put("encoding", this.documentEncoding);
                FeatureMap featureMap2 = Factory.newFeatureMap();
                final Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2);
                document.setName(fileArray[i].getName());
                if (document == null) continue;
                this.processDocument(document);
                final LanguageResource languageResource = serialDataStore.adopt(document, null);
                serialDataStore.sync(languageResource);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Factory.deleteResource(document);
                        Factory.deleteResource(languageResource);
                    }
                });
            }
            serialDataStore.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + malformedURLException.getMessage()).initCause(malformedURLException);
        }
        catch (PersistenceException persistenceException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + persistenceException.getMessage()).initCause(persistenceException);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + resourceInstantiationException.getMessage()).initCause(resourceInstantiationException);
        }
        catch (SecurityException securityException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + securityException.getMessage()).initCause(securityException);
        }
    }

    protected void evaluateCorpus(File file, File file2, File file3, File file4) {
        boolean bl;
        if (file == null || !file.exists()) {
            return;
        }
        if (file2 == null || !file2.exists()) {
            if (this.isMarkedStored) {
                Out.prln("Cannot evaluate because no processed documents exist.");
                return;
            }
            this.isMarkedClean = true;
        }
        File file5 = null;
        if (this.isMoreInfoMode) {
            file5 = file4;
            if (file5 == null) {
                file5 = new File(this.currDir, ERROR_DIR_NAME);
            } else if (!Files.rmdir(file5)) {
                Out.prln("cannot delete old error directory: " + file5);
            }
            Out.prln("Create error directory: " + file5 + "<BR><BR>");
            file5.mkdir();
        }
        boolean bl2 = bl = file3 != null && file3.exists();
        if (!bl && (this.isMarkedStored || this.isMarkedClean)) {
            Out.prln("Cannot evaluate because no human-annotated documents exist.");
            return;
        }
        if (this.isMarkedStored) {
            this.evaluateMarkedStored(file3, file2, file5);
            return;
        }
        if (this.isMarkedClean) {
            this.evaluateMarkedClean(file3, file, file5);
            return;
        }
        Document document = null;
        Document document2 = null;
        Document document3 = null;
        try {
            DataStore dataStore = Factory.openDataStore("gate.persist.SerialDataStore", file2.toURI().toURL().toExternalForm());
            List list = dataStore.getLrIds("gate.corpora.DocumentImpl");
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                Object object3;
                Comparable<StringBuffer> comparable;
                String string = (String)list.get(i);
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("DataStore", dataStore);
                featureMap.put("LRPersistenceId", string);
                FeatureMap featureMap2 = Factory.newFeatureMap();
                document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2);
                if (this.isMoreInfoMode) {
                    comparable = new StringBuffer(document.getName());
                    ((StringBuffer)comparable).replace(document.getName().lastIndexOf("."), document.getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + ((StringBuffer)comparable).toString() + "\">" + document.getName() + "</a>" + "</H2>");
                } else {
                    Out.prln("<H2>" + document.getName() + "</H2>");
                }
                comparable = new File(file, document.getName());
                if (!((File)comparable).exists()) {
                    Out.prln("Warning: Cannot find original document " + document.getName() + " in " + file);
                } else {
                    object3 = Factory.newFeatureMap();
                    object3.put("sourceUrl", ((File)comparable).toURI().toURL());
                    object3.put("encoding", this.documentEncoding);
                    document2 = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object3, featureMap2);
                    document2.setName(document.getName());
                }
                object3 = new StringBuffer(document.getName());
                if (!this.isMarkedDS) {
                    ((StringBuffer)object3).replace(document.getName().lastIndexOf("."), ((StringBuffer)object3).length(), ".xml");
                    object2 = new File(file3, ((StringBuffer)object3).toString());
                    if (!bl || !((File)object2).exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + object2 + " in " + file3);
                    } else {
                        object = Factory.newFeatureMap();
                        object.put("sourceUrl", ((File)object2).toURI().toURL());
                        object.put("encoding", this.documentEncoding);
                        document3 = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object, featureMap2);
                        document3.setName(document.getName());
                    }
                } else {
                    object2 = Factory.openDataStore("gate.persist.SerialDataStore", file3.toURI().toURL().toExternalForm());
                    object = object2.getLrIds("gate.corpora.DocumentImpl");
                    boolean bl3 = false;
                    int n = 0;
                    while (n < object.size() && !bl3) {
                        String string2 = (String)object.get(n);
                        FeatureMap featureMap3 = Factory.newFeatureMap();
                        featureMap3.put("DataStore", object2);
                        featureMap3.put("LRPersistenceId", string2);
                        Document document4 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap3, featureMap2);
                        if (((String)document4.getFeatures().get("gate.SourceURL")).endsWith(document.getName())) {
                            bl3 = true;
                            document3 = document4;
                            continue;
                        }
                        ++n;
                    }
                }
                this.evaluateDocuments(document, document2, document3, file5);
                if (document != null) {
                    object2 = document;
                    SwingUtilities.invokeLater(new Runnable((Document)object2){
                        final /* synthetic */ Document val$pd;
                        {
                            this.val$pd = document;
                        }

                        public void run() {
                            Factory.deleteResource(this.val$pd);
                        }
                    });
                }
                if (document2 != null) {
                    object2 = document2;
                    SwingUtilities.invokeLater(new Runnable((Document)object2){
                        final /* synthetic */ Document val$cd;
                        {
                            this.val$cd = document;
                        }

                        public void run() {
                            Factory.deleteResource(this.val$cd);
                        }
                    });
                }
                if (document3 == null) continue;
                object2 = document3;
                SwingUtilities.invokeLater(new Runnable((Document)object2){
                    final /* synthetic */ Document val$md;
                    {
                        this.val$md = document;
                    }

                    public void run() {
                        Factory.deleteResource(this.val$md);
                    }
                });
            }
            dataStore.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + malformedURLException.getMessage()).initCause(malformedURLException);
        }
        catch (PersistenceException persistenceException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + persistenceException.getMessage()).initCause(persistenceException);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + resourceInstantiationException.getMessage()).initCause(resourceInstantiationException);
        }
    }

    protected void evaluateMarkedStored(File file, File file2, File file3) {
        Document document = null;
        Document document2 = null;
        Document document3 = null;
        try {
            DataStore dataStore = Factory.openDataStore("gate.persist.SerialDataStore", file2.toURI().toURL().toExternalForm());
            List list = dataStore.getLrIds("gate.corpora.DocumentImpl");
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                String string = (String)list.get(i);
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("DataStore", dataStore);
                featureMap.put("LRPersistenceId", string);
                FeatureMap featureMap2 = Factory.newFeatureMap();
                document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2);
                if (this.isMoreInfoMode) {
                    object2 = new StringBuffer(document.getName());
                    ((StringBuffer)object2).replace(document.getName().lastIndexOf("."), document.getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + ((StringBuffer)object2).toString() + "\">" + document.getName() + "</a>" + "</H2>");
                } else {
                    Out.prln("<H2>" + document.getName() + "</H2>");
                }
                if (!this.isMarkedDS) {
                    object2 = new StringBuffer(document.getName());
                    ((StringBuffer)object2).replace(document.getName().lastIndexOf("."), ((StringBuffer)object2).length(), ".xml");
                    object = new File(file, ((StringBuffer)object2).toString());
                    if (!((File)object).exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + object + " in " + file);
                    } else {
                        FeatureMap featureMap3 = Factory.newFeatureMap();
                        featureMap3.put("sourceUrl", ((File)object).toURI().toURL());
                        featureMap3.put("encoding", this.documentEncoding);
                        document3 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap3, featureMap2);
                        document3.setName(document.getName());
                    }
                } else {
                    try {
                        object2 = Factory.openDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toExternalForm());
                        object = object2.getLrIds("gate.corpora.DocumentImpl");
                        boolean bl = false;
                        int n = 0;
                        while (n < object.size() && !bl) {
                            String string2 = (String)object.get(n);
                            FeatureMap featureMap4 = Factory.newFeatureMap();
                            featureMap4.put("DataStore", object2);
                            featureMap4.put("LRPersistenceId", string2);
                            Document document4 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap4, featureMap2);
                            if (((String)document4.getFeatures().get("gate.SourceURL")).endsWith(document.getName())) {
                                bl = true;
                                document3 = document4;
                                continue;
                            }
                            ++n;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Out.prln("Error finding marked directory " + file.getAbsolutePath());
                    }
                    catch (PersistenceException persistenceException) {
                        Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                    }
                }
                this.evaluateDocuments(document, document2, document3, file3);
                if (document != null) {
                    object2 = document;
                    SwingUtilities.invokeLater(new Runnable((Document)object2){
                        final /* synthetic */ Document val$pd;
                        {
                            this.val$pd = document;
                        }

                        public void run() {
                            Factory.deleteResource(this.val$pd);
                        }
                    });
                }
                if (document3 == null) continue;
                object2 = document3;
                SwingUtilities.invokeLater(new Runnable((Document)object2){
                    final /* synthetic */ Document val$md;
                    {
                        this.val$md = document;
                    }

                    public void run() {
                        Factory.deleteResource(this.val$md);
                    }
                });
            }
            dataStore.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + malformedURLException.getMessage()).initCause(malformedURLException);
        }
        catch (PersistenceException persistenceException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + persistenceException.getMessage()).initCause(persistenceException);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + resourceInstantiationException.getMessage()).initCause(resourceInstantiationException);
        }
    }

    protected void evaluateMarkedClean(File file, File file2, File file3) {
        Document document = null;
        Document document2 = null;
        Document document3 = null;
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            block23: {
                Object object2;
                if (!fileArray[i].isFile()) continue;
                FeatureMap featureMap = Factory.newFeatureMap();
                try {
                    featureMap.put("sourceUrl", fileArray[i].toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Out.prln("Cannot create document from file: " + fileArray[i].getAbsolutePath());
                    continue;
                }
                featureMap.put("encoding", this.documentEncoding);
                FeatureMap featureMap2 = Factory.newFeatureMap();
                try {
                    document2 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2, fileArray[i].getName());
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    Out.prln("Cannot create document from file: " + fileArray[i].getAbsolutePath());
                    continue;
                }
                if (this.isMoreInfoMode) {
                    object = new StringBuffer(fileArray[i].getName());
                    ((StringBuffer)object).replace(fileArray[i].getName().lastIndexOf("."), fileArray[i].getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + ((StringBuffer)object).toString() + "\">" + fileArray[i].getName() + "</a>" + "</H2>");
                } else {
                    Out.prln("<H2>" + fileArray[i].getName() + "</H2>");
                }
                if (!this.isMarkedDS) {
                    object = new StringBuffer(document2.getName());
                    ((StringBuffer)object).replace(document2.getName().lastIndexOf("."), ((StringBuffer)object).length(), ".xml");
                    object2 = new File(file, ((StringBuffer)object).toString());
                    if (!((File)object2).exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + object2 + " in " + file);
                        continue;
                    }
                    featureMap = Factory.newFeatureMap();
                    try {
                        featureMap.put("sourceUrl", ((File)object2).toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Out.prln("Cannot create document from file: " + ((File)object2).getAbsolutePath());
                        continue;
                    }
                    featureMap.put("encoding", this.documentEncoding);
                    try {
                        document3 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2, document2.getName());
                        break block23;
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        Out.prln("Cannot create document from file: " + ((File)object2).getAbsolutePath());
                        continue;
                    }
                }
                try {
                    object = Factory.openDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toExternalForm());
                    object2 = object.getLrIds("gate.corpora.DocumentImpl");
                    boolean bl = false;
                    int n = 0;
                    while (n < object2.size() && !bl) {
                        String string = (String)object2.get(n);
                        FeatureMap featureMap3 = Factory.newFeatureMap();
                        featureMap3.put("DataStore", object);
                        featureMap3.put("LRPersistenceId", string);
                        Document document4 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap3, featureMap2);
                        if (((String)document4.getFeatures().get("gate.SourceURL")).endsWith(document2.getName())) {
                            bl = true;
                            document3 = document4;
                            continue;
                        }
                        ++n;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Out.prln("Error finding marked directory " + file.getAbsolutePath());
                }
                catch (PersistenceException persistenceException) {
                    Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                }
            }
            try {
                this.evaluateDocuments(document, document2, document3, file3);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace();
                Out.prln("Evaluate failed on document: " + document2.getName());
            }
            if (document != null) {
                object = document;
                SwingUtilities.invokeLater(new Runnable((Document)object){
                    final /* synthetic */ Document val$pd;
                    {
                        this.val$pd = document;
                    }

                    public void run() {
                        Factory.deleteResource(this.val$pd);
                    }
                });
            }
            if (document2 != null) {
                object = document2;
                SwingUtilities.invokeLater(new Runnable((Document)object){
                    final /* synthetic */ Document val$cd;
                    {
                        this.val$cd = document;
                    }

                    public void run() {
                        Factory.deleteResource(this.val$cd);
                    }
                });
            }
            if (document3 == null) continue;
            object = document3;
            SwingUtilities.invokeLater(new Runnable((Document)object){
                final /* synthetic */ Document val$md;
                {
                    this.val$md = document;
                }

                public void run() {
                    Factory.deleteResource(this.val$md);
                }
            });
        }
    }

    protected void processDocument(Document document) {
        try {
            if (this.application instanceof CorpusController) {
                Corpus corpus = Factory.newCorpus("temp");
                corpus.add(document);
                ((CorpusController)this.application).setCorpus(corpus);
                this.application.execute();
                Factory.deleteResource(corpus);
                corpus = null;
            } else {
                Iterator iterator = this.application.getPRs().iterator();
                while (iterator.hasNext()) {
                    ((ProcessingResource)iterator.next()).setParameterValue("document", document);
                }
                this.application.execute();
            }
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw (RuntimeException)new RuntimeException("Error executing application: " + resourceInstantiationException.getMessage()).initCause(resourceInstantiationException);
        }
        catch (ExecutionException executionException) {
            throw (RuntimeException)new RuntimeException("Error executing application: " + executionException.getMessage()).initCause(executionException);
        }
    }

    protected void evaluateDocuments(Document document, Document document2, Document document3, File file) throws ResourceInstantiationException {
        if (document2 == null && document3 == null) {
            return;
        }
        if (annotTypes == null || annotTypes.isEmpty()) {
            return;
        }
        if (document2 != null && !this.isMarkedStored) {
            this.processDocument(document2);
            int n = this.countWords(document2);
            if (n == 0) {
                Out.prln("<BR>No Token annotations to count words in the document.");
            } else {
                Out.prln("<BR>Word count: " + n);
            }
            corpusWordCount += n;
            if (!this.isMarkedClean) {
                this.evaluateAllThree(document, document2, document3, file);
            } else {
                this.evaluateTwoDocs(document3, document2, file);
            }
        } else {
            this.evaluateTwoDocs(document3, document, file);
        }
    }

    protected int countWords(Document document) {
        int n = 0;
        if (document == null) {
            return 0;
        }
        AnnotationSet annotationSet = document.getAnnotations(this.outputSetName).get("Token");
        if (annotationSet == null) {
            return 0;
        }
        for (Annotation annotation : annotationSet) {
            Object v = annotation.getFeatures().get("kind");
            if (v == null || !"word".equalsIgnoreCase((String)v)) continue;
            ++n;
        }
        return n;
    }

    protected void evaluateAllThree(Document document, Document document2, Document document3, File file) throws ResourceInstantiationException {
        Object object;
        Object object2;
        this.printTableHeader();
        Writer writer = null;
        if (this.isMoreInfoMode && file != null) {
            StringBuffer stringBuffer = new StringBuffer(document2.getName());
            stringBuffer.replace(document2.getName().lastIndexOf("."), stringBuffer.length(), ".err");
            object2 = new File(file, stringBuffer.toString());
            object = ((DocumentImpl)document2).getEncoding();
            try {
                writer = new FileWriter((File)object2, false);
            }
            catch (Exception exception) {
                Out.prln("Exception when creating the error file " + object2 + ": " + exception.getMessage());
                writer = null;
            }
        }
        for (int i = 0; i < annotTypes.size(); ++i) {
            object2 = (String)annotTypes.get(i);
            object = this.measureDocs(document3, document2, (String)object2);
            if (object == null) continue;
            ++this.docNumber;
            this.updateStatistics((AnnotationDiffer)object, (String)object2);
            AnnotationDiffer annotationDiffer = this.measureDocs(document3, document, (String)object2);
            Out.prln("<TR>");
            if (this.isMoreInfoMode && annotationDiffer != null && (annotationDiffer.getPrecisionAverage() != ((AnnotationDiffer)object).getPrecisionAverage() || annotationDiffer.getRecallAverage() != ((AnnotationDiffer)object).getRecallAverage())) {
                Out.prln("<TD> " + (String)object2 + "_new" + "</TD>");
            } else {
                Out.prln("<TD> " + (String)object2 + "</TD>");
            }
            if (this.isMoreInfoMode) {
                if (annotationDiffer != null) {
                    this.updateStatisticsProc(annotationDiffer, (String)object2);
                }
                Out.prln("<TD>" + ((AnnotationDiffer)object).getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getMissing() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getSpurious() + "</TD>");
            }
            Out.prln("<TD>");
            if (annotationDiffer != null) {
                if (annotationDiffer.getPrecisionAverage() < ((AnnotationDiffer)object).getPrecisionAverage()) {
                    Out.prln("<P><Font color=blue> ");
                    Out.prln(((AnnotationDiffer)object).getPrecisionAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Precision increase on human-marked from ");
                        Out.pr(annotationDiffer.getPrecisionAverage() + " to ");
                        Out.prln(((AnnotationDiffer)object).getPrecisionAverage());
                    }
                    Out.prln(" </Font></P>");
                } else if (annotationDiffer.getPrecisionAverage() > ((AnnotationDiffer)object).getPrecisionAverage()) {
                    Out.prln("<P><Font color=red> ");
                    Out.prln(((AnnotationDiffer)object).getPrecisionAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Precision decrease on human-marked from ");
                        Out.pr(annotationDiffer.getPrecisionAverage() + " to ");
                        Out.prln(((AnnotationDiffer)object).getPrecisionAverage());
                    }
                    Out.prln(" </Font></P>");
                } else {
                    Out.prln("<P> " + ((AnnotationDiffer)object).getPrecisionAverage() + " </P>");
                }
            } else {
                Out.prln("<P> " + ((AnnotationDiffer)object).getPrecisionAverage() + " </P>");
            }
            Out.prln("</TD>");
            Out.prln("<TD>");
            if (annotationDiffer != null) {
                if (annotationDiffer.getRecallAverage() < ((AnnotationDiffer)object).getRecallAverage()) {
                    Out.prln("<P><Font color=blue> ");
                    Out.prln(((AnnotationDiffer)object).getRecallAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Recall increase on human-marked from ");
                        Out.pr(annotationDiffer.getRecallAverage() + " to ");
                        Out.prln(((AnnotationDiffer)object).getRecallAverage());
                    }
                    Out.prln(" </Font></P>");
                } else if (annotationDiffer.getRecallAverage() > ((AnnotationDiffer)object).getRecallAverage()) {
                    Out.prln("<P><Font color=red> ");
                    Out.prln(((AnnotationDiffer)object).getRecallAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Recall decrease on human-marked from ");
                        Out.pr(annotationDiffer.getRecallAverage() + " to ");
                        Out.prln(((AnnotationDiffer)object).getRecallAverage());
                    }
                    Out.prln(" </Font></P>");
                } else {
                    Out.prln("<P> " + ((AnnotationDiffer)object).getRecallAverage() + " </P>");
                }
            } else {
                Out.prln("<P> " + ((AnnotationDiffer)object).getRecallAverage() + " </P>");
            }
            Out.prln("</TD>");
            if (this.isVerboseMode) {
                Out.prln("<TD>");
                if (((AnnotationDiffer)object).getRecallAverage() < this.threshold || ((AnnotationDiffer)object).getPrecisionAverage() < this.threshold) {
                    this.printAnnotations((AnnotationDiffer)object, document3, document2);
                } else {
                    Out.prln("&nbsp;");
                }
                Out.prln("</TD>");
            }
            Out.prln("</TR>");
            if (this.isMoreInfoMode && annotationDiffer != null && (annotationDiffer.getPrecisionAverage() != ((AnnotationDiffer)object).getPrecisionAverage() || annotationDiffer.getRecallAverage() != ((AnnotationDiffer)object).getRecallAverage())) {
                Out.prln("<TR>");
                Out.prln("<TD> " + (String)object2 + "_old" + "</TD>");
                Out.prln("<TD>" + annotationDiffer.getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotationDiffer.getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotationDiffer.getMissing() + "</TD>");
                Out.prln("<TD>" + annotationDiffer.getSpurious() + "</TD>");
                Out.prln("<TD>");
                if (annotationDiffer.getPrecisionAverage() < ((AnnotationDiffer)object).getPrecisionAverage()) {
                    Out.prln("<P><Font color=blue> " + annotationDiffer.getPrecisionAverage() + "</Font></P>");
                } else if (annotationDiffer.getPrecisionAverage() > ((AnnotationDiffer)object).getPrecisionAverage()) {
                    Out.prln("<P><Font color=red> " + annotationDiffer.getPrecisionAverage() + " </Font></P>");
                } else {
                    Out.prln(annotationDiffer.getPrecisionAverage());
                }
                Out.prln("</TD>");
                Out.prln("<TD>");
                if (annotationDiffer.getRecallAverage() < ((AnnotationDiffer)object).getRecallAverage()) {
                    Out.prln("<P><Font color=blue> " + annotationDiffer.getRecallAverage() + " </Font></P>");
                } else if (annotationDiffer.getRecallAverage() > ((AnnotationDiffer)object).getRecallAverage()) {
                    Out.prln("<P><Font color=red> " + annotationDiffer.getRecallAverage() + " </Font></P>");
                } else {
                    Out.prln(annotationDiffer.getRecallAverage());
                }
                Out.prln("</TD>");
                if (this.isVerboseMode) {
                    Out.prln("<TD>");
                    if (((AnnotationDiffer)object).getRecallAverage() < this.threshold || ((AnnotationDiffer)object).getPrecisionAverage() < this.threshold) {
                        this.printAnnotations((AnnotationDiffer)object, document3, document2);
                    } else {
                        Out.prln("&nbsp;");
                    }
                    Out.prln("</TD>");
                }
                Out.prln("</TR>");
            }
            if (!this.isMoreInfoMode || file == null) continue;
            this.storeAnnotations((String)object2, (AnnotationDiffer)object, document3, document2, writer);
        }
        Out.prln("</TABLE>");
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            Out.prln("Exception on close of error file " + writer + ": " + exception.getMessage());
        }
    }

    protected void evaluateTwoDocs(Document document, Document document2, File file) throws ResourceInstantiationException {
        Object object;
        Object object2;
        this.printTableHeader();
        Writer writer = null;
        if (this.isMoreInfoMode && file != null) {
            StringBuffer stringBuffer = new StringBuffer(document.getName());
            stringBuffer.replace(document.getName().lastIndexOf("."), stringBuffer.length(), ".err");
            object2 = new File(file, stringBuffer.toString());
            object = ((DocumentImpl)document).getEncoding();
            try {
                writer = new FileWriter((File)object2, false);
            }
            catch (Exception exception) {
                Out.prln("Exception when creating the error file " + object2 + ": " + exception.getMessage());
                writer = null;
            }
        }
        for (int i = 0; i < annotTypes.size(); ++i) {
            object2 = (String)annotTypes.get(i);
            object = this.measureDocs(document, document2, (String)object2);
            if (object == null) continue;
            ++this.docNumber;
            this.updateStatistics((AnnotationDiffer)object, (String)object2);
            Out.prln("<TR>");
            Out.prln("<TD>" + (String)object2 + "</TD>");
            if (this.isMoreInfoMode) {
                Out.prln("<TD>" + ((AnnotationDiffer)object).getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getMissing() + "</TD>");
                Out.prln("<TD>" + ((AnnotationDiffer)object).getSpurious() + "</TD>");
            }
            Out.prln("<TD>" + ((AnnotationDiffer)object).getPrecisionAverage() + "</TD>");
            Out.prln("<TD>" + ((AnnotationDiffer)object).getRecallAverage() + "</TD>");
            if (this.isVerboseMode) {
                Out.prln("<TD>");
                if (((AnnotationDiffer)object).getRecallAverage() < this.threshold || ((AnnotationDiffer)object).getPrecisionAverage() < this.threshold) {
                    this.printAnnotations((AnnotationDiffer)object, document, document2);
                } else {
                    Out.prln("&nbsp;");
                }
                Out.prln("</TD>");
            }
            Out.prln("</TR>");
            if (!this.isMoreInfoMode || file == null) continue;
            this.storeAnnotations((String)object2, (AnnotationDiffer)object, document, document2, writer);
        }
        Out.prln("</TABLE>");
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            Out.prln("Exception on close of error file " + writer + ": " + exception.getMessage());
        }
    }

    protected void printTableHeader() {
        Out.prln("<TABLE BORDER=1");
        Out.pr("<TR> <TD><B>Annotation Type</B></TD> ");
        if (this.isMoreInfoMode) {
            Out.pr("<TD><B>Correct</B></TD> <TD><B>Partially Correct</B></TD> <TD><B>Missing</B></TD> <TD><B>Spurious<B></TD>");
        }
        Out.pr("<TD><B>Precision</B></TD> <TD><B>Recall</B></TD>");
        if (this.isVerboseMode) {
            Out.pr("<TD><B>Annotations</B></TD>");
        }
        Out.prln("</TR>");
    }

    protected void updateStatistics(AnnotationDiffer annotationDiffer, String string) {
        double d = (annotationDiffer.getPrecisionLenient() + annotationDiffer.getPrecisionStrict()) / 2.0;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.precisionSum += d;
        double d2 = (annotationDiffer.getRecallLenient() + annotationDiffer.getRecallStrict()) / 2.0;
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        this.recallSum += d2;
        double d3 = (annotationDiffer.getFMeasureLenient(1.0) + annotationDiffer.getFMeasureStrict(1.0)) / 2.0;
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        this.fMeasureSum += d3;
        Double d4 = (Double)this.precisionByType.get(string);
        if (d4 == null) {
            this.precisionByType.put(string, new Double(d));
        } else {
            this.precisionByType.put(string, new Double(d4 + d));
        }
        Integer n = (Integer)this.prCountByType.get(string);
        if (n == null) {
            this.prCountByType.put(string, new Integer(1));
        } else {
            this.prCountByType.put(string, new Integer(n + 1));
        }
        Double d5 = (Double)this.fMeasureByType.get(string);
        if (d5 == null) {
            this.fMeasureByType.put(string, new Double(d3));
        } else {
            this.fMeasureByType.put(string, new Double(d5 + d3));
        }
        Integer n2 = (Integer)this.fMeasureCountByType.get(string);
        if (n2 == null) {
            this.fMeasureCountByType.put(string, new Integer(1));
        } else {
            this.fMeasureCountByType.put(string, new Integer(n2 + 1));
        }
        Double d6 = (Double)this.recallByType.get(string);
        if (d6 == null) {
            this.recallByType.put(string, new Double(d2));
        } else {
            this.recallByType.put(string, new Double(d6 + d2));
        }
        Integer n3 = (Integer)this.recCountByType.get(string);
        if (n3 == null) {
            this.recCountByType.put(string, new Integer(1));
        } else {
            this.recCountByType.put(string, new Integer(n3 + 1));
        }
        Long l = (Long)this.missingByType.get(string);
        if (l == null) {
            this.missingByType.put(string, new Long(annotationDiffer.getMissing()));
        } else {
            this.missingByType.put(string, new Long(l + (long)annotationDiffer.getMissing()));
        }
        Long l2 = (Long)this.correctByType.get(string);
        if (l2 == null) {
            this.correctByType.put(string, new Long(annotationDiffer.getCorrectMatches()));
        } else {
            this.correctByType.put(string, new Long(l2 + (long)annotationDiffer.getCorrectMatches()));
        }
        Long l3 = (Long)this.partialByType.get(string);
        if (l3 == null) {
            this.partialByType.put(string, new Long(annotationDiffer.getPartiallyCorrectMatches()));
        } else {
            this.partialByType.put(string, new Long(l3 + (long)annotationDiffer.getPartiallyCorrectMatches()));
        }
        Long l4 = (Long)this.spurByType.get(string);
        if (l4 == null) {
            this.spurByType.put(string, new Long(annotationDiffer.getSpurious()));
        } else {
            this.spurByType.put(string, new Long(l4 + (long)annotationDiffer.getSpurious()));
        }
    }

    protected void updateStatisticsProc(AnnotationDiffer annotationDiffer, String string) {
        hasProcessed = true;
        double d = (annotationDiffer.getPrecisionLenient() + annotationDiffer.getPrecisionStrict()) / 2.0;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.proc_precisionSum += d;
        double d2 = (annotationDiffer.getRecallLenient() + annotationDiffer.getRecallStrict()) / 2.0;
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        this.proc_recallSum += d2;
        double d3 = (annotationDiffer.getFMeasureLenient(1.0) + annotationDiffer.getFMeasureStrict(1.0)) / 2.0;
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        this.proc_fMeasureSum += d3;
        Double d4 = (Double)this.proc_precisionByType.get(string);
        if (d4 == null) {
            this.proc_precisionByType.put(string, new Double(d));
        } else {
            this.proc_precisionByType.put(string, new Double(d4 + d));
        }
        Integer n = (Integer)this.proc_prCountByType.get(string);
        if (n == null) {
            this.proc_prCountByType.put(string, new Integer(1));
        } else {
            this.proc_prCountByType.put(string, new Integer(n + 1));
        }
        Double d5 = (Double)this.proc_fMeasureByType.get(string);
        if (d5 == null) {
            this.proc_fMeasureByType.put(string, new Double(d3));
        } else {
            this.proc_fMeasureByType.put(string, new Double(d5 + d3));
        }
        Integer n2 = (Integer)this.proc_fMeasureCountByType.get(string);
        if (n2 == null) {
            this.proc_fMeasureCountByType.put(string, new Integer(1));
        } else {
            this.proc_fMeasureCountByType.put(string, new Integer(n2 + 1));
        }
        Double d6 = (Double)this.proc_recallByType.get(string);
        if (d6 == null) {
            this.proc_recallByType.put(string, new Double(d2));
        } else {
            this.proc_recallByType.put(string, new Double(d6 + d2));
        }
        Integer n3 = (Integer)this.proc_recCountByType.get(string);
        if (n3 == null) {
            this.proc_recCountByType.put(string, new Integer(1));
        } else {
            this.proc_recCountByType.put(string, new Integer(n3 + 1));
        }
        Long l = (Long)this.proc_missingByType.get(string);
        if (l == null) {
            this.proc_missingByType.put(string, new Long(annotationDiffer.getMissing()));
        } else {
            this.proc_missingByType.put(string, new Long(l + (long)annotationDiffer.getMissing()));
        }
        Long l2 = (Long)this.proc_correctByType.get(string);
        if (l2 == null) {
            this.proc_correctByType.put(string, new Long(annotationDiffer.getCorrectMatches()));
        } else {
            this.proc_correctByType.put(string, new Long(l2 + (long)annotationDiffer.getCorrectMatches()));
        }
        Long l3 = (Long)this.proc_partialByType.get(string);
        if (l3 == null) {
            this.proc_partialByType.put(string, new Long(annotationDiffer.getPartiallyCorrectMatches()));
        } else {
            this.proc_partialByType.put(string, new Long(l3 + (long)annotationDiffer.getPartiallyCorrectMatches()));
        }
        Long l4 = (Long)this.proc_spurByType.get(string);
        if (l4 == null) {
            this.proc_spurByType.put(string, new Long(annotationDiffer.getSpurious()));
        } else {
            this.proc_spurByType.put(string, new Long(l4 + (long)annotationDiffer.getSpurious()));
        }
    }

    public void printStatistics() {
        Out.prln("<H2> Statistics </H2>");
        if (annotTypes == null) {
            Out.prln("No types given for evaluation, cannot obtain precision/recall");
            return;
        }
        Out.prln("<table border=1>");
        Out.prln("<TR> <TD><B>Annotation Type</B></TD> <TD><B>Correct</B></TD><TD><B>Partially Correct</B></TD> <TD><B>Missing</B></TD><TD><B>Spurious</B></TD> <TD><B>Precision</B></TD><TD><B>Recall</B></TD> <TD><B>F-Measure</B></TD> </TR>");
        for (int i = 0; i < annotTypes.size(); ++i) {
            String string = (String)annotTypes.get(i);
            this.printStatsForType(string);
        }
        Out.prln("</table>");
    }

    protected void printStatsForType(String string) {
        String string2;
        long l = this.correctByType.get(string) == null ? 0L : (Long)this.correctByType.get(string);
        long l2 = this.partialByType.get(string) == null ? 0L : (Long)this.partialByType.get(string);
        long l3 = this.spurByType.get(string) == null ? 0L : (Long)this.spurByType.get(string);
        long l4 = this.missingByType.get(string) == null ? 0L : (Long)this.missingByType.get(string);
        long l5 = l + l2 + l3;
        long l6 = l + l2 + l4;
        double d = 0.0;
        if (l5 != 0L) {
            d = ((double)l + 0.5 * (double)l2) / (double)l5;
        }
        double d2 = 0.0;
        if (l6 != 0L) {
            d2 = ((double)l + 0.5 * (double)l2) / (double)l6;
        }
        double d3 = 0.0;
        if (this.beta * this.beta * d + d2 != 0.0) {
            d3 = (this.beta * this.beta + 1.0) * d * d2 / (this.beta * this.beta * d + d2);
        }
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (hasProcessed) {
            l7 = this.proc_correctByType.get(string) == null ? 0L : (Long)this.proc_correctByType.get(string);
            l8 = this.proc_partialByType.get(string) == null ? 0L : (Long)this.proc_partialByType.get(string);
            l9 = this.proc_spurByType.get(string) == null ? 0L : (Long)this.proc_spurByType.get(string);
            l10 = this.proc_missingByType.get(string) == null ? 0L : (Long)this.proc_missingByType.get(string);
            l11 = l7 + l8 + l9;
            l12 = l7 + l8 + l10;
            d4 = ((double)l7 + 0.5 * (double)l8) / (double)l11;
            d5 = ((double)l7 + 0.5 * (double)l8) / (double)l12;
            d6 = (this.beta * this.beta + 1.0) * d4 * d5 / (this.beta * this.beta * d4 + d5);
        }
        Out.prln("<TR>");
        if (hasProcessed) {
            Out.prln("<TD>" + string + "_new" + "</TD>");
        } else {
            Out.prln("<TD>" + string + "</TD>");
        }
        Out.prln("<TD>" + l + "</TD>");
        Out.prln("<TD>" + l2 + "</TD>");
        Out.prln("<TD>" + l4 + "</TD>");
        Out.prln("<TD>" + l3 + "</TD>");
        String string3 = this.isMoreInfoMode ? this.avgPrint(d, 4) : Double.toString(d);
        String string4 = this.isMoreInfoMode ? this.avgPrint(d2, 4) : Double.toString(d2);
        String string5 = string2 = this.isMoreInfoMode ? this.avgPrint(d3, 4) : Double.toString(d3);
        if (hasProcessed && d < d4) {
            Out.prln("<TD><Font color=red>" + string3 + "</TD>");
        } else if (hasProcessed && d > d4) {
            Out.prln("<TD><Font color=blue>" + string3 + "</TD>");
        } else {
            Out.prln("<TD>" + string3 + "</TD>");
        }
        if (hasProcessed && d2 < d5) {
            Out.prln("<TD><Font color=red>" + string4 + "</TD>");
        } else if (hasProcessed && d2 > d5) {
            Out.prln("<TD><Font color=blue>" + string4 + "</TD>");
        } else {
            Out.prln("<TD>" + string4 + "</TD>");
        }
        Out.prln("<TD>" + string2 + "</TD>");
        Out.prln("</TR>");
        if (hasProcessed) {
            String string6;
            Out.prln("<TR>");
            Out.prln("<TD>" + string + "_old" + "</TD>");
            Out.prln("<TD>" + l7 + "</TD>");
            Out.prln("<TD>" + l8 + "</TD>");
            Out.prln("<TD>" + l10 + "</TD>");
            Out.prln("<TD>" + l9 + "</TD>");
            String string7 = this.isMoreInfoMode ? this.avgPrint(d4, 4) : Double.toString(d4);
            String string8 = this.isMoreInfoMode ? this.avgPrint(d5, 4) : Double.toString(d5);
            String string9 = string6 = this.isMoreInfoMode ? this.avgPrint(d6, 4) : Double.toString(d6);
            if (d < d4) {
                Out.prln("<TD><Font color=red>" + string7 + "</TD>");
            } else if (d > d4) {
                Out.prln("<TD><Font color=blue>" + string7 + "</TD>");
            } else {
                Out.prln("<TD>" + string7 + "</TD>");
            }
            if (d2 < d5) {
                Out.prln("<TD><Font color=red>" + string8 + "</TD>");
            } else if (d2 > d5) {
                Out.prln("<TD><Font color=blue>" + string8 + "</TD>");
            } else {
                Out.prln("<TD>" + string8 + "</TD>");
            }
            Out.prln("<TD>" + string6 + "</TD>");
            Out.prln("</TR>");
        }
    }

    protected String avgPrint(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = (double)Math.round(d * d2) / d2;
        return Double.toString(d3);
    }

    public double getPrecisionAverageCalc() {
        return this.precisionSumCalc;
    }

    public double getRecallAverageCalc() {
        return this.recallSumCalc;
    }

    public double getFmeasureAverageCalc() {
        return this.fMeasureSumCalc;
    }

    protected void calculateAvgTotal() {
        if (annotTypes == null) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < annotTypes.size(); ++i) {
            String string = (String)annotTypes.get(i);
            long l5 = this.correctByType.get(string) == null ? 0L : (Long)this.correctByType.get(string);
            long l6 = this.partialByType.get(string) == null ? 0L : (Long)this.partialByType.get(string);
            long l7 = this.spurByType.get(string) == null ? 0L : (Long)this.spurByType.get(string);
            long l8 = this.missingByType.get(string) == null ? 0L : (Long)this.missingByType.get(string);
            l4 += l5;
            l3 += l6;
            l2 += l7;
            l += l8;
        }
        long l9 = l4 + l3 + l2;
        long l10 = l4 + l3 + l;
        this.precisionSumCalc = l9 == 0L ? 0.0 : ((double)l4 + 0.5 * (double)l3) / (double)l9;
        this.recallSumCalc = l10 == 0L ? 0.0 : ((double)l4 + 0.5 * (double)l3) / (double)l9;
        this.fMeasureSumCalc = this.precisionSumCalc == 0.0 && this.recallSumCalc == 0.0 ? 0.0 : (this.beta * this.beta + 1.0) * this.precisionSumCalc * this.recallSumCalc / (this.beta * this.beta * this.precisionSumCalc + this.recallSumCalc);
    }

    protected AnnotationDiffer measureDocs(Document document, Document document2, String string) throws ResourceInstantiationException {
        AnnotationSet annotationSet;
        AnnotationSet annotationSet2;
        if (document == null || document2 == null) {
            return null;
        }
        if (this.annotSetName != null && document.getAnnotations(this.annotSetName).get(string) == null) {
            return null;
        }
        if ((this.annotSetName == null || this.annotSetName.equals("")) && document.getAnnotations().get(string) == null) {
            return null;
        }
        AnnotationDiffer annotationDiffer = new AnnotationDiffer();
        annotationDiffer.setSignificantFeaturesSet(this.diffFeaturesSet);
        if (this.annotSetName == null || this.annotSetName.equals("")) {
            annotationSet2 = document.getAnnotations().get(string);
            annotationSet = document2.getAnnotations().get(string);
        } else {
            annotationSet2 = document.getAnnotations(this.annotSetName).get(string);
            annotationSet = document2.getAnnotations(this.outputSetName).get(string);
        }
        List list = annotationDiffer.calculateDiff(annotationSet2, annotationSet);
        return annotationDiffer;
    }

    protected void storeAnnotations(String string, AnnotationDiffer annotationDiffer, Document document, Document document2, Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            OffsetComparator offsetComparator = new OffsetComparator();
            TreeSet<Annotation> treeSet = new TreeSet<Annotation>(offsetComparator);
            Set set = annotationDiffer.getAnnotationsOfType(2);
            treeSet.clear();
            treeSet.addAll(set);
            this.storeAnnotations(string + ".miss", treeSet, document, writer);
            Set set2 = annotationDiffer.getAnnotationsOfType(3);
            treeSet.clear();
            treeSet.addAll(set2);
            this.storeAnnotations(string + ".spur", treeSet, document2, writer);
            Set set3 = annotationDiffer.getAnnotationsOfType(1);
            treeSet.clear();
            treeSet.addAll(set3);
            this.storeAnnotations(string + ".part", treeSet, document2, writer);
        }
        catch (Exception exception) {
            Out.prln("Exception on close of error file " + writer + ": " + exception.getMessage());
        }
    }

    protected void storeAnnotations(String string, Set set, Document document, Writer writer) throws IOException {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Annotation annotation : set) {
            writer.write(string);
            writer.write(".");
            writer.write(document.getContent().toString().substring(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue()));
            writer.write(".");
            writer.write(annotation.getStartNode().getOffset().toString());
            writer.write(".");
            writer.write(annotation.getEndNode().getOffset().toString());
            writer.write("\n");
        }
    }

    protected void printAnnotations(AnnotationDiffer annotationDiffer, Document document, Document document2) {
        Out.pr("MISSING ANNOTATIONS in the automatic texts: ");
        Set set = annotationDiffer.getAnnotationsOfType(2);
        this.printAnnotations(set, document);
        Out.prln("<BR>");
        Out.pr("SPURIOUS ANNOTATIONS in the automatic texts: ");
        Set set2 = annotationDiffer.getAnnotationsOfType(3);
        this.printAnnotations(set2, document2);
        Out.prln("</BR>");
        Out.pr("PARTIALLY CORRECT ANNOTATIONS in the automatic texts: ");
        Set set3 = annotationDiffer.getAnnotationsOfType(1);
        this.printAnnotations(set3, document2);
    }

    protected void printAnnotations(Set set, Document document) {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Annotation annotation : set) {
            Out.prln("<B>" + document.getContent().toString().substring(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue()) + "</B>: <I>[" + annotation.getStartNode().getOffset() + "," + annotation.getEndNode().getOffset() + "]</I>");
        }
    }

    static {
        hasProcessed = false;
        corpusWordCount = 0;
        usage = "usage: CorpusBenchmarkTool [-generate|-marked_stored|-marked_clean] [-verbose] [-moreinfo] directory-name application";
    }
}

