/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.event.StatusListener;
import gate.swing.MenuLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class XJMenu
extends JMenu {
    protected StatusListener listener;
    private String description;

    public XJMenu() {
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(Action action) {
        super(action);
        this.setToolTipText(null);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(Action action, StatusListener statusListener) {
        super(action);
        this.description = (String)action.getValue("ShortDescription");
        this.listener = statusListener;
        this.setToolTipText(null);
        this.initListeners();
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String string) {
        super(string);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String string, String string2, StatusListener statusListener) {
        super(string);
        this.description = string2;
        this.listener = statusListener;
        this.initListeners();
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String string, boolean bl) {
        super(string, bl);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public void setPopupMenuVisible(boolean bl) {
        super.setPopupMenuVisible(bl);
        if (!bl) {
            return;
        }
        MenuLayout menuLayout = (MenuLayout)this.getPopupMenu().getLayout();
        for (int i = 0; i < this.getMenuComponents().length; ++i) {
            Component component = this.getMenuComponents()[i];
            if (!(component instanceof JSeparator)) continue;
            JSeparator jSeparator = (JSeparator)component;
            int n = menuLayout.getColumnForComponentIndex(i);
            int n2 = menuLayout.getPreferredWidthForColumn(n);
            jSeparator.setPreferredSize(new Dimension(n2, jSeparator.getHeight()));
        }
        this.getPopupMenu().revalidate();
    }

    protected void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                XJMenu.this.listener.statusChanged("");
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                XJMenu.this.listener.statusChanged(XJMenu.this.description);
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
                XJMenu.this.listener.statusChanged("");
            }

            public void menuSelected(MenuEvent menuEvent) {
            }
        });
    }
}

