/*
 * Decompiled with CFR 0.152.
 */
package gate.security;

import gate.event.GateEvent;
import gate.event.ObjectModificationEvent;
import gate.event.ObjectModificationListener;
import gate.persist.DBHelper;
import gate.persist.PersistenceException;
import gate.security.AccessControllerImpl;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.util.MethodNotImplementedException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;

public class GroupImpl
implements Group,
ObjectModificationListener {
    private Long id;
    private String name;
    private List users;
    private Connection conn;
    private int dbType;
    private AccessControllerImpl ac;
    private Vector omModificationListeners;
    private Vector omCreationListeners;
    private Vector omDeletionListeners;

    public GroupImpl(Long l, String string, List list, AccessControllerImpl accessControllerImpl, Connection connection) {
        this.id = l;
        this.name = string;
        this.users = list;
        this.ac = accessControllerImpl;
        this.conn = connection;
        try {
            String string2 = connection.getMetaData().getURL();
            this.dbType = DBHelper.getDatabaseType(string2);
            Assert.assertTrue((this.dbType == 101 || this.dbType == 102 ? 1 : 0) != 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.omModificationListeners = new Vector();
        this.omCreationListeners = new Vector();
        this.omDeletionListeners = new Vector();
        this.ac.registerObjectModificationListener(this, 1002);
    }

    public Long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getUsers() {
        Vector vector = new Vector();
        vector.addAll(this.users);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string, Session session) throws PersistenceException, SecurityException {
        Object object;
        if (!this.ac.isValidSession(session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges to change group name");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.conn.prepareCall("{ call gateadmin.security.set_group_name(?,?)} ");
                    callableStatement.setLong(1, (long)this.id);
                    callableStatement.setString(2, string);
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't change group name in DB: [" + sQLException.getMessage() + "]");
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_set_group_name(?,?) ";
                    preparedStatement = this.conn.prepareStatement((String)object);
                    preparedStatement.setLong(1, this.id);
                    preparedStatement.setString(2, string);
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't change group name in DB: [" + sQLException.getMessage() + "]");
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(preparedStatement);
        }
        this.name = string;
        object = new ObjectModificationEvent(this, 1001, 1001);
        this.fireObjectModifiedEvent((ObjectModificationEvent)object);
    }

    public void addUser(Long l, Session session) throws PersistenceException, SecurityException {
        User user = this.ac.findUser(l);
        this.addUser(user, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addUser(User user, Session session) throws PersistenceException, SecurityException {
        Object object;
        if (this.users.contains(user)) {
            throw new SecurityException("User id=[" + user.getID() + "] is alredy member of group");
        }
        if (!this.ac.isValidSession(session)) {
            throw new SecurityException("invalid session provided");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges to add users");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.conn.prepareCall("{ call gateadmin.security.add_user_to_group(?,?)} ");
                    callableStatement.setLong(1, (long)this.id);
                    callableStatement.setLong(2, (long)user.getID());
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't add user to group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_add_user_to_group(?,?) ";
                    preparedStatement = this.conn.prepareStatement((String)object);
                    preparedStatement.setLong(1, this.id);
                    preparedStatement.setLong(2, user.getID());
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't add user to group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(preparedStatement);
        }
        object = new ObjectModificationEvent(this, 1001, 1002);
        this.users.add(user);
        ((ObjectModificationListener)((Object)user)).objectModified((ObjectModificationEvent)object);
        this.fireObjectModifiedEvent((ObjectModificationEvent)object);
    }

    public void removeUser(Long l, Session session) throws PersistenceException, SecurityException {
        User user = this.ac.findUser(l);
        this.removeUser(user, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeUser(User user, Session session) throws PersistenceException, SecurityException {
        Object object;
        if (!this.users.contains(user)) {
            throw new SecurityException("User id=[" + user.getID() + "] is NOT a member of group");
        }
        if (!this.ac.isValidSession(session)) {
            throw new SecurityException("invalid session provided");
        }
        if (!session.isPrivilegedSession()) {
            throw new SecurityException("insufficient privileges to remove users");
        }
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        if (this.dbType == 101) {
            try {
                try {
                    callableStatement = this.conn.prepareCall("{ call gateadmin.security.remove_user_from_group(?,?)} ");
                    callableStatement.setLong(1, (long)this.id);
                    callableStatement.setLong(2, (long)user.getID());
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't remove user from group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                DBHelper.cleanup(callableStatement);
                throw throwable;
            }
            DBHelper.cleanup(callableStatement);
        } else {
            if (this.dbType != 102) {
                throw new IllegalArgumentException();
            }
            try {
                try {
                    object = "select security_remove_user_from_group(?,?) ";
                    preparedStatement = this.conn.prepareStatement((String)object);
                    preparedStatement.setLong(1, this.id);
                    preparedStatement.setLong(2, user.getID());
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't remove user from group in DB: [" + sQLException.getMessage() + "]");
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            DBHelper.cleanup(preparedStatement);
        }
        object = new ObjectModificationEvent(this, 1001, 1003);
        this.users.remove(user);
        ((ObjectModificationListener)((Object)user)).objectModified((ObjectModificationEvent)object);
        this.fireObjectModifiedEvent((ObjectModificationEvent)object);
    }

    public void objectCreated(ObjectModificationEvent objectModificationEvent) {
    }

    public void objectModified(ObjectModificationEvent objectModificationEvent) {
    }

    public void objectDeleted(ObjectModificationEvent objectModificationEvent) {
        User user;
        if (objectModificationEvent.getSource() instanceof User && this.users.contains(user = (User)objectModificationEvent.getSource())) {
            this.users.remove(user);
        }
    }

    public void processGateEvent(GateEvent gateEvent) {
        throw new MethodNotImplementedException();
    }

    public boolean equals(Object object) {
        Assert.assertTrue((boolean)(object instanceof Group));
        Group group = (Group)object;
        return this.id.equals(group.getID());
    }

    public void registerObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1000 && n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                Assert.fail();
                break;
            }
            case 1002: {
                Assert.fail();
                break;
            }
            case 1001: {
                this.omModificationListeners.add(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    private void fireObjectModifiedEvent(ObjectModificationEvent objectModificationEvent) {
        if (objectModificationEvent.getType() != 1001) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.omModificationListeners.size(); ++i) {
            ((ObjectModificationListener)this.omModificationListeners.elementAt(i)).objectModified(objectModificationEvent);
        }
    }

    public void unregisterObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1000 && n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                this.omCreationListeners.remove(objectModificationListener);
                break;
            }
            case 1002: {
                this.omDeletionListeners.remove(objectModificationListener);
                break;
            }
            case 1001: {
                this.omModificationListeners.remove(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    void setUsers(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Long l = (Long)vector.elementAt(i);
            User user = null;
            try {
                user = this.ac.findUser(l);
            }
            catch (SecurityException securityException) {
                Assert.fail();
            }
            catch (PersistenceException persistenceException) {
                Assert.fail();
            }
            Assert.assertNotNull((Object)user);
            Assert.assertTrue((boolean)(user instanceof User));
            this.users.add(user);
        }
    }
}

