/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.ResourceInstantiationException;
import gate.creole.annic.Hit;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.SearchException;
import gate.creole.annic.SearchableDataStore;
import gate.creole.annic.Searcher;
import gate.creole.annic.lucene.LuceneIndexer;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.security.SecurityException;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LuceneDataStoreImpl
extends SerialDataStore
implements SearchableDataStore,
CorpusListener,
CreoleListener {
    private static final long serialVersionUID = 3618696392336421680L;
    protected Map<Object, LabelledSoftReference> lockObjects = new HashMap<Object, LabelledSoftReference>();
    protected ReferenceQueue<Object> refQueue = new ReferenceQueue();
    protected boolean dataStoreClosing = false;
    protected ScheduledThreadPoolExecutor executor;
    protected ConcurrentMap<Object, IndexingTask> currentTasks = new ConcurrentHashMap<Object, IndexingTask>();
    protected long indexDelay = 1000L;
    protected Indexer indexer;
    protected Map indexParameters;
    protected URL indexURL;
    protected Searcher searcher;
    protected Map searchParameters;

    public void close() throws PersistenceException {
        IndexingTask[] indexingTaskArray;
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.executor.execute(new Runnable(){

            public void run() {
                LuceneDataStoreImpl.this.executor.shutdown();
            }
        });
        try {
            this.executor.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        Collection collection = this.currentTasks.values();
        for (IndexingTask indexingTask : indexingTaskArray = collection.toArray(new IndexingTask[collection.size()])) {
            indexingTask.run();
        }
        super.close();
    }

    public void open() throws PersistenceException {
        super.open();
        try {
            FileReader fileReader = new FileReader(this.getVersionFile());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            currentProtocolVersion = bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string != null && string.trim().length() > 1) {
                this.indexURL = new URL(string);
                this.indexer = new LuceneIndexer(this.indexURL);
                this.searcher = new LuceneSearcher();
                ((LuceneSearcher)this.searcher).setLuceneDatastore(this);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("Invalid storage directory: " + iOException);
        }
        if (!this.isValidProtocolVersion(currentProtocolVersion)) {
            throw new PersistenceException("Invalid protocol version number: " + currentProtocolVersion);
        }
        this.executor = new ScheduledThreadPoolExecutor(1, Executors.defaultThreadFactory());
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lockObjectForID(Object object) {
        Map<Object, LabelledSoftReference> map = this.lockObjects;
        synchronized (map) {
            this.processRefQueue();
            Object object2 = null;
            if (this.lockObjects.containsKey(object)) {
                object2 = this.lockObjects.get(object).get();
            }
            if (object2 == null) {
                this.lockObjects.remove(object);
                object2 = new Object();
                LabelledSoftReference labelledSoftReference = new LabelledSoftReference(object2);
                labelledSoftReference.label = object;
                this.lockObjects.put(object, labelledSoftReference);
            }
            return object2;
        }
    }

    private void processRefQueue() {
        LabelledSoftReference labelledSoftReference = null;
        while ((labelledSoftReference = (LabelledSoftReference)LabelledSoftReference.class.cast(this.refQueue.poll())) != null) {
            if (this.lockObjects.get(labelledSoftReference.label) != labelledSoftReference) continue;
            this.lockObjects.remove(labelledSoftReference.label);
        }
    }

    protected void queueForIndexing(Object object) {
        IndexingTask indexingTask = (IndexingTask)this.currentTasks.get(object);
        if (indexingTask != null) {
            indexingTask.disable();
        }
        IndexingTask indexingTask2 = new IndexingTask(object);
        this.currentTasks.put(object, indexingTask2);
        this.executor.schedule(indexingTask2, this.indexDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string, Object object) throws PersistenceException {
        Cloneable cloneable;
        block16: {
            IndexingTask indexingTask = (IndexingTask)this.currentTasks.get(object);
            if (indexingTask != null) {
                indexingTask.disable();
            }
            ArrayList<Object> arrayList = this.lockObjectForID(object);
            cloneable = arrayList;
            synchronized (cloneable) {
                super.delete(string, object);
            }
            arrayList = null;
            try {
                if (!Corpus.class.isAssignableFrom(Class.forName(string, true, Gate.getClassLoader()))) break block16;
                cloneable = new HashMap();
                cloneable.put("INDEX_LOCATION_URL", this.indexURL);
                cloneable.put("CORPUS_ID", object.toString());
                try {
                    boolean bl = this.getSearcher().search("nothing", (Map<String, Object>)((Object)cloneable));
                    if (!bl) {
                        return;
                    }
                    Hit[] hitArray = this.getSearcher().next(-1);
                    if (hitArray == null || hitArray.length == 0) {
                        return;
                    }
                    for (int i = 0; i < hitArray.length; ++i) {
                        String string2 = hitArray[i].getDocumentID();
                        this.queueForIndexing(string2);
                    }
                }
                catch (SearchException searchException) {
                    throw new PersistenceException(searchException);
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        cloneable = new ArrayList<Object>();
        ((ArrayList)cloneable).add(object);
        try {
            Indexer indexer = this.indexer;
            synchronized (indexer) {
                this.indexer.remove((List)((Object)cloneable));
            }
        }
        catch (IndexException indexException) {
            throw new PersistenceException(indexException);
        }
    }

    public LanguageResource getLr(String string, Object object) throws PersistenceException, SecurityException {
        LanguageResource languageResource = super.getLr(string, object);
        if (languageResource instanceof Corpus) {
            ((Corpus)languageResource).addCorpusListener(this);
        }
        return languageResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(LanguageResource languageResource) throws PersistenceException {
        if (languageResource.getLRPersistenceId() != null) {
            Object object;
            Object object2 = object = this.lockObjectForID(languageResource.getLRPersistenceId());
            synchronized (object2) {
                super.sync(languageResource);
            }
            object = null;
        } else {
            super.sync(languageResource);
        }
        if (languageResource instanceof Document) {
            this.queueForIndexing(languageResource.getLRPersistenceId());
        }
    }

    public void setIndexer(Indexer indexer, Map map) throws IndexException {
        this.indexer = indexer;
        this.indexParameters = map;
        this.indexURL = (URL)this.indexParameters.get("INDEX_LOCATION_URL");
        this.indexer.createIndex(this.indexParameters);
        try {
            File file = this.getVersionFile();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            outputStreamWriter.write(this.versionNumber + Strings.getNl());
            outputStreamWriter.write(this.indexURL.toString());
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new IndexException("couldn't write version file: " + iOException);
        }
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setSearcher(Searcher searcher) throws SearchException {
        this.searcher = searcher;
        if (this.searcher instanceof LuceneSearcher) {
            ((LuceneSearcher)this.searcher).setLuceneDatastore(this);
        }
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setIndexDelay(long l) {
        this.indexDelay = l;
    }

    public long getIndexDelay() {
        return this.indexDelay;
    }

    public boolean search(String string, Map map) throws SearchException {
        return this.searcher.search(string, map);
    }

    public Hit[] next(int n) throws SearchException {
        return this.searcher.next(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentRemoved(CorpusEvent corpusEvent) {
        Object object = corpusEvent.getDocumentLRID();
        if (object != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            try {
                Indexer indexer = this.indexer;
                synchronized (indexer) {
                    this.indexer.remove(arrayList);
                }
            }
            catch (IndexException indexException) {
                throw new GateRuntimeException(indexException);
            }
        }
    }

    public void documentAdded(CorpusEvent corpusEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Resource resource = creoleEvent.getResource();
        if (resource instanceof Corpus) {
            ((Corpus)resource).removeCorpusListener(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelledSoftReference
    extends SoftReference<Object> {
        Object label;

        public LabelledSoftReference(Object object) {
            super(object);
        }
    }

    protected class IndexingTask
    implements Runnable {
        private AtomicBoolean disabled = new AtomicBoolean(false);
        private Object lrID;

        public IndexingTask(Object object) {
            this.lrID = object;
        }

        public void disable() {
            this.disabled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LuceneDataStoreImpl.this.currentTasks.remove(this.lrID, this);
            if (this.disabled.compareAndSet(false, true)) {
                ArrayList<Document> arrayList;
                ArrayList<Object> arrayList2;
                Document document = null;
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("LRPersistenceId", this.lrID);
                featureMap.put("DataStore", LuceneDataStoreImpl.this);
                FeatureMap featureMap2 = Factory.newFeatureMap();
                Gate.setHiddenAttribute(featureMap2, true);
                try {
                    arrayList2 = LuceneDataStoreImpl.this.lockObjectForID(this.lrID);
                    arrayList = arrayList2;
                    synchronized (arrayList) {
                        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap, featureMap2);
                    }
                    arrayList2 = null;
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    document = null;
                }
                if (document != null) {
                    arrayList2 = new ArrayList<Object>();
                    arrayList2.add(this.lrID);
                    try {
                        arrayList = LuceneDataStoreImpl.this.indexer;
                        synchronized (arrayList) {
                            LuceneDataStoreImpl.this.indexer.remove(arrayList2);
                        }
                    }
                    catch (IndexException indexException) {
                        throw new GateRuntimeException(indexException);
                    }
                    arrayList = new ArrayList<Document>();
                    arrayList.add(document);
                    try {
                        Object object;
                        String string = null;
                        List<LanguageResource> list = Gate.getCreoleRegister().getLrInstances(SerialCorpusImpl.class.getName());
                        if (list != null) {
                            object = list.iterator();
                            while (object.hasNext()) {
                                SerialCorpusImpl serialCorpusImpl = (SerialCorpusImpl)object.next();
                                if (serialCorpusImpl == null || !serialCorpusImpl.contains(document)) continue;
                                string = serialCorpusImpl.getLRPersistenceId().toString();
                                break;
                            }
                        }
                        if (string == null && (object = LuceneDataStoreImpl.this.getLrIds(SerialCorpusImpl.class.getName())) != null) {
                            for (int i = 0; i < object.size(); ++i) {
                                Object object2;
                                Object e = object.get(i);
                                SerialCorpusImpl serialCorpusImpl = null;
                                FeatureMap featureMap3 = Factory.newFeatureMap();
                                featureMap3.put("DataStore", LuceneDataStoreImpl.this);
                                featureMap3.put("LRPersistenceId", e);
                                featureMap2 = Factory.newFeatureMap();
                                Gate.setHiddenAttribute(featureMap2, true);
                                Object object3 = object2 = LuceneDataStoreImpl.this.lockObjectForID(e);
                                synchronized (object3) {
                                    serialCorpusImpl = (SerialCorpusImpl)Factory.createResource(SerialCorpusImpl.class.getCanonicalName(), featureMap3, featureMap2);
                                }
                                object2 = null;
                                if (serialCorpusImpl == null) continue;
                                if (serialCorpusImpl.contains(document)) {
                                    string = serialCorpusImpl.getLRPersistenceId().toString();
                                }
                                Factory.deleteResource(serialCorpusImpl);
                                if (string != null) break;
                            }
                        }
                        object = LuceneDataStoreImpl.this.indexer;
                        synchronized (object) {
                            LuceneDataStoreImpl.this.indexer.add(string, arrayList);
                        }
                        Factory.deleteResource(document);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }
}

