/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.JapeException;
import gate.util.Benchmarkable;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class Transducer
implements Serializable,
Benchmarkable {
    private static final boolean DEBUG = false;
    protected String name;
    protected Ontology ontology = null;
    protected Map benchmarkFeatures = new HashMap();
    protected String benchmarkID;
    protected boolean interrupted = false;
    private boolean debugMode = false;
    private boolean matchGroupMode = false;
    private URL baseURL;
    private transient Vector progressListeners;
    private transient Vector statusListeners;
    protected boolean enableDebugging;

    public String getName() {
        return this.name;
    }

    public String getBenchmarkId() {
        if (this.benchmarkID == null) {
            return this.getName();
        }
        return this.benchmarkID;
    }

    public void setBenchmarkId(String string) {
        this.benchmarkID = string;
    }

    public abstract void transduce(Document var1, AnnotationSet var2, AnnotationSet var3) throws JapeException, ExecutionException;

    public abstract void finish();

    public abstract void cleanUp();

    public abstract String toString(String var1);

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void interrupt() {
        this.interrupted = true;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setMatchGroupMode(boolean bl) {
        this.matchGroupMode = bl;
    }

    public boolean isMatchGroupMode() {
        return this.matchGroupMode;
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null && !this.progressListeners.isEmpty()) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    public boolean isEnableDebugging() {
        return this.enableDebugging;
    }

    public void setEnableDebugging(boolean bl) {
        this.enableDebugging = bl;
    }
}

