/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.jape.BaseJapeTests;
import gate.jape.Batch;
import gate.persist.PersistenceException;
import gate.util.AnnotationDiffer;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestJape
extends BaseJapeTests {
    private static final Logger log = Logger.getLogger(TestJape.class);

    public TestJape(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testBatch() throws Exception {
        Object object;
        Corpus corpus = Factory.newCorpus("TestJape corpus");
        corpus.add(Factory.newDocument(Files.getGateResourceAsString("texts/doc0.html")));
        Document document = (Document)corpus.get(0);
        AnnotationSet annotationSet = document.getAnnotations();
        try {
            object = Factory.newFeatureMap();
            annotationSet.add(new Long(2L), new Long(4L), "A", (FeatureMap)object);
            annotationSet.add(new Long(4L), new Long(6L), "B", (FeatureMap)object);
            annotationSet.add(new Long(6L), new Long(8L), "C", (FeatureMap)object);
            annotationSet.add(new Long(8L), new Long(10L), "C", (FeatureMap)object);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace(Err.getPrintWriter());
        }
        object = new Batch(Files.getGateResource("/jape/TestABC.jape"), "UTF-8");
        ((Batch)object).transduce(corpus);
        document = (Document)corpus.get(0);
    }

    public void testApplicationModes() throws PersistenceException, ResourceInstantiationException, IOException, ExecutionException {
        URL uRL = Files.getGateResource("gate.ac.uk/tests/jape/jape-test.xgapp");
        CorpusController corpusController = (CorpusController)PersistenceManager.loadObjectFromUrl(uRL);
        Document document = Factory.newDocument(Files.getGateResource("gate.ac.uk/tests/jape/test-doc.xml"), "UTF-8");
        Corpus corpus = Factory.newCorpus("JAPE Test Corpus");
        corpus.add(document);
        corpusController.setCorpus(corpus);
        corpusController.execute();
        AnnotationDiffer annotationDiffer = new AnnotationDiffer();
        annotationDiffer.setSignificantFeaturesSet(null);
        for (String string : new String[]{"appelt", "brill", "all", "once"}) {
            AnnotationSet annotationSet = document.getAnnotations(string);
            AnnotationSet annotationSet2 = document.getAnnotations(string + "-test");
            annotationDiffer.calculateDiff(annotationSet, annotationSet2);
            double d = annotationDiffer.getFMeasureStrict(1.0);
            TestJape.assertEquals((String)("Incorrect F-measure for test " + string), (Object)1.0, (Object)d);
        }
        corpusController.setCorpus(null);
        Factory.deleteResource(corpusController);
        corpus.remove(0);
        Factory.deleteResource(document);
        Factory.deleteResource(corpus);
    }

    public void testRhsErrorMessages() {
        boolean bl = false;
        try {
            if (log.isDebugEnabled()) {
                log.info((Object)("Opening Jape grammar... " + Gate.getUrl("tests/RhsError.jape")));
            }
            Batch batch = new Batch(Gate.getUrl("tests/RhsError.jape"), "UTF-8");
            Document document = Factory.newDocument("This is a Small Document.");
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("orth", "upperInitial");
            document.getAnnotations().add(new Long(0L), new Long(8L), "Token", featureMap);
            batch.transduce(document);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Exception in Jape rule: " + exception));
            }
            bl = true;
        }
        TestJape.assertTrue((String)"Bad JAPE grammar didn't throw an exception", (boolean)bl);
    }

    public void testBrill() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/brill_test.jape";
        String[] stringArray = new String[]{"Find_A", "Find_A", "Find_A_B", "Find_A_B", "Find_A_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.add(2, 4, "A");
                this.add(2, 5, "A");
                this.add(3, 5, "A");
                this.add(4, 6, "B");
                this.add(5, 7, "B");
                this.add(6, 8, "C");
                this.add(8, 10, "D");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testAppeltMode() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/appelt_test.jape";
        String[] stringArray = new String[]{"Find_A_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.add(2, 4, "A");
                this.add(4, 6, "B");
                this.add(2, 3, "C");
                this.add(3, 8, "D");
                this.add(2, 3, "A");
                this.add(3, 4, "B");
                this.add(4, 9, "C");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testAllMode() throws IOException, GateException, Exception {
        String string = "/gate.ac.uk/tests/jape/control_mode_tests/all_mode_test.jape";
        String[] stringArray = new String[]{"Find_A", "Find_A", "Find_A_B", "Find_A_B", "Find_A_B_C", "Find_A", "Find_A_B", "Find_B_C"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.add(2, 4, "A");
                this.add(2, 5, "A");
                this.add(3, 5, "A");
                this.add(4, 6, "B");
                this.add(5, 7, "B");
                this.add(6, 8, "C");
                this.add(8, 10, "D");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public static Test suite() {
        return new TestSuite(TestJape.class);
    }
}

