/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.jape.BaseJapeTests;
import gate.jape.parser.ParseException;
import gate.util.Err;
import gate.util.Out;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestConstraints
extends BaseJapeTests {
    protected static final String JAPE_PREFIX = "Phase: first\n Options: control = appelt\nRule: RuleOne\n";
    protected BaseJapeTests.AnnotationCreator basicAnnotCreator = new BaseJapeTests.BaseAnnotationCreator(){

        public AnnotationSet createAnnots(Document document) {
            this.setDoc(document);
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "atext");
            featureMap.put("f2", "2");
            featureMap.put("f3", 3);
            this.add(2, 4, "A", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "btext");
            featureMap.put("f2", "2");
            featureMap.put("f4", "btext4");
            this.add(2, 3, "B", featureMap);
            this.add(4, 6, "B", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "cctext");
            featureMap.put("f2", "2");
            featureMap.put("f3", 3L);
            featureMap.put("f4", "ctext4");
            this.add(6, 7, "B", featureMap);
            this.add(6, 8, "C", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "cctext");
            featureMap.put("f2", "1");
            featureMap.put("f4", "ctext4");
            this.add(8, 10, "C", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f1", "dtext");
            featureMap.put("f3", 3L);
            this.add(12, 14, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("f2", 2L);
            this.add(14, 16, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("ontology", "http://gate.ac.uk/tests/demo.owl");
            featureMap.put("class", "Businessman");
            this.add(16, 18, "D", featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put("ontology", "http://gate.ac.uk/tests/demo.owl");
            featureMap.put("class", "Country");
            this.add(18, 19, "D", featureMap);
            return this.as;
        }
    };

    public TestConstraints(String string) {
        super(string);
    }

    public void testGoodOperators() throws Exception {
        String string = "/jape/operators/operator_tests.jape";
        String[] stringArray = new String[]{"AndEqual", "RegExMatch", "NotEqualandGreaterEqual", "NotEqual", "EqualAndNotEqualRegEx", "EqualAndNotExistance", "OntoTest", "OntoTest2"};
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, this.basicAnnotCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testBadCompare() throws Exception {
        String string = "/jape/operators/bad_operator_tests.jape";
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, this.basicAnnotCreator);
        TestConstraints.assertTrue((String)"No results should be found", (boolean)set.isEmpty());
    }

    public void testBadPattern() throws Exception {
        String string = "Phase: first\n Options: control = appelt\nRule: RuleOne\n({A.f1=~\"[a.*\"}):abc-->{}";
        try {
            this.parseJapeString(string);
            TestConstraints.assertTrue((String)"Should have thrown exception for bad grammer", (boolean)false);
        }
        catch (ParseException parseException) {
            Out.println(parseException.getMessage());
        }
        string = "Phase: first\n Options: control = appelt\nRule: RuleOne\n({A.f1=~[a.*}):abc-->{}";
        try {
            this.parseJapeString(string);
            TestConstraints.assertTrue((String)"Should have thrown exception for bad grammer", (boolean)false);
        }
        catch (ParseException parseException) {
            Out.println(parseException.getMessage());
        }
    }

    public void testMetaPropertyAccessors() throws Exception {
        String string = "foo bar blah word4    word5  ";
        String string2 = "/jape/operators/meta_property_tests.jape";
        String[] stringArray = new String[]{"LengthAccessorEqual", "StringAccessorEqual", "CleanStringAccessorEqual"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f1", "aval");
                featureMap.put("f2", "2");
                featureMap.put("f3", 3);
                this.add(4, 7, "A", featureMap);
                this.add(8, 12, "A");
                this.add(12, 28, "B");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest(this.createDoc(string), string2, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testCustomPredicates() throws Exception {
        String string = "/jape/operators/custom_predicates_tests.jape";
        String[] stringArray = new String[]{"Contains", "IsContained", "Contains", "IsContained"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.add(4, 7, "A");
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f2", "bar");
                this.add(5, 6, "B", featureMap);
                this.add(12, 28, "F");
                this.add(14, 20, "E");
                this.add(30, 35, "A");
                this.add(30, 35, "B");
                this.add(40, 45, "F");
                this.add(40, 45, "E");
                this.add(36, 37, "A");
                this.add(36, 38, "B");
                this.add(37, 38, "B");
                this.add(40, 45, "F");
                this.add(40, 46, "E");
                this.add(41, 46, "E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testCustomPredicatesWithConstraints() throws Exception {
        String string = "/jape/operators/custom_predicates_tests.jape";
        String[] stringArray = new String[]{"ContainsWithConstraints", "ContainsWithMetaProperty"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("f1", "foo");
                this.add(4, 7, "C", featureMap);
                this.add(4, 8, "C", Factory.newFeatureMap());
                FeatureMap featureMap2 = Factory.newFeatureMap();
                featureMap2.put("f2", "bar");
                this.add(5, 6, "B", featureMap2);
                this.add(8, 10, "C", featureMap);
                this.add(8, 9, "B");
                this.add(11, 13, "C");
                this.add(12, 16, "C", featureMap);
                this.add(12, 15, "C");
                this.add(12, 16, "B");
                this.add(17, 20, "C", featureMap);
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testRanges() throws Exception {
        String string = "/jape/operators/range_tests.jape";
        String[] stringArray = new String[]{"OneToTwoB", "ThreeA", "OneToTwoB", "ZeroToThreeC", "ThreeToFourB", "ThreeToFourB", "ZeroToThreeC", "ZeroToThreeC"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.addInc("F");
                this.addInc("B");
                this.addInc("G");
                this.addInc("A");
                this.addInc("A");
                this.addInc("A");
                this.addInc("F");
                this.addInc("G");
                this.addInc("A");
                this.addInc("A");
                this.addInc("F");
                this.addInc("B");
                this.addInc("G");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("D");
                this.addInc("E");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("F");
                this.addInc("B");
                this.addInc("B");
                this.addInc("B");
                this.addInc("B");
                this.addInc("G");
                this.addInc("D");
                this.addInc("C");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public void testKleeneOperators() throws Exception {
        String string = "/jape/operators/kleene_tests.jape";
        String[] stringArray = new String[]{"OptionalB", "PlusA", "OptionalB", "PlusA", "StarC", "StarC", "StarC"};
        BaseJapeTests.BaseAnnotationCreator baseAnnotationCreator = new BaseJapeTests.BaseAnnotationCreator(){

            public AnnotationSet createAnnots(Document document) {
                this.setDoc(document);
                this.addInc("C");
                this.addInc("B");
                this.addInc("C");
                this.addInc("A");
                this.addInc("A");
                this.addInc("A");
                this.addInc("C");
                this.addInc("C");
                this.addInc("A");
                this.addInc("A");
                this.addInc("B");
                this.addInc("D");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("E");
                this.addInc("D");
                this.addInc("C");
                this.addInc("C");
                this.addInc("C");
                this.addInc("E");
                return this.as;
            }
        };
        Set<Annotation> set = this.doTest("jape/InputTexts/AveShort", string, (BaseJapeTests.AnnotationCreator)baseAnnotationCreator);
        Out.println(set);
        this.compareResults(stringArray, set);
    }

    public static Test suite() {
        return new TestSuite(TestConstraints.class);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 6; ++i) {
            System.gc();
            Out.println("Run " + i + "   ==============");
            try {
                TestConstraints testConstraints = new TestConstraints("Test Constraints");
                testConstraints.setUp();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

