/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ANNIEConstants;
import gate.creole.ontology.Ontology;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.JdmAttribute;
import gate.jape.constraint.AnnotationFeatureAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.util.Err;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constraint
implements JapeConstants,
ANNIEConstants,
Serializable,
Cloneable {
    private String annotType;
    private boolean negated = false;
    private List<ConstraintPredicate> predicates = new ArrayList<ConstraintPredicate>();
    protected ConstraintPredicate ontLookupClassPred;
    protected FeatureMap ontFeatureMap;

    public Constraint(String string) {
        this.annotType = string;
    }

    public Constraint(String string, FeatureMap featureMap) {
        this(string);
        for (Map.Entry entry : featureMap.entrySet()) {
            this.addAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    @Deprecated
    public Constraint(String string, List<JdmAttribute> list) {
        this(string);
        for (JdmAttribute jdmAttribute : list) {
            this.addAttribute(jdmAttribute.getName(), jdmAttribute.getValue());
        }
    }

    public void negate() {
        this.negated = true;
    }

    public void changeSign() {
        this.negated = !this.negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String getAnnotType() {
        return this.annotType;
    }

    public List<ConstraintPredicate> getAttributeSeq() {
        return this.predicates;
    }

    public void addAttribute(ConstraintPredicate constraintPredicate) {
        this.predicates.add(constraintPredicate);
        if (constraintPredicate.getAccessor() instanceof AnnotationFeatureAccessor) {
            String string = (String)constraintPredicate.getAccessor().getKey();
            if (string.equals("class")) {
                this.ontLookupClassPred = constraintPredicate;
                this.getOntFeatureMap().put("class", this.ontLookupClassPred.getValue());
                if (!constraintPredicate.getOperator().equals("==")) {
                    Err.println("Warning: If an ontology is specified at runtime, Ontology class feature will be compared using ontology subsumption, not " + constraintPredicate.getOperator());
                }
            } else if (string.equals("ontology")) {
                this.getOntFeatureMap().put("ontology", constraintPredicate.getValue());
            }
        }
    }

    protected FeatureMap getOntFeatureMap() {
        if (this.ontFeatureMap == null) {
            this.ontFeatureMap = new SimpleFeatureMapImpl();
        }
        return this.ontFeatureMap;
    }

    public void addAttribute(JdmAttribute jdmAttribute) {
        this.addAttribute(jdmAttribute.getName(), jdmAttribute.getValue());
    }

    public void addAttribute(String string, Object object) {
        ConstraintPredicate constraintPredicate = Factory.getConstraintFactory().createPredicate(string, object);
        this.addAttribute(constraintPredicate);
    }

    public void addAttributes(Collection<ConstraintPredicate> collection) {
        for (ConstraintPredicate constraintPredicate : collection) {
            this.addAttribute(constraintPredicate);
        }
    }

    public Object clone() {
        Constraint constraint = null;
        try {
            constraint = (Constraint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        constraint.annotType = this.annotType;
        constraint.predicates = (List)((ArrayList)this.predicates).clone();
        return constraint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constraint)) {
            return super.equals(object);
        }
        Constraint constraint = (Constraint)object;
        return constraint.negated == this.negated && constraint.annotType.equals(this.annotType) && ((Object)constraint.predicates).equals(this.predicates);
    }

    public int hashCode() {
        int n = this.negated ? 0 : 629;
        n = 37 * n + this.annotType.hashCode();
        n = 37 * n + ((Object)this.predicates).hashCode();
        return n;
    }

    public void finish() {
    }

    public String toString() {
        return this.getDisplayString("Constraint: ");
    }

    public String getDisplayString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.negated) {
            stringBuffer.append("!");
        }
        stringBuffer.append(this.annotType);
        if (!this.predicates.isEmpty()) {
            stringBuffer.append("(");
            stringBuffer.append(this.getAttributesString());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getAttributesString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ConstraintPredicate> iterator = this.predicates.iterator();
        while (iterator.hasNext()) {
            ConstraintPredicate constraintPredicate = iterator.next();
            stringBuffer.append(constraintPredicate);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String shortDesc() {
        return this.getDisplayString("");
    }

    public List<Annotation> matches(Collection<Annotation> collection, Ontology ontology, AnnotationSet annotationSet) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        if (collection == null) {
            return arrayList;
        }
        for (Annotation annotation : collection) {
            if (!this.matches(annotation, ontology, annotationSet)) continue;
            arrayList.add(annotation);
            if (!this.negated) continue;
            break;
        }
        return arrayList;
    }

    public final boolean matches(Annotation annotation, Ontology ontology, AnnotationSet annotationSet) {
        if (annotation == null) {
            return false;
        }
        if (!annotation.getType().equals(this.getAnnotType())) {
            return false;
        }
        if (this.predicates == null || this.predicates.isEmpty()) {
            return true;
        }
        for (ConstraintPredicate constraintPredicate : this.predicates) {
            boolean bl = false;
            try {
                bl = constraintPredicate == this.ontLookupClassPred && ontology != null ? annotation.getFeatures().subsumes(ontology, this.ontFeatureMap) : constraintPredicate.matches(annotation, annotationSet);
            }
            catch (JapeException japeException) {
                Err.println(japeException.getMessage());
            }
            if (!bl && !this.negated) {
                return false;
            }
            if (!bl || !this.negated) continue;
            return true;
        }
        return !this.negated;
    }

    public boolean matches(Annotation annotation, AnnotationSet annotationSet) {
        return this.matches(annotation, null, annotationSet);
    }
}

